#ifndef LINK_TYPEDEF_DEFINED

#define LINK_TYPEDEF_DEFINED

typedef	struct	LINK
{
	struct	LINK	*sptr_forward_link;
	struct	LINK	*sptr_backward_link;
} LINK;

#endif


typedef	struct	UIM_TX_DESCRIPTOR
{
	LINK						links;
	USHORT					length;

	BYTE						*sptr_tx_packet;

} UIM_TX_DESCRIPTOR;


typedef	struct	UIM_CLASS
{
	enum BOOLEAN						enabled;
	
	UIM_TX_DESCRIPTOR					tx_descriptor[NUMBER_OF_TX_DESCRIPTORS];

	UIM_TX_DESCRIPTOR					*sptr_current_tx_descriptor;
	LINK									free_tx_list;
	LINK									scheduled_for_tx;

	BYTE									response_buffer[MAX_CONFIG_PKT];

	BYTE									request_buffer[MAX_CONFIG_PKT];

	USHORT								write_index;		/* for request_buffer */

/* sudhir 18/12/97 */
	USHORT                        send_buffer_index;
	BYTE 									send_buffer[MAX_CONFIG_PKT];
/* sudhir 18/12/97 */

} UIM_CLASS;

typedef struct	{
	BYTE	BridgeNumber[4];
} SMCPktHeadType;

#define		SMC_PKT_HEAD_SIZE	sizeof(SMCPktHeadType)

/* uiminit.c */
extern	int	ChatOnPort;	/* non-zero means SMC-WAN chat is on this port */
int	initialize_uim_controller(void);
int	initialize_uim_rxtx_descriptors (void);
int	reinitialize_uim_rxtx_descriptors_for_chat (void);

/* rserver.c */
extern	BYTE		*DownloadFlag;
USHORT	ProcessPkt(BYTE	*Packet);

/* uimrxtx.c */
void	SMCForeground(int);
void	GetPacket(void);
void	uim_tx_isr_complete(void);
void 	SendModemCommand(void);
USHORT	SearchBuffForResp(char *String);
USHORT	SearchCirBuff(char *String);
void	process_timeout(void);
void	schedule_pkt_on_SMC(UIM_TX_DESCRIPTOR	*sptr_tx_descriptor);

/* quote.68k */
USHORT	Quote(BYTE *,BYTE * ,USHORT);

/* smc.68k */
void	SendPktOnSMC(BYTE *, USHORT Length);
void	Reset(void);

/* timer.68k */
extern	ULONG	ChatIdleTimer;
void	InitTimer(void);
void	StartTimer(BYTE);
void	ResetTimer(BYTE);
void	StopTimer(void);
void	TmOut(void);

/* uimmux.c */
extern BYTE	SettingUpMux;
int	initialize_mux_module_talk(void);
int	check_MMV101_present(void);
int	check_mux_initialization_done(void);
