#include "defs.h"
#include <stdio.h>
#include "wan.h"
/* Kamalnath SLIP 07\03\1997 */
extern enum BOOLEAN check_if_slip_is_enabled(USHORT port_num);
/* Kamalnath SLIP 07\03\1997 */

/* sudhir */
extern void check_for_user_name_and_send_prompt (USHORT port_number);


/*****************************************************************************
*	initialize_connection_on_port: Checks for the connection type on the port.
*	In case of modem connection, it initiates the modem state machine.
*****************************************************************************/
void	initialize_connection_on_port( USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	/* if there is modem read the modem config */
	if (wan.port[port_number].direct_connect_enabled)
	{
		/* Bring up DTR for this port since direct connect */
		SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);
		modem_state_ptr->state = MDM_STATE_ABSENT;

		/* Kamalnath 07\03\1997 it is put in the comments */
		/*if (!(wan.port[port_number].asyncport == TRUE && wan.port[port_number].modem_info.configured_auto_answer))*/
		if(!wan.port[port_number].modem_info.configured_auto_answer)
		{
			/* inform HLDD that port is up */
			/* Kamalnath SLIP 07\02\1997 */
			if (check_if_slip_is_enabled(port_number) == TRUE)
			{
				change_protocol_to_async(port_number, TRUE, SLIP_MODE);
				lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				LOWER_DEVICE_DRIVER_SLIP_UP, port_number);
			}
			/* Kamalnath SLIP 07\02\1997 */
			else
			{
				change_protocol_to_async_hdlc(port_number);
				lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
					LOWER_DEVICE_DRIVER_UP, port_number);
			}
			
         lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
         wan.port[port_number].statistics.connection_up_time = 0 ;
         wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
         wan.port[port_number].statistics.connection_bytes_received = 0 ;
         wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
         wan.port[port_number].statistics.connection_packets_received = 0 ;
         wan.port[port_number].statistics.number_of_calls++ ;
#endif
		}
		else
		{
			/* For async ports that are on the answering end, don't inform 
			** HLDD. Instead wait for and analyse the first packet.
			*/

	/* sudhir 26/6/97 
		This is to send shell menu when wan port is inited*/

         check_for_user_name_and_send_prompt (port_number);
         wan.port[port_number].shell_menu_response_length = 0;

			wan.port[port_number].packet_analysis_on = TRUE;
			start_analysing_packets_on_port(port_number);
		}
	}
	else
	{
		printf("Initializing modem, setting up modem default info.\r\n");
		SetModemDefInfo(port_number);

#ifdef FRAME_RELAY
		if (wan.port[port_number].hldd_type == HLDD_TYPE_FRAME_RELAY)
		{
			modem_state_ptr->wait_ticks = 0 ;
			modem_state_ptr->state = MDM_STATE_OFFLINE ;
			return ;
		}
#endif

#ifndef __DOD__
		modem_state_ptr->wait_ticks = 0;
		modem_state_ptr->state = MDM_STATE_OFFLINE;
#endif /* __DOD__ */
	}
}


