/***************************************************************************
File	:	modem.c
Synop	:	Mainly contains the modem state machine.
modification	:	03/10/96 Vidy added "SOFTWARE_QUOTING" conditional for
						RF200 problem wih microcode
***************************************************************************/

#include "defs.h"
#include <stdio.h>
#include "wan.h"
#include	"modemsup.h"
#include <wanmgr.h>
#include <udb.h>
#include <softquot.h>

#if EVENT_LOG		/* Imran 7.4.99 */
#include	<logif.h>
#endif

extern void flush_rx_buffers_sticking_around (USHORT port_number) ;
extern void callback_attempt_failed (USHORT) ;
extern void DLBK_Initialize_Port (USHORT wan_port_number);

/* Chetan 22/11/96 */
extern void StartScript (USHORT port_number) ;
extern int ScriptRunning (BYTE PortNum) ;
/* Chetan 22/11/96 */

/* Kamalnath SLIP 07\03\1997 */
extern enum BOOLEAN check_if_slip_is_enabled(USHORT port_num);
/* Kamalnath SLIP 07\03\1997 */

/* sudhir  26/6/97 */
extern void check_for_user_name_and_send_prompt (USHORT port_number);

extern USHORT is_DCD_present(USHORT);
void append_cr_if_necessary (BYTE *string) ;
extern char *process_back_slash (char *) ;

void	reinitiaize_SYNC_port(port_number);
extern	void enable_wan_tx_rx (USHORT port_number);

void	(* MdmStateHandlers[])(USHORT) = {
	MdmStateIdle,			/* 20/05/96 Vidy added  */
	MdmStateOffLine,
	MdmStateOnLine,
	MdmStateCmdA,
	ModemStateCmdT,
	MdmStateCmdRest,
	MdmStateWaitOK,
	MdmStateDialA,
	MdmStateDialT,
	MdmStateDialRest,
	MdmStateWaitConn,
	MdmStateWaitRing,
	MdmStateHupDTRDown,
	MdmStateHupCheckCD,
	MdmStateHupStr,
	MdmStateBreak,
	MdmStateDelayOnline,
	MdmStateDTRDialLinkDn,
	MdmStateDTRDialDTRDn,
	MdmStateDTRDialDTRUp,
	MdmStateDTRDialChkOnline,
	MdmStateCallBack
};


void construct_dial_string (USHORT port_number, char *dial_number)
{
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;
	
	strcpy (modem_str_ptr->dial_string, modem_str_ptr->modem_dial_prefix) ;
	strcat (modem_str_ptr->dial_string, dial_number) ;
	strcat (modem_str_ptr->dial_string, modem_str_ptr->modem_dial_suffix) ;

	/* printf ("Dial number : %s, New dial string : %s\n", dial_number, modem_str_ptr->dial_string) ; */
}

/* Converts lower case to higher case */
BYTE  *strupr( BYTE *ptr)
{
	BYTE	*p = ptr;
	while (*ptr) {
		if (*ptr <= 'z' && *ptr >= 'a')
			*ptr = *ptr - 32;
		ptr ++;
	}
	 return(p);
}

void	SetModemDefInfo(USHORT	port_number)
{
	USHORT i ;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;

	if (!modem_str_ptr->modem_ring_mesg[0])
		ConvertControls((modem_str_ptr->modem_ring_mesg), DEF_MDM_RING_MESG);
	process_back_slash (modem_str_ptr->modem_ring_mesg) ;

	if (!modem_str_ptr->modem_hangup_string[0])
			ConvertControls((modem_str_ptr->modem_hangup_string), DEF_MDM_HANUP_STR);
	process_back_slash (modem_str_ptr->modem_hangup_string) ;

	if (!modem_str_ptr->modem_ok_mesg[0])
			ConvertControls((modem_str_ptr->modem_ok_mesg), DEF_MDM_RESP_OK);
	process_back_slash (modem_str_ptr->modem_ok_mesg) ;

	if (!modem_str_ptr->modem_error_mesg[0])
			ConvertControls((modem_str_ptr->modem_error_mesg), DEF_MDM_RESP_ERROR);
	process_back_slash (modem_str_ptr->modem_error_mesg) ;

	if (!modem_str_ptr->modem_busy_mesg[0])
			ConvertControls((modem_str_ptr->modem_busy_mesg), DEF_MDM_RESP_BUSY);
	process_back_slash (modem_str_ptr->modem_busy_mesg) ;

	if (!modem_str_ptr->modem_no_carrier_mesg[0])
			ConvertControls((modem_str_ptr->modem_no_carrier_mesg), DEF_MDM_RESP_NO_CARRIER);
	process_back_slash (modem_str_ptr->modem_no_carrier_mesg) ;

	if (!modem_str_ptr->modem_no_dial_tone_mesg[0])
			ConvertControls((modem_str_ptr->modem_no_dial_tone_mesg), DEF_MDM_RESP_NO_DLTONE);
	process_back_slash (modem_str_ptr->modem_no_dial_tone_mesg) ;

	if (!modem_str_ptr->modem_no_answer_mesg[0])
			ConvertControls((modem_str_ptr->modem_no_answer_mesg), DEF_MDM_RESP_NO_ANSWER);
	process_back_slash (modem_str_ptr->modem_no_answer_mesg) ;

	if (!modem_str_ptr->modem_response_string[0])
			ConvertControls((modem_str_ptr->modem_response_string), DEF_MDM_RESP_CONNECT);
	process_back_slash (modem_str_ptr->modem_response_string) ;

	if (!modem_str_ptr->modem_dial_suffix[0])
		strcpy (modem_str_ptr->modem_dial_suffix, "^M") ;

	construct_dial_string (port_number, modem_str_ptr->modem_dial_number) ;

	wan.port[port_number].modem_info.constant.dial_timeout = DEF_DIAL_TIMEOUT;
	wan.port[port_number].modem_info.constant.break_len =	DEF_BREAK_LEN;
	wan.port[port_number].modem_info.constant.max_retry =	DEF_MAX_RETRY;
	wan.port[port_number].modem_info.constant.sleep_time = DEF_SLEEP_TIME;
	wan.port[port_number].modem_info.constant.retry_wait = DEF_RETRY_WAIT;

	wan.port[port_number].modem_info.status.carrier_loss = 0;
	wan.port[port_number].modem_info.status.init_attempts = 0;
	wan.port[port_number].modem_info.status.stat_retry_fails = 0;
	wan.port[port_number].modem_info.status.check_online_count = 0;

/* Vidy and Sachin 13/07/1997 */
   if (!modem_str_ptr->modem_response_string[0])
      wan.port[port_number].connection_started_by_modem_response = FALSE ;
/* Vidy and Sachin 13/07/1997 */

	for (i = 0 ; i < 5 ; i++)
		append_cr_if_necessary (modem_str_ptr->init_string[i]) ;

	append_cr_if_necessary (modem_str_ptr->dial_string) ;
	append_cr_if_necessary (modem_str_ptr->modem_hangup_string) ;
}

/************************************************************************
 * Routine	:	ConvertControls
 * Input	:	destination and source pointers
 * Return	:	pointer to destination
 * Note		:	the '^' character given in a modem setup string is 
 *				interpreted by this routine. it puts the modified string
 *				in the destination. A pointer to the destination is
 *				returned
 ************************************************************************/
BYTE *ConvertControls(BYTE *dst_str, BYTE *src_str)
{
	BYTE *ret_str = dst_str;

	while (*src_str)
	{
		if (*src_str == '^')
		{
			src_str++;
			if (*src_str)
			{
				if (*src_str == '^')
					*dst_str++ = *src_str++;
				else
					*dst_str++ = (BYTE) (*src_str++ - 'A' + 1);
			}
		}
		else
		{
			*dst_str++ = *src_str++;
		}
	}
	*dst_str = 0;
	return ret_str;
}

void TriggerDial(USHORT port_number)
{
	/** If port is SYNC or DTR Dialing enabled, state = DTR_DIAL.
	** Sync port is always in DTR_DIAL_STATE whether answering/dialing
	** because, there are no strings to be sent and CD has to be
	** present for data transfer to take place (even in direct_connect).
	**/
	if (wan.port[port_number].modem_info.dtr_dial) {
		wan.port[port_number].modem_info.status.state = MDM_STATE_DTR_DIAL_DTR_DN;
	} else {	/* Port is Async */
		if (wan.port[port_number].direct_connect_enabled == FALSE) {
			/* Bring up DTR since Command Mode dialing */
			/* SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number); */
			wan.port[port_number].modem_info.status.wait_ticks = 0;
			wan.port[port_number].modem_info.status.state = MDM_STATE_OFFLINE;
		}
	}
}
/*******   The following routines are for modem dial state machine   *******/

/****************************************************************************
Routine	:	MoveModemState
Parameter : USHORT port_number
Synop	:	Checks for modem status and moves state machine
****************************************************************************/
void	MoveModemState(USHORT port_number)
{
	enum WAN_PORT_OWNER wan_owner;

	wan_owner = get_wan_port_owner(port_number);
	
	/* Kamalnath 20\03\1997 SLIP  added OWNED_BY_SLIP too */	
	if (!(wan_owner == OWNED_BY_NONE || wan_owner == OWNED_BY_PPP || wan_owner == OWNED_BY_SLIP))
		return;

	/* Just call the handler for the current state */
	(* MdmStateHandlers[wan.port[port_number].modem_info.status.state]) (port_number);
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateIdle(USHORT port_number)
{
	/* This is dummy state where nothing moves. Only external events can move */
	/* the state machine out of this state (like dial, wait for call) */
	return;
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateOffLine(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	USHORT TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
	{
		return;
	}

/* Ravi on 10-jan-2000 */
	modem_state_ptr->this_end_dialed = FALSE; 


#if PROXY_SERVER
   wan.port[port_number].statistics.modem_connect_message[0] = 0 ;
#endif
	modem_state_ptr->init_string_index = 0;	/* start witht the first string */

	/* Bring up DTR since Command Mode dialing */
	SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);

	if ((is_DCD_present(port_number)) && (wan.port[port_number].connection_started_by_DCD))
	{

		TmpSr = _GPL();
		_SPL(7);
		Stop_Tx_and_Rx(port_number);
		Just_FlushRxBufferUART(port_number);
		Just_FlushTxBufferUART(port_number);
/* Added by Naveen ... */
      Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added by Naveen */
		_SPL(TmpSr);

#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_DCD_DETECTED, (BYTE) (port_number + 1));  
#endif


#if 0  /* Code Removed by Naveen */
		/* check if all the queues are in the reset state by checking the forward
		or backward pointers */
		if(wan.port[port_number].xmited_tx_list.sptr_forward_link != NULL || 
			wan.port[port_number].current_rx_list.sptr_forward_link != NULL )
		{
			modem_state_ptr->wait_ticks = 1;	/* just  wait */
			return;
		}
#endif 
		/* Now change the state */

		inform_hldd_and_change_to_async_hdlc(port_number);
		return;
	}
	if (modem_state_ptr->last_error == MDM_ERR_CMD)
	{
		if (!wan.port[port_number].modem_info.auto_answer)
		{	/* If caller goto dial */
			modem_state_ptr->wait_ticks = MDM_DELAY_DIAL;
			modem_state_ptr->state = MDM_STATE_DIAL_A;
		}
		else
		{					/* If callee goto wait for ring */
			TmpSr = _GPL();
			_SPL(7);
			FlushRxBufferUART(port_number);
			_SPL(TmpSr);
			PortModemPoweredOffAndOn(port_number);			/* Flush Mdm status */
			modem_state_ptr->state = MDM_STATE_WAIT_RING;
			modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;
		}
		modem_state_ptr->last_error == MDM_ERR_NONE;
	}

	if (modem_state_ptr->retry_count >= wan.port[port_number].modem_info.constant.max_retry)
	{
		modem_state_ptr->stat_retry_fails++;		/* Some statistics */
		modem_state_ptr->retry_count = 0;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.sleep_time;
							
#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_DIAL_RETRIES_FAIL, (BYTE) (port_number + 1));
#endif

		if (modem_state_ptr->call_back_on)
		{
			/* reset any pending callbacks */
			printf ("CALLBACK : Resetting callback flag, changing port %d to answering\n", port_number) ;
#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_CALLBACK_CANCELLED, (BYTE) (port_number + 1)); 
#endif
			modem_state_ptr->call_back_on = FALSE ;	/* reset any pending callbacks */
			wan.port[port_number].modem_info.auto_answer = TRUE;
			modem_state_ptr->wait_ticks = 1;
			callback_attempt_failed (port_number) ;
		}
		return;
	}
	modem_state_ptr->init_attempts++;
 	modem_state_ptr->state = MDM_STATE_CMD_A;
	modem_state_ptr->wait_ticks = 0;

#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_MODEM_INIT, (BYTE) (port_number + 1)); 
#endif
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateOnLine(USHORT	port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	if ((wan.port[port_number].connection_dropped_by_DCD) && (is_DCD_present(port_number)))
	{
		modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;
		return;
	}
	modem_state_ptr->carrier_loss++;
#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_DCD_LOST,(BYTE) (port_number + 1)); 
#endif

	
	/* In case of SYNC just go to DTR_DIAL state irrespective of whether	answering or
	dialing. Reinitialize the SCC*/
	if (wan.port[port_number].asyncport == FALSE)
	{
		lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			LOWER_DEVICE_DRIVER_DOWN, port_number);

		reinitiaize_SYNC_port(port_number);		
		modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_DN;	/* move the state */
	} 
	else
	{
		/* inform HLDD about port no longer available */
		inform_hldd_and_change_to_async(port_number);

		if (wan.port[port_number].modem_info.dtr_dial)
		{
			modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_DN;	/* move the state */
		}
		else
		{
			SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
			modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
			modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
		}
		modem_state_ptr->retry_count = 0;
	}

	/* chetan 22/11/96 */
	if (wan.port[port_number].script_enabled)
	{
		if (wan.port[port_number].restart_script_on_comm_failure)
		{
			if (wan.port[port_number].asyncport
					&& !wan.port[port_number].direct_connect_enabled)
			{
				SetLineConfigUART (SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number) ;
				if (!ScriptRunning ((BYTE) port_number))
				{
					printf ("DCD LOST : Ready to execute script for port : %d \n\r", port_number) ;
					StartScript (port_number) ;
				}
			}
		}
	}
	/* chetan 22/11/96 */

}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateCmdA(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;
	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	ConvertControls(modem_state_ptr->cmnd_string, modem_str_ptr->
								init_string[modem_state_ptr->init_string_index]);
	modem_state_ptr->init_string_index++;
	
	if ((modem_state_ptr->cmnd_string[0]) && (modem_state_ptr->init_string_index <= 5))
	{
		WriteToPort(port_number, modem_state_ptr->cmnd_string, 1);
		modem_state_ptr->state = MDM_STATE_CMD_T;
		modem_state_ptr->wait_ticks = 0;
	}
	else
	{
		if (!wan.port[port_number].modem_info.auto_answer)
		{	/* If caller goto dial */
			modem_state_ptr->wait_ticks = MDM_DELAY_DIAL;
			modem_state_ptr->state = MDM_STATE_DIAL_A;
		}
		else
		{					/* If callee goto wait for ring */
			TmpSr = _GPL();
			_SPL(7);
			FlushRxBufferUART(port_number);
			_SPL(TmpSr);
			PortModemPoweredOffAndOn(port_number);			/* Flush Mdm status */
			modem_state_ptr->state = MDM_STATE_WAIT_RING;
			modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;
		}
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	ModemStateCmdT(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	if (modem_state_ptr->cmnd_string[1])
	{
		WriteToPort(port_number, &modem_state_ptr->cmnd_string[1], 1);
		modem_state_ptr->state = MDM_STATE_CMD_REST;
		modem_state_ptr->wait_ticks = 0;
	}
	else
	{
		WriteToPort(port_number, "\r", 1);		
		if (!wan.port[port_number].modem_info.auto_answer)
		{	/* If caller goto dial */
			modem_state_ptr->wait_ticks = MDM_DELAY_DIAL;
			modem_state_ptr->state = MDM_STATE_DIAL_A;
		}
		else
		{					/* If callee goto wait for ring */
			TmpSr = _GPL();
			_SPL(7);
			FlushRxBufferUART(port_number);
			_SPL(TmpSr);
			PortModemPoweredOffAndOn(port_number);			/* Flush Mdm status */
			modem_state_ptr->state = MDM_STATE_WAIT_RING;
			modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;
		}
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateCmdRest(USHORT port_number)
{
	USHORT	TmpSr;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	/* Flush the Receive buffer of this port */
	TmpSr = _GPL();
	_SPL(7);
	FlushRxBufferUART(port_number);
	_SPL(TmpSr);

	if (modem_state_ptr->cmnd_string[2])
	{
		WriteToPort(port_number, &modem_state_ptr->cmnd_string[2], 0);
		modem_state_ptr->state = MDM_STATE_WAIT_OK ;
		modem_state_ptr->wait_ticks = MDM_WAIT_FOR_OK ;
	}
	else
	{
		WriteToPort(port_number, "\r", 1);		
		if (!wan.port[port_number].modem_info.auto_answer)
		{	/* If caller goto dial */
			modem_state_ptr->wait_ticks = MDM_DELAY_DIAL;
			modem_state_ptr->state = MDM_STATE_DIAL_A;
		}
		else
		{					/* If callee goto wait for ring */
			TmpSr = _GPL();
			_SPL(7);
			FlushRxBufferUART(port_number);
			_SPL(TmpSr);
			PortModemPoweredOffAndOn(port_number);			/* Flush Mdm status */
			modem_state_ptr->state = MDM_STATE_WAIT_RING;
			modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;
		}
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateWaitOK(USHORT port_number)
{
//	USHORT	TmpSr;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;

	if (SearchLnBuffFor(port_number, modem_str_ptr->modem_ok_mesg))
	{
		modem_state_ptr->state = MDM_STATE_CMD_A ;
		modem_state_ptr->wait_ticks = 1 ;
		return ;
	}

	if (SearchLnBuffFor(port_number, modem_str_ptr->modem_error_mesg)) {

#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_MODEM_ERROR, (BYTE) (port_number + 1)); 
#endif

		modem_state_ptr->retry_count++;
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
		modem_state_ptr->last_error = MDM_ERR_CMD;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
		return;
	}
	if ( ! modem_state_ptr->wait_ticks) {		/* don't move till ticks expire */
		/* This is a timeout case */

#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_MODEM_NO_RESP, (BYTE) (port_number + 1)); 
#endif
		modem_state_ptr->retry_count++;
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
		modem_state_ptr->last_error = MDM_ERR_CMD_TMOUT;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateDialA(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

/* Ravi on 10-jan-2000 */
	modem_state_ptr->this_end_dialed = TRUE;

	if ( ! modem_str_ptr->dial_string[0]) {
		modem_state_ptr->state = MDM_STATE_WAIT_CONN;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.dial_timeout;
#if PROXY_SERVER
		modem_state_ptr->flush_rx_buffer_counter = 3 ;
#endif
		return;
	}
	ConvertControls(modem_state_ptr->cmnd_string, modem_str_ptr->dial_string);

#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_DIALING, (BYTE) (port_number + 1)); 
#endif

	WriteToPort(port_number, modem_state_ptr->cmnd_string, 1);
	modem_state_ptr->state = MDM_STATE_DIAL_T;
	modem_state_ptr->wait_ticks = 0;
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateDialT(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	/* Send one more char out */
	WriteToPort(port_number, &modem_state_ptr->cmnd_string[1], 1);
	modem_state_ptr->state = MDM_STATE_DIAL_REST;
	modem_state_ptr->wait_ticks = 0;
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateDialRest(USHORT port_number)
{
	USHORT	TmpSr;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	/* send rest of the dialing command one shot */
	/* Flush the Receive buffer of this port */
	TmpSr = _GPL();
	_SPL(7);
	FlushRxBufferUART(port_number);
	_SPL(TmpSr);
	WriteToPort(port_number, &modem_state_ptr->cmnd_string[2], 0);
	modem_state_ptr->state = MDM_STATE_WAIT_CONN;
#if PROXY_SERVER
	modem_state_ptr->flush_rx_buffer_counter = 3 ;
#endif
	modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.dial_timeout;
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateWaitConn(USHORT port_number)
{
	USHORT	ModemResponded;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;
	USHORT	TmpSr;

#if PROXY_SERVER
	if (modem_state_ptr->flush_rx_buffer_counter)
   {
      FlushRxBufferUART(port_number) ;
      return ;
   }
#endif

	/* check if the modem has responded by now */
	if (((wan.port[port_number].connection_started_by_modem_response) && (SearchLnBuffFor(port_number, modem_str_ptr->modem_response_string))) ||
		  ((wan.port[port_number].connection_started_by_DCD) && (is_DCD_present(port_number))))
	{
		modem_state_ptr->state = MDM_STATE_DELAY_ONLINE;
		TmpSr = _GPL();
		_SPL(7);
#if PROXY_SERVER
#else
		Flush_Rx_Tx_Buffers(port_number);
#endif
		_SPL(TmpSr);
		modem_state_ptr->wait_ticks =  1;	
		return ;
	}

	ModemResponded = TRUE;
	if (SearchLnBuffFor(port_number, modem_str_ptr->modem_error_mesg))
	{

#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_WAN_ERROR, (BYTE)(port_number + 1));   
#endif

		modem_state_ptr->last_error = MDM_ERR_DIALING;
	}
	else
		if (SearchLnBuffFor(port_number, modem_str_ptr->modem_busy_mesg))
		{
#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_WAN_BUSY, (BYTE)(port_number + 1));  
#endif
			modem_state_ptr->last_error = MDM_ERR_BUSY;
		}
		else
		if (SearchLnBuffFor(port_number, modem_str_ptr->modem_no_carrier_mesg))
		{
#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_NO_CARRIER_ON_WAN, (BYTE)(port_number + 1));   
#endif
			modem_state_ptr->last_error = MDM_ERR_NO_CARRIER;
		}
		else
		if (SearchLnBuffFor(port_number, modem_str_ptr->modem_no_dial_tone_mesg))
		{
#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_NO_DIAL_TONE, (BYTE)(port_number + 1));   
#endif
			modem_state_ptr->last_error = MDM_ERR_NO_DTONE;
		}
		else
		if (SearchLnBuffFor(port_number, modem_str_ptr->modem_no_answer_mesg))
		{
#if EVENT_LOG		/* Imran 7.4.99 */
	write_log(LOG_EVENT_MODEM_ERR_NO_ANSWR, (BYTE)(port_number + 1));  
#endif
			modem_state_ptr->last_error = MDM_ERR_NO_ANSWR;
		}
		else
		{
			ModemResponded = FALSE;
		}

		if (ModemResponded)
		{
			modem_state_ptr->retry_count++;
			SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
			modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
			modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
			return;
		}
		if (!modem_state_ptr->wait_ticks)
		{
			/* This is a timeout case */
			modem_state_ptr->retry_count++;
			SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
			modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
			modem_state_ptr->last_error = MDM_ERR_CONN_TMOUT;
			modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;
			WriteToPort(port_number, "\r", 1);	/* Reset the modem */
#if EVENT_LOG		/* Imran 7.4.99 */
		write_log(LOG_EVENT_MODEM_NO_CONNECT_RESP, (BYTE) (port_number + 1)); 
#endif
		}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateWaitRing(USHORT port_number)
{
	USHORT	TmpSr;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	if (PortModemPoweredOffAndOn(port_number))
	{
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */
		modem_state_ptr->wait_ticks = MDM_POWER_ON_DELAY;
		return;
	}

	/* check for CD */
	if ((wan.port[port_number].connection_started_by_DCD) && (is_DCD_present(port_number)))
	{
#if EVENT_LOG		/* Imran 7.4.99 */
		write_log(LOG_EVENT_MODEM_CONNECTED,(BYTE) (port_number + 1));
#endif

		/* printf ("DCD found on port %d\n", port_number) ; */
		TmpSr = _GPL();
		_SPL(7);
		Stop_Tx_and_Rx(port_number);
		Just_FlushRxBufferUART(port_number);
		Just_FlushTxBufferUART(port_number);
/* Added By Naveen ... */
      Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added By Naveen */
		_SPL(TmpSr);

#if 0 /* Code Removed By Naveen */
		/* check if all the queues are in the reset state by checking the forward
		or backward pointers */
		if (wan.port[port_number].xmited_tx_list.sptr_forward_link != NULL || 
			wan.port[port_number].current_rx_list.sptr_forward_link != NULL)
		{
			modem_state_ptr->wait_ticks = 1;	/* just  wait */
			return;
		}
#endif

		/* Now change the state */
		inform_hldd_and_change_to_async_hdlc(port_number);
		return;
	}

	/* check if the modem has responded by now */
	if (SearchLnBuffFor(port_number, modem_str_ptr->modem_ring_mesg))
	{
#if EVENT_LOG		/* Imran 7.4.99 */
		write_log(LOG_EVENT_MODEM_RING,(BYTE) (port_number + 1)); 
#endif

		TmpSr = _GPL();
		_SPL(7);
		FlushRxBufferUART(port_number);
		_SPL(TmpSr);
		modem_state_ptr->state = MDM_STATE_WAIT_CONN;
#if PROXY_SERVER
		modem_state_ptr->flush_rx_buffer_counter = 0 ;
#endif
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.dial_timeout;
		return;
	}
	modem_state_ptr->wait_ticks = MDM_CHK_FOR_RING;	/* check ring after some tm */

	return ;
}


/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateHupDTRDown(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	/* Set the DTR down for some time */

	SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number);

	if (wan.port[port_number].modem_info.dtr_dial)
	{	/* if DTR dialing is enabled, to hangup just lower DTR */
		modem_state_ptr->state = MDM_STATE_IDLE;
		modem_state_ptr->wait_ticks = -1;
	}
	else
	{			/* if not DTR dialing, after lowering DTR, check for CD */
		/* Wait for some time and check for CD */
		modem_state_ptr->state = MDM_STATE_HUP_CHK_CD;
		modem_state_ptr->wait_ticks = MDM_DTR_DN_TIME;
	}
}
/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateHupCheckCD(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	MODEM_STRINGS	*modem_str_ptr = &wan.port[port_number].modem_info.strings;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;
	/* Set the DTR up back */
	/* SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number) ; */

	/* if DCD is still present and async we need to send out HangupStr */
	if (wan.port[port_number].connection_dropped_by_DCD && is_DCD_present(port_number) && wan.port[port_number].asyncport)
	{
		/* we need to send HUP command to modem */

/* Sachin, 20th Sept. 1997 */
		/* strcpy(modem_state_ptr->cmnd_string, modem_str_ptr->modem_hangup_string); */
      ConvertControls (modem_state_ptr->cmnd_string, modem_str_ptr->modem_hangup_string) ;
/* Sachin, 20th Sept. 1997 */

		modem_state_ptr->cmnd_string_index = 0;

		if (modem_state_ptr->cmnd_string[0])
		{
			SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);
			modem_state_ptr->state = MDM_STATE_HUP_STR;
			return;
		}
	}
	SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
	modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */

	modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;	/* no activity */

	inform_hldd_and_change_to_async(port_number);
}
/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateHupStr(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	static	BYTE *BreakStr = "<BREAK>";
	BYTE	CmdStrBuff[PHONE_NUM_LEN + MDM_DIAL_PREFIX_LEN * 2];
	BYTE	*CmdStr, *bptr;
	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	CmdStr = &modem_state_ptr->cmnd_string[modem_state_ptr->cmnd_string_index];

	if (!*CmdStr)
	{
		SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number); /* 23/05/96 Vidy */
		modem_state_ptr->state = MDM_STATE_OFFLINE;	/* move the state */

		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.retry_wait;	/* no activity */

		inform_hldd_and_change_to_async(port_number);
		return;
	}
	if (*CmdStr == MDM_CMD_PAUSE_CHAR) {
		modem_state_ptr->cmnd_string_index++;
		modem_state_ptr->wait_ticks = MDM_CMD_PAUSE_TIME;
		return;
	}
	/* check for break verb */
	strcpy(CmdStrBuff, CmdStr);
	strupr(CmdStrBuff);
	if (bptr = strstr(CmdStrBuff, BreakStr)) {
		modem_state_ptr->cmnd_string_index += bptr - CmdStrBuff;
		modem_state_ptr->cmnd_string_index += strlen(BreakStr);
		TmpSr = _GPL();
		_SPL(7);
		SetBreakUART(port_number);
		_SPL(TmpSr);

		/* wait for break time */
		modem_state_ptr->state = MDM_STATE_BREAK;
		modem_state_ptr->wait_ticks = wan.port[port_number].modem_info.constant.break_len;	/* no activity */
		return;
	}
	if (bptr = strchr(CmdStr, MDM_CMD_PAUSE_CHAR)) {
		WriteToPort (port_number, CmdStr, bptr - CmdStr);
		modem_state_ptr->cmnd_string_index += bptr - CmdStr;
	} else {
		WriteToPort (port_number, CmdStr, 0);
		modem_state_ptr->cmnd_string_index += strlen(CmdStr);
		modem_state_ptr->wait_ticks = 2;	/* no activity */
	}
}

/****************************************************************************
Routine	:
Synop	:
****************************************************************************/
void	MdmStateBreak(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;
	modem_state_ptr->state = MDM_STATE_HUP_STR;
	TmpSr = _GPL();
	_SPL(7);
	ResetBreakUART(port_number);
	_SPL(TmpSr);
}
/****************************************************************************
Routine	:
Synop	: As soon as the "CONNECT" string appears we shouldn't start business
****************************************************************************/
#if PROXY_SERVER
void record_connect_message (USHORT) ;
#endif
void	MdmStateDelayOnline(USHORT port_number)
{
	USHORT	TmpSr;

	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	if (modem_state_ptr->call_back_on)
	{
      /* Chidanand - 17 May 1997 - Postponed and handled in 
         inform_hldd_and_change_to_async_hdlc() to avoid
         SLIP coming up on call back.
      */
		/* modem_state_ptr->call_back_on = FALSE ; */
		wan.port[port_number].modem_info.auto_answer = TRUE;
	}
	TmpSr = _GPL();
	_SPL(7);
	Stop_Tx_and_Rx(port_number);
#if PROXY_SERVER
   /* Get the connect message */
   record_connect_message (port_number) ;
   Flush_Rx_Tx_Buffers(port_number);
#else
#endif
	Just_FlushRxBufferUART(port_number);
	Just_FlushTxBufferUART(port_number);
/* Added By Naveen ... */
   Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added By Naveen */
	_SPL(TmpSr);

#if 0 /* Code Remove By Naveen */
	/* check if all the queues are in the reset state by checking the forward
	or backward pointers */
	if ((wan.port[port_number].xmited_tx_list.sptr_forward_link != NULL)
	    || (wan.port[port_number].current_rx_list.sptr_forward_link != NULL))
	{
		/* printf ("Buffers not cleared off\n") ; */
		flush_rx_buffers_sticking_around (port_number) ;
		return ;
	}
#endif

	/* Now change the state */
	inform_hldd_and_change_to_async_hdlc(port_number);
}	


void	wan_dec_modem_ticks(void)
{
	USHORT port_number;

	for (port_number = 0x0000; port_number < wan.number_of_ports; ++port_number)
	{
		if(wan.port[port_number].modem_info.status.wait_ticks)
			 wan.port[port_number].modem_info.status.wait_ticks--;
/* Sachin 03/07/1996 */
		if(wan.port[port_number].modem_info.status.call_back_delay)
			 wan.port[port_number].modem_info.status.call_back_delay--;
/* Sachin 03/07/1996 */
#if PROXY_SERVER
      if (wan.port[port_number].modem_info.status.flush_rx_buffer_counter)
         wan.port[port_number].modem_info.status.flush_rx_buffer_counter-- ;
#endif
	}
}

/**************************     							*******************************/
/* The following routines are needed for using the AHDLC microcode from
motorola. But we find that on RF200 the microcode is running into some
problem. SO we resort to software-quoting for rf200
*/

inform_hldd_and_change_to_async_hdlc(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
		
	modem_state_ptr->state = MDM_STATE_ONLINE;
	modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;

	if (wan.port[port_number].asyncport == TRUE && 
		wan.port[port_number].modem_info.configured_auto_answer &&
		get_wan_port_owner(port_number) == OWNED_BY_NONE)
	{
		/* Restart the stopped SCC */
		Start_Tx_and_Rx(port_number);

		/* For async ports that are on the answering end, don't inform HLDD.
		** Instead wait for and analyse the first packet.
		*/
		wan.port[port_number].packet_analysis_on = TRUE;
		start_analysing_packets_on_port(port_number);
		wan.port[port_number].analysed_once = FALSE;

/* sudhir 26/6/97 */
		check_for_user_name_and_send_prompt (port_number);
      wan.port[port_number].shell_menu_response_length = 0;

		/* Wait for a few seconds for a packet. After that much time expires, 
		** allot the port to AG inbound module rather than the HLDD.
		*/
		wan.port[port_number].packet_analysis_timer = ANALYSIS_WAIT_SECONDS;
		return;
	}

	/* Kamalnath 20\03\1997 SLIP */
	/* Chidanand 17/5/1997 Added condition for call back */
	if ((wan.port[(USHORT)port_number].modem_info.status.call_back_on == FALSE) &&
		(check_if_slip_is_enabled(port_number) == TRUE))
	{
		printf ("Running slip on (dialing) port %d\n", port_number) ;
		change_protocol_to_async(port_number, TRUE, SLIP_MODE);
		
		/* inform HLDD that port is up */
		lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			LOWER_DEVICE_DRIVER_SLIP_UP, port_number);
	}
	else
	{
   	if (modem_state_ptr->call_back_on)
	   {
         /* Chidanand - 17 May 1997 - Done here to avoid
            SLIP coming up on call back.
         */
		   modem_state_ptr->call_back_on = FALSE ; 
	   }

		change_protocol_to_async_hdlc(port_number);
		
		/* inform HLDD that port is up */
		lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			LOWER_DEVICE_DRIVER_UP, port_number);
	}
/* Kamalnath 20\03\1997 SLIP */

	/* inform HLDD that port is up */
	lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
   wan.port[port_number].statistics.connection_up_time = 0 ;
   wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
   wan.port[port_number].statistics.connection_bytes_received = 0 ;
   wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
   wan.port[port_number].statistics.connection_packets_received = 0 ;
   wan.port[port_number].statistics.number_of_calls++ ;
#endif
}

change_protocol_to_async_hdlc(USHORT port_number)
{
	USHORT	TmpSr;
	USHORT wan_buffer_size;

	TmpSr = _GPL();
	_SPL(7);

/* Sachin 05/07/1996 */
	flush_rx_buffers_sticking_around (port_number) ;
/* Sachin 05/07/1996 */

	Flush_Rx_Tx_Buffers(port_number);

#ifndef SOFTWARE_QUOTING
	wan_buffer_size = (USHORT) lsl_control (LSL_GET_PORT_MTU, port_number+lsl_control(GET_NUMBER_OF_LAN_PORTS));
#ifdef DEBUG
	printf ("Changing protocol to Async HDLC\n") ;
#endif /* DEBUG */

#if EVENT_LOG		/* Imran 7.4.99 */
		write_log(LOG_EVENT_CHANGING_TO_PPP ,(BYTE) (port_number + 1)); 
#endif

	switch(port_number)
	{
		case	0 :	
				InitSCC3_as_Async_HDLC(GetBaudDivisor(wan.port[port_number].port_speed),																			wan_buffer_size); 
				TurnOnTXAndRXOfSCC3();
				break;

		case	1 :
				InitSCC3_as_Async_HDLC(GetBaudDivisor(wan.port[port_number].port_speed),																			wan_buffer_size); 
				TurnOnTXAndRXOfSCC3();
				break;

		case	2 :
				InitSCC4_as_Async_HDLC(GetBaudDivisor(wan.port[port_number].port_speed),																			wan_buffer_size); 
				TurnOnTXAndRXOfSCC4();
				break;

		default:
				printf ("Invalid port to change protocol to AHDLC\n");
				break;
	}
#else
	change_protocol_to_async(port_number, TRUE);

#endif 			/* SOFTWARE_QUOTING */

	_SPL(TmpSr);
}

inform_hldd_and_change_to_async(USHORT port_number)
{
/* Ravi on 10-jan-2000 ... */
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	modem_state_ptr->this_end_dialed = FALSE;
/* ... Ravi on 10-jan-2000 */

	if (wan.port[port_number].packet_analysis_on == TRUE)
	{
		wan.port[port_number].packet_analysis_on = FALSE;
		return;
	}

	lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id, LOWER_DEVICE_DRIVER_DOWN, port_number);
	/* Kamalnath 14\03\1997 SLIP added fourth parameter */
	change_protocol_to_async(port_number, FALSE,ASYNC_PPP_OR_SLIP_MODE);

	/* chetan 22/11/96 */
/* Changed this condition by Ravi on 11-jan-2000 */
/*	if(wan.port[port_number].script_enabled)*/

	if (!wan.port[port_number].port_down_by_no_demand &&
			wan.port[port_number].script_enabled)
	{
		if (wan.port[port_number].restart_script_on_comm_failure)
		{
			if (wan.port[port_number].asyncport
					&& !wan.port[port_number].direct_connect_enabled)
			{
				if (!ScriptRunning ((BYTE) port_number))
				{
					printf ("Changing to async : Ready to execute script for port : %d \n\r", port_number) ;
					StartScript (port_number) ;
				}
			}
		}
	}
	/* chetan 22/11/96 */

}

/* Kamalnath 14\03\1997 SLIP added fourth parameter */
change_protocol_to_async(USHORT port_number, int for_routing, int mode)
{
	USHORT	TmpSr;
	USHORT wan_buffer_size;

	TmpSr = _GPL();
	_SPL(7);

	Flush_Rx_Tx_Buffers(port_number);

	wan_buffer_size = (USHORT) lsl_control (LSL_GET_PORT_MTU, port_number+lsl_control(GET_NUMBER_OF_LAN_PORTS));

#if EVENT_LOG		/* Imran 7.4.99 */
		write_log(LOG_EVENT_CHANGING_TO_UART, (BYTE) (port_number + 1)); 
#endif

	switch(port_number){
		case	0 :	
				/* Kamalnath 14\03\1997 SLIP added fourth parameter */
				InitSCC3(GetBaudDivisor(wan.port[port_number].port_speed), wan_buffer_size, for_routing, mode); 
 				TurnOnTXAndRXOfSCC3();
				break;

		case	1 :
				/* Kamalnath 14\03\1997 SLIP added fourth parameter */
				InitSCC3(GetBaudDivisor(wan.port[port_number].port_speed), wan_buffer_size, for_routing, mode); 
				TurnOnTXAndRXOfSCC3();
				break;

		case	2 :
				/* Kamalnath 14\03\1997 SLIP added fourth parameter */
				InitSCC4(GetBaudDivisor(wan.port[port_number].port_speed), wan_buffer_size, for_routing, mode); 
				TurnOnTXAndRXOfSCC4();
				break;

		default:
				return;
	}

	_SPL(TmpSr);
}
/**************************     							*******************************/

Flush_Rx_Tx_Buffers(USHORT port_number)
{
	WAN_TX_DESCRIPTOR *sptr_current_tx_descriptor;
	WAN_RX_DESCRIPTOR *sptr_current_rx_descriptor;

	Stop_Tx_and_Rx(port_number);

	/* Free up all the scheduled_for_rx  descriptors cause we are reinitialising
	the RxBDs */

	while (sptr_current_rx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].scheduled_for_rx))
	{
	   add_entry_to_list (&wan.port[port_number].free_rx_list,
										(LINK *) &sptr_current_rx_descriptor->links);
	}

	/* release current and all queued up descriptors by adding them to the 
	xmitted list. It will take care of freeing up the descriptor properly. */

	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].scheduled_for_tx) ) {
	   add_entry_to_list (&wan.port[port_number].xmited_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}

	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].current_tx_list) ) {
	   add_entry_to_list (&wan.port[port_number].xmited_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}

#if SMALL_PACKETS_FIRST
	while (sptr_current_tx_descriptor = get_entry_from_list ((LINK *) &wan.port[port_number].current_first_tx_list) ) {
	   add_entry_to_list (&wan.port[port_number].xmited_tx_list,
										(LINK *) &sptr_current_tx_descriptor->links);
	}
#endif

	wan.port[port_number].sptr_current_tx_descriptor = NULL;

}

Stop_Tx_and_Rx(port_number)
{
	switch(port_number){
		case	0 :						/* SCC 2 */
				Stop_Rx_Tx_on_SCC3();
				break;
		case	1 :						/* SCC 3 */
				Stop_Rx_Tx_on_SCC3();
				break;
		case	2 :						/* SCC 4 */
				Stop_Rx_Tx_on_SCC4();
				break;
		default:
				return;
	}
}

Start_Tx_and_Rx(port_number)
{
	switch(port_number){
		case	0 :						/* SCC 2 */
				Start_Rx_Tx_on_SCC3();
				break;
		case	1 :						/* SCC 3 */
				Start_Rx_Tx_on_SCC3();
				break;
		case	2 :						/* SCC 4 */
				Start_Rx_Tx_on_SCC4();
				break;
		default:
				return;
	}
}


/****************************************************************************
Routine	:	MdmStateDTRDialLinkDn
Synop	: Brings the link down by dropping DTR. Informs PPP that LLDD is down.
Goes to DTR_UP state.
****************************************************************************/
void	MdmStateDTRDialLinkDn(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	/* Set the DTR down for some time */

	SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number);
	
	if (wan.port[port_number].asyncport == FALSE)
	{
		lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
			LOWER_DEVICE_DRIVER_DOWN, port_number);

		reinitiaize_SYNC_port(port_number);		
	}
	else
	{		
		inform_hldd_and_change_to_async(port_number);
	} 

	modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_UP;	/* move the state */
	modem_state_ptr->wait_ticks = DTR_DIAL_DTR_DN_TIME;
}



/****************************************************************************
Routine	:	MdmStateDTRDialDTRDn
Synop	: Brings DTR down for some time. To facilitate DTR dialing.
****************************************************************************/
void	MdmStateDTRDialDTRDn(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;
	USHORT	TmpSr;

	if (modem_state_ptr->wait_ticks)
		return;

	if (wan.port[port_number].connection_started_by_DCD && is_DCD_present(port_number))
	{
		if (wan.port[port_number].asyncport == FALSE)
		{
			reinitiaize_SYNC_port(port_number);

			modem_state_ptr->state = MDM_STATE_ONLINE;
			modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;

			/* inform HLDD that port is up */
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				LOWER_DEVICE_DRIVER_UP, port_number);
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
         wan.port[port_number].statistics.connection_up_time = 0 ;
         wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
         wan.port[port_number].statistics.connection_bytes_received = 0 ;
         wan.port[port_number].statistics.number_of_calls++ ;
#endif
		}
		else
		{
			TmpSr = _GPL();
			_SPL(7);
			Stop_Tx_and_Rx(port_number);
			Just_FlushRxBufferUART(port_number);
			Just_FlushTxBufferUART(port_number);
/* Added By Naveen ... */
         Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added By Naveen */
			_SPL(TmpSr);

#if 0 /* Code Removed By Naveen */
			/* check if all the queues are in the reset state by checking the forward
			or backward pointers */
			if(wan.port[port_number].xmited_tx_list.sptr_forward_link != NULL || 
				wan.port[port_number].current_rx_list.sptr_forward_link != NULL ) {
				modem_state_ptr->wait_ticks = 1;	/* just  wait */
				return;
			}
#endif

         /* Now change the state */
			inform_hldd_and_change_to_async_hdlc(port_number);

		}
		modem_state_ptr->check_online_count = 0;		
		return;
	} 

	/* Set the DTR down for some time */
	SetLineConfigUART(SET_CONF_RESET_SIGS, LINE_STAT_DTR, port_number);

	modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_UP;	/* move the state */
	modem_state_ptr->wait_ticks = DTR_DIAL_DTR_DN_TIME;
}

	
/****************************************************************************
Routine	:	MdmStateDTRDialDTRUp
Synop	: Brings up DTR and then changes state to check for CD.
****************************************************************************/
void	MdmStateDTRDialDTRUp(USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)				/* don't move till ticks expire */
		return;

	/* Set the DTR up back */
	SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number);

	modem_state_ptr->check_online_count = 0;
	modem_state_ptr->state = MDM_STATE_DTR_DIAL_CHK_ONLINE;	/* move the state */
	modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;

}

/****************************************************************************
Routine	: MdmStateDTRDialChkOnline
Synop	: Checks for CD . If it is not up for a long time, initiates redial
by dropping DTR again.
****************************************************************************/

void	MdmStateDTRDialChkOnline(USHORT port_number)
{
	USHORT	TmpSr;
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	if (modem_state_ptr->wait_ticks)
		return;
		
	if (wan.port[port_number].connection_started_by_DCD && is_DCD_present(port_number))
	{
#if EVENT_LOG		/* Imran 7.4.99 */
		write_log(LOG_EVENT_MODEM_CONNECTED,(BYTE) (port_number + 1)); 
#endif

		if (wan.port[port_number].asyncport == FALSE)
		{
			reinitiaize_SYNC_port(port_number);

			modem_state_ptr->state = MDM_STATE_ONLINE;
			modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;

			/* inform HLDD that port is up */
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				LOWER_DEVICE_DRIVER_UP, port_number);
			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
				OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
         wan.port[port_number].statistics.connection_up_time = 0 ;
         wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
         wan.port[port_number].statistics.connection_bytes_received = 0 ;
         wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
         wan.port[port_number].statistics.connection_packets_received = 0 ;
         wan.port[port_number].statistics.number_of_calls++ ;
#endif
		}
		else
		{
			TmpSr = _GPL();
			_SPL(7);
			Stop_Tx_and_Rx(port_number);
			Just_FlushRxBufferUART(port_number);
			Just_FlushTxBufferUART(port_number);
/* Added By Naveen ... */
         Just_FlushTransmittedTxBufferUART(port_number);
/* ... Added By Naveen */
			_SPL(TmpSr);

#if 0 /* Code Removed By Naveen */	
         /* check if all the queues are in the reset state by checking the forward
			or backward pointers */
			if(wan.port[port_number].xmited_tx_list.sptr_forward_link != NULL || 
				wan.port[port_number].current_rx_list.sptr_forward_link != NULL ) {
				modem_state_ptr->wait_ticks = 1;	/* just  wait */
				return;
			}
#endif

         /* Now change the state */
			inform_hldd_and_change_to_async_hdlc(port_number);
		}
		modem_state_ptr->check_online_count = 0;		/* Used below */
	} 
	else
	{
		/**
		 ** The modem may try to dial and the other end does not respond.
		 ** After waiting for some time, the modem goes ON-HOOK. Now, unless
		 ** DTR is toggled, the modem will not redial. So, we wait for some time
		 ** ( 1.5 minute => DTR_DIAL_MAX_CHECK_ONLINE * MDM_STAT_CHK_ONLINE)
		 ** and then toggle DTR to reinitiate dialing.
		**/
		if (!wan.port[port_number].modem_info.auto_answer)
			if (modem_state_ptr->check_online_count++  > DTR_DIAL_MAX_CHECK_ONLINE)
				modem_state_ptr->state = MDM_STATE_DTR_DIAL_DTR_DN;

		modem_state_ptr->wait_ticks = MDM_STAT_CHK_ONLINE;
	}
}

void	reinitiaize_SYNC_port(port_number)
{
	USHORT	TmpSr;

	TmpSr = _GPL();
	_SPL(7);
 
	Flush_Rx_Tx_Buffers (port_number);
	InitSCC (port_number);
	enable_wan_tx_rx (port_number);

	_SPL(TmpSr);
}


/* Sachin 03/07/1996 */

void MdmStateCallBack (USHORT port_number)
{
	/* MODEM_STATUS *modem_state_ptr = &wan.port[port_number].modem_info.status ; */
	MODEM_INFO *modem_info_ptr = &wan.port[port_number].modem_info ;

	/* wait for the client to hangup the line. TILL CD GOES OFF!! */
	if (wan.port[port_number].connection_dropped_by_DCD && is_DCD_present(port_number))
		return;

	inform_hldd_and_change_to_async (port_number) ;

	/* now don't let the modem auto answer to any calls in between */
	WriteToPort(port_number, "ATS0=0\r", 0);		

#if EVENT_LOG		/* Imran 7.4.99 */
		write_log(LOG_EVENT_CALLBACK_ARRANGED, (BYTE) (port_number + 1)); 
#endif

	modem_info_ptr->dtr_dial = FALSE;
	modem_info_ptr->auto_answer = FALSE ;
	modem_info_ptr->status.state = MDM_STATE_OFFLINE;
	/*
		Now, start treating the modem state machine as another normal
	   state machine
	*/
}

/* Sachin 03/07/1996 */

void append_cr_if_necessary (BYTE *string)
{
	int string_length ;

	string_length = strlen(string);
	if (string_length >= 2)
		if(string[string_length - 2] != '^')
			strcat(string, "^M"); 
}

enum BOOLEAN is_callback_on (USHORT port_number)
{
	return (wan.port[port_number].modem_info.status.call_back_on) ;
}

/* Sachin 13/07/1997 */
void null_out_modem_strings (USHORT port_number)
{
   memset (&wan.port[port_number].modem_info.strings, 0, sizeof (MODEM_STRINGS)) ;
}
/* Sachin 13/07/1997 */


#if PROXY_SERVER

extern char *get_rx_buffer_SCC2 () ;
extern char *get_rx_buffer_SCC3 () ;
extern char *get_rx_buffer_SCC4 () ;

extern USHORT get_SCC2_rx_buffer_length () ;
extern USHORT get_SCC3_rx_buffer_length () ;
extern USHORT get_SCC4_rx_buffer_length () ;

void record_connect_message (USHORT port_number)
{
   BYTE *bptr_rx_buffer ;
   USHORT rx_buffer_length ;
   USHORT index ;

   switch (port_number)
   {
      case (0) :
         bptr_rx_buffer = get_rx_buffer_SCC3() ;
         rx_buffer_length = get_SCC3_rx_buffer_length() ;
         break ;

      case (1) :
         bptr_rx_buffer = get_rx_buffer_SCC3() ;
         rx_buffer_length = get_SCC3_rx_buffer_length() ;
         break ;

      case (2) :
         bptr_rx_buffer = get_rx_buffer_SCC4() ;
         rx_buffer_length = get_SCC4_rx_buffer_length() ;
         break ;
   }

   rx_buffer_length = MODEM_CONNECT_MESSAGE_LENGTH ;

   memset (&wan.port[port_number].statistics.modem_connect_message[0], 0, MODEM_CONNECT_MESSAGE_LENGTH) ;

   index = 0 ;
   while ((*bptr_rx_buffer) && (index < MODEM_CONNECT_MESSAGE_LENGTH - 1))
   {
      if ((*bptr_rx_buffer != 0x0A) && (*bptr_rx_buffer != 0x0D))
      {
         wan.port[port_number].statistics.modem_connect_message[index++] = *bptr_rx_buffer ;
      }
      bptr_rx_buffer++ ;
   }
}

/* Ravi on 10-jan-2000 ... */
BYTE is_dialing_initiated_by_this_end (USHORT port_number)
{
	MODEM_STATUS	*modem_state_ptr = &wan.port[port_number].modem_info.status;

	return (modem_state_ptr->this_end_dialed);
}
/* ... Ravi on 10-jan-2000 */


#endif



/**************************     Last  Line    *******************************/
