#include	"defs.h"
/*	                                                          				
* $lgb$
1.0 04/05/94 ross
1.1 04/05/94 ross initial release
1.2 09/22/94 ross
1.3 12/01/94 ross
* $lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.							*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.								*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/*	$Modname: wanini.c$  $version: 1.3$      $date: 12/01/94$   */
/************************************************************************/
#define GLOBAL_FILE
#include <stdio.h>
#include <stdarg.h>
#include "wan.h"
#include "scc.h"
#include <udb.h>
int	ASyncHdlRxError;
int	ASyncHdlTxError;
int	ASyncHdlNotLastInFrame;
#include <softquot.h>
/****************************************************************************/
extern void	wan1_timer_function(void);
extern void	wan2_timer_function(void);
extern void	wan3_timer_function(void);
void	(* fnptr_wan_timer_functions[])() = {
	wan1_timer_function,
	wan2_timer_function,
	wan3_timer_function,
};

static void initialize_wan_tx (USHORT port_number);
static void initialize_tx_descriptors (USHORT port_number);
static void initialize_wan_rx (USHORT port_number);
static void initialize_rx_descriptors (USHORT port_number,USHORT wan_buffer_size);

static void set_rx_accm_of_port(ULONG port_number ,ULONG accm);
static void set_tx_accm_of_port(ULONG port_number ,ULONG accm);
void compute_async_brg_config_values();
void compute_sync_brg_config_values();


extern void set_tx_accm_wan_port0(ULONG);
extern void set_tx_accm_wan_port1(ULONG);
extern void set_tx_accm_wan_port2(ULONG);
extern void set_rx_accm_wan_port0(ULONG);
extern void set_rx_accm_wan_port1(ULONG);
extern void set_rx_accm_wan_port2(ULONG);


extern void TurnOnTXAndRXOfSCC2(void);
extern void TurnOnTXAndRXOfSCC3(void);
extern void TurnOnTXAndRXOfSCC4(void);
enum TEST wan_control (enum DEVICE_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1);
void	enable_wan_tx_rx(USHORT port_number);

ULONG  LocalIOToMove = 0xC7;        /* none of the ports are Internal Clock */

extern void StartScript (USHORT port_number) ;


/* Sachin 13/07/1997 */
extern void null_out_modem_strings (USHORT port_number) ;
extern int does_port_have_a_backup (port_number) ;
/* Sachin 13/07/1997 */


/****************************************************************************/
enum TEST initialize_wan_controller (ULONG clock_ticks_per_second)
{
	USHORT port_number;

	PARAMETER_NOT_USED (clock_ticks_per_second);

	if (wan.enabled == FALSE)
		{
		return (PASS);
		}

	CommonInitSCC();
	
	init_wan_port_owner_table();

/* Added by Naveen 3/3/1998... */   
   compute_async_brg_config_values();
   compute_sync_brg_config_values();
/* ... Added by Naveen 3/3/1998 */   

	for (port_number = 0x0000; port_number < wan.number_of_ports; ++port_number)
	{
		if (wan.port[port_number].enabled == TRUE)
		{
/* Sachin 13/07/1997 */
         /* For a direct connected WAN port, if there is a backup, change
            the port from Direct Connected to Null Modem connected */
            
         if ((wan.port[port_number].direct_connect_enabled) &&
             (wan.port[port_number].asyncport))
         {
            /* if (does_port_have_a_backup (port_number)) */
            if (FALSE)
            {
               wan.port[port_number].direct_connect_enabled = FALSE ;
               null_out_modem_strings (port_number) ;
            }
         }
/* Sachin 13/07/1997 */
			if (wan.port[port_number].asyncport == TRUE)
			{
				wan.port[port_number].device_driver_id = lsl_control (LSL_REGISTER_SERIAL_DEVICE_DRIVER, port_number, "WAN Driver",
					ASYNCHRONOUS_SERIAL_DRIVER,
					(enum TEST (*) (USHORT port_number, USHORT virtual_port_number, SERIAL_BUFFER *sptr_tx_buffer,
					USHORT number_of_bytes,	enum BOOLEAN do_not_calculate_new_crc, enum BOOLEAN device_driver_buffer,
					void (*fptr_tx_completion) (USHORT port_number, SERIAL_BUFFER *sptr_wan_buffer)))
					send_wan_packet,
					wan_packet_transmitted,
					(enum BOOLEAN (*) (USHORT port_number, void **vptr_buffer, USHORT *usptr_number_of_bytes_rxed))
					wan_packet_received,
					fnptr_wan_timer_functions[port_number],
	   				(enum TEST (*) (enum SERIAL_DRIVER_CONTROL command, ULONG parameter_0, ULONG parameter_1)) wan_control,
					wan_return_buffer_to_device_driver);
			}
			else
			{
					wan.port[port_number].device_driver_id = lsl_control (LSL_REGISTER_SERIAL_DEVICE_DRIVER, port_number, "SYNC Driver",
						SYNCHRONOUS_SERIAL_DRIVER,
						(enum TEST (*) (USHORT port_number, USHORT virtual_port_number, SERIAL_BUFFER *sptr_tx_buffer,
						USHORT number_of_bytes,	enum BOOLEAN do_not_calculate_new_crc, enum BOOLEAN device_driver_buffer,
						void (*fptr_tx_completion) (USHORT port_number, SERIAL_BUFFER *sptr_wan_buffer)))
						send_wan_packet,
						wan_packet_transmitted,
						(enum BOOLEAN (*) (USHORT port_number, void **vptr_buffer, USHORT *usptr_number_of_bytes_rxed))
						wan_packet_received,
						fnptr_wan_timer_functions[port_number],
	   						(enum TEST (*) (enum SERIAL_DRIVER_CONTROL command, ULONG parameter_0, ULONG parameter_1)) wan_control,
						wan_return_buffer_to_device_driver);
			}
			if (wan.port[port_number].device_driver_id == INVALID_DEVICE_ID)
			{
				printf("\n\r WAN FAILED TO INIT ");
				return (FAIL);
			}

#ifdef FRAME_RELAY
			switch (wan.port[port_number].hldd_type)
			{
				case (HLDD_TYPE_PPP) :
					wan_printf (WAN_INITIALIZATION_PRINTF, "WAN : Port %d configured for PPP\n", port_number) ;
					break ;
				case (HLDD_TYPE_SLIP) :
					wan_printf (WAN_INITIALIZATION_PRINTF, "WAN : Port %d configured for SLIP\n", port_number) ;
					break ;
				case (HLDD_TYPE_FRAME_RELAY) :
					wan_printf (WAN_INITIALIZATION_PRINTF, "WAN : Port %d configured for Frame Relay\n", port_number) ;
					break ;
				default :
					wan_printf (WAN_INITIALIZATION_PRINTF, "WAN : Port %d configured for unknown HLDD\n", port_number) ;
					break ;
			}
			if (wan.port[port_number].hldd_type == HLDD_TYPE_FRAME_RELAY)
			{
				initialize_wan_tx (port_number) ;
				initialize_wan_rx (port_number) ;

				if (InitSCC (port_number))
					printf ("WAN : Initialized port number %d\n", port_number) ;
				else
					printf ("WAN : Failed to initialize port number %d\n", port_number) ;

				wan.port[port_number].modem_info.status.state = MDM_STATE_ABSENT;
				lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
					LOWER_DEVICE_DRIVER_UP, port_number);

				lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
					OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
            wan.port[port_number].statistics.connection_up_time = 0 ;
            wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
            wan.port[port_number].statistics.connection_bytes_received = 0 ;
            wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
            wan.port[port_number].statistics.connection_packets_received = 0 ;
            wan.port[port_number].statistics.number_of_calls++ ;
#endif
			}
#endif

#ifndef __DOD__
			initialize_wan_tx (port_number);
			initialize_wan_rx (port_number);

			if (InitSCC(port_number))
			{
				printf("WAN: Initialized port number %d\n", port_number);
			}
			else
			{
				printf("WAN: FAILED port init. Port number %d\n", port_number);
			}
			if (wan.port[port_number].asyncport == TRUE)
			{
				/* there might be a dial-up modem on this port */
				initialize_connection_on_port(port_number);
			}
			else
			{
				wan.port[port_number].modem_info.status.state = MDM_STATE_ABSENT;
				lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
					LOWER_DEVICE_DRIVER_UP, port_number);

				lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[port_number].device_driver_id,
					OPEN_DEVICE_DRIVER_PORT, port_number);
#if PROXY_SERVER
            wan.port[port_number].statistics.connection_up_time = 0 ;
            wan.port[port_number].statistics.connection_bytes_transmitted = 0 ;
            wan.port[port_number].statistics.connection_bytes_received = 0 ;
            wan.port[port_number].statistics.connection_packets_transmitted = 0 ;
            wan.port[port_number].statistics.connection_packets_received = 0 ;
            wan.port[port_number].statistics.number_of_calls++ ;
#endif
			} /* end of if-then-else */

			/* Chetan 22/11/96 */
			if (wan.port[port_number].script_enabled)
			{
/* Ravi on 11-jan-2000 ... */
				wan.port[port_number].port_down_by_no_demand = FALSE;
/* ... Ravi on 11-jan-2000 */

				if (wan.port[port_number].asyncport
						&& !wan.port[port_number].direct_connect_enabled)
				{
					printf ("INIT WAN PORT : Ready to execute script for port : %d \n\r", port_number) ;
					StartScript (port_number) ;
				}
			}
			/* Chetan 22/11/96 */

#endif /* __DOD__ */

		}/* end of outer if */
	} /* end of for */

	wan.number_of_lan_ports = (USHORT) lsl_control (GET_NUMBER_OF_LAN_PORTS);

	return (PASS);
}
/**************************************************************************/
/**************************************************************************/
static void initialize_wan_tx (USHORT port_number)
{
	initialize_tx_descriptors (port_number);
}
/****************************************************************************/
/* in here all the buffer descriptors defined statically are put in free tx 
	 list. When ever a packet is to transmitted a free descripotor is got from
	 this list and is initialized. look in wantx.c.
*/
/****************************************************************************/
static void initialize_tx_descriptors (USHORT port_number)
{
	WAN_PORT_CLASS *sptr_wan_port_class;
	USHORT number_of_tx_descriptors;

	sptr_wan_port_class = &wan.port[port_number];

	for (number_of_tx_descriptors = 0; number_of_tx_descriptors < NUMBER_OF_TX_BUFFERS; ++number_of_tx_descriptors)
		{
		sptr_wan_port_class->tx_descriptor[number_of_tx_descriptors].in_use = FALSE;
		sptr_wan_port_class->tx_descriptor[number_of_tx_descriptors].device_driver_buffer = FALSE;
		sptr_wan_port_class->tx_descriptor[number_of_tx_descriptors].sptr_tx_packet = NULL;
		sptr_wan_port_class->tx_descriptor[number_of_tx_descriptors].fptr_tx_complete = NULL;

		add_entry_to_list (&sptr_wan_port_class->free_tx_list,
			&sptr_wan_port_class->tx_descriptor[number_of_tx_descriptors].links);
		}
}
/**************************************************************************/
static void initialize_wan_rx (USHORT port_number)
{
	USHORT wan_buffer_size;

	wan_buffer_size = (USHORT) lsl_control (LSL_GET_PORT_MTU, port_number+lsl_control(GET_NUMBER_OF_LAN_PORTS));

	initialize_rx_descriptors (port_number, wan_buffer_size);
}

/****************************************************************************/
/*  we try to allocate the buffer using device_driver_malloc and put the ptr 
		in rx buffer descriptor. if we are  successfull we add the descriptor to
		free_rx_list else we add it to need_buffer_list.
*/
/****************************************************************************/
static void initialize_rx_descriptors (USHORT port_number, USHORT wan_buffer_size)
{
	WAN_PORT_CLASS *sptr_wan_port_class;
	USHORT number_of_rx_descriptors;
	/* USHORT total_number_of_rx_descriptors; */

	sptr_wan_port_class = &wan.port[port_number];

/* total_number_of_rx_descriptors = (USHORT) lsl_control (GET_CURRENT_RX_BUFFER_LIST_SIZE, */
/* wan.port[port_number].device_driver_id); */

/* wan.port[port_number].number_of_rx_buffers = (USHORT) (total_number_of_rx_descriptors - */
/* NUMBER_OF_SYSTEM_BUFFERS_TO_LEAVE_FREE); */

/* for (number_of_rx_descriptors = 0; number_of_rx_descriptors < wan.port[port_number].number_of_rx_buffers; */
	for (number_of_rx_descriptors = 0; number_of_rx_descriptors < NUMBER_OF_RX_BUFFERS;
		++number_of_rx_descriptors)
   {
		sptr_wan_port_class->rx_descriptor[number_of_rx_descriptors].buffer_size = wan_buffer_size;
		sptr_wan_port_class->rx_descriptor[number_of_rx_descriptors].sptr_rx_buffer =
			(SERIAL_BUFFER *)device_driver_malloc (port_number, wan.port[port_number].device_driver_id, (USHORT) NULL);

		sptr_wan_port_class->rx_descriptor[number_of_rx_descriptors].number_of_bytes_rxed = 0x0000;

		if (sptr_wan_port_class->rx_descriptor[number_of_rx_descriptors].sptr_rx_buffer != NULL)
      {
			add_entry_to_list (&sptr_wan_port_class->free_rx_list,
				&sptr_wan_port_class->rx_descriptor[number_of_rx_descriptors].links);
		}
      else
      {
			wan_printf(WAN_INITIALIZATION_PRINTF, "WAN: Number of Device driver buffers allocated for port %04X : %d\n", port_number, number_of_rx_descriptors);
         /* Vidy 05/06/97 break if we can't get any more device driver buffers */
	      while (1)
   	      printf("WAN: %d buffers for WAN port %04x, Needs atleast %d buffers\n", number_of_rx_descriptors, port_number, NUMBER_OF_RX_BUFFERS);
			/*
			break;
			add_entry_to_list (&sptr_wan_port_class->rx_descriptor_need_buffer_list,
				&sptr_wan_port_class->rx_descriptor[number_of_rx_descriptors].links);
				*/
		}
	}
   if (number_of_rx_descriptors < 2 * NUMBER_OF_SCC_RX_BDS)
   {
      while (1)
         printf("WAN: Too few buffers for WAN port %04x, Needs reconfiguration\n", port_number);
   }
   /* Vidy 05/06/97 changed the second parameter */
	lsl_control (SET_CURRENT_RX_BUFFER_LIST_SIZE, wan.port[port_number].device_driver_id, number_of_rx_descriptors);
}

enum TEST wan_control (enum DEVICE_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	MODEM_INFO	*modem_info_ptr;
	MODEM_STATUS *modem_state_ptr ;
	USHORT port_number ;
	RAS_USER_DATABASE_RECORD *sptr_ras_udb_record ;

	PARAMETER_NOT_USED(parameter_1);

	modem_info_ptr = &wan.port[(USHORT)parameter_0].modem_info;

	switch (command)
	{
/* Ravi on 11-jan-2000 ... */
		case  PORT_DOWN_BY_DEMAND:
			wan.port[(USHORT)parameter_0].port_down_by_no_demand = TRUE;
			break;
/* ... Ravi on 11-jan-2000 */

		case INIT_SERIAL_PORT:
#ifdef FRAME_RELAY
			if (wan.port[(USHORT)parameter_0].hldd_type == HLDD_TYPE_FRAME_RELAY)
				break ;
#endif

#ifdef __DOD__
			/* Chidanand - 10 Apr 1997 - Avoid initialization, if port is disabled */
			if (wan.port[parameter_0].enabled == FALSE) 
				return (FAIL);
			/* Chidanand - 10 Apr 1997 */
			initialize_wan_tx (parameter_0);
			initialize_wan_rx (parameter_0);

			if (InitSCC(parameter_0))
			{
				printf("WAN: Initialized port number %d\n", parameter_0);
			}
			else
			{
				printf("WAN: FAILED port init. Port number %d\n", parameter_0);
			}
			if (wan.port[(USHORT)parameter_0].asyncport == TRUE)
			{
				/* there might be a dial-up modem on this port */
				initialize_connection_on_port((USHORT)parameter_0);
			} 

			/* Chetan 22/11/96 */
			if (wan.port[(USHORT) parameter_0].script_enabled)
			{
				if (wan.port[(USHORT) parameter_0].asyncport
						&& !wan.port[(USHORT) parameter_0].direct_connect_enabled)
				{
					printf ("INIT SERIAL PORT : Ready to execute script for port : %d \n\r", parameter_0) ;
					StartScript ((USHORT) parameter_0) ;
				}
			}
			/* Chetan 22/11/96 */

#endif /* __DOD__ */
			break;



		case OPEN_SERIAL_PORT:
#ifdef FRAME_RELAY
			if (wan.port[(USHORT)parameter_0].hldd_type == HLDD_TYPE_FRAME_RELAY)
			{
				enable_wan_tx_rx ((USHORT)parameter_0) ;
				break ;
			}
#endif
			/* Chidanand - 17 May 1997 */
			if (wan.port[(USHORT)parameter_0].modem_info.status.call_back_on)
				break;
			/* Chidanand - 17 May 1997 */

			/* printf ("wan_control() called with OPEN_SERIAL_PORT for port number %d\n", parameter_0) ; */
#ifdef __DOD__

			/* Copy the initialization strings from parameter_1 into the wan 
			structure. Use these strings in the modem state machine. */

			/* If port is SYNC or ASYNC-ModemConnected-NoStrings, then
			DTR Dialing is enabled */

			modem_info_ptr->dtr_dial = FALSE;
			modem_info_ptr->auto_answer = modem_info_ptr->configured_auto_answer ;

			if (wan.port[(USHORT)parameter_0].asyncport == FALSE)
				modem_info_ptr->dtr_dial = TRUE;
			else 
			{ 
				if (wan.port[(USHORT)parameter_0].direct_connect_enabled == FALSE &&
					!modem_info_ptr->auto_answer &&
					!modem_info_ptr->strings.dial_string[0])
					modem_info_ptr->dtr_dial = TRUE;
			}
			/** If port is SYNC or DTR Dialing enabled, state = DTR_DIAL.
			 ** Sync port is always in DTR_DIAL_STATE whether answering/dialing
			 ** because, there are no strings to be sent and CD has to be
          ** present for data transfer to take place (even in direct_connect).
			**/
			if (modem_info_ptr->dtr_dial == TRUE) 
			{
				/* 22/05/96 Vidy changed this from MDM_STATE_DTR_DIAL_DTR_DN */
				modem_info_ptr->status.state = MDM_STATE_DTR_DIAL_DTR_UP;
			}
			else
			{	/* Port is Async */
				if (wan.port[(USHORT)parameter_0].direct_connect_enabled == FALSE) {
					/* Bring up DTR since Command Mode dialing */
					/* SetLineConfigUART(SET_CONF_SET_SIGS, LINE_STAT_DTR, (USHORT)parameter_0); */
					modem_info_ptr->status.wait_ticks = 0;
					modem_info_ptr->status.state = MDM_STATE_OFFLINE;
				}
			}

			/* Finally enable rx and tx on the port. */
			enable_wan_tx_rx((USHORT)parameter_0);

/* Ravi 11-jan-2000 ... */
			if (wan.port[(USHORT)parameter_0].port_down_by_no_demand &&
				 wan.port[(USHORT)parameter_0].script_enabled)
			{
				if (wan.port[(USHORT)parameter_0].restart_script_on_comm_failure)
				{
					if (wan.port[(USHORT)parameter_0].asyncport
							&& !wan.port[(USHORT)parameter_0].direct_connect_enabled)
					{		
						SetLineConfigUART (SET_CONF_SET_SIGS, LINE_STAT_DTR, parameter_0) ;
						if (!ScriptRunning ((BYTE)parameter_0))
						{
							wan.port[(USHORT)parameter_0].port_down_by_no_demand = FALSE;
							printf ("WAN: OPEN SERIAL PORT: Ready to restart script- port : %d \n\r", (USHORT)parameter_0) ;
							StartScript (parameter_0) ;
						}
					}
				}
			}
/* ... Ravi 11-jan-2000 */

#endif /* __DOD__ */

			break;


		case CLOSE_SERIAL_PORT:
			if (wan.port[(USHORT)parameter_0].modem_info.status.call_back_on)
				break ;


			if (wan.port[(USHORT)parameter_0].asyncport && 
					wan.port[(USHORT)parameter_0].direct_connect_enabled)
			{	
			}
			else
			{
				/* Port is SYNC or ASYNC-ModemConnected, check for CD */
			 	if (is_DCD_present( (USHORT)parameter_0) )
				{
					if (modem_info_ptr->dtr_dial)
						modem_info_ptr->status.state = MDM_STATE_DTR_DIAL_LINK_DN;
					else
						modem_info_ptr->status.state = MDM_STATE_HUP_DTR_DN;
				}
			} 
			
			break;


		case SET_RX_ACCM_SERIAL_PORT:
#ifndef SOFTWARE_QUOTING
			if  (wan.port[(USHORT)parameter_0].asyncport) 
			{
				set_rx_accm_of_port(parameter_0,parameter_1);
			}
#endif
			break;



		case SET_TX_ACCM_SERIAL_PORT:
#ifndef SOFTWARE_QUOTING
			if  (wan.port[(USHORT)parameter_0].asyncport) 
			{
				set_tx_accm_of_port(parameter_0,parameter_1);
			}
#endif
			break;

		
		case CHECK_IF_ANSWERING:
			*((BYTE *)parameter_1) = wan.port[(USHORT)parameter_0].modem_info.auto_answer;
			break;


/* Sachin 28/06/1996 */

		case WAIT_AND_CALL_BACK :

			sptr_ras_udb_record = (RAS_USER_DATABASE_RECORD *)parameter_1 ;

			port_number = (USHORT) parameter_0 ;
			modem_state_ptr = &wan.port[port_number].modem_info.status ;
			construct_dial_string ((USHORT)port_number, sptr_ras_udb_record->call_back_number) ;

			modem_state_ptr->state = MDM_STATE_CALLBACK ;
			/******** Make sure where it has to be reset to FALSE ******/
			modem_state_ptr->call_back_on = TRUE ;
			printf ("CALLBACK : preparing to call back on port %d\n", (USHORT)parameter_0) ;
			modem_state_ptr->call_back_delay = 2 ;
			/* This (2 seconds can be removed later) */
			modem_state_ptr->wait_ticks = sptr_ras_udb_record->call_back_delay ;

			lsl_control (HIGH_LEVEL_DEVICE_DRIVER_PORT, wan.port[parameter_0].device_driver_id,
				LOWER_DEVICE_DRIVER_DOWN, parameter_0);

			break;

/* Sachin 28/06/1996 */
		}

	return (PASS);
}
/*************************************************************************/
void wan_printf (enum WAN_PRINTF_GROUPS printf_group,const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr, cptr_format);

	if (wan.printing_enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case WAN_INITIALIZATION_PRINTF:
			print_string = wan.initialization_printing_enabled;
			break;
								 
		case WAN_RX_PRINTF:
			print_string = wan.rx_printing_enabled;
			break;

		case WAN_TX_PRINTF:
			print_string = wan.tx_printing_enabled;
			break;
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format, argptr);
		}

	va_end (argptr);
}


/****************************************************************************
	If the actual baudrate is exactly equal to any of the defined values
	return the Baudrate divisor corresponding to that index.
	Otherwise return the divisor value which is nearest to it
****************************************************************************/
int GetBaudDivisor (int ActualBaudRate)
{
	int index = 0 ;

	if ((ActualBaudRate < BaudRateValues[0]) ||
		 (ActualBaudRate > BaudRateValues[MAX_BAUD_INDEX]))
	{
		wan_printf (WAN_INITIALIZATION_PRINTF,
			"Invalid Baud rate %d, Will be set to 9600\n",	ActualBaudRate);
		return BRGConfigValues[DEFAULT_BAUD_INDEX];
	}

	while (BaudRateValues[index] < ActualBaudRate)
		index++ ;

	if (BaudRateValues[index] == ActualBaudRate)	/* actual rate is exactly */
		return(BRGConfigValues[index]);				/* matching */

	if (ActualBaudRate < ( (BaudRateValues[index] + BaudRateValues[index-1]) >> 1) )
		index--;					/* nearer to lower index */

	return BRGConfigValues[index];
}

/******************************************************************************/
/******************************************************************************/
int	InitSCC(USHORT port_number)
{
	int port_speed;
	USHORT	wan_buffer_size;

	wan_buffer_size = (USHORT) lsl_control (LSL_GET_PORT_MTU, port_number+lsl_control(GET_NUMBER_OF_LAN_PORTS));

	/* Srikar, Mar 30, 1997. Added calls to lsl_control to register the port speed */
	if (wan.port[port_number].asyncport == TRUE)
	{
		port_speed = GetBaudDivisor(wan.port[port_number].port_speed);
		lsl_control(SET_PORT_SPEED, wan.number_of_lan_ports + port_number, wan.port[port_number].port_speed);
	}
	else
	{
		if (wan.port[port_number].InternalClk == TRUE)
		{
			port_speed = GetSyncBaudDivisor(wan.port[port_number].sync_port_speed);
			lsl_control(SET_PORT_SPEED, wan.number_of_lan_ports + port_number, wan.port[port_number].sync_port_speed);
			if (port_number == 0)
						LocalIOToMove &= 0xFD; /* 0xFE; Changed for Firewall */
			if (port_number == 1)
						LocalIOToMove &= 0xFD; 
			if (port_number == 2)
						LocalIOToMove &= 0xFB; 
		}
		else 
		{
			port_speed = 0;
			lsl_control(SET_PORT_SPEED, wan.number_of_lan_ports + port_number, 0);
		}
	}

#ifdef FRAME_RELAY
	SetLineConfigUART (SET_CONF_SET_SIGS, LINE_STAT_DTR, port_number) ;
#endif

	switch (port_number) 
	{
		case 0:
			if (wan.port[port_number].asyncport == TRUE)
			{
				/* 06/10/96 Vidy added third parameter */
				/* 14/03/97 Kamalnath added fourth parameter */
				InitSCC3(port_speed,wan_buffer_size, FALSE, ASYNC_PPP_OR_SLIP_MODE);
			}
			else
			{
				init_SCC3_as_HDLC(port_speed,wan_buffer_size,
					wan.port[port_number].sync_xmit_idle_flags);
			}
			break;
	
		case 1:
			if (wan.port[port_number].asyncport == TRUE)
			{
				/* 06/10/96 Vidy added third parameter */
				/* 14/03/97 Kamalnath added fourth parameter */
				InitSCC3(port_speed,wan_buffer_size, FALSE, ASYNC_PPP_OR_SLIP_MODE);
			}
			else 
			{
				init_SCC3_as_HDLC(port_speed,wan_buffer_size,
						wan.port[port_number].sync_xmit_idle_flags);
			}
			break;
		
			case 2:
			if (wan.port[port_number].asyncport == TRUE)
			{
				/* 06/10/96 Vidy added third parameter */
				/* 14/03/97 Kamalnath added fourth parameter */
				InitSCC4(port_speed,wan_buffer_size, FALSE, ASYNC_PPP_OR_SLIP_MODE);
			}
			else 
			{
				init_SCC4_as_HDLC(port_speed,wan_buffer_size,
						wan.port[port_number].sync_xmit_idle_flags);
			}
			break;
	}
	return(PASS);
}


void	enable_wan_tx_rx(USHORT port_number)
{
			if (wan.port[port_number].enabled == TRUE){
				switch (port_number)
				{
					case 0: 
						TurnOnTXAndRXOfSCC3();
						break;
					case 1: 
						TurnOnTXAndRXOfSCC3();
						break;
					case 2: 
						TurnOnTXAndRXOfSCC4();
						break;
				}
			}
}
/****************************************************************************
	If the actual baudrate is exactly equal to any of the defined values
	return the Baudrate divisor corresponding to that index.
	Otherwise return the divisor value which is nearest to it
****************************************************************************/


int GetSyncBaudDivisor(int ActualBaudRate)
{
	int index=0;

	if((ActualBaudRate < SyncBaudRateValues[0]) ||
			(ActualBaudRate > SyncBaudRateValues[SYNC_MAX_BAUD_INDEX]) ) {
		wan_printf(WAN_INITIALIZATION_PRINTF,
			"Invalid Baud rate %d, Will be set to 9600\n",	ActualBaudRate);
		return SyncBRGConfigValues[SYNC_DEFAULT_BAUD_INDEX];
	}

	while (SyncBaudRateValues[index] < ActualBaudRate)
		index++;

	if (SyncBaudRateValues[index] == ActualBaudRate)	/* actual rate is exactly */
		return(SyncBRGConfigValues[index]);				/* matching */

	if (ActualBaudRate < ( (SyncBaudRateValues[index] + SyncBaudRateValues[index-1]) >> 1) )
		index--;					/* nearer to lower index */

	return SyncBRGConfigValues[index];
}

#ifndef SOFTWARE_QUOTING
static void set_rx_accm_of_port(ULONG port_number,ULONG accm)
{
	switch (port_number)
	{
		case 0 :
			set_rx_accm_wan_port1(accm);
			break;

		case 1 :
			set_rx_accm_wan_port1(accm);
			break;

		case 2 :
			set_rx_accm_wan_port2(accm);
			break;
	}
}

static void set_tx_accm_of_port(ULONG port_number,ULONG accm)
{
	switch (port_number)
	{
		case 0 :
			set_tx_accm_wan_port1(accm);
			break;

		case 1 :
			set_tx_accm_wan_port1(accm);
			break;

		case 2 :
			set_tx_accm_wan_port2(accm);
			break;
	}
}
#endif

/* Naveen 3/3/1998 : Added new function to compute BaudDivisors. 
   This function will compute for those baud rates present in the
   scc.h in array BaudRateValues[].
*/
void compute_async_brg_config_values()
{  
   int index = 0;
   int speed;
#if WAN_DEBUG
   char buffer[200], temp_buffer[30];
   strcpy(buffer, "Baud Divisors: ");
#endif

#if __SPEED__ == 25
   speed = 25000000;
#elif __SPEED__ == 258048
   speed = 25804800;
#elif __SPEED__ == 33344
   speed = 33344000;
#elif __SPEED__ == 331776
   speed = 33177600;
#endif   

   for ( index = 0 ; index < MAX_BAUD_RATES_SUPPORTED ; ++index)
   {
      BRGConfigValues[index] = (( ( speed ) / ( 16 * BaudRateValues[index] * ((BaudRateValues[index] < 600) ? 16 : 1 ) ) - 1)) * 2 +  ((BaudRateValues[index] < 600) ? 1 : 0); 
#if WAN_DEBUG  
      sprintf(temp_buffer, "%x ",BRGConfigValues[index]);
      strcat(buffer, temp_buffer);
#endif
   }
#if WAN_DEBUG  
   printf("%s\n", buffer);
#endif
}

/* Naveen 23/3/1998 : Added new function to compute BaudDivisors. 
   This function will compute for those baud rates present in the
   scc.h in array syncBaudRateValues[].
*/
void compute_sync_brg_config_values()
{  
   int index = 0;
   int speed;
#if WAN_DEBUG
   char buffer[200], temp_buffer[30];
   strcpy(buffer, "Sync Baud Divisors: ");
#endif

#if __SPEED__ == 25
   speed = 25000000;
#elif __SPEED__ == 258048
   speed = 25804800;
#elif __SPEED__ == 33344
   speed = 33344000;
#elif __SPEED__ == 331776
   speed = 33177600;
/*   speed = 25804800;*/
#endif                  

   for ( index = 0 ; index < MAX_SYNC_BAUD_RATES_SUPPORTED; ++index)
   {
      SyncBRGConfigValues[index] = ((( speed ) / ( SyncBaudRateValues[index] * ((SyncBaudRateValues[index] < 64000) ? 16 : 1 ) ) - 1)) * 2 +  ((SyncBaudRateValues[index] < 64000) ? 1 : 0); 
#if WAN_DEBUG  
      sprintf(temp_buffer, "%x ", SyncBRGConfigValues[index]);
      strcat(buffer, temp_buffer);
#endif
   }
#if WAN_DEBUG  
   printf("%s\n", buffer);
#endif
}

