/*---------------------------------------------------------------------------
	file	:	log.c
	Auth	:	vidy
	Date	:	30th Jan 98
	Synop	:	Contains the interface routines for the log abstract data type
	Assumptions :
	1. Log can log only message strings with a null termination.
	2. This is for logging events which are not-too-fast. SO it
	assumes that the log read is a much faster operation than log write.
	If this is not the case the read pointers may become invalid during
	a read process as the circular buffer eats up the head
	3. log functions are not to be used from ISRs
---------------------------------------------------------------------------*/
void	init_log(void);
void	clean_log(void);
int	open_log(void);
int	close_log(int log_descriptor);
int	read_log(int log_descriptor, char *buffer, int count);
int	get_info_log(int *approx_total_size, int *approx_number_of_msgs);

extern	unsigned long log_size;		/* log file size */
extern	int	log_enabled;			/* flag to turn on/off logging dynamic */
extern	int	time_stamp_log;

#define	LOG_NOT_LOGGING			-1
#define	LOG_INVALID_DESCRIPTOR	-2
#define	LOG_ERR_MAX_OPEN			-3

#define	LOG_NORMAL_MSG_LEN		80	/* just for easy access every where */

/* Imran 30/06/98 */

enum events_log { 		LOG_EVENT_REMOTE_PAP_AUTH_FAIL,
                        LOG_EVENT_LOG_INIT,
                        LOG_EVENT_MODEM_INIT,
                        LOG_EVENT_MODEM_DIAL,
                        LOG_EVENT_MODEM_ERROR,
                        LOG_EVENT_MODEM_NO_RESP,
                        LOG_EVENT_MODEM_ERR_NO_ANSWR,
                        LOG_EVENT_MODEM_NO_CONNECT_RESP,
                        LOG_EVENT_MODEM_CONNECTED,
                        LOG_EVENT_MODEM_RING,
								LOG_EVENT_NO_DIAL_TONE,	
                        LOG_EVENT_DIALING,
                        LOG_EVENT_DCD_DETECTED,
                        LOG_EVENT_DCD_LOST,
								LOG_EVENT_CHANGING_TO_PPP,
								LOG_EVENT_CHANGING_TO_UART,
								LOG_EVENT_CALLBACK_ARRANGED,				
								LOG_EVENT_CALLBACK_CANCELLED,
                        LOG_EVENT_CHAP_AUTH_OK,
                        LOG_EVENT_CHAP_AUTH_FAIL,
                        LOG_EVENT_REMOTE_PAP_AUTH_OK,
                        LOG_EVENT_PAP_AUTH_OK,
                        LOG_EVENT_PAP_AUTH_FAIL,
                        LOG_EVENT_DOD_PORT_DOWN, 
                        LOG_EVENT_DOD_PORT_UP,   
								LOG_EVENT_WAN_PROTOCOLS_UP,
	                     LOG_EVENT_DIAL_RETRIES_FAIL,
								LOG_EVENT_WAN_ERROR,
								LOG_EVENT_WAN_BUSY,
								LOG_EVENT_NO_CARRIER_ON_WAN
                        };

typedef enum events_log LOG_EVENTS;

typedef struct log
{
	BYTE hour;
	BYTE minute;
	BYTE second;
	WORD year;
	BYTE month;
	BYTE day;

	LOG_EVENTS event_type;
   BYTE 	port_number;
	struct log *next_event_ptr;
}event_record;

#if EVENT_LOG
void  write_log(LOG_EVENTS event_type,BYTE port_no);    /* Imran 9/07/98 */
#endif

