/* This is the RouterWare memory file, this is implementation dependent */

/* these are user-defined buffer functions */

#ifdef __MEMCHECK__
	#include <memcheck.h>
#endif

#if !defined (_MSC_VER)
	void *device_driver_malloc (USHORT real_port_number,ULONG device_driver_id,USHORT number_of_bytes);
	enum TEST device_driver_free (USHORT real_port_number,ULONG device_driver_id,void *vptr_buffer);
	enum TEST packet_forward_device_driver_free (USHORT real_tx_port_number,ULONG tx_device_driver_id,void *vptr_buffer_data);
#endif

#if defined (__FULL_VERSION__)

	#if defined (_MSC_VER)
		void *_table_malloc (ULONG number_of_items,ULONG size_of_item);
		void _table_free (void *vptr_table_entry);
		void *_buffer_malloc (ULONG size_of_buffer);
		void _buffer_free (void *vptr_buffer);
	#else
		void *_table_malloc (size_t number_of_items,size_t size_of_item);
		void _table_free (void *vptr_table_entry);
		void *_buffer_malloc (size_t size_of_buffer);
		void _buffer_free (void *vptr_buffer);
	#endif

	#define buffer_malloc _buffer_malloc
	#define buffer_free _buffer_free

	#define table_malloc _table_malloc
	#define table_free _table_free

#else
	#define buffer_malloc malloc
	#define buffer_free free

	#define table_malloc calloc
	#define table_free free

	#if !defined (_MSC_VER)
/*		#define vprintf _vprintf*/
	#else
/*		#define vprintf(format,argptr) lsl_control (VPRINTF,format,argptr)*/
	#endif
#endif

/*int _vprintf (const char *cptr_format, void *vptr_arglist);*/

#if !defined (_MSC_VER)
/*	#define vprintf _vprintf*/
	#define ENTER_CRITICAL_SECTION
	#define LEAVE_CRITICAL_SECTION
#else
	#if defined (__KERNEL__)
		#if !defined (__WINNT__)
			#define ENTER_CRITICAL_SECTION Begin_Critical_Section(BLOCK_SVC_INTS);
			#define LEAVE_CRITICAL_SECTION End_Critical_Section();
		#else
			#define ENTER_CRITICAL_SECTION
			#define LEAVE_CRITICAL_SECTION
		#endif
	#else
		#define ENTER_CRITICAL_SECTION
		#define LEAVE_CRITICAL_SECTION
	#endif
	
	#define BREAKPOINT _asm int 3
	#define router_timer lsl_control (GET_ROUTER_TIMER)
	#define timer_ulong lsl_control (GET_SYSTEM_TIMER)
#endif

#if defined (_MSC_VER)
	#include "dll_impr.h"
#endif
