/*---------------------------------------------------------------------------
	file		:	usrlog.h
	Auth		:	Md.Imran Naveed
	Date		:	22 Mar '99
	Synopsis :  Logging of important user events such as logon,logoff,invalid 
					login attempts etc. over a period of time.
---------------------------------------------------------------------------*/
#define	LOG_NOT_LOGGING			-1
#define	LOG_INVALID_DESCRIPTOR	-2
#define	LOG_ERR_MAX_OPEN			-3

#define	LOG_NORMAL_MSG_LEN		240	/* just for easy access every where */

#if USER_EVENT_LOG
typedef enum event_type_enum {
				LOG_USER_EVENT_LOGON,
				LOG_USER_EVENT_LOGOFF,
				LOG_USER_EVENT_DEFAULTER,
				LOG_USER_EVENT_INVALID_LOGIN_ATTEMPT
				} EVENT_TYPE_ENUM ;
 

typedef struct user_event{
				BYTE *user_name;
				BYTE_ENUM(EVENT_TYPE_ENUM) event_type;
				BYTE hour;
				BYTE minute;
				BYTE second;
				BYTE read_by_procon; /* To indicate that this event has been 
												registered by procon */
				struct user_event *next_event;
				} USER_EVENT;

typedef struct day{
				WORD year;
				BYTE month;
				BYTE day;
				BYTE this_day_completed; /* if TRUE, the next days events are logged on in a new row */
				struct day *next_day;	 /* pointer to next row */
				USER_EVENT *first_event; /* pointer to next column */
	     		} Day;
   

/* function declarations .... */
void	init_user_log(void);
void	clean_user_log(void);
int	open_user_log(void);
int	close_user_log(int log_descriptor);
void  write_user_log(EVENT_TYPE_ENUM event_type,BYTE* uname);
int	read_user_log(int log_descriptor, char *buffer, int count, int dnld_flag);
int	get_info_user_log(int *approx_total_size, int *approx_number_of_msgs);
/* ..... function declarations  */
#endif


