#include	"defs.h"
/*	$Modname: lslctrl.c$  $version: 1.6$      $date: 07/05/95$   */
/*
* 	$lgb$
1.0 02/04/95 ross version 1.
1.1 02/22/95 ross changed the int to ULONG in the va_arg function.
1.2 03/03/95 ross
1.3 03/03/95 ross copyright added.
1.4 03/31/95 ross New close function, general cleanup.
1.5 06/29/95 ross added new parameter to port routine.
1.6 07/05/95 ross changes to lsl class.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1993 - 1994 RouterWare, Inc.   								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#include	<time.h>
#include	<stdarg.h>
#include	"lsl.h"
#include	"vlslctrl.h"
/**********************************************************************************/
static enum TEST lsl_pass_parameters_to_transport (enum TRANSPORT_TYPE transport_type,	ULONG command,	ULONG parameter_0,
	ULONG parameter_1);
extern USHORT get_secured_lan_port_number();
BYTE is_insecured_lan(USHORT port_number);
void ppp_dhcp_control_function (int port_num, ULONG dhcp_command, ULONG parameter_0);
void ip_dhcp_control_function (int port_num, ULONG dhcp_command, ULONG parameter_0);

/**********************************************************************************/
ULONG lsl_control (enum LSL_CONTROL_OPERATION command,...)
{
	va_list argptr;
	ULONG return_value;
	ULONG parameter[10];
	BYTE parameter_index;

	/* Srikar, Mar 24, 1997. The following condition strengthened to include command code. It is */
	/* not enough to check the function pointer, since an out of bounds access can crash the system. */

	if (command >= NUMBER_OF_LSL_CONTROL_OPERATIONS || lsl_control_function_table[command].fptr_control_function == NULL)
	{
		return ((ULONG) NULL);
	}

	va_start (argptr,command);

	for (parameter_index = 0x00; parameter_index < lsl_control_function_table[command].number_of_parameters_to_pass;
		parameter_index = (BYTE) (parameter_index + 1))
		{
		parameter[parameter_index] = va_arg (argptr,ULONG);
		}

	switch (lsl_control_function_table[command].number_of_parameters_to_pass)
		{
		case 0:
			return_value = ((ULONG (*) (void)) (*lsl_control_function_table[command].fptr_control_function)) ();
			break;
		case 1:
			return_value = ((ULONG (*) (ULONG parameter_0)) (*lsl_control_function_table[command].fptr_control_function))
				(parameter[0]);
			break;
		case 2:
			return_value = ((ULONG (*) (ULONG parameter_0,ULONG parameter_1))
				(*lsl_control_function_table[command].fptr_control_function)) (parameter[0],parameter[1]);
			break;
		case 3:
			return_value =	((ULONG (*) (ULONG parameter_0,ULONG parameter_1,ULONG parameter_2))
				(*lsl_control_function_table[command].fptr_control_function)) (parameter[0],parameter[1],parameter[2]);
			break;
		case 4:
			return_value =	((ULONG (*) (ULONG parameter_0,ULONG parameter_1,ULONG parameter_2,ULONG parameter_3))
				(*lsl_control_function_table[command].fptr_control_function)) (parameter[0],parameter[1],parameter[2],
				parameter[3]);
			break;
		case 5:
			return_value =	((ULONG (*) (ULONG parameter_0,ULONG parameter_1,ULONG parameter_2,ULONG parameter_3,ULONG parameter_4))
				(*lsl_control_function_table[command].fptr_control_function)) (parameter[0],parameter[1],parameter[2],
				parameter[3],parameter[4]);
			break;
		case 6:
			return_value =	((ULONG (*) (ULONG parameter_0,ULONG parameter_1,ULONG parameter_2,ULONG parameter_3,ULONG parameter_4,
				ULONG parameter_5))
				(*lsl_control_function_table[command].fptr_control_function)) (parameter[0],parameter[1],parameter[2],
				parameter[3],parameter[4],parameter[5]);
			break;
		case 7:
			return_value =	((ULONG (*) (ULONG parameter_0,ULONG parameter_1,ULONG parameter_2,ULONG parameter_3,ULONG parameter_4,
				ULONG parameter_5,ULONG parameter_6))
				(*lsl_control_function_table[command].fptr_control_function)) (parameter[0],parameter[1],parameter[2],
				parameter[3],parameter[4],parameter[5],parameter[6]);
			break;
		case 8:
			return_value =	((ULONG (*) (ULONG parameter_0,ULONG parameter_1,ULONG parameter_2,ULONG parameter_3,ULONG parameter_4,
				ULONG parameter_5,ULONG parameter_6,ULONG parameter_7))
				(*lsl_control_function_table[command].fptr_control_function)) (parameter[0],parameter[1],parameter[2],
				parameter[3],parameter[4],parameter[5],parameter[6],parameter[7]);
			break;
		case 9:
			return_value =	((ULONG (*) (ULONG parameter_0,ULONG parameter_1,ULONG parameter_2,ULONG parameter_3,ULONG parameter_4,
				ULONG parameter_5,ULONG parameter_6,ULONG parameter_7,ULONG parameter_8))
				(*lsl_control_function_table[command].fptr_control_function)) (parameter[0],parameter[1],parameter[2],
				parameter[3],parameter[4],parameter[5],parameter[6],parameter[7],parameter[8]);
			break;
		}

	va_end (argptr);

	return (return_value);
}
/**********************************************************************************/
void check_lsl (LSL_CLASS *sptr_lsl)
{
	PARAMETER_NOT_USED (sptr_lsl);
}
/**********************************************************************************/
enum TEST lsl_configuration (enum ISO_LAYER_TYPE iso_layer_type, ULONG command,ULONG parameter_0,ULONG parameter_1)
{
	enum PROTOCOL_STACK_TYPE protocol_stack_type;
	enum APPLICATION_TYPE application_type;
	enum TRANSPORT_TYPE transport_type;
	LSL_MESSAGE *sptr_lsl_message;

	switch (iso_layer_type)
		{
		case APPLICATION_LAYER_TYPE:

			application_type = (enum APPLICATION_TYPE) parameter_0;

			if (lsl_pass_parameters_to_application (application_type, command, parameter_0, parameter_1) == FAIL)
				{
				return (FAIL);
				}

			break;

		case TRANSPORT_LAYER_TYPE:

			transport_type = (enum TRANSPORT_TYPE) parameter_0;

			if (lsl_pass_parameters_to_transport (transport_type, command, parameter_0, parameter_1) == FAIL)
				{
				return (FAIL);
				}

			break;

		case NETWORK_LAYER_TYPE:

			protocol_stack_type = (enum PROTOCOL_STACK_TYPE) parameter_0;

			if (lsl_pass_parameters_to_protocol_stack (protocol_stack_type, command, parameter_0, parameter_1)	== FAIL)
				{
				return (FAIL);
				}

			break;

		case DATA_LINK_LAYER_TYPE:

			break;

		case PHYSICAL_LAYER_TYPE:

			break;

		case OPERATING_SYSTEM_TYPE:
		case LINK_SERVICES_LAYER_TYPE:

			switch ((enum LSL_CONTROL_OPERATION) command)
				{
				case ADD_MESSAGE_TO_QUEUE:

					sptr_lsl_message = (LSL_MESSAGE *) parameter_0;

					add_entry_to_list ((LINK *) &lsl.message_list, (LINK *) sptr_lsl_message);

					break;

				default:

					break;
				}

			break;

		default:

			return (FAIL);
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST lsl_pass_parameters_to_application (enum APPLICATION_TYPE application_type,	ULONG command,	ULONG parameter_0,
	ULONG parameter_1)
{
	APPLICATION_REGISTRATION_ENTRY *sptr_application_entry;

	for (sptr_application_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.applications_list);
		sptr_application_entry != NULL;
		sptr_application_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_application_entry->links))
		{
		if (sptr_application_entry->type == application_type)
			{
			if (sptr_application_entry->fptr_control_routine != NULL)
				{
				if ((*sptr_application_entry->fptr_control_routine)
					((enum APPLICATION_CONTROL_OPERATION) command, parameter_0, parameter_1) == FAIL)
					{
					return (FAIL);
					}

				break;
				}
			}
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST lsl_pass_parameters_to_transport (enum TRANSPORT_TYPE transport_type,	ULONG command,	ULONG parameter_0,
	ULONG parameter_1)
{
	TRANSPORT_REGISTRATION_ENTRY *sptr_transport_entry;

	for (sptr_transport_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.transports_list);
		sptr_transport_entry != NULL;
		sptr_transport_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_transport_entry->links))
		{
		if (sptr_transport_entry->type == transport_type)
			{
			if (sptr_transport_entry->fptr_control_routine != NULL)
				{
				if ((*sptr_transport_entry->fptr_control_routine)
					((enum TRANSPORT_CONTROL_OPERATION) command, parameter_0, parameter_1) == FAIL)
					{
					return (FAIL);
					}

				break;
				}
			}
		}

	return (PASS);
}
/**********************************************************************************/
enum TEST lsl_pass_parameters_to_protocol_stack (enum PROTOCOL_STACK_TYPE protocol_stack_type,	ULONG command,
	ULONG parameter_0, ULONG parameter_1)
{
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry;

	for (sptr_protocol_stack_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.protocol_stacks_list);
		sptr_protocol_stack_entry != NULL;
		sptr_protocol_stack_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_protocol_stack_entry->links))
		{
		if (sptr_protocol_stack_entry->type == protocol_stack_type)
			{
			if (sptr_protocol_stack_entry->fptr_control_routine != NULL)
				{
				if ((*sptr_protocol_stack_entry->fptr_control_routine)
					((enum PROTOCOL_CONTROL_OPERATION) command, parameter_0, parameter_1, (ULONG) NULL) == FAIL)
					{
					return (FAIL);
					}

				break;
				}
			}
		}

	return (PASS);
}
/*************************************************************************/
ULONG get_random_number (void)
{
	USHORT short_time;
	ULONG long_time;
	ULONG long_number;

	long_time = (ULONG) time (NULL);
	short_time = (USHORT) (long_time / 2);
	srand (short_time);

	long_number = (ULONG) rand ();

	return (long_number);
}
/****************************************************************************/
char *get_remote_console_buffer_string (char **ptr_cptr_end_of_string)
{
	*ptr_cptr_end_of_string = lsl.console.cptr_current_buffer_string;

	return (lsl.console.cptr_remote_buffer);
}
/****************************************************************************/
#if 1
void get_mac_address (USHORT virtual_port_number,ULONG protocol_stack_id,MAC_ADDRESS *sptr_return_mac_address)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = get_device_driver_entry_from_protocol_stack_id (
		(PROTOCOL_STACK_REGISTRATION_ENTRY *) protocol_stack_id, get_secured_lan_port_number());

	*sptr_return_mac_address = sptr_device_driver_entry->rfc1213_ifEntry.ifPhysAddress;
/* Extra piece of code added to support other ethernet port in Firewall ...*/
   if (virtual_port_number == 1) /* 1 => Internet Ethernet Port */
   {
      if (sptr_return_mac_address->_ushort == 0xFFFF)
      {
         sptr_return_mac_address->_ulong++;
         sptr_return_mac_address->_ushort = 0;
      }
      else
         sptr_return_mac_address->_ushort++;
   }
/* ... Firewall */
}
#else
void get_mac_address (USHORT virtual_port_number,ULONG protocol_stack_id,MAC_ADDRESS *sptr_return_mac_address)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = get_device_driver_entry_from_protocol_stack_id (
		(PROTOCOL_STACK_REGISTRATION_ENTRY *) protocol_stack_id, virtual_port_number);

	*sptr_return_mac_address = sptr_device_driver_entry->rfc1213_ifEntry.ifPhysAddress;
}
#endif
/****************************************************************************/
#if 1
void device_driver_get_mac_address (USHORT real_port_number,MAC_ADDRESS *sptr_return_mac_address)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = find_matching_device_driver_for_port_number (get_secured_lan_port_number());

	if (sptr_device_driver_entry != NULL)
		{
		*sptr_return_mac_address = sptr_device_driver_entry->rfc1213_ifEntry.ifPhysAddress;
		}

/* Extra piece of code added to support other ethernet port in Firewall ...*/
   if (real_port_number == 1) /* 1 => Internet Ethernet Port */
   {
      if (sptr_return_mac_address->_ushort == 0xFFFF)
      {
         sptr_return_mac_address->_ulong++;
         sptr_return_mac_address->_ushort = 0;
      }
      else
         sptr_return_mac_address->_ushort++;
   }
/* ... Firewall */
}
#else
void device_driver_get_mac_address (USHORT real_port_number,MAC_ADDRESS *sptr_return_mac_address)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = find_matching_device_driver_for_port_number (real_port_number);

	if (sptr_device_driver_entry != NULL)
		{
		*sptr_return_mac_address = sptr_device_driver_entry->rfc1213_ifEntry.ifPhysAddress;
		}
}
#endif
/****************************************************************************/
ULONG get_driver_header_size (ULONG device_driver_id)
{
	ULONG header_size;

	header_size = (ULONG) ((DEVICE_DRIVER_REGISTRATION_ENTRY *) device_driver_id)->header_size;

	return (header_size);
}
/****************************************************************************/
ULONG get_number_of_lan_ports (void)
{
	ULONG number_of_lan_ports;

	number_of_lan_ports = (ULONG) lsl.number_of_lan_ports;

	return (number_of_lan_ports);
}
/****************************************************************************/
ULONG get_number_of_wan_ports (void)
{
	ULONG number_of_wan_ports;

	number_of_wan_ports = (ULONG) lsl.number_of_wan_ports;

	return (number_of_wan_ports);
}
/****************************************************************************/
void protocol_stack_virtual_port (USHORT virtual_port_number,ULONG protocol_stack_id,
	enum PROTOCOL_CONTROL_OPERATION protocol_control_operation,ULONG parameter_1,ULONG parameter_2)
{
	if (((PROTOCOL_STACK_REGISTRATION_ENTRY *) protocol_stack_id)->fptr_control_routine != NULL)
		{
		(((PROTOCOL_STACK_REGISTRATION_ENTRY *) protocol_stack_id)->fptr_control_routine)
					(protocol_control_operation,virtual_port_number,parameter_1,parameter_2);
		}
}
/****************************************************************************/
void initialize_lsl_function_pointers (enum APPLICATION_TYPE application_type, ULONG *ptr_to_fptr_poll_for_packet_received,
	ULONG *ptr_to_fptr_polling_timer_interrupt)
{
	if (application_type == SOCKETS_INTERFACE)
		{
		*ptr_to_fptr_poll_for_packet_received = (ULONG) poll_for_packet_received;

		*ptr_to_fptr_polling_timer_interrupt = (ULONG) polling_timer_interrupt;
		}
}
#ifdef RTRERROR
/****************************************************************************/
enum TEST get_channel_occupancy (ULONG port_number, ULONG *ulptr_channel_occupancy, ULONG unloaded_bandwidth,
	ULONG number_of_neighbors)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = (DEVICE_DRIVER_REGISTRATION_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *)
		&lsl.device_drivers_list);

	while (sptr_device_driver_entry != NULL)
		{
		if (sptr_device_driver_entry->real_port_number == port_number)
			{
			break;
			}

		sptr_device_driver_entry = (DEVICE_DRIVER_REGISTRATION_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *)
			sptr_device_driver_entry);
		}

	if (sptr_device_driver_entry == NULL)
		{
		return (FAIL);
		}

	/* an arbitrary guess on the load of the channel as a fraction of 255 */

	*ulptr_channel_occupancy = (ULONG) (((float) (sptr_device_driver_entry->rfc1213_ifEntry.ifInOctets +
		sptr_device_driver_entry->rfc1213_ifEntry.ifOutOctets) * number_of_neighbors * 255) /
		(float) (router_timer * ((1.0 / (float) unloaded_bandwidth) * 10e10)));

	return (PASS);
}
/****************************************************************************/
enum TEST get_interface_error_rate (ULONG port_number, ULONG *ulptr_error_rate)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = (DEVICE_DRIVER_REGISTRATION_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *)
		&lsl.device_drivers_list);

	while (sptr_device_driver_entry != NULL)
		{
		if (sptr_device_driver_entry->real_port_number == port_number)
			{
			break;
			}

		sptr_device_driver_entry = (DEVICE_DRIVER_REGISTRATION_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *)
			sptr_device_driver_entry);
		}

	if (sptr_device_driver_entry == NULL)
		{
		return (FAIL);
		}

	/* an estimate on the error rate as a fraction of 255 */

	*ulptr_error_rate = (ULONG) (((float) sptr_device_driver_entry->rfc1213_ifEntry.ifInErrors /
		(float) (sptr_device_driver_entry->rfc1213_ifEntry.ifInUcastPkts + sptr_device_driver_entry->rfc1213_ifEntry.ifInNUcastPkts
		+ sptr_device_driver_entry->rfc1213_ifEntry.ifInErrors)) * 255);

	return (PASS);
}
#endif

/* Added by Naveen for Firewall on 15/06/1998... */
void lsl_dhcp_control_function(int port_num, ULONG dhcp_command, ULONG parameter_0)
{
   if (is_insecured_lan(port_num))
      ip_dhcp_control_function(port_num, dhcp_command, parameter_0);
   else
      ppp_dhcp_control_function(port_num, dhcp_command, parameter_0);
}
/* ...Added by Naveen for Firewall on 15/06/1998 */


