#include	"defs.h"
/*	$Modname: lslinit.c$  $version: 1.27$      $date: 07/05/95$   */
/*
* 	$lgb$
1.0 06/29/93 ross fixed port number problem.
1.1 06/29/93 ross added copyright for new version.
1.2 07/01/93 ross changed ticks to clock_ticks.
1.3 07/27/93 ross added device driver type.
1.4 07/28/93 ross changed stack to device name.
1.5 10/11/93 ross changes for frame relay and spanning tree
1.6 11/01/93 ross ipx certification version
1.7 11/19/93 ross
1.8 12/03/93 ross token ring fixes
1.9 01/08/94 ross More LSL version 3 changes
1.10 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.11 03/06/94 ross adding more rfc 1213 statistics.
1.12 03/09/94 ross removed some duplicate variables
1.13 03/09/94 ross added support for virtual port number passing to device driver.
1.14 03/14/94 ross cleaned up braces and white spaces for release.
1.15 03/26/94 ross added serial device driver registration function.
1.16 03/30/94 ross added ifdefs for frame relay and ppp serial driver calls.  Courtesy of Lori.
1.17 04/21/94 ross added extra poll call to close routine to send out remaining packets.
1.18 06/06/94 ross fixed ifdefs for frame relay and ppp.  Courtesy of Lori.
1.19 06/20/94 ross put check in for null trap function.
1.20 09/26/94 ross protected mode changes.
1.21 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.22 01/12/95 ross building rwutils directory.
1.23 02/21/95 ross add close changes.
1.24 03/23/95 ross adding raw serial driver support.
1.25 03/31/95 ross New close function, general cleanup.
1.26 06/29/95 ross new snmp access routine              new parameter in port control routine.
1.27 07/05/95 ross changes to lsl class.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#define	GLOBAL_FILE
#include	<string.h>
/*#include	<ctype.h>*/
#include	"lsl.h"
#define	byte BYTE
#define	word USHORT
#define	dword ULONG
#define	BOOL int
#include	"..\store\boot.h"

#define FL_SYS_CONTACT       FL_SNMP_CFG
#define FL_SYS_NAME          (FL_SYS_CONTACT + 256)
#define FL_SYS_LOCATION      (FL_SYS_NAME + 256)

#if LSL_DEBUG
#if STATUS_DEBUG
int lsl_debug_on = 0;
void toggle_lsl_debug();
#endif
#endif
#if LSL_MDBG
void toggle_lsl_mdebug();
#endif

/* Added By Ravi */
extern int debug_packet_rec_and_forwarded;
void debug_ip_data_packet_and_forw();
/* Added By Ravi */


void	write_snmp_vals_to_flash(char *);	
extern int higher_write_to_flash(char *src, char *dest, int size);
BYTE  init_ethernet_address_for_internet_lan();

/****************************************************************************/
static void build_rfc1213_mib (USHORT real_port_number,DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_entry);
static enum RFC1213_IF_TYPE get_rfc1213_device_driver_type (enum DEVICE_DRIVER_TYPE type);
static void initialize_remote_console_buffer (void);
static void close_device_drivers (void);
static enum BOOLEAN check_to_see_if_modules_have_deregistered (GENERIC_LINKS *sptr_generic_links);
static void initialize_mac_addr_of_other_ports (void);
void fill_mac_address (MAC_ADDRESS *mac_address) ;
extern ULONG router_up_time;
USHORT get_insecured_lan_port_number();
USHORT get_secured_lan_port_number();
/****************************************************************************/
enum TEST initialize_lsl (ULONG clock_ticks_per_second)
{
	lsl.clock_ticks_per_second = clock_ticks_per_second;

	lsl.number_of_real_ports = (USHORT) (lsl.number_of_lan_ports + lsl.number_of_wan_ports); 

/* This is reqd for WIN 95 PPP */
	initialize_mac_addr_of_other_ports ();
	initialize_remote_console_buffer ();

	lsl_printf (LSL_INITIALIZATION_PRINTF,"Number of Real Ports %04u\r\n",lsl.number_of_real_ports);

	lsl_printf (LSL_INITIALIZATION_PRINTF,"Maximum Number of Virtual Ports %04u\r\n",MAXIMUM_NUMBER_OF_VIRTUAL_PORTS);

	initialize_port_class ();
	init_lsl_snmp_system_var();

#if LSL_DEBUG
#if STATUS_DEBUG
   register_debugger(toggle_lsl_debug, "lsldebug");   
#endif
#endif

#if LSL_MDBG
#if STATUS_DEBUG
   register_debugger(toggle_lsl_mdebug, "lslmdebug");   
#endif
#endif

/* added By Ravi */
   register_debugger(debug_ip_data_packet_and_forw, "lslforw");   
/* added By Ravi */

/*   if (!init_ethernet_address_for_internet_lan())
      return (FALSE);*/
   
   
	return (PASS);
}
/****************************************************************************/
static void initialize_remote_console_buffer (void)
{
	if (lsl.console.remote_printing == TRUE)
		{
		if (lsl.console.size_of_remote_buffer != 0x0000)
			{
			lsl.console.cptr_remote_buffer = (char *) malloc (lsl.console.size_of_remote_buffer);
			}

		lsl.console.cptr_current_buffer_string = lsl.console.cptr_remote_buffer;

		lsl_printf (LSL_INITIALIZATION_PRINTF,"Remote Console Buffer Initialized %04u\r\n",
			lsl.console.size_of_remote_buffer);
		}
}
/****************************************************************************/
enum TEST close_lsl (void)
{
	/*
	 *	LSL should not issue a close to transport modules until all the applications have de-registered.
	 * Similarly, it should not close the protocol stacks until all transports have de-registerd.
	 * It should again not close the device drivers until all the protocol stacks have de-registerd.
	 * Finally, it should close the device drivers.
	 */

	lsl_printf (LSL_ALARM_PRINTF, "LSL: Still another call to close_lsl\n");

	if (lsl.started_system_shutdown == FALSE)
		{
		lsl.started_system_shutdown = TRUE;

		issue_command_to_entry_control_routine (TERMINATE_APPLICATION, (GENERIC_LINKS *) &lsl.applications_list);
		}
	else
		{
		process_lsl_message ();
		}

	if (check_to_see_if_modules_have_deregistered ((GENERIC_LINKS *) &lsl.applications_list) == FALSE)
		{
		return (FAIL);
		}

	issue_command_to_entry_control_routine (CLOSE_TRANSPORT, (GENERIC_LINKS *) &lsl.transports_list);

	if (check_to_see_if_modules_have_deregistered ((GENERIC_LINKS *) &lsl.transports_list) == FALSE)
		{
		return (FAIL);
		}

	issue_command_to_entry_control_routine (CLOSE_PROTOCOL_STACK, (GENERIC_LINKS *) &lsl.protocol_stacks_list);

	if (check_to_see_if_modules_have_deregistered ((GENERIC_LINKS *) &lsl.protocol_stacks_list) == FALSE)
		{
		return (FAIL);
		}

	issue_command_to_entry_control_routine (CLOSE_DEVICE_DRIVER, (GENERIC_LINKS *) &lsl.device_drivers_list);

	if (check_to_see_if_modules_have_deregistered ((GENERIC_LINKS *) &lsl.device_drivers_list) == FALSE)
		{
		return (FAIL);
		}

	close_device_drivers ();

	close_buffer_class ();

	if (lsl.console.remote_printing == TRUE)
		{
		lsl.console.remote_printing = FALSE;

		if (lsl.console.size_of_remote_buffer != 0x0000)
			{
			free (lsl.console.cptr_remote_buffer);
			}
		}

	return (PASS);
}
/****************************************************************************/
static enum BOOLEAN check_to_see_if_modules_have_deregistered (GENERIC_LINKS *sptr_generic_links)
{
	GENERIC_REGISTRATION_ENTRY *sptr_generic_entry;
	enum BOOLEAN return_value;

	return_value = TRUE;

	sptr_generic_entry = get_pointer_to_first_entry_in_list ((LINK *) sptr_generic_links);

	while (sptr_generic_entry != NULL)
		{
		if (strcmp (sptr_generic_entry->name, "TCP Transport") == STRINGS_MATCH)
			{
			return (FALSE);
			}
/*
		if (return_value == TRUE)
			{
			return_value = FALSE;
			}
*/
		sptr_generic_entry = get_pointer_to_next_entry_in_list ((LINK *) sptr_generic_entry);
		}

	return (return_value);
}
/****************************************************************************/
enum TEST deregister_module (enum ISO_LAYER_TYPE iso_layer_type, ULONG module_id)
{
	GENERIC_REGISTRATION_ENTRY *sptr_generic_entry;

	sptr_generic_entry = (GENERIC_REGISTRATION_ENTRY *) module_id;

	if (iso_layer_type == APPLICATION_LAYER_TYPE)
		{
		delete_entry_from_list ((LINK *) &lsl.applications_list, (LINK *) &sptr_generic_entry->links);

		table_free ((void *) sptr_generic_entry);

		return (PASS);
		}
	else if (iso_layer_type == TRANSPORT_LAYER_TYPE)
		{
		delete_entry_from_list ((LINK *) &lsl.transports_list, (LINK *) &sptr_generic_entry->links);

		table_free ((void *) sptr_generic_entry);

		return (PASS);
		}
	else if (iso_layer_type == NETWORK_LAYER_TYPE)
		{
		delete_entry_from_list ((LINK *) &lsl.protocol_stacks_list, (LINK *) &sptr_generic_entry->links);

		table_free ((void *) sptr_generic_entry);

		return (PASS);
		}
	else if (iso_layer_type == DATA_LINK_LAYER_TYPE)
		{
		delete_entry_from_list ((LINK *) &lsl.device_drivers_list, (LINK *) &sptr_generic_entry->links);

		table_free ((void *) sptr_generic_entry);

		return (PASS);
		}

	return (FAIL);
}
/****************************************************************************/
void issue_command_to_entry_control_routine (ULONG command,GENERIC_LINKS *sptr_generic_links)
{
	GENERIC_REGISTRATION_ENTRY *sptr_generic_entry;
	GENERIC_REGISTRATION_ENTRY *sptr_generic_entry_previous;

	process_lsl_message ();

	for (sptr_generic_entry = get_pointer_to_last_entry_in_list ((LINK *) sptr_generic_links); sptr_generic_entry != NULL; )
		{
		sptr_generic_entry_previous = get_pointer_to_previous_entry_in_list ((LINK *) sptr_generic_entry);

		if (sptr_generic_entry->fptr_control_routine != NULL)
			{
			(*sptr_generic_entry->fptr_control_routine) (command,(ULONG) NULL,(ULONG) NULL);
			}

		sptr_generic_entry = sptr_generic_entry_previous;
		}
}
/****************************************************************************/
static void close_device_drivers (void)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	for (sptr_device_driver_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.device_drivers_list);
		sptr_device_driver_entry != NULL;
		sptr_device_driver_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_device_driver_entry->links))
		{
		if (lsl.fptr_snmp_trap_function != NULL)
			{
			(*lsl.fptr_snmp_trap_function) (sptr_device_driver_entry->real_port_number,CLOSE_DEVICE_DRIVER);
			}

		if (sptr_device_driver_entry->fptr_control_routine != NULL)
			{
			(*sptr_device_driver_entry->fptr_control_routine) (CLOSE_DEVICE_DRIVER, (ULONG) NULL,(ULONG) NULL);
			}

		sptr_device_driver_entry->rfc1213_ifEntry.ifOperStatus = REAL_PORT_DOWN;
		}
}
/****************************************************************************/
ULONG register_application (char *cptr_application_name,enum APPLICATION_TYPE type,void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum APPLICATION_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	ULONG *ulptr_return_application_id)
{
	APPLICATION_REGISTRATION_ENTRY *sptr_application_entry;

	sptr_application_entry = table_malloc (1,sizeof (APPLICATION_REGISTRATION_ENTRY));

	if (sptr_application_entry != NULL)
		{
		sptr_application_entry->type = type;

		strcpy (&sptr_application_entry->name[0],cptr_application_name);

		sptr_application_entry->id = (ULONG) sptr_application_entry;

		*ulptr_return_application_id = sptr_application_entry->id;

		sptr_application_entry->fptr_timer_routine = fptr_timer_routine;
		sptr_application_entry->fptr_control_routine =	fptr_control_routine;

		add_entry_to_list ((LINK *) &lsl.applications_list,(LINK *) &sptr_application_entry->links);

		return (PASS);
		}
	else
		{
		return (FAIL);
		}
}
/****************************************************************************/
ULONG register_transport (char *cptr_transport_name,enum TRANSPORT_TYPE type,void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum TRANSPORT_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	ULONG *ulptr_return_transport_id)
{
	TRANSPORT_REGISTRATION_ENTRY *sptr_transport_entry;

	sptr_transport_entry = table_malloc (1,sizeof (TRANSPORT_REGISTRATION_ENTRY));

	if (sptr_transport_entry != NULL)
		{
		sptr_transport_entry->type = type;

		strcpy (&sptr_transport_entry->name[0],cptr_transport_name);

		sptr_transport_entry->id = (ULONG) sptr_transport_entry;

		*ulptr_return_transport_id = sptr_transport_entry->id;

		sptr_transport_entry->fptr_timer_routine = fptr_timer_routine;
		sptr_transport_entry->fptr_control_routine =	fptr_control_routine;

		add_entry_to_list ((LINK *) &lsl.transports_list,(LINK *) &sptr_transport_entry->links);

		return (PASS);
		}
	else
		{
		return (FAIL);
		}
}
/****************************************************************************/
ULONG register_protocol_stack (char *cptr_protocol_stack_name,
	enum RX_PACKET_STATE (*fptr_rx_routine) (USHORT port_number,void *vptr_buffer,USHORT number_of_bytes),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum PROTOCOL_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1,
		ULONG parameter_2),
	ULONG *ulptr_return_protocol_stack_id)
{
	PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry;

	sptr_protocol_stack_entry = table_malloc (1,sizeof (PROTOCOL_STACK_REGISTRATION_ENTRY));

	if (sptr_protocol_stack_entry != NULL)
		{
		strcpy (&sptr_protocol_stack_entry->name[0],cptr_protocol_stack_name);

		sptr_protocol_stack_entry->id = (ULONG) sptr_protocol_stack_entry;

		*ulptr_return_protocol_stack_id = sptr_protocol_stack_entry->id;

		sptr_protocol_stack_entry->fptr_rx_routine = fptr_rx_routine;
		sptr_protocol_stack_entry->fptr_timer_routine = fptr_timer_routine;
		sptr_protocol_stack_entry->fptr_control_routine = fptr_control_routine;

		pass_stack_id_to_device_driver (cptr_protocol_stack_name,sptr_protocol_stack_entry->id);

		if (get_port_parameters (sptr_protocol_stack_entry) == FAIL)
			{
			lsl_printf (LSL_INITIALIZATION_PRINTF,"LSL: Problem initializing %s\r\n",cptr_protocol_stack_name);

			return (FAIL);
			}
		else
			{
			lsl_printf (LSL_INITIALIZATION_PRINTF,"LSL: Initializing %s\r\n",cptr_protocol_stack_name);
			}

		if (strcmp (cptr_protocol_stack_name,"Spanning Tree") == STRINGS_MATCH)
			{
			lsl.sptr_spanning_tree = sptr_protocol_stack_entry;
			}
		else if (strcmp (cptr_protocol_stack_name,"DLSW Routing") == STRINGS_MATCH)
	 		{
			lsl.sptr_dlsw = sptr_protocol_stack_entry;
			}
		else if (strcmp (cptr_protocol_stack_name,"Source Routing") == STRINGS_MATCH)
			{
			lsl.sptr_source_routing = sptr_protocol_stack_entry;
			}

		add_entry_to_list ((LINK *) &lsl.protocol_stacks_list,(LINK *) &sptr_protocol_stack_entry->links);

		return (PASS);
		}
	else
		{
		return (FAIL);
		}
}
/****************************************************************************/
ULONG register_device_driver
	(
	char *cptr_device_name,
	enum DEVICE_DRIVER_TYPE device_driver_type,
	enum TEST (*fptr_tx_routine) (ULONG protocol_stack_id,USHORT port_number,USHORT virtual_port_number,void *sptr_tx_buffer,
		USHORT number_of_bytes,enum BOOLEAN bridged_packet,enum BOOLEAN protocol_packet,
		void (*fptr_tx_completion)	(USHORT port_number,void *sptr_ethernet_buffer)),
	void 	(*fptr_tx_complete) (USHORT port_number),
	enum BOOLEAN (*fptr_rx_routine) (USHORT port_number,void **vptr_buffer,USHORT *usptr_number_of_bytes_rxed),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum DEVICE_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	void 	(*fptr_rx_buffer_return) (USHORT port_number,void *vptr_buffer),
	ULONG *ulptr_return_device_driver_id
	)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	sptr_device_driver_entry = table_malloc (1,sizeof (DEVICE_DRIVER_REGISTRATION_ENTRY));

	if (sptr_device_driver_entry != NULL)
	{
		memcpy (&sptr_device_driver_entry->rfc1213_ifEntry,&lsl.port[lsl.number_of_device_drivers].rfc1213_ifEntry,
			sizeof (RFC1213_IFENTRY));

		sptr_device_driver_entry->buffer_size = lsl.port[lsl.number_of_device_drivers].buffer_size ;
		sptr_device_driver_entry->rx_buffer_list = lsl.port[lsl.number_of_device_drivers].rx_buffer_list;
		sptr_device_driver_entry->number_of_buffers_allocated = lsl.port[lsl.number_of_device_drivers].number_of_buffers_allocated;
		sptr_device_driver_entry->number_of_system_buffers_free =
			lsl.port[lsl.number_of_device_drivers].number_of_system_buffers_free;
		sptr_device_driver_entry->current_rx_buffers_in_list = lsl.port[lsl.number_of_device_drivers].current_rx_buffers_in_list;
		sptr_device_driver_entry->rx_buffer_lower_limit = lsl.port[lsl.number_of_device_drivers].rx_buffer_lower_limit;
		sptr_device_driver_entry->current_tx_buffers_in_list = lsl.port[lsl.number_of_device_drivers].current_tx_buffers_in_list;
		sptr_device_driver_entry->tx_buffer_upper_limit = lsl.port[lsl.number_of_device_drivers].tx_buffer_upper_limit;
		sptr_device_driver_entry->header_size = lsl.port[lsl.number_of_device_drivers].header_size;

		strcpy (&sptr_device_driver_entry->rfc1213_ifEntry.ifDescr[0],cptr_device_name);
		sptr_device_driver_entry->type = device_driver_type;

		sptr_device_driver_entry->id = (ULONG) sptr_device_driver_entry ;
		sptr_device_driver_entry->real_port_number = lsl.number_of_device_drivers;

		*ulptr_return_device_driver_id = sptr_device_driver_entry->id;

		sptr_device_driver_entry->fptr_tx_routine = fptr_tx_routine;
		sptr_device_driver_entry->fptr_tx_complete = fptr_tx_complete;
		sptr_device_driver_entry->fptr_rx_routine = fptr_rx_routine;
		sptr_device_driver_entry->fptr_timer_routine = fptr_timer_routine;
		sptr_device_driver_entry->fptr_control_routine = fptr_control_routine;
		sptr_device_driver_entry->fptr_rx_buffer_return = fptr_rx_buffer_return;

		build_rfc1213_mib (lsl.number_of_device_drivers,sptr_device_driver_entry);

		if (strcmp (cptr_device_name,"Frame Relay Driver") == STRINGS_MATCH)
		{
			sptr_device_driver_entry->protocol_id_pass_through = TRUE;
			sptr_device_driver_entry->header_size = 4;
		}
		else 
			if (strcmp (cptr_device_name,"PPP Driver") == STRINGS_MATCH)
			{
				sptr_device_driver_entry->protocol_id_pass_through = TRUE;
				sptr_device_driver_entry->header_size = 10;
			}
			else
			{
				sptr_device_driver_entry->protocol_id_pass_through = FALSE;
			}

		++lsl.number_of_device_drivers;
		++lsl.number_of_real_ports;

		add_entry_to_list ((LINK *) &lsl.device_drivers_list,(LINK *) &sptr_device_driver_entry->links);

		return (PASS);
		}
	else
		{
		return (FAIL);
		}

}
/****************************************************************************/
ULONG register_serial_device_driver
	(
	USHORT port_number,
	char *cptr_device_name,
	enum SERIAL_DRIVER_TYPE device_driver_type,
	enum TEST (*fptr_tx_routine) (USHORT port_number,USHORT virtual_port_number,void *sptr_tx_buffer,
		USHORT number_of_bytes,enum BOOLEAN do_not_calculate_new_crc,enum BOOLEAN device_driver_buffer,
		void (*fptr_tx_completion)	(USHORT port_number,void *vptr_tx_buffer)),
	void 	(*fptr_tx_complete) (USHORT port_number),
	enum BOOLEAN (*fptr_rx_routine) (USHORT port_number,void **vptr_buffer,USHORT *usptr_number_of_bytes_rxed),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum SERIAL_DRIVER_CONTROL command,ULONG parameter_0,ULONG parameter_1),
	void 	(*fptr_rx_buffer_return) (USHORT port_number,void *vptr_buffer)
	)
{
	LOW_LEVEL_DEVICE_DRIVER_API low_level_device_driver_api;
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	low_level_device_driver_api.port_number = port_number;
	low_level_device_driver_api.cptr_device_name = cptr_device_name;
	low_level_device_driver_api.device_driver_type = device_driver_type;
	low_level_device_driver_api.fptr_tx_routine = fptr_tx_routine;
	low_level_device_driver_api.fptr_tx_complete = fptr_tx_complete;
	low_level_device_driver_api.fptr_rx_routine = fptr_rx_routine;
	low_level_device_driver_api.fptr_timer_routine = fptr_timer_routine;
	low_level_device_driver_api.fptr_control_routine = fptr_control_routine;
	low_level_device_driver_api.fptr_rx_buffer_return = fptr_rx_buffer_return;

	sptr_device_driver_entry = (DEVICE_DRIVER_REGISTRATION_ENTRY *) serial_driver_get_device_driver_id (port_number);

	if (sptr_device_driver_entry != NULL)
	{
		if (sptr_device_driver_entry->fptr_control_routine != NULL)
		{
			(*sptr_device_driver_entry->fptr_control_routine) (REGISTER_SERIAL_DEVICE_DRIVER,
				sptr_device_driver_entry->real_port_number,(ULONG) &low_level_device_driver_api);
		}
	}

	return ((ULONG) sptr_device_driver_entry);
}
/****************************************************************************/
static void build_rfc1213_mib (USHORT real_port_number,DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_entry)
{

	sptr_device_entry->rfc1213_ifEntry.ifType =
		get_rfc1213_device_driver_type (sptr_device_entry->type);

	sptr_device_entry->rfc1213_ifEntry.ifIndex = real_port_number + 1;
#ifdef RTRERROR
	sptr_device_entry->rfc1213_ifEntry.ifMtu = sptr_device_entry->buffer_size;
#endif

	/* Srikar, Mar 24, 1997. For the WAN ports we set the operational status to 'down' and change the */
	/* status whenever a connection is established or dropped. */

	if ( sptr_device_entry->rfc1213_ifEntry.ifType == 7 )
		/* Srikar, Mar 24, 1997. Added the following intiailzation for port speed in port entry. */
		{
		lsl.port[real_port_number].rfc1213_ifEntry.ifSpeed = 10000000L;
		sptr_device_entry->rfc1213_ifEntry.ifSpeed = 10000000L;
		}
	else
		sptr_device_entry->rfc1213_ifEntry.ifOperStatus = REAL_PORT_DOWN;

	sptr_device_entry->rfc1213_ifEntry.ifAdminStatus =	sptr_device_entry->rfc1213_ifEntry.ifOperStatus;
	/* Srikar, Mar 30, 1997. Changed the ifLastChange intialization to 0 since according to the mib
	   if the current operational state was entered before the last initialization of the management
		entity it should be 0 */
	sptr_device_entry->rfc1213_ifEntry.ifLastChange = 0x00000000L;
	sptr_device_entry->rfc1213_ifEntry.ifInDiscards = 0x00000000L;
	sptr_device_entry->rfc1213_ifEntry.ifInErrors = 0x00000000L;
	sptr_device_entry->rfc1213_ifEntry.ifOutErrors = 0x00000000L;
	sptr_device_entry->rfc1213_ifEntry.ifOutQLen = 0x00000000L;
	sptr_device_entry->rfc1213_ifEntry.ifSpecific = 0x00000000L;
}
/****************************************************************************/
RFC1213_DEVICE_DRIVER_TYPE rfc1213_device_driver_type[] = 
{
	{ISO88025_TOKENRING,TOKEN_RING_DEVICE_DRIVER},
	{ISO88023_CSMACD,ETHERNET_DEVICE_DRIVER},
	{FRAME_RELAY_,FRAME_RELAY_DEVICE_DRIVER},
	{PPP_,PPP_DEVICE_DRIVER},
	{ILLEGAL_IF_TYPE, (enum DEVICE_DRIVER_TYPE) NULL}
};
/****************************************************************************/
static enum RFC1213_IF_TYPE get_rfc1213_device_driver_type (enum DEVICE_DRIVER_TYPE type)
{
	USHORT device_driver_type_table_index;

	device_driver_type_table_index = 0x0000;

	for (;rfc1213_device_driver_type[device_driver_type_table_index].ifType != ILLEGAL_IF_TYPE; ++device_driver_type_table_index)
		{
		if (rfc1213_device_driver_type[device_driver_type_table_index].type == type)
			{
			return (rfc1213_device_driver_type[device_driver_type_table_index].ifType);
			}
		}

	return (ILLEGAL_IF_TYPE);
}
/****************************************************************************/
void register_lsl_trap_function (void (*fptr_lsl_trap_function) (USHORT real_port_number,
	enum DEVICE_CONTROL_OPERATION control_command))
{
	lsl.fptr_snmp_trap_function = fptr_lsl_trap_function;
}

#if 0
int init_lsl_snmp_system_var (void)
{
	int i;

	strcpy(lsl.system_mib.sysDescr,"MULTI  PROTOCOL  ROUTER Ver 1.11");
	strcpy(lsl.system_mib.sysObjectID,""); /* to be filled in later on */
	for(i = 0 ; i < SIZE_OF_SYSTEM_OBJECT_ID ; i++)
		lsl.system_mib.sysObjectID[i] = 0x0;
	lsl.system_mib.sysUpTime = 0;

#ifdef DEBUG
	if (isalnum(*(char *)FL_SYS_CONTACT))
		strncpy(lsl.system_mib.sysContact,(char *)FL_SYS_CONTACT,256);

	if (isalnum(*(char *)FL_SYS_NAME))
		strncpy(lsl.system_mib.sysName,(char *)FL_SYS_NAME,256);


	if( isalnum(*(char *)FL_SYS_LOCATION))
		strncpy(lsl.system_mib.sysLocation,(char *)FL_SYS_LOCATION,256);
#endif

	if( *((char *)FL_SYS_CONTACT)  < 0x7f)
		strncpy(lsl.system_mib.sysContact,(char *)FL_SYS_CONTACT,256);

	if( *((char *)FL_SYS_NAME)  < 0x7f)
		strncpy(lsl.system_mib.sysName,(char *)FL_SYS_NAME,256);

	if( *((char *)FL_SYS_LOCATION)  < 0x7f)
		strncpy(lsl.system_mib.sysLocation,(char *)FL_SYS_LOCATION,256);

	lsl.system_mib.sysServices = 14; /* works as a bridge and router RFC1213
																				there is also tcp and telnet */
}
#endif

/* Srikar 22/11/96 */
/* Sachin 25/09/1997 */
extern VersionDateType VersionDate ;
/* Sachin 25/09/1997 */
int init_lsl_snmp_system_var (void)
{
	int i;

	strcpy(lsl.system_mib.sysDescr,"MULTI-PROTOCOL ROUTER. Version ") ;
	strcat(lsl.system_mib.sysDescr, VersionDate.Date) ;
	strcpy(lsl.system_mib.sysObjectID,""); /* to be filled in later on */
	for(i = 0 ; i < SIZE_OF_SYSTEM_OBJECT_ID ; i++)
		lsl.system_mib.sysObjectID[i] = 0x0;
	lsl.system_mib.sysUpTime = 0;

#ifdef DEBUG
	if (isalnum(*(char *)FL_SYS_CONTACT))
		strncpy(lsl.system_mib.sysContact,(char *)FL_SYS_CONTACT,256);

	if (isalnum(*(char *)FL_SYS_NAME))
		strncpy(lsl.system_mib.sysName,(char *)FL_SYS_NAME,256);


	if( isalnum(*(char *)FL_SYS_LOCATION))
		strncpy(lsl.system_mib.sysLocation,(char *)FL_SYS_LOCATION,256);
#endif

	if( *((char *)FL_SYS_CONTACT)  < 0x7f)
	{
		for(i = 0; ((char *)FL_SYS_CONTACT)[i] != '\0' && i < SIZE_OF_SYSTEM_CONTACT; i++);
		if (i == SIZE_OF_SYSTEM_CONTACT)
			lsl.system_mib.sysContact[0] = '\0';
		else
			strcpy(lsl.system_mib.sysContact,(char *)FL_SYS_CONTACT);
	}
	else
		lsl.system_mib.sysContact[0] = '\0';

	if( *((char *)FL_SYS_NAME)  < 0x7f)
	{
		for(i = 0; ((char *)FL_SYS_NAME)[i] != '\0' && i < SIZE_OF_SYSTEM_NAME; i++);
		if (i == SIZE_OF_SYSTEM_NAME)
			lsl.system_mib.sysName[0] = '\0';
		else
			strcpy(lsl.system_mib.sysName,(char *)FL_SYS_NAME);
	}
	else
		lsl.system_mib.sysName[0] = '\0';


	if( *((char *)FL_SYS_LOCATION)  < 0x7f)
	{
		for(i = 0; ((char *)FL_SYS_NAME)[i] != '\0' && i < SIZE_OF_SYSTEM_LOCATION; i++);
		if (i == SIZE_OF_SYSTEM_LOCATION)
			lsl.system_mib.sysLocation[0] = '\0';
		else
		strcpy(lsl.system_mib.sysLocation,(char *)FL_SYS_LOCATION);
	}
	else
		lsl.system_mib.sysLocation[0] = '\0';

	lsl.system_mib.sysServices = 14; /* works as a bridge and router RFC1213
																				there is also tcp and telnet */
}
/* Srikar 22/11/96 */

void	write_snmp_vals_to_flash(char *ChPtr)	
{
	higher_write_to_flash(ChPtr,(char *) FL_SNMP_CFG,512);
	higher_write_to_flash(&ChPtr[512],(char *) (FL_SNMP_CFG+512),512);
}

static void initialize_mac_addr_of_other_ports ()
{
	int	port_number;
	for(port_number=0;port_number < lsl.number_of_wan_ports;port_number++)
	{
		lsl.port[port_number+1].rfc1213_ifEntry.ifPhysAddress =
					lsl.port[0].rfc1213_ifEntry.ifPhysAddress ;
	}
}


/* Sachin 03/08/1996 */

void fill_mac_address (MAC_ADDRESS *mac_address)
{
	*mac_address = lsl.port[0].rfc1213_ifEntry.ifPhysAddress ;
}

/* Sachin 03/08/1996 */

#if LSL_DEBUG
#if STATUS_DEBUG
void toggle_lsl_debug()
{
   if (lsl_debug_on)
      lsl_debug_on = 0;
   else  
      lsl_debug_on = 1;
}
#endif
#endif

#if LSL_MDBG
#if STATUS_DEBUG
int lsl_mdebug_on = 0;
void toggle_lsl_mdebug()
{
   if (lsl_mdebug_on)
      lsl_mdebug_on = 0;
   else   
      lsl_mdebug_on = 1;
}
#endif
#endif

/* Added By Ravi */
void debug_ip_data_packet_and_forw()
{
		printf("\n LSLDEBUG : Ip data Packet Rcvd and was forwarded count : %d\n", debug_packet_rec_and_forwarded);
}
/* Added By Ravi */

BYTE init_ethernet_address_for_internet_lan()  
{
   MAC_ADDRESS secured_lan_port_mac_address;
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;


   lsl_control(DEVICE_DRIVER_GET_MAC_ADDRESS, get_secured_lan_port_number(), &secured_lan_port_mac_address);

   if (secured_lan_port_mac_address._ushort == 0xFFFF)
   {
      secured_lan_port_mac_address._ulong++;
      secured_lan_port_mac_address._ushort = 0;
   }
   else
      secured_lan_port_mac_address._ushort++;


	sptr_device_driver_entry = find_matching_device_driver_for_port_number (get_insecured_lan_port_number());

	if (sptr_device_driver_entry != NULL)
   {
		sptr_device_driver_entry->rfc1213_ifEntry.ifPhysAddress = secured_lan_port_mac_address;
      return TRUE;
	}
   return FALSE;
}
