#include	"defs.h"
/*	$Modname: lslctrl.c$  $version: 1.3$      $date: 03/03/95$   */
/*
* 	$lgb$
1.0 02/04/95 ross version 1.
1.1 02/22/95 ross changed the int to ULONG in the va_arg function.
1.2 03/03/95 ross
1.3 03/03/95 ross copyright added.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1993 - 1994 RouterWare, Inc.   								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA 92660	*/
/************************************************************************/
#include	"lsl.h"
/************************************************************************/
static enum BOOLEAN lsl_check_if_destination_id_is_valid (enum ISO_LAYER_TYPE iso_layer_type, ULONG destination_id);
/************************************************************************/
enum TEST lsl_process_message_list_entry (LSL_MESSAGE *sptr_lsl_message)
{
	if (sptr_lsl_message != NULL)
		{
		switch (sptr_lsl_message->destination_iso_layer_type)
			{
			case APPLICATION_LAYER_TYPE:

				if (lsl_check_if_destination_id_is_valid (sptr_lsl_message->destination_iso_layer_type,
					sptr_lsl_message->destination_id) == TRUE)
					{
					if (((APPLICATION_REGISTRATION_ENTRY *) sptr_lsl_message->destination_id)->fptr_control_routine != NULL)
						{
						(*((APPLICATION_REGISTRATION_ENTRY *) sptr_lsl_message->destination_id)->fptr_control_routine)
							(sptr_lsl_message->command, sptr_lsl_message->socket_descriptor, (ULONG) NULL);
						}
					else
						{
						lsl_printf (LSL_ALARM_PRINTF, "LSL: ERROR IN HANDLING MESSAGE: INVALID FUNCTION POINTER\n");
						}
					}
				else
					{
					lsl_printf (LSL_ALARM_PRINTF, "LSL: ERROR IN HANDLING MESSAGE: INVALID DESTINATION ID\n");
					}

				break;

			case TRANSPORT_LAYER_TYPE:

				break;

			case NETWORK_LAYER_TYPE:

				break;

			case DATA_LINK_LAYER_TYPE:

				break;

			case PHYSICAL_LAYER_TYPE:

				break;

			default:

				break;
			}

		return (PASS);
		}

	return (FAIL);
}
/****************************************************************************/
static enum BOOLEAN lsl_check_if_destination_id_is_valid (enum ISO_LAYER_TYPE iso_layer_type, ULONG destination_id)
{
	APPLICATION_REGISTRATION_ENTRY *sptr_application_registration_entry;

	if (iso_layer_type == APPLICATION_LAYER_TYPE)
		{
			sptr_application_registration_entry = (APPLICATION_REGISTRATION_ENTRY *) get_pointer_to_first_entry_in_list
				((LINK *) &lsl.applications_list);

			while (sptr_application_registration_entry != NULL)
				{
				if (sptr_application_registration_entry == (APPLICATION_REGISTRATION_ENTRY *) destination_id)
					{
					return (TRUE);
					}

				sptr_application_registration_entry = (APPLICATION_REGISTRATION_ENTRY *) get_pointer_to_next_entry_in_list
					((LINK *) sptr_application_registration_entry);
				}
		}

	return (FALSE);
}
