#include	"defs.h"
/*	$Modname: lslsnap.c$  $version: 1.16$      $date: 02/21/95$   */
/*
* 	$lgb$
1.0 11/29/93 ross initial check-in.
1.1 11/29/93 ross
1.2 12/03/93 ross token ring fixes
1.3 01/08/94 ross More LSL version 3 changes
1.4 02/02/94 ross fixed lslsnap bugs, and added ipx protocol detection, support for dlsx and nlsp
1.5 02/02/94 ross fixed packet type problem.
1.6 02/04/94 ross fixed get_packet_type bug for token ring
1.7 03/14/94 ross removed some redundant lines.
1.8 03/26/94 ross token ring mac frame filter added.
1.9 03/27/94 ross added SOURCE_ROUTING ifdef.  Found by Lori and I.
1.10 04/18/94 ross added function to clear source routed bit.
1.11 04/18/94 ross added support for rfc 1042.
1.12 04/21/94 ross added code to handle rfc1042.
1.13 06/15/94 ross Changed dlsx to dlsw.
1.14 09/26/94 ross appletalk changes.
1.15 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.16 02/21/95 ross add close changes.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<string.h>
#include	"lsl.h"
/****************************************************************************/
static enum LSL_PACKET_TYPE get_packet_type (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,PACKET *sptr_rx_packet);
static ULONG get_size_of_packet_type_header (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,
	USHORT virtual_port_number);
/****************************************************************************/
void *convert_stack_header_in_rx_packet (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,PACKET *sptr_rx_packet,
	USHORT *usptr_size_of_rx_packet,PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry)
{
	UNION_SNAP_OR_LLC_HEADER *sptr_snap_or_llc_header;
	BYTE *sptr_stack_header;
	MAC_ADDRESS source;
	MAC_ADDRESS destination;
	USHORT ethernet_protocol_type;
	BYTE length_of_token_ring_rif;
	BYTE rif[50];

	if ((sptr_protocol_stack_entry->type == SPANNING_TREE_STACK) ||
		(sptr_protocol_stack_entry->type == SOURCE_ROUTING_STACK) || 
		(sptr_protocol_stack_entry->type == DLSW_PROTOCOL_STACK) ||
		(sptr_protocol_stack_entry->type == APPLETALK_PROTOCOL_STACK))
		{
		return (sptr_rx_packet);
		}

	if (sptr_device_driver_entry->type == TOKEN_RING_DEVICE_DRIVER)
		{
		if (lsl_is_token_ring_frame_a_mac (sptr_rx_packet) == TRUE)
			{
			return (NULL);
			}

		if (lsl_is_token_ring_frame_source_routed (sptr_rx_packet) == TRUE)
			{
			length_of_token_ring_rif = lsl_get_length_of_token_ring_rif (sptr_rx_packet);

			source = sptr_rx_packet->raw.mac_header.token_ring.source_address;
			destination = sptr_rx_packet->raw.mac_header.token_ring.destination_address;

			memcpy (&rif,(void *)((ULONG) sptr_rx_packet + sizeof (UNION_MAC_HEADER)),length_of_token_ring_rif);

			sptr_rx_packet = (PACKET *) ((ULONG) sptr_rx_packet + length_of_token_ring_rif);

			memcpy ((void *) ((ULONG) sptr_rx_packet - sizeof (length_of_token_ring_rif) - length_of_token_ring_rif),
				&rif,length_of_token_ring_rif);

			*((BYTE *)((ULONG) sptr_rx_packet - sizeof (length_of_token_ring_rif))) = length_of_token_ring_rif;

			sptr_rx_packet->raw.mac_header.token_ring.source_address = source;
			sptr_rx_packet->raw.mac_header.token_ring.destination_address = destination;

			*usptr_size_of_rx_packet -= length_of_token_ring_rif;
			}
		}

	sptr_stack_header = (BYTE *) &sptr_rx_packet->raw.stack_header;
	sptr_snap_or_llc_header = (UNION_SNAP_OR_LLC_HEADER *) sptr_stack_header;

	if (*((USHORT *)sptr_stack_header) == 0xffff)	/* novell raw ethernet packet (this will change in 94' or 95') */
		{
		if (sptr_rx_packet->raw.mac_header.ethernet.length_or_type.type != SNAP_IPX_PROTOCOL_ID)
			{
			sptr_rx_packet->raw.mac_header.ethernet.length_or_type.length = (USHORT) RAW_8023;
			}
		else
			{
			sptr_rx_packet->raw.mac_header.ethernet.length_or_type.length = (USHORT) ETHERNET_TYPE_II;
			}

		return (sptr_rx_packet);
		}
	else if (sptr_device_driver_entry->type != TOKEN_RING_DEVICE_DRIVER
		&& swap (sptr_rx_packet->raw.mac_header.ethernet.length_or_type.length) > MAXIMUM_ETHERNET_PACKET_SIZE)
		{
		ethernet_protocol_type = sptr_rx_packet->raw.mac_header.ethernet.length_or_type.type;

		sptr_rx_packet->raw.mac_header.ethernet.length_or_type.type = (USHORT) ETHERNET_TYPE_II;

		if (sptr_protocol_stack_entry->type == IP_PROTOCOL_STACK)
			{
			*((USHORT *) ((ULONG) sptr_rx_packet - sizeof (USHORT))) = ethernet_protocol_type;
			}

		return (sptr_rx_packet);
		}
	else if (sptr_snap_or_llc_header->snap.llc_frame_type == UNNUMBERED_INFORMATION)
		{
		if (sptr_snap_or_llc_header->snap.destination_address_DSAP == LSAP_SNAP_LLC &&
			sptr_snap_or_llc_header->snap.source_address_SSAP == LSAP_SNAP_LLC) 
			{
			sptr_stack_header = (BYTE *) &((_8022_SNAP_PACKET *)sptr_rx_packet)->stack_header;

			if (sptr_device_driver_entry->type == TOKEN_RING_DEVICE_DRIVER)
				{
				source = sptr_rx_packet->_8022_snap.mac_header.token_ring.source_address;
				destination = sptr_rx_packet->_8022_snap.mac_header.token_ring.destination_address;
				}
			else
				{
				source = sptr_rx_packet->_8022_snap.mac_header.ethernet.source_address;
				destination = sptr_rx_packet->_8022_snap.mac_header.ethernet.destination_address;
				}

			((CONVERTED_8022_SNAP_PACKET *)sptr_rx_packet)->snap_header = sptr_snap_or_llc_header->snap;

			sptr_rx_packet = (PACKET *) ((ULONG) sptr_stack_header - sizeof (UNION_MAC_HEADER));

			sptr_rx_packet->_8022_snap.mac_header.ethernet.source_address = source;
			sptr_rx_packet->_8022_snap.mac_header.ethernet.destination_address = destination;
			sptr_rx_packet->_8022_snap.mac_header.ethernet.length_or_type.length = (USHORT) SNAP_PACKET;

			*usptr_size_of_rx_packet -= (USHORT) sizeof (SNAP_HEADER);

			return (sptr_rx_packet);
			}
		else if (sptr_snap_or_llc_header->llc.destination_address_DSAP != LSAP_SNAP_LLC &&
			sptr_snap_or_llc_header->llc.source_address_SSAP != LSAP_SNAP_LLC)
			{
			sptr_stack_header = (BYTE *) &sptr_rx_packet->_8022.stack_header;

			if (sptr_device_driver_entry->type == TOKEN_RING_DEVICE_DRIVER)
				{
				source = sptr_rx_packet->_8022.mac_header.token_ring.source_address;
				destination = sptr_rx_packet->_8022.mac_header.token_ring.destination_address;
				}
			else
				{
				source = sptr_rx_packet->_8022.mac_header.ethernet.source_address;
				destination = sptr_rx_packet->_8022.mac_header.ethernet.destination_address;
				}

			((CONVERTED_8022_PACKET *)sptr_rx_packet)->llc_header = sptr_snap_or_llc_header->llc;

			sptr_rx_packet = (PACKET *) ((ULONG) sptr_stack_header - sizeof (UNION_MAC_HEADER));

			sptr_rx_packet->_8022.mac_header.ethernet.source_address = source;
			sptr_rx_packet->_8022.mac_header.ethernet.destination_address = destination;

			sptr_rx_packet->_8022.mac_header.ethernet.length_or_type.length = (USHORT) LLC_PACKET;

			*usptr_size_of_rx_packet -= (USHORT) sizeof (LLC_HEADER);

			return (sptr_rx_packet);
			}
		}

	return (NULL);
}
/****************************************************************************/
void *convert_stack_header_for_tx (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,USHORT virtual_port_number,
	PACKET *sptr_tx_packet,USHORT *usptr_size_of_tx_packet)
{
	BYTE *sptr_stack_header;
	MAC_ADDRESS source;
	MAC_ADDRESS destination;
	PACKET *sptr_modified_tx_packet;
	enum LSL_PACKET_TYPE tx_packet_type;
	UNION_ETHERNET_LENGTH_OR_TYPE_FIELD length_or_type;

	if ((sptr_protocol_stack_entry->type == SPANNING_TREE_STACK) ||
		(sptr_protocol_stack_entry->type == SOURCE_ROUTING_STACK) || 
		(sptr_protocol_stack_entry->type == DLSW_PROTOCOL_STACK) ||
		(sptr_protocol_stack_entry->type == APPLETALK_PROTOCOL_STACK))
		{
		return (sptr_tx_packet);
		}

	tx_packet_type = sptr_protocol_stack_entry->port_number[virtual_port_number].packet_type;

	sptr_stack_header = (BYTE *) &sptr_tx_packet->_8022.llc_header;

	if (sptr_protocol_stack_entry->port_number[virtual_port_number].driver_type ==
		TOKEN_RING_DEVICE_DRIVER)
		{
		if (lsl_is_mac_address_source_routed (&sptr_tx_packet->raw.mac_header.ethernet.source_address) == TRUE)
			{
			sptr_tx_packet = (PACKET *) lsl_move_rif_into_packet ((PACKET *) sptr_tx_packet,usptr_size_of_tx_packet);

			return (sptr_tx_packet);
			}

		source = sptr_tx_packet->raw.mac_header.ethernet.source_address;
		destination = sptr_tx_packet->raw.mac_header.ethernet.destination_address;
		}
	else
		{
		if (tx_packet_type != ETHERNET_TYPE_II)
			{
			if (tx_packet_type == RAW_8023)
				{
				*usptr_size_of_tx_packet = (USHORT) ((*usptr_size_of_tx_packet + 1) & 0xfffe);
				}

			length_or_type.length =	swap ((USHORT) (*usptr_size_of_tx_packet - sizeof (UNION_MAC_HEADER)));
			}
		else
			{
			if (sptr_protocol_stack_entry->type == IP_PROTOCOL_STACK)
				{
				length_or_type.type = *((USHORT *) ((ULONG) sptr_tx_packet - sizeof (USHORT)));
				}
			else
				{
				length_or_type.type = sptr_protocol_stack_entry->snap_protocol_id;
				}
			}

		source = sptr_tx_packet->raw.mac_header.ethernet.source_address;
		destination = sptr_tx_packet->raw.mac_header.ethernet.destination_address;
		}

	switch (tx_packet_type)
		{
		case ETHERNET_TYPE_II:
		case RAW_8023:
			sptr_modified_tx_packet = (PACKET *) ((ULONG) sptr_stack_header - sizeof (UNION_MAC_HEADER));
			break;
		case LLC_PACKET:
			sptr_modified_tx_packet = (PACKET *) ((ULONG) sptr_stack_header - sizeof (UNION_MAC_HEADER) - sizeof (LLC_HEADER));

			sptr_modified_tx_packet->_8022.llc_header.llc_frame_type = UNNUMBERED_INFORMATION;

			sptr_modified_tx_packet->_8022.llc_header.source_address_SSAP =
				sptr_protocol_stack_entry->source_address_SSAP;

			sptr_modified_tx_packet->_8022.llc_header.destination_address_DSAP =
				sptr_protocol_stack_entry->source_address_DSAP;

			break;
		case SNAP_PACKET:
			sptr_modified_tx_packet = (PACKET *) ((ULONG) sptr_stack_header - sizeof (UNION_MAC_HEADER) - sizeof (SNAP_HEADER));

			sptr_modified_tx_packet->_8022_snap.snap_header.destination_address_DSAP = LSAP_SNAP_LLC;
			sptr_modified_tx_packet->_8022_snap.snap_header.source_address_SSAP = LSAP_SNAP_LLC;
			sptr_modified_tx_packet->_8022_snap.snap_header.llc_frame_type = UNNUMBERED_INFORMATION;

			sptr_modified_tx_packet->_8022_snap.snap_header.protocol_id_filler[0] = 0x00;
			sptr_modified_tx_packet->_8022_snap.snap_header.protocol_id_filler[1] = 0x00;
			sptr_modified_tx_packet->_8022_snap.snap_header.protocol_id_filler[2] = 0x00;


			if (sptr_protocol_stack_entry->type != IP_PROTOCOL_STACK)
				{
				sptr_modified_tx_packet->_8022_snap.snap_header.protocol_id =
					sptr_protocol_stack_entry->snap_protocol_id;
				}
			else
				{
				sptr_tx_packet = (PACKET *) ((ULONG) sptr_tx_packet - sizeof (SNAP_HEADER));

				sptr_modified_tx_packet->_8022_snap.snap_header.protocol_id =
					((CONVERTED_8022_SNAP_PACKET *) sptr_tx_packet)->snap_header.protocol_id;
				}

			break;
		default:
			lsl_printf (LSL_ALARM_PRINTF,"LSL: Illegal PACKET_TYPE %04x",virtual_port_number);
			return (NULL);
		}

	*usptr_size_of_tx_packet += (USHORT) get_size_of_packet_type_header (sptr_protocol_stack_entry,virtual_port_number);

	if (sptr_protocol_stack_entry->port_number[virtual_port_number].driver_type ==
		TOKEN_RING_DEVICE_DRIVER)
		{
		sptr_modified_tx_packet->_8022.mac_header.token_ring.source_address = source;
		sptr_modified_tx_packet->_8022.mac_header.token_ring.destination_address = destination;
		sptr_modified_tx_packet->_8022.mac_header.token_ring.access_control = 0x00;
		sptr_modified_tx_packet->_8022.mac_header.token_ring.frame_control = TOKEN_RING_LLC_PACKET;
		}
	else
		{
		length_or_type.length = swap ((USHORT) (swap (length_or_type.length) +
			get_size_of_packet_type_header (sptr_protocol_stack_entry,virtual_port_number)));

		sptr_modified_tx_packet->raw.mac_header.ethernet.source_address = source;
		sptr_modified_tx_packet->raw.mac_header.ethernet.destination_address = destination;
		sptr_modified_tx_packet->raw.mac_header.ethernet.length_or_type = length_or_type;
		}

	return (sptr_modified_tx_packet);
}
/****************************************************************************/
static ULONG get_size_of_packet_type_header (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,
	USHORT virtual_port_number)
{
	USHORT size_of_extra_header;

	size_of_extra_header = 0x0000;

	if (sptr_protocol_stack_entry->port_number[virtual_port_number].driver_type ==
		TOKEN_RING_DEVICE_DRIVER)
		{
		if (sptr_protocol_stack_entry->port_number[virtual_port_number].packet_type ==
			LLC_PACKET)
			{
			size_of_extra_header = sizeof (LLC_HEADER);
			}
		else
			{
			size_of_extra_header = sizeof (SNAP_HEADER);
			}
		}
	else
		{
		switch (sptr_protocol_stack_entry->port_number[virtual_port_number].packet_type)
			{
			case ETHERNET_TYPE_II:
			case RAW_8023:
				break;
			case LLC_PACKET:
				size_of_extra_header = sizeof (LLC_HEADER);
				break;
			case SNAP_PACKET:
				size_of_extra_header = sizeof (SNAP_HEADER);
				break;
			default:
				break;
			}
		}

	return (size_of_extra_header);
}
/*************************************************************************/
USHORT convert_real_to_stack_virtual_port_number (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,
	void *vptr_rx_buffer,DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry)
{
	USHORT virtual_port_number;
	enum LSL_PACKET_TYPE stack_packet_type;

	if (sptr_protocol_stack_entry->type == SPANNING_TREE_STACK ||
		sptr_protocol_stack_entry->type == SOURCE_ROUTING_STACK || 
		sptr_protocol_stack_entry->type == DLSW_PROTOCOL_STACK ||
		(sptr_protocol_stack_entry->type == APPLETALK_PROTOCOL_STACK))
		{
		return (sptr_device_driver_entry->real_port_number);
		}

	stack_packet_type = (enum LSL_PACKET_TYPE) ((PACKET *) vptr_rx_buffer)->raw.mac_header.ethernet.length_or_type.type;

	for (virtual_port_number = 0x0000; virtual_port_number < sptr_protocol_stack_entry->number_of_virtual_ports;
		++virtual_port_number)
		{
		if (sptr_device_driver_entry->real_port_number ==
			sptr_protocol_stack_entry->port_number[virtual_port_number].real_port_number)
			{
			if (stack_packet_type == sptr_protocol_stack_entry->port_number[virtual_port_number].packet_type)
				{
				return (virtual_port_number);
				}
			}
		}

 	lsl_printf (LSL_ALARM_PRINTF,"LSL: Illegal Virtual Port Number\r\n");

	return (ILLEGAL_VIRTUAL_PORT_NUMBER);
}
/*************************************************************************/
DEVICE_DRIVER_REGISTRATION_ENTRY *find_matching_device_driver_for_port_number (USHORT real_port_number)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;

	for (sptr_device_driver_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.device_drivers_list);
		sptr_device_driver_entry != NULL;
		sptr_device_driver_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_device_driver_entry->links))
		{
		if (sptr_device_driver_entry->real_port_number == real_port_number)
			{
			break;
			}
		}

	return (sptr_device_driver_entry);
}
/*************************************************************************/
USHORT raw_convert_real_to_stack_virtual_port_number (PROTOCOL_STACK_REGISTRATION_ENTRY *sptr_protocol_stack_entry,
	void *vptr_rx_buffer,DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry)
{
	USHORT virtual_port_number;
	enum LSL_PACKET_TYPE stack_packet_type;

	stack_packet_type = get_packet_type (sptr_device_driver_entry,(PACKET *) vptr_rx_buffer);

	if (stack_packet_type == ILLEGAL_LSL_PACKET_TYPE)
		{
		return (ILLEGAL_VIRTUAL_PORT_NUMBER);
		}

	for (virtual_port_number = 0x0000;
		virtual_port_number < sptr_protocol_stack_entry->number_of_virtual_ports;
		++virtual_port_number)
		{
		if (sptr_device_driver_entry->real_port_number ==
			sptr_protocol_stack_entry->port_number[virtual_port_number].real_port_number)
			{
			if (stack_packet_type == sptr_protocol_stack_entry->port_number[virtual_port_number].packet_type)
				{
				return (virtual_port_number);
				}
			}
		}

 	lsl_printf (LSL_ALARM_PRINTF,"LSL: Link Layer Type Not Configured for Protocol %08lx\r\n",sptr_protocol_stack_entry);

	return (ILLEGAL_VIRTUAL_PORT_NUMBER);
}
/*************************************************************************/
static enum LSL_PACKET_TYPE get_packet_type (DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry,PACKET *sptr_rx_packet)
{
	UNION_SNAP_OR_LLC_HEADER *sptr_snap_or_llc_header;
	BYTE *sptr_stack_header;
	USHORT length_of_token_ring_rif;

	sptr_stack_header = (BYTE *) &sptr_rx_packet->raw.stack_header;
	sptr_snap_or_llc_header = (UNION_SNAP_OR_LLC_HEADER *) sptr_stack_header;

	if (sptr_device_driver_entry->type != TOKEN_RING_DEVICE_DRIVER)
		{
		if (swap (sptr_rx_packet->raw.mac_header.ethernet.length_or_type.length) > MAXIMUM_ETHERNET_DATA_SIZE)
			{
			return (ETHERNET_TYPE_II);
			}
		else
			{
			if (*((USHORT *)sptr_stack_header) == 0xffff)	/* novell raw ethernet packet (this will change in 94' or 95') */
				{
				return (RAW_8023);
				}
			else if (sptr_snap_or_llc_header->snap.llc_frame_type == UNNUMBERED_INFORMATION)
				{
				if (sptr_snap_or_llc_header->snap.destination_address_DSAP == LSAP_SNAP_LLC &&
					sptr_snap_or_llc_header->snap.source_address_SSAP == LSAP_SNAP_LLC) 
					{
					return (SNAP_PACKET);
					}
				else
					{
					return (LLC_PACKET);
					}
				}

			}
		}
	else
		{
		if (lsl_is_token_ring_frame_source_routed (sptr_rx_packet) == TRUE)
			{
			length_of_token_ring_rif = lsl_get_length_of_token_ring_rif (sptr_rx_packet);

			sptr_snap_or_llc_header = (UNION_SNAP_OR_LLC_HEADER *) ((ULONG) sptr_snap_or_llc_header + length_of_token_ring_rif);
			}

		if (sptr_snap_or_llc_header->snap.llc_frame_type == UNNUMBERED_INFORMATION)
			{
			if (sptr_snap_or_llc_header->snap.destination_address_DSAP == LSAP_SNAP_LLC &&
				sptr_snap_or_llc_header->snap.source_address_SSAP == LSAP_SNAP_LLC) 
				{
				return (SNAP_PACKET);
				}
			else if (sptr_snap_or_llc_header->llc.destination_address_DSAP != LSAP_SNAP_LLC &&
				sptr_snap_or_llc_header->llc.source_address_SSAP != LSAP_SNAP_LLC)
				{
				return (LLC_PACKET);
				}
			}
		}

 	lsl_printf (LSL_ALARM_PRINTF,"LSL: Illegal LSL Type\r\n");

	return (ILLEGAL_LSL_PACKET_TYPE);
}
