#include	"defs.h"
/*	$Modname: lslsnmp.c$  $version: 1.8$		 $date: 07/05/95$	  */
/*
* 	$lgb$
1.0 06/15/94 ross
1.1 06/15/94 ross added copyright.
1.2 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.3 12/19/94 ross add new snmp.
1.4 01/12/95 ross building rwutils directory.
1.5 02/21/95 ross add close changes.
1.6 03/31/95 ross New close function, general cleanup.
1.7 06/29/95 ross new snmp access routine
1.8 07/05/95 ross new routines...
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<string.h>
#include	<stddef.h>
#include	"lsl.h"
#include	<visnpstr.h>
#include "vlslsnmp.h"
extern void	write_snmp_vals_to_flash(char *);	
/****************************************************************************/
/* Srikar, Mar 20, 1997. Changed the type of the parameter bptr_table_indices from BYTE * to OBJECT_ID * */
/* and its name from bptr_table_indices to sptr_table_indices */
enum TEST get_lsl_interfaces_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST return_code;

	return_code = process_mib_variable (mib_operation,cptr_mib_string,bptr_variable_value,
		usptr_size_of_variable_value,usptr_size_of_table_indices,sptr_table_indices,eptr_end_of_table,
		ptr_to_cptr_next_variable_name,&lsl_interfaces_snmp_table[0x00]);

	return (return_code);
}
/****************************************************************************/
/* Srikar, Mar 20, 1997. Changed the type of the parameter bptr_table_indices from BYTE * to OBJECT_ID * */
/* and its name from bptr_table_indices to sptr_table_indices */
enum TEST get_lsl_system_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	char *Chptr;
	enum TEST return_code;
	return_code = process_mib_variable (mib_operation,cptr_mib_string,bptr_variable_value,
		usptr_size_of_variable_value,usptr_size_of_table_indices,sptr_table_indices,eptr_end_of_table,
		ptr_to_cptr_next_variable_name,&lsl_system_snmp_table[0x00]);

	if(mib_operation == SET_OPERATION){

			Chptr =  (char *) calloc(1024,sizeof(char));
			if(Chptr == NULL ){
				printf("\r\n Memory Allocation Error \r\n");
				return (return_code);
			}

			strncpy(&Chptr[0],lsl.system_mib.sysContact,256);
			strncpy(&Chptr[256],lsl.system_mib.sysName,256);
			strncpy(&Chptr[512],lsl.system_mib.sysLocation,256);

			if( !(strcmp(cptr_mib_string,"sysContact") ) ) 
				strcpy(&Chptr[0],lsl.system_mib.sysContact);
				
			if( !(strcmp(cptr_mib_string,"sysName") ) ) 
				strcpy(&Chptr[256],lsl.system_mib.sysName);

			if( !(strcmp(cptr_mib_string,"sysLocation") ) ) 
				strcpy(&Chptr[512],lsl.system_mib.sysLocation);
			

			write_snmp_vals_to_flash(Chptr);	
			free(Chptr);
	}
	return (return_code);
}

/* Srikar, Mar 24, 1997. Added the following function to check the length of the string being assigned. */

/**********************************************************************************/

enum TEST snmp_get_or_set_sysContact (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	char	*dst_ptr;

	if (mib_operation == SET_OPERATION && strlen((char *) vptr_mib_value_obtained) > sizeof(lsl.system_mib.sysContact) - 1)
		{
		dst_ptr = (char *) (_class + offset + (size * port_number));
		memmove (dst_ptr, (char *) vptr_mib_value_obtained, sizeof(lsl.system_mib.sysContact) - 1);
		dst_ptr[sizeof(lsl.system_mib.sysContact) - 1] = 0;
		return(PASS);
		}
	return(snmp_get_or_set_string (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained));
}

/* Srikar, Mar 24, 1997. Added the following function to check the length of the string being assigned. */

/**********************************************************************************/

enum TEST snmp_get_or_set_sysName (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	char	*dst_ptr;

	if (mib_operation == SET_OPERATION && strlen((char *) vptr_mib_value_obtained) > sizeof(lsl.system_mib.sysName) - 1)
		{
		dst_ptr = (char *) (_class + offset + (size * port_number));
		memmove (dst_ptr, (char *) vptr_mib_value_obtained, sizeof(lsl.system_mib.sysName) - 1);
		dst_ptr[sizeof(lsl.system_mib.sysName) - 1] = 0;
		return(PASS);
		}
	return(snmp_get_or_set_string (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained));
}

/* Srikar, Mar 24, 1997. Added the following function to check the length of the string being assigned. */

/**********************************************************************************/

enum TEST snmp_get_or_set_sysLocation (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	char	*dst_ptr;

	if (mib_operation == SET_OPERATION && strlen((char *) vptr_mib_value_obtained) > sizeof(lsl.system_mib.sysLocation) - 1)
		{
		dst_ptr = (char *) (_class + offset + (size * port_number));
		memmove (dst_ptr, (char *) vptr_mib_value_obtained, sizeof(lsl.system_mib.sysLocation) - 1);
		dst_ptr[sizeof(lsl.system_mib.sysLocation) - 1] = 0;
		return(PASS);
		}
	return(snmp_get_or_set_string (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained));
}

/**********************************************************************************/
enum TEST snmp_get_or_set_ifAdminStatus (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	DEVICE_DRIVER_REGISTRATION_ENTRY *sptr_device_driver_entry;
	BYTE	current_admin_status;
	BYTE	new_admin_status;
	USHORT	port_index;

	if  (mib_operation == SET_OPERATION)
		{
		/* Since the port number passed is zero, we need to find out which the port's status to change. */

		port_index = 0;
		sptr_device_driver_entry = get_pointer_to_first_entry_in_list ((LINK *) &lsl.device_drivers_list);
		while (sptr_device_driver_entry != NULL)
			{
			if ((ULONG) sptr_device_driver_entry == _class)
				break;
			port_index++;
			sptr_device_driver_entry = get_pointer_to_next_entry_in_list ((LINK *) &sptr_device_driver_entry->links);
			}

		/* LAN port status cannot be changed. Ensure that the index for WAN ports is ok. */
		if (port_index < lsl.number_of_lan_ports || port_index >= lsl.number_of_lan_ports + lsl.number_of_wan_ports)
			return(FAIL);
		port_index -= lsl.number_of_lan_ports;

		current_admin_status = *(BYTE *) (_class + offset + (size * port_number));
		new_admin_status = *(BYTE *) vptr_mib_value_obtained;
		if (current_admin_status == new_admin_status)
			return(PASS);
		switch (new_admin_status) /* Code to be filled here when admin status actually becomes settable */
			{
			case REAL_PORT_UP :
				return(FAIL);
			case REAL_PORT_DOWN :
				return(FAIL);
			default :
				return(FAIL);
			}
		}
	/* Srikar, Mar 30, 1997. Changed the call function snmp_get_or_set_ulong instead of snmp_get_or_set_byte */
	return (snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size,
		vptr_mib_value_obtained, usptr_length_of_mib_obtained));
}
