#include	"defs.h"
/*	$Modname: accesnmp.c$  $version: 1.3$      $date: 01/30/95$   */
/*
* 	$lgb$
1.0 01/12/95 ross
1.1 01/12/95 ross added copyright.
1.2 01/26/95 ross SNMP file added
1.3 01/30/95 ross removing duplicate configuration options
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include <kstart.h>
#include	<v8022str.h>
#include <lslproto.h>

/* Srikar, Mar 18, 1997. Added by SN to support setting of ip addresses. Earlier we were using the */
/* snmp_get_or_set_ulong which was not setting the IP address correctly. We need to swap the received */
/* address before setting the local variable. */
enum TEST snmp_get_or_set_ip_address (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		*(ULONG *) vptr_mib_value_obtained = *(ULONG *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (*(ULONG *) vptr_mib_value_obtained);
		}
	else if (mib_operation == SET_OPERATION)
		{
		*(ULONG *) (_class + offset + (size * port_number)) = swap_long(*(ULONG *) vptr_mib_value_obtained);
		}

	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}

/**********************************************************************************/
enum TEST snmp_get_or_set_ulong (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		*(ULONG *) vptr_mib_value_obtained = 0;
		*(ULONG *) vptr_mib_value_obtained = *(ULONG *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (*(ULONG *) vptr_mib_value_obtained);
		}
	else if (mib_operation == SET_OPERATION)
		{
		*(ULONG *) (_class + offset + (size * port_number)) = *(ULONG *) vptr_mib_value_obtained;
		}

	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_ushort (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	value = 0x00000000;

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		value = *(USHORT *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);
		}
	else if (mib_operation == SET_OPERATION)
		{
		/* Srikar, Mar 19, 1997. Changed the access length from long to short and removed swapping. */

		*(USHORT *) (_class + offset + (size * port_number)) = (*(USHORT *) vptr_mib_value_obtained);
		}

	*usptr_length_of_mib_obtained = sizeof (ULONG);

	PARAMETER_NOT_USED (value);

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 17, 1997. Added this function to for accessing variables */
/* already stored in the big endian form */
enum TEST snmp_get_or_set_big_endian_ushort (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	value = 0x00000000;

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		value = swap(*(USHORT *) (_class + offset + (size * port_number)));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = *(ULONG *) vptr_mib_value_obtained;

		*(USHORT *) (_class + offset + (size * port_number)) = swap((USHORT) swap_long (value));
		}

	*usptr_length_of_mib_obtained = sizeof (ULONG);

	PARAMETER_NOT_USED (value);

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_boolean_plus_one (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size,	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	value = 0x00000000;

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		value = *(BYTE *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value + 1);
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = *(ULONG *) vptr_mib_value_obtained;

		*(BYTE *) (_class + offset + (size * port_number)) = (BYTE) (value - 1);
		}

	PARAMETER_NOT_USED (value);

	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_byte (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	value = 0x00000000;

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		value = *(BYTE *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (value);
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = *(ULONG *) vptr_mib_value_obtained;

		*(BYTE *) (_class + offset + (size * port_number)) = (BYTE) value;
		}

	PARAMETER_NOT_USED (value);

	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_string (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		strcpy ((char *) vptr_mib_value_obtained, (char *) (_class + offset + (size * port_number)));
		
		*usptr_length_of_mib_obtained = (USHORT) strlen (vptr_mib_value_obtained);

		/* Srikar, Mar 19, 1997. Commented the following assignment since sending a length of 4 for a null */
		/* string can display garbage at the manager. */
#if 0
		if (*usptr_length_of_mib_obtained == 0x0000)
			{
			*usptr_length_of_mib_obtained = sizeof (ULONG);
			}
#endif
		}
	else if (mib_operation == SET_OPERATION)
		{
		strcpy ((char *) (_class + offset + (size * port_number)), (char *) vptr_mib_value_obtained);
		}

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 17, 1997. Added this function to access a fixed length string of size 2 */
enum TEST snmp_get_or_set_2_byte_string (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		memcpy ((char *) vptr_mib_value_obtained, (char *) (_class + offset + (size * port_number)), 2);
		
		*usptr_length_of_mib_obtained = (USHORT) 2;
		}
	else if (mib_operation == SET_OPERATION)
		{
		memcpy ((char *) (_class + offset + (size * port_number)), (char *) vptr_mib_value_obtained, 2);
		}

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 18, 1997. Added support for SET_OPERATION. */
enum TEST snmp_get_or_set_mac_address (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size,	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	void *vptr_mac_address;

	vptr_mac_address = (BYTE *) (_class + offset + (size * port_number));
	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		memcpy (vptr_mib_value_obtained, vptr_mac_address, sizeof (MAC_ADDRESS));
		}
	else if (mib_operation == SET_OPERATION)
		{
		memcpy (vptr_mac_address, vptr_mib_value_obtained, sizeof (MAC_ADDRESS));
		}

	*usptr_length_of_mib_obtained = sizeof (MAC_ADDRESS);

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_8_byte_object (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size,	void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained)
{
	void *vptr_class_variable;

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memcpy (vptr_mib_value, vptr_class_variable, 0x0008);
		}
	else
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memcpy (vptr_class_variable, vptr_mib_value, 0x0008);
		}

	*usptr_length_of_mib_obtained = 0x0008;

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 15, 1997. Funciton added to access 4 byte objects */
enum TEST snmp_get_or_set_4_byte_object (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size,	void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained)
{
	void *vptr_class_variable;

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memcpy (vptr_mib_value, vptr_class_variable, 0x0004);
		}
	else
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memcpy (vptr_class_variable, vptr_mib_value, 0x0004);
		}

	*usptr_length_of_mib_obtained = 0x0004;

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_or_set_2_byte_object (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class,
	ULONG size,	void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained)
{
	void *vptr_class_variable;

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memset ((BYTE *) vptr_mib_value, (int) NULL, sizeof (USHORT));

		memcpy ((BYTE *) vptr_mib_value + sizeof (USHORT), vptr_class_variable, sizeof (USHORT));
		}
	else
		{
		vptr_class_variable = (char *) (_class + offset + (size * port_number));

		memset ((BYTE *) vptr_class_variable, (int) NULL, sizeof (USHORT));

		memcpy (vptr_class_variable, (BYTE *) vptr_mib_value + sizeof (USHORT), sizeof (USHORT));
		}

	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}
/**********************************************************************************/
enum TEST snmp_get_port_number (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;

	PARAMETER_NOT_USED (offset);
	PARAMETER_NOT_USED (_class);
	PARAMETER_NOT_USED (size);

	value = (ULONG) port_number + 1;

	if  ((mib_operation == GET_OPERATION)|| (mib_operation == GET_NEXT_OPERATION))
		{
		*(ULONG *) vptr_mib_value = swap_long (value);
		}

	*usptr_length_of_mib_obtained = sizeof (ULONG);

	return (PASS);
}


