/**  **/
/*	Author 	: Neelu																		*/
/*	Module	: Event Broadcast           											*/
/*	Synopsis	: Sends a UDP Broadcast as soon as any event occurs         */
/**  **/

#include	<stdlib.h>
/*#include "ip.h"*/
#include "event.h"
#include "evntstr.h"

#include "..\applicat\sntp\ksntp.h"
#include "..\applicat\sntp\vsntpstr.h"   /* for getting the time */


BYTE uname[MAX_DATA_PACKET_SIZE];
DATE dptr;
TIME tptr;
const char *users_log_msgs[] = {
		"User %s logged on",
		"User %s logged off",
		"User %s identified as defaulter, account locked-up",
		"Invalid login attempts by User %s"
		"User %s identified as Invalid username",
		"User %s Put invalid Passwords"
		};

extern UNION_IP_PACKET *get_an_ip_send_packet (USHORT port_number, ULONG size_of_packet);
extern void send_completion_ip_packet (USHORT port_number, void *vptr_txed_packet);
extern USHORT get_secured_lan_port_number();
extern ULONG get_ip_address(USHORT port_number);
extern void GetDateTime (SntpDateTime far *dt_ptr);

void build_event_header (EVENT_HEADER *sptr_event_header, EVENT_HEADER *event_broadcast_packet);

static void send_event_packet (IP_SOCKET *sptr_remote_socket, EVENT_HEADER *event_packet);
void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet);

void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet)
{
	USHORT port_number;
	IP_SOCKET remote_socket;

   remote_socket.ip_address = INTERNET_ADDRESS_BROADCAST;

	remote_socket.port = EVENT_PORT;
	remote_socket.virtual_port_number = get_secured_lan_port_number();
	send_event_packet (&remote_socket, event_packet);
}


static void send_event_packet (IP_SOCKET *sptr_remote_socket,EVENT_HEADER *event_packet)
{
	EVENT_REQUEST_PACKET *sptr_event_request_packet;
	IP_SOCKET local_socket;
	UNION_SERVICE_TYPE_BIT_STRUCTURE type_of_service;
	USHORT size;
	DATE dptr;
	TIME tptr;
	
	SntpDateTime date_time_ptr;
	EVENT_HEADER event_broadcast_pkt;

	sptr_event_request_packet = (EVENT_REQUEST_PACKET *) get_an_ip_send_packet (sptr_remote_socket->virtual_port_number,
											sizeof (EVENT_REQUEST_PACKET));
	if (sptr_event_request_packet == NULL)
	{
			return;
	}
	
	local_socket.ip_address = get_ip_address(sptr_remote_socket->virtual_port_number);
	local_socket.port = EVENT_PORT;

	/* we will have to initialize this uname before passing */
	GetDateTime(&date_time_ptr); 
  
	dptr.day = date_time_ptr.Day;
	dptr.month = date_time_ptr.Month;
	dptr.year = date_time_ptr.Year;
	tptr.hour = date_time_ptr.Hour;
	tptr.minute = date_time_ptr.Minute;
	tptr.second = date_time_ptr.Second;
	 
	sprintf(event_packet->time, "%02d:%02d:%02d",date_time_ptr.Hour,date_time_ptr.Minute,date_time_ptr.Second);
	sprintf(event_packet->date,"%02d/%02d/%04d",date_time_ptr.Month,date_time_ptr.Day,date_time_ptr.Year); /* Changed by Sreelu to mm/dd/yy */
	event_packet->server_ip_address = get_ip_address(0);
	sptr_event_request_packet->header = *event_packet;
	
	type_of_service._byte = 0x00;
	
	send_udp (sptr_remote_socket->virtual_port_number, &local_socket, sptr_remote_socket, type_of_service._bit,
		255, (void *)sptr_event_request_packet, 0, FALSE, sizeof (EVENT_REQUEST_PACKET),
		send_completion_ip_packet, NULL);
}

void build_event_header (EVENT_HEADER *sptr_event_header, EVENT_HEADER *event_broadcast_packet)
{
	sptr_event_header->event_type = event_broadcast_packet->event_type;
	sptr_event_header->user_event_type = event_broadcast_packet->user_event_type;
	strcpy(sptr_event_header->username,event_broadcast_packet->username);
/*	printf("usname = %s\n",sptr_event_header->username);*/
/*	printf("usname2 = %s\n",event_broadcast_packet->username);*/
   strcpy(sptr_event_header->groupname,event_broadcast_packet->groupname);
	strcpy(sptr_event_header->login_time,event_broadcast_packet->login_time);
	sptr_event_header->ip_address = event_broadcast_packet->ip_address;
	strcpy(sptr_event_header->date,event_broadcast_packet->date);
	strcpy(sptr_event_header->time,event_broadcast_packet->time);

	/*	printf("\neventstring = %s",sptr_event_header->event_string); */
}


