/*---------------------------------------------------------------------------
	file	:	log.h
	Auth	:	vidy
	Date	:	30th Jan 98
	Synop	:	Contains the routines for the log abstract data type
	Assumptions :
	1. This is for logging events which are not-too-fast. SO it
	assumes that the log read is a much faster operation than log write.
	2. log functions are not to be used from ISRs
---------------------------------------------------------------------------*/
#define	LOG_MIN_FILE_SIZE		(20 * 1024)
#define	LOG_MAX_FILE_SIZE		(100 * 1024)
#define	LOG_DEF_FILE_SIZE		LOG_MIN_FILE_SIZE
#define	LOG_MIN_FREE_SIZE		100

#define	CHAR_NEW_LINE			'\n'
#define  LOG_MAX_OPENS			10
#define  LOG_MAX_RECORDS 		150
#define  LOG_FREE_UP_QUANTUM  5

typedef struct log_descriptor {
   event_record *read_ptr;
	char valid;
}log_descriptor_type;

static int get_log_time_stamp(SntpDateTime time,char *buffer);
static void free_up_event_records(void);
  

