#include <memory.h>
#include <redblack.h>

#define PARAMETER_NOT_USED(x) x=x


RED_BLACK_NODE_HEADER NULLNode =
{
	0, 0, 0, /* parent and children-pointers */
	COLOR_BLACK
} ;

RED_BLACK_NODE_HEADER far *sptr_RB_sentinal_node = &NULLNode ;


static RED_BLACK_NODE_HEADER far *tree_minimum (RED_BLACK_NODE_HEADER far *x)
{
	while (x->LChild != sptr_RB_sentinal_node)
		x = x->LChild ;
	return x ;
}


static RED_BLACK_NODE_HEADER far *tree_successor ( RED_BLACK_NODE_HEADER far *x)
{
	RED_BLACK_NODE_HEADER far *y ;

	if (x->RChild != sptr_RB_sentinal_node)
		return tree_minimum (x->RChild) ;
	
	y = x->Parent ;

	while ((y != sptr_RB_sentinal_node) && (x == y->RChild))
	{
		x = y ;
		y = y->Parent ;
	}
	return y ;
}



static RED_BLACK_NODE_HEADER far *RB_left_rotate (RED_BLACK_NODE_HEADER far *node, RED_BLACK_NODE_HEADER far *root)
{
	RED_BLACK_NODE_HEADER far *rightchild ;

	rightchild = node->RChild ;
	node->RChild = rightchild->LChild ;
	if (rightchild->LChild != sptr_RB_sentinal_node)
		rightchild->LChild->Parent = node ;
	rightchild->Parent = node->Parent ;
	if (node->Parent == sptr_RB_sentinal_node)
		root = rightchild ;
	else
		if (node == node->Parent->LChild)
			node->Parent->LChild = rightchild ;
		else
			node->Parent->RChild = rightchild ;
	rightchild->LChild = node ;
	node->Parent = rightchild ;
	return root ;
}


static RED_BLACK_NODE_HEADER far *RB_right_rotate (RED_BLACK_NODE_HEADER far *node, RED_BLACK_NODE_HEADER far *root)
{
	RED_BLACK_NODE_HEADER far *leftchild ;

	leftchild = node->LChild;
	node->LChild = leftchild->RChild ;
	if (leftchild->RChild != sptr_RB_sentinal_node)
		leftchild->RChild->Parent = node ;
	leftchild->Parent = node->Parent ;
	if (node->Parent == sptr_RB_sentinal_node)
		root = leftchild ;
	else
		if (node == node->Parent->RChild)
			node->Parent->RChild = leftchild ;
		else
			node->Parent->LChild = leftchild ;
	leftchild->RChild = node ;
	node->Parent = leftchild ;			 	
	return root ;
}

static RED_BLACK_NODE_HEADER far *RB_delete_fixup (RED_BLACK_NODE_HEADER far	*x, RED_BLACK_NODE_HEADER far *T)
{
	RED_BLACK_NODE_HEADER far *w ;

	while ((x != T) && (x->Color == COLOR_BLACK))
	{
		if (x == x->Parent->LChild)
		{
			w = x->Parent->RChild ;
			if (w->Color == COLOR_RED)
			{
				w->Color = COLOR_BLACK ;
				x->Parent->Color = COLOR_RED ;
				T = RB_left_rotate(x->Parent, T) ;
				w = x->Parent->RChild ;
			}
			if ((w->LChild->Color == COLOR_BLACK) && (w->RChild->Color == COLOR_BLACK))
			{
				w->Color = COLOR_RED ;
				x = x->Parent ;
			}
			else
			{
				if (w->RChild->Color == COLOR_BLACK)
				{
					w->LChild->Color = COLOR_BLACK ;
					w->Color = COLOR_RED ;
					T = RB_right_rotate(w, T) ;
					w = x->Parent->RChild ;
				}
				w->Color = x->Parent->Color ;
				x->Parent->Color = COLOR_BLACK ;
				w->RChild->Color = COLOR_BLACK ;
				T = RB_left_rotate(x->Parent, T) ;
				x = T ;
			}
		}
		else
		{
			w = x->Parent->LChild ;
			if (w->Color == COLOR_RED)
			{
				w->Color = COLOR_BLACK ;
				x->Parent->Color = COLOR_RED ;
				T = RB_right_rotate(x->Parent, T) ;
				w = x->Parent->LChild ;
			}
			if ((w->RChild->Color == COLOR_BLACK) && (w->LChild->Color == COLOR_BLACK))
			{
				w->Color = COLOR_RED ;
				x = x->Parent ;
			}
			else
			{
				if (w->LChild->Color == COLOR_BLACK)
				{
					w->RChild->Color = COLOR_BLACK ;
					w->Color = COLOR_RED ;
					T = RB_left_rotate(w, T) ;
					w = x->Parent->LChild ;
				}
				w->Color = x->Parent->Color ;
				x->Parent->Color = COLOR_BLACK ;
				w->LChild->Color = COLOR_BLACK ;
				T = RB_right_rotate(x->Parent, T) ;
				x = T ;
			}
		}
	}
	x->Color = COLOR_BLACK ;
	return T ;
}




RED_BLACK_NODE_HEADER far *RB_red_balance (RED_BLACK_NODE_HEADER far *x, RED_BLACK_NODE_HEADER far *T)
{
	RED_BLACK_NODE_HEADER far *y ;

	x->Color = COLOR_RED ;
	while ((x != T) && (x->Parent->Color == COLOR_RED))
	{
		if (x->Parent == x->Parent->Parent->LChild)
		{
			y = x->Parent->Parent->RChild ;
			if (y->Color == COLOR_RED)
			{
				x->Parent->Color = COLOR_BLACK ;
				y->Color = COLOR_BLACK ;
				x->Parent->Parent->Color = COLOR_RED ;
				x = x->Parent->Parent ;
			}
			else
			{
				if (x == x->Parent->RChild)
				{
					x = x->Parent ;
					T = RB_left_rotate(x, T) ;
				}
				x->Parent->Color = COLOR_BLACK ;
				x->Parent->Parent->Color = COLOR_RED ;
				T = RB_right_rotate(x->Parent->Parent, T) ;
			}
		}
		else
		{
			y = x->Parent->Parent->LChild ;
			if (y->Color == COLOR_RED)
			{
				x->Parent->Color = COLOR_BLACK ;
				y->Color = COLOR_BLACK ;
				x->Parent->Parent->Color = COLOR_RED ;
				x = x->Parent->Parent ;
			}
			else
			{
				if (x == x->Parent->LChild)
				{
					x = x->Parent ;
					T = RB_right_rotate(x, T) ;
				}
				x->Parent->Color = COLOR_BLACK ;
				x->Parent->Parent->Color = COLOR_RED ;
				T = RB_left_rotate(x->Parent->Parent, T) ;
			}
		}
	}
	T->Color = COLOR_BLACK ;
	return T ;
}



/* RED_BLACK_NODE_HEADER far *RB_delete(RED_BLACK_NODE_HEADER far *z, RED_BLACK_NODE_HEADER far *T, unsigned long node_size, RED_BLACK_NODE_HEADER far **sptr_physically_deleted_node) */
RED_BLACK_NODE_HEADER far *RB_delete(RED_BLACK_NODE_HEADER far *T, RED_BLACK_NODE_HEADER far *z, unsigned long node_size, RED_BLACK_NODE_HEADER far **sptr_physically_deleted_node) 
{
	RED_BLACK_NODE_HEADER far *x, far *y ;
		
	if ((z->LChild == sptr_RB_sentinal_node) || (z->RChild == sptr_RB_sentinal_node))
		y = z ;
	else
		y = tree_successor(z) ;
	if (y->LChild != sptr_RB_sentinal_node)
		x = y->LChild ;
	else
		x = y->RChild ;
	x->Parent = y->Parent ;

	if (y->Parent == sptr_RB_sentinal_node)
		T = x ;
	else
		if (y == y->Parent->LChild)
			y->Parent->LChild = x ;
		else
			y->Parent->RChild = x ;
	if (z != y)
	{
		/* Copy y to z */
		/* All feilds including key i.e except parent, children-pointers & Color */
		_fmemcpy ((unsigned char far *)z+sizeof(RED_BLACK_NODE_HEADER),
		         (unsigned char far *)y+sizeof(RED_BLACK_NODE_HEADER),
					(unsigned short) (node_size - (unsigned long) sizeof(RED_BLACK_NODE_HEADER))) ;
	}
	if (y->Color == COLOR_BLACK)
		T = RB_delete_fixup(x, T) ; 

	*sptr_physically_deleted_node = y ;
#if 0
	UpdatedNode = z ;
#endif
	return T ;
}





RED_BLACK_NODE_HEADER far *RB_get_first_node(RED_BLACK_NODE_HEADER far *Tree)
{
	if (Tree == sptr_RB_sentinal_node)
		return (RED_BLACK_NODE_HEADER far *) 0 ;
	else
	{
		while (Tree->LChild != sptr_RB_sentinal_node)
			Tree = Tree->LChild ;
		return Tree ;
	}
}


RED_BLACK_NODE_HEADER far *RB_get_next_node(RED_BLACK_NODE_HEADER far *PrevNode)
{
	if (PrevNode->RChild != sptr_RB_sentinal_node)
	{
		PrevNode = PrevNode->RChild ;
		while (PrevNode->LChild != sptr_RB_sentinal_node)
			PrevNode = PrevNode->LChild ;
		if (PrevNode == sptr_RB_sentinal_node)
			return (RED_BLACK_NODE_HEADER far *) 0 ;
		return PrevNode ;
	}
	while (PrevNode->Parent != sptr_RB_sentinal_node)
	{
		if (PrevNode == PrevNode->Parent->RChild)
			PrevNode = PrevNode->Parent ;
		else
		{
			PrevNode = PrevNode->Parent ;
			if (PrevNode == sptr_RB_sentinal_node)
				PrevNode = (RED_BLACK_NODE_HEADER far *) 0 ;
			return PrevNode ;		
		}
	}
	return (RED_BLACK_NODE_HEADER far *) 0 ;
}


