 #include	"defs.h"
/*	$Modname: socklapi.c$  $version: 1.5$      $date: 04/06/95$   */
/*
* 	$lgb$
1.0 11/04/94 titus Initial Release. Broke up sockapi.c into socklapi.c and sockoapi.c .
1.1 11/04/94 titus Cosmetic changes for c++ compilation.
1.2 11/15/94 titus Utilization of links for list manipulation and ULONG socket_descriptors.
1.3 12/27/94 titus Removed dependencies with UDP, TCP, added LSL message feature, module registers as application with LSL etc.
1.4 01/26/95 titus Cosmetic changes for Borland 4.5 compiler etc. and added new test program to test TCP
1.5 04/06/95 titus Changes to support AF_RTRWARE family of protocols (for console applications)
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "socket.h"
/*********************************************************************************************/
/*
 * Create a user socket, return socket descriptor
 */
int socket (int address_family, int socket_type_of_service, int protocol)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;
	int return_value;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	if ((socket_class.current_number_of_sockets + 1) > socket_class.maximum_number_of_sockets)
		{
		socket_class.error_number = TOO_MANY_SOCKETS_OPEN;

		return (FAILED);
		}

	sptr_user_socket = (USER_SOCKET *) table_malloc (1, sizeof (USER_SOCKET));

	if (sptr_user_socket == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: socket (): table_malloc failed\n");

		return (FAILED);
		}

	add_entry_to_front_of_list ((LINK *) &socket_class.user_socket_list, (LINK *) sptr_user_socket);

	sptr_user_socket->socket_descriptor = (ULONG) sptr_user_socket;
	sptr_user_socket->reference_count = 0x0001;

	if (socket_class.blocking_enabled == FALSE)
		{
		sptr_user_socket->do_not_block = TRUE;
		}
	else
		{
		sptr_user_socket->do_not_block = FALSE;
		}

	socket_class.error_number = 0x0000;

	sptr_user_socket->valid_ready_socket = FALSE;

	switch (address_family)
		{
		case AF_INET:

			switch (socket_type_of_service)
				{
				case SOCK_STREAM:

					sptr_user_socket->socket_type_of_service = TYPE_TCP;

					break;

				case SOCK_DGRAM:

					sptr_user_socket->socket_type_of_service = TYPE_UDP;

					break;

				default:

					socket_class.error_number = SOCKET_NOT_SUPPORTED_ERROR;

					break;
				}

			break;

		case AF_NETWARE:

			switch (socket_type_of_service)
				{
				case SOCK_STREAM:

					sptr_user_socket->socket_type_of_service = TYPE_SPX;

					break;

				case SOCK_DGRAM:

					sptr_user_socket->socket_type_of_service = TYPE_IPX;

					break;

				default:

					socket_class.error_number = SOCKET_NOT_SUPPORTED_ERROR;

					break;
				}

			break;

		case AF_RTRWARE:

			switch (socket_type_of_service)
				{
				case SOCK_DGRAM:

					sptr_user_socket->socket_type_of_service = TYPE_CONSOLE;

					break;

				default:

					socket_class.error_number = SOCKET_NOT_SUPPORTED_ERROR;

					break;
				}

			break;

		default:

			socket_class.error_number = ADDRESS_FAMILY_NOT_SUPPORTED_ERROR;

			break;
		}

	/* Look for entry in protocol table */

	#ifndef __LSL__

		sptr_transport_interface = socket_class.transport_interface_list.sptr_forward_link;

		while ((sptr_transport_interface != NULL) &&
			(sptr_transport_interface->socket_type_of_service != INVALID_USER_SOCKET_TYPE))
			{
			if (sptr_user_socket->socket_type_of_service == sptr_transport_interface->socket_type_of_service)
				{
				break;
				}

			++sptr_transport_interface;
			}

	#endif /* __LSL__ */

	#ifdef __LSL__

		sptr_transport_interface = (TRANSPORT_INTERFACE *) get_pointer_to_first_entry_in_list (
			(LINK *) &socket_class.transport_interface_list);

		while ((sptr_transport_interface != NULL) &&
			(sptr_transport_interface->socket_type_of_service != INVALID_USER_SOCKET_TYPE))
			{
			if (sptr_user_socket->socket_type_of_service == sptr_transport_interface->socket_type_of_service)
				{
				break;
				}

			sptr_transport_interface = (TRANSPORT_INTERFACE *) get_pointer_to_next_entry_in_list (
				(LINK *) sptr_transport_interface);
			}

	#endif /* __LSL__ */

	if (sptr_transport_interface != NULL)
		{
		sptr_user_socket->sptr_transport_interface = sptr_transport_interface;

		if (sptr_transport_interface->socket_type_of_service != INVALID_USER_SOCKET_TYPE)
			{
			if ((sptr_transport_interface->socket == NULL) ||
				((*sptr_transport_interface->socket) (sptr_user_socket, (USHORT) protocol) == FAIL))
				{
				socket_class.error_number = SOCKET_NOT_SUPPORTED_ERROR;

				return (FAILED);
				}
			}
		else
			{
			sptr_user_socket->sptr_transport_interface = NULL;

			socket_class.error_number = SOCKET_NOT_SUPPORTED_ERROR;

			return (FAILED);
			}
		}
	else
		{
		socket_class.error_number = SOCKET_NOT_SUPPORTED_ERROR;

		return (FAILED);
		}

	++socket_class.current_number_of_sockets;

	return_value = (int) sptr_user_socket;

	return (return_value);
}
/*********************************************************************************************/
/*
 * Attach a local address/port to a socket. If not issued before a connect or listen, will be issued automatically
 */
int bind (int socket_descriptor, SOCKADDR *sptr_sockaddr, int sockaddr_length)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAILED);
		}

	if (sptr_sockaddr == NULL)
		{
		socket_class.error_number = NULL_LOCAL_ADDRESS;

		return (FAILED);
		}

	if (sockaddr_length == 0x00000000L)
		{
		socket_class.error_number = BAD_DATA;

		return (FAILED);
		}

	if (sptr_user_socket->vptr_address != NULL)
		{
		/* Bind has already been issued */

		socket_class.error_number = ALREADY_BOUND_TO_ADDRESS;

		return (FAILED);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	if ((sptr_transport_interface->check != NULL) &&
		((*sptr_transport_interface->check) (sptr_sockaddr, (USHORT) sockaddr_length) == FAIL))
		{
		/* Incorrect length or family for chosen protocol */

		socket_class.error_number = ADDRESS_FAMILY_NOT_SUPPORTED_ERROR;

		return (FAILED);
 		}

	/* Stash name in an allocated block */

	sptr_user_socket->address_length = (USHORT) sockaddr_length;

	sptr_user_socket->vptr_address = (void *) table_malloc (1, sptr_user_socket->address_length);

	if (sptr_user_socket->vptr_address == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: bind (): table_malloc failed\n");

		return (FAILED);
		}

	memcpy (sptr_user_socket->vptr_address, (void *) sptr_sockaddr, sptr_user_socket->address_length);

	/* a bind routine is optional - don't fail if it isn't present */

	if ((sptr_transport_interface->bind != NULL) && ((*sptr_transport_interface->bind) (sptr_user_socket) == FAIL))
		{
		socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;

		return (FAILED);
		}

	return (DONE);
}
/*********************************************************************************************/
/*
 * Initiate active open. For datagram sockets, merely bind the remote address.
 */
#if 0
int connect (int socket_descriptor, SOCKADDR_IN *sptr_sockaddr_in, int sockaddr_in_length)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAILED);
		}

	if (sptr_sockaddr_in == NULL)
		{
		/* Connect must specify a remote address */

		socket_class.error_number = NULL_PEER_ADDRESS;

		return (FAILED);
		}

	if (sockaddr_in_length == 0x00000000L)
		{
		socket_class.error_number = BAD_DATA;

		return (FAILED);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	/* Check name format, if checking routine is available */

	if ((sptr_transport_interface->check != NULL) &&
		((*sptr_transport_interface->check) ((SOCKADDR *) sptr_sockaddr_in, (USHORT) sockaddr_in_length) ==  FAIL))
		{
		socket_class.error_number = ADDRESS_FAMILY_NOT_SUPPORTED_ERROR;

		return (FAILED);
		}

	if (sptr_user_socket->vptr_peer_address != NULL)
		{
		table_free (sptr_user_socket->vptr_peer_address);
		}

	sptr_user_socket->vptr_peer_address = table_malloc (1, (USHORT) sockaddr_in_length);

	if (sptr_user_socket->vptr_peer_address == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: connect (): table_malloc failed\n");
		}

	memcpy ((void *) sptr_user_socket->vptr_peer_address, (void *) sptr_sockaddr_in, (USHORT) sockaddr_in_length);

	sptr_user_socket->peer_address_length = (USHORT) sockaddr_in_length;

	/* a connect routine is optional - don't fail if it isn't present */

	if ((sptr_transport_interface->connect != NULL) && ((*sptr_transport_interface->connect) (sptr_user_socket) == FAIL))
		{
		return (FAILED);
		}

	return (DONE);
}
#endif
int connect (int socket_descriptor, SOCKADDR_IN *sptr_sockaddr_in, int sockaddr_in_length)
{
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;
   

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAILED);
		}

	if (sptr_sockaddr_in == NULL)
		{
		/* Connect must specify a remote address */

		socket_class.error_number = NULL_PEER_ADDRESS;

		return (FAILED);
		}

	if (sockaddr_in_length == 0x00000000L)
		{
		socket_class.error_number = BAD_DATA;

		return (FAILED);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	/* Check name format, if checking routine is available */


	if ((sptr_transport_interface->check != NULL) &&
		((*sptr_transport_interface->check) ((SOCKADDR *) sptr_sockaddr_in, (USHORT) sockaddr_in_length) ==  FAIL))
		{
		socket_class.error_number = ADDRESS_FAMILY_NOT_SUPPORTED_ERROR;

		return (FAILED);
		}

	while ((sptr_user_socket->vptr_protocol_control_block != NULL) && (sptr_user_socket->valid_ready_socket == FALSE))
		{
		if (sptr_user_socket->do_not_block == TRUE)
			{
			socket_class.error_number = WOULD_BLOCK_ERROR;

			return (FAILED);
			}
		else 
			{
			socket_class.error_number = wait_on_socket_event (sptr_user_socket, CONNECTION_REQUEST_EVENT);

			if (socket_class.error_number != PASS)
				{
				return (FAILED);
				}
			}
		}

/* In case the connect call failes, the TCP lib would have set the */
/* valid_ready_socket to CONNECTION_REFUSED_ERROR				   */
/* else sets the value to TRUE									   */

      if (sptr_user_socket->valid_ready_socket == CONNECTION_REFUSED_ERROR) 
		{
         printf ("setting error to cre\n");
			socket_class.error_number = CONNECTION_REFUSED_ERROR;
			return (FAILED);
		}	
	if (sptr_user_socket->valid_ready_socket) 
		{
		sptr_user_socket->valid_ready_socket = FALSE;
		return (PASS);
		}

	if (sptr_user_socket->vptr_peer_address != NULL)
		{
		table_free (sptr_user_socket->vptr_peer_address);
		}

	sptr_user_socket->vptr_peer_address = table_malloc (1, (USHORT) sockaddr_in_length);

	if (sptr_user_socket->vptr_peer_address == NULL)
		{
		socket_printf (SOCKET_ALARM_PRINTF, "SOCKET: connect (): table_malloc failed\n");
		}

	memcpy ((void *) sptr_user_socket->vptr_peer_address, (void *) sptr_sockaddr_in, (USHORT) sockaddr_in_length);

	sptr_user_socket->peer_address_length = (USHORT) sockaddr_in_length;

	/* a connect routine is optional - don't fail if it isn't present */

	if ((sptr_transport_interface->connect != NULL) && ((*sptr_transport_interface->connect) (sptr_user_socket) == FAIL))
		{
		return (FAILED);
		}

	socket_class.error_number = WOULD_BLOCK_ERROR;
	return (FAILED);
}
/*********************************************************************************************/
/*
 * Wait for a connection. Valid only for connection-oriented sockets.
 */
int accept (int socket_descriptor, SOCKADDR *sptr_sockaddr, int *iptr_sockaddr_length)
{
	int local_socket_descriptor;
	USER_SOCKET *sptr_user_socket;
	TRANSPORT_INTERFACE *sptr_transport_interface;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	sptr_user_socket = (USER_SOCKET *) socket_descriptor;

	if (sptr_user_socket == NULL)
		{
		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAILED);
		}

	if (sptr_user_socket->vptr_protocol_control_block == NULL)
		{
		socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;

		return (FAILED);
		}

	sptr_transport_interface = sptr_user_socket->sptr_transport_interface;

	/* Fail if accept flag isn't set */

	if (sptr_transport_interface->accept == FALSE)
		{
		socket_class.error_number = OPERATION_NOT_SUPPORTED_ERROR;

		return (FAILED);
		}

	/* Wait for the connection request received upcall routine to signal us */

	while ((sptr_user_socket->vptr_protocol_control_block != NULL) && (sptr_user_socket->valid_ready_socket == FALSE))
		{
		if (sptr_user_socket->do_not_block == TRUE)
			{
			socket_class.error_number = WOULD_BLOCK_ERROR;

			return (FAILED);
			}
		else 
			{
			socket_class.error_number = wait_on_socket_event (sptr_user_socket, CONNECTION_REQUEST_EVENT);

			if (socket_class.error_number != PASS)
				{
				return (FAILED);
				}
			}
		}

	if (sptr_user_socket->vptr_protocol_control_block == NULL)
		{
		/* Blown away */

		socket_class.error_number = BAD_SOCKET_HANDLE;

		return (FAILED);
		}

	local_socket_descriptor = (int) sptr_user_socket->ready_socket;

	if ((local_socket_descriptor == (int) FAILED) || (local_socket_descriptor == (int) NULL))
		{
		socket_class.error_number = BAD_NEW_SOCKET_HANDLE;

		return (FAILED);
		}

	sptr_user_socket->valid_ready_socket = FALSE;

	sptr_user_socket = (USER_SOCKET *) local_socket_descriptor;

	if ((sptr_sockaddr != NULL) && (iptr_sockaddr_length != NULL))
		{
		if (sptr_user_socket->peer_address_length < *iptr_sockaddr_length)
			{
			*iptr_sockaddr_length = sptr_user_socket->peer_address_length;
			}

		memcpy ((void *) sptr_sockaddr, (void *) sptr_user_socket->vptr_peer_address, (USHORT) *iptr_sockaddr_length);
		}

	return (local_socket_descriptor);
}
/****************************************************************************************/
/*
 * Receive routine, intended for datagram sockets. Can also be used for connection-oriented sockets, although
 * sptr_sockaddr and iptr_sockaddr_length are ignored.
 */
int recvfrom (int socket_descriptor, char *cptr_data, int length, int flags, SOCKADDR *sptr_sockaddr, int *iptr_sockaddr_length)
{
	USHORT count;
	enum TEST error;
	int return_value;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	if (length == 0x00000000L)
		{
		/* Otherwise would be interp as "all" */

		return (DONE);
		}

	if ((length < 0x00000000L) && (length > 0x0000ffffL))
		{
		socket_class.error_number = BAD_LENGTH;

		return (FAILED);
		}

	error = PASS;

	count = socket_receive_data ((ULONG) socket_descriptor, (void *) cptr_data, (USHORT) length, (ULONG) flags, sptr_sockaddr,
		(USHORT *) iptr_sockaddr_length, &error);

	if (error == FAIL)
		{
		return (FAILED);
		}

	return_value = (int) count;

	return (return_value);
}
/****************************************************************************************/
/*
 * High level send routine, intended for datagram sockets. Can be used on connection-oriented sockets, but "sptr_sockaddr" and
 * "address_length" are ignored.
 */
int sendto (int socket_descriptor, char *cptr_data, int length, int flags, SOCKADDR *sptr_sockaddr, int sockaddr_length)
/*
 * Socket index, User buffer, Length of buffer, Unused; will eventually select oob data, etc., Destination, only for datagrams
 * Length of destination
 */
{
	int return_value;
	enum TEST error;

	if (socket_class.enabled == FALSE)
		{
		socket_class.error_number = SOCKET_INTERFACE_NOT_ENABLED;

		return (FAILED);
		}

	if ((length <= 0x00000000L) || (length > 0x0000ffffL))
		{
		socket_class.error_number = BAD_LENGTH;

		return (FAILED);
		}

	error = PASS;

	return_value = (int) socket_send_data ((ULONG) socket_descriptor, (void *) cptr_data, (USHORT) length, (ULONG) flags, sptr_sockaddr,
		(USHORT) sockaddr_length, &error);

	if (error == FAIL)
		{
		return (FAILED);
		}

	return (return_value);
}
