/*	$Modname: vsockadr.h$  $version: 1.2$      $date: 10/10/94$   */
/*
* 	$lgb$
1.0 10/10/94 titus
1.1 10/10/94 titus Initial Version
1.2 10/10/94 titus Added version control header.
* 	$lge$
*/
#/************************************************************************/
#/*	Copyright (C) 1989 - 1991 Router Engines, Inc.								*/
#/*	Unpublished - rights reserved under the Copyright Laws of the			*/
#/*	United States.  Use, duplication, or disclosure by the 					*/
#/*	Government is subject to restrictions as set forth in 					*/
#/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
#/*	Computer Software clause at 252.227-7013.										*/
#/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
#/************************************************************************/
#ifndef _VSOCKADR_H_
#define _VSOCKADR_H_

/*
 * Berkeley format socket address structures. These things were rather poorly thought out, but compatibility is important
 * (or so they say). Note that all the sockaddr variants must be of the same size, 16 bytes to be specific.
 * Note that porters should check each structure.
 */

/* Generic socket address structure */
typedef struct sockaddr
{
	short 	sa_family;
	char 		sa_data[SOCKADDR_DATA_SIZE];
} SOCKADDR;


/* This is a structure for "historical" reasons (whatever they are) */
typedef struct in_addr
{
	ULONG 	s_addr;
} IN_ADDR;


/* Socket address, DARPA Internet style */
typedef struct sockaddr_in
{
	USHORT 	sin_family;
	USHORT	sin_port;
	IN_ADDR 	sin_addr;
	char 		sin_zero[SIN_ZERO_SIZE];
} SOCKADDR_IN;

typedef struct SOCKADDR_IPX
{
	USHORT 	family;
	USHORT	port;
	BYTE		ipx_address[10];
	char 		zero[IPX_ZERO_SIZE];
} SOCKADDR_IPX;

#endif /* _SOCKADDR_H_ */
