#include	"defs.h"
/*
 * $Log: /IP/ARPLIST.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: arplist.c$  $version: 1.4$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 12/27/94 ross
1.1 12/27/94 ross added copyright.
1.2 01/17/95 ross fixed arp problems from snmp
1.3 01/26/95 ross SNMP name change, printf change.
1.4 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stdlib.h>
#include	<stddef.h>
#include "ip.h"
/*************************************************************************/
static void	get_arp_table_entry (ARP_TABLE_ENTRY **ptr_to_sptr_arp_table_entry, enum BOOLEAN *eptr_new_entry_in_table,
	USHORT port_number, ULONG ip_address, enum ARP_TABLE_ENTRY_TYPE type);
static void free_the_packets_waiting_to_be_sent (ARP_TABLE_ENTRY *sptr_arp_table_entry);
static void	build_arp_table_entry (USHORT port_number, ULONG ip_address, MAC_ADDRESS *sptr_mac_address,
	enum ARP_TABLE_ENTRY_TYPE type, ARP_TABLE_ENTRY *sptr_arp_table_entry);
static ARP_TABLE_ENTRY *allocate_arp_table_entry (void);
static void add_sorted_arp_table_entry_to_list (ARP_TABLE_ENTRY_LINK *sptr_arp_table,
	ARP_TABLE_ENTRY *sptr_arp_table_entry_to_add);
/*************************************************************************/
void *add_entry_to_arp_table (USHORT port_number, ULONG ip_address, MAC_ADDRESS *sptr_mac_address,
	enum ARP_TABLE_ENTRY_TYPE type, void *vptr_packet)
{
	ARP_TABLE_ENTRY *sptr_arp_table_entry;
	enum BOOLEAN new_entry_in_table;

	get_arp_table_entry (&sptr_arp_table_entry, &new_entry_in_table, port_number, ip_address, type);

	if (sptr_arp_table_entry != NULL)
	{
		free_the_packets_waiting_to_be_sent (sptr_arp_table_entry);

		build_arp_table_entry (port_number, ip_address, sptr_mac_address, type, sptr_arp_table_entry);

		if ((ip.port[port_number].config.token_ring == TRUE) && (ip.port[port_number].config.rfc1042_enabled == TRUE))
		{
			if (vptr_packet != NULL)
			{
				add_token_ring_rif_to_arp_table_entry (vptr_packet, sptr_arp_table_entry);
			}
		}

	#ifdef __IP_DEBUG__
		ip_printf (ARP_PRINTF, "IP/ARP: entry learned: ip address %s, hardware address [%08lx:%04x], port %u\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], ip_address),
			net_to_host_long (sptr_mac_address->_ulong), net_to_host_short (sptr_mac_address->_ushort), port_number);
	#endif /* __IP__DEBUG__ */

		if (new_entry_in_table == TRUE)
		{
			add_sorted_arp_table_entry_to_list ((ARP_TABLE_ENTRY_LINK *) &ip.arp.port[port_number].current_list,
				sptr_arp_table_entry);
		}
	}

	return (sptr_arp_table_entry);
}
/*************************************************************************/
static void	get_arp_table_entry (ARP_TABLE_ENTRY **ptr_to_sptr_arp_table_entry, enum BOOLEAN *eptr_new_entry_in_table,
	USHORT port_number, ULONG ip_address, enum ARP_TABLE_ENTRY_TYPE type)
{
	if (type == INVALID_ARP_ENTRY)
	{
		*ptr_to_sptr_arp_table_entry = find_arp_table_entry_on_port (port_number, ip_address, FALSE);
	}
	else
	{
		*ptr_to_sptr_arp_table_entry = find_arp_table_entry_on_port (port_number, ip_address, TRUE);
	}

	if (*ptr_to_sptr_arp_table_entry == NULL)
	{
		*eptr_new_entry_in_table = TRUE;

		*ptr_to_sptr_arp_table_entry = allocate_arp_table_entry ();
	}
	else
	{
		*eptr_new_entry_in_table = FALSE;
	}
}
/*************************************************************************/
ARP_TABLE_ENTRY *find_arp_table_entry_on_port (USHORT port_number, ULONG ip_address, enum BOOLEAN valid)
{
	ARP_TABLE_ENTRY *sptr_arp_table_entry;
	
	/* if ((ip.port[port_number].config.port_enabled == TRUE) && (ip.port[port_number].config.arp_enabled == TRUE)) */
	/*
		Sachin made this change to get this working for RAS
		wherein ARP is disabled for PPP ports, but ARP table
		has entries for them. 23/07/1996
	*/
	if (ip.port[port_number].config.port_enabled == TRUE)
	{
		for (sptr_arp_table_entry = ip.arp.port[port_number].current_list.sptr_forward_link;
			sptr_arp_table_entry != NULL; sptr_arp_table_entry = sptr_arp_table_entry->links.sptr_forward_link)
			{
			if (sptr_arp_table_entry->ip_address == ip_address)
				{
				if ((valid == TRUE) && (sptr_arp_table_entry->type != INVALID_ARP_ENTRY))
				{
					return (sptr_arp_table_entry);
				}
				else if (valid == FALSE)
				{
					return (sptr_arp_table_entry);
				}
			}
		}
	}

	return (NULL);
}
/*************************************************************************/
static ARP_TABLE_ENTRY *allocate_arp_table_entry (void)
{
	ARP_TABLE_ENTRY *sptr_arp_table_entry;

	sptr_arp_table_entry = table_malloc (1, sizeof (ARP_TABLE_ENTRY));

	if (sptr_arp_table_entry == NULL)
		{
		ip_printf (IP_ALARM_PRINTF, "IP/ARP: table_malloc failed\n");

		return (NULL);
		}

	return (sptr_arp_table_entry);
}
/*************************************************************************/
static void free_the_packets_waiting_to_be_sent (ARP_TABLE_ENTRY *sptr_arp_table_entry)
{
	UNION_IP_PACKET_LIST_ELEMENT *sptr_ip_packet_element;

	sptr_ip_packet_element = (UNION_IP_PACKET_LIST_ELEMENT *) get_entry_from_list ((LINK *)
		&sptr_arp_table_entry->list_of_packets_waiting_to_be_sent);

	while (sptr_ip_packet_element != NULL)
		{
		if (sptr_ip_packet_element->sptr_packet_waiting_to_send != NULL)
			{
			sptr_ip_packet_element->sptr_packet_waiting_to_send = normalize_ip_send_packet_header (
				sptr_arp_table_entry->port_number, sptr_ip_packet_element->sptr_packet_waiting_to_send);

			free_an_ip_send_packet (sptr_arp_table_entry->port_number, sptr_ip_packet_element->sptr_packet_waiting_to_send);

			++ip.arp.statistics.total_number_of_pending_packets_discarded; 
			}

		sptr_ip_packet_element = (UNION_IP_PACKET_LIST_ELEMENT *) get_entry_from_list ((LINK *)
			&sptr_arp_table_entry->list_of_packets_waiting_to_be_sent);
		}
}
/*************************************************************************/
static void	build_arp_table_entry (USHORT port_number, ULONG ip_address, MAC_ADDRESS *sptr_mac_address,
	enum ARP_TABLE_ENTRY_TYPE type, ARP_TABLE_ENTRY *sptr_arp_table_entry)
{
	sptr_arp_table_entry->hardware_address = *sptr_mac_address;
	sptr_arp_table_entry->port_number = port_number;
	sptr_arp_table_entry->list_of_packets_waiting_to_be_sent.sptr_forward_link = NULL;
	sptr_arp_table_entry->list_of_packets_waiting_to_be_sent.sptr_backward_link = NULL;
	sptr_arp_table_entry->timer = 0x0000;
	sptr_arp_table_entry->ip_address = ip_address;
	sptr_arp_table_entry->type = (BYTE_ENUM (ARP_TABLE_ENTRY_TYPE)) type;
}
/*************************************************************************/
static void add_sorted_arp_table_entry_to_list (ARP_TABLE_ENTRY_LINK *sptr_arp_table,
	ARP_TABLE_ENTRY *sptr_arp_table_entry_to_add)
{
	LINKED_LIST_SORT_PARAMETERS linked_list_sort_parameters;

	linked_list_sort_parameters.sptr_list = (LINK *) sptr_arp_table;
	linked_list_sort_parameters.sptr_entry_to_add = (LINK *) sptr_arp_table_entry_to_add;

	linked_list_sort_parameters.index[0].offset = offsetof (ARP_TABLE_ENTRY, ip_address);
	linked_list_sort_parameters.index[0].size = sizeof (ULONG);
	linked_list_sort_parameters.index[0]._swap = TRUE;

	linked_list_sort_parameters.index[1].size = 0x0000;

	add_entry_to_sorted_linked_list (&linked_list_sort_parameters);
}
/*************************************************************************/
ARP_TABLE_ENTRY *find_arp_table_entry (USHORT port_number, ULONG ip_address, enum BOOLEAN valid)
{
	USHORT skip_port_number;
	ARP_TABLE_ENTRY *sptr_arp_table_entry;

	skip_port_number = NO_SUCH_PORT;

	if ((port_number != NO_SUCH_PORT) && (port_number < ip.number_of_ports))
	{
		if ((ip.port[port_number].config.port_enabled == TRUE) && (ip.port[port_number].config.arp_enabled == TRUE))
		{
			sptr_arp_table_entry = find_arp_table_entry_on_port (port_number, ip_address, valid);

			if (sptr_arp_table_entry != NULL)
			{
				return (sptr_arp_table_entry);
			}
		}

		skip_port_number = port_number;
	}

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
	{
		if (port_number == skip_port_number)
		{
			continue;
		}

		if ((ip.port[port_number].config.port_enabled == TRUE) && (ip.port[port_number].config.arp_enabled == TRUE))
		{
			sptr_arp_table_entry = find_arp_table_entry_on_port (port_number, ip_address, valid);

			if (sptr_arp_table_entry != NULL)
			{
				return (sptr_arp_table_entry);
			}
		}
	}

	return (NULL);
}
/*************************************************************************/
void delete_arp_table_entry (ARP_TABLE_ENTRY *sptr_arp_table_entry)
{
	free_the_packets_waiting_to_be_sent (sptr_arp_table_entry);

	sptr_arp_table_entry = find_arp_table_entry_on_port (sptr_arp_table_entry->port_number,
		sptr_arp_table_entry->ip_address, FALSE);

	delete_entry_from_list ((LINK *) &ip.arp.port[sptr_arp_table_entry->port_number].current_list,
		(LINK *) &sptr_arp_table_entry->links);

#ifdef __IP_DEBUG__
	ip_printf (IP_MEMORY_PRINTF, "IP: freeing arp table entry %p\n", sptr_arp_table_entry);
#endif /* __IP__DEBUG__ */

	table_free (sptr_arp_table_entry);
}
/*************************************************************************/
void delete_arp_table_entry_using_ip_address (USHORT port_number, ULONG ip_address)
{
	ARP_TABLE_ENTRY *sptr_arp_table_entry;

	for (sptr_arp_table_entry = ip.arp.port[port_number].current_list.sptr_forward_link;
		sptr_arp_table_entry != NULL;
		sptr_arp_table_entry = sptr_arp_table_entry->links.sptr_forward_link)
		{
		if (sptr_arp_table_entry->ip_address == ip_address)
			{
			if (ip.arp.port[port_number].sptr_cached_arp_entry == sptr_arp_table_entry)
				{
				ip.arp.port[port_number].sptr_cached_arp_entry = NULL;
				}

			delete_arp_table_entry (sptr_arp_table_entry);

			break;
			}
		}
}
/*************************************************************************/
void free_ip_arp_entries (void)
{
	USHORT port_number;
	ARP_TABLE_ENTRY *sptr_arp_table_entry;
	ARP_TABLE_ENTRY *sptr_next_arp_table_entry;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if ((ip.port[port_number].config.port_enabled == TRUE) && (ip.port[port_number].config.arp_enabled == TRUE))
			{
			for (sptr_arp_table_entry = ip.arp.port[port_number].current_list.sptr_forward_link;
				sptr_arp_table_entry != NULL;)
				{
				sptr_next_arp_table_entry = (ARP_TABLE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_arp_table_entry);

				delete_arp_table_entry (sptr_arp_table_entry);

				sptr_arp_table_entry = sptr_next_arp_table_entry;
				}

			ip.arp.port[port_number].sptr_cached_arp_entry = NULL;
			}
		}
}

