
/* Sudha for auto detection of proxy in the same lan thru UDP broadcast
& to change its ip address to the required one thru UDP broadcast again. */

#include "ip.h"
#include "detip.h"
#include "kdetip.h"
#include "detipstr.h"

#include "..\..\store\boot.h"

extern ULONG get_ip_address(USHORT port_number);
/*  Local  Prototypes   */
enum TEST initialize_proxy_server_discovery (ULONG clock_ticks_per_second);
enum TEST initialize_proxy_server_discovery_socket_interface(void);
enum TEST register_proxy_server_discovery(void);
enum TEST proxy_server_discovery_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
extern void proxy_server_discovery_timer();
void get_mac_address_of_proxy_server (void);

BYTE mac_address[MAX_MAC_ADDRESS_LENGTH+1];
extern char ethernet_address[8];

PROXY_SERVER_DISCOVERY_CLASS proxy_server_discovery;

enum TEST initialize_proxy_server_discovery (ULONG clock_ticks_per_second)
{
  /* printf("/nDetip:entering initialise proxy server discovery");*/
	proxy_server_discovery.enabled = TRUE;
	proxy_server_discovery.socket_interface_enabled = TRUE;
   
	if ( register_proxy_server_discovery() == FAIL )
   {
      printf("IP: ProxyServer discovery failed to register properly \n\r");
		return (FAIL);
   }
	
	if (initialize_proxy_server_discovery_socket_interface() == FAIL)
	{  
		printf("\n detip:initialize_proxy_server_discovery_socket_interface() == FAIL" );
		return (FAIL);
	}
	get_mac_address_of_proxy_server();
	return (PASS);
}

enum TEST initialize_proxy_server_discovery_socket_interface (void)
{
	SOCKADDR_IN local_read_sockaddr_in;
  /*	printf("\ndetip:entering initialize_proxy_server_discovery_socket_interface");*/
	if ( proxy_server_discovery.socket_interface_enabled  == FALSE )
	{	
		printf("\n detip:proxy_server_discovery.socket_interface_enabled  == FALSE ");
		return (FAIL);
	}	
	proxy_server_discovery.local_internet_address = get_ip_address(0);

	proxy_server_discovery.socket = socket (AF_INET, SOCK_DGRAM ,0L);

	if (proxy_server_discovery.socket == FAILED) 
	{	
		printf("\ndetip:proxy_server_discovery.socket == FAILED ");
		return (FAIL);
	}
	associate_application_with_socket (proxy_server_discovery.socket, proxy_server_discovery.application_id);

	/* initialize local sockaddr_in structure */
	local_read_sockaddr_in.sin_family      = AF_INET;    /* "Internet" Address Family */
	local_read_sockaddr_in.sin_addr.s_addr = 0;  /* since this is a broadcast */
/*	local_read_sockaddr_in.sin_addr.s_addr = proxy_server_discovery.local_internet_address; */
	local_read_sockaddr_in.sin_port = IPPORT_DISCOVER_PROXY_SERVER;

	/* bind local ip address & port number to the socket */
	if (bind (proxy_server_discovery.socket, (SOCKADDR *)&local_read_sockaddr_in, sizeof(SOCKADDR_IN)) == FAILED) 
	{
		closesocket(proxy_server_discovery.socket);
	  	printf("\ndetip:binding is failed ");
		return (FAIL);
	}
		
	proxy_server_discovery.socket_interface_initialized = TRUE;
	return (PASS);
}

enum TEST register_proxy_server_discovery (void)
{
  /*	printf("\ndetip:entering register_proxy_server_discovery");*/
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "Proxy Server Discovery", 
		PROXY_SERVER_DISCOVERY_APPLICATION, proxy_server_discovery_timer, proxy_server_discovery_control, &proxy_server_discovery.application_id) == FAIL)
	{
		printf("\ndetip:lsl_control failed");
		return (FAIL);
	}
	return (PASS);
}

enum TEST proxy_server_discovery_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
  /*	printf("\ndetip:entering proxy_server_discovery_control");*/
/*
	switch (command)
	{
		case START_APPLICATION:
			break;
		case TERMINATE_APPLICATION:
         break;
		case READ_DATA_FROM_SOCKET:
			break;
		case IS_APPLICATION_ENABLED:
			*((enum BOOLEAN *) parameter_1) = (enum BOOLEAN ) proxy_server_discovery.enabled;
			break;
	}
*/
	return (PASS);
}

void get_mac_address_of_proxy_server()
{
 	int index ;
	BYTE temp_string[4];

	mac_address[0] = 0;
  /*	printf("\ndetip:Entering get mac address");*/
	for (index = 0; index < 6; index++)
	{
		sprintf(temp_string,"%02X",ethernet_address[index]);
		strcat(mac_address,temp_string);		
	}
}

