/*--------------------------------------------------------------------------*\

Changes History : 

{sudha 12-Feb-2000. initialize_dns(), initialize_cache() functions - for 
	DNS memory leakage problem}

\*--------------------------------------------------------------------------*/

#include "dns.h" 
#include "ip.h"
#include "kdns.h"
#include "vdnsstr.h"


extern DNS_CLASS dns;
extern QUERY_INFORMATION query_info[MAX_WAN_PORTS];
extern DNS_LOCAL_CACHE dns_cache[MAX_NUMBER_OF_CACHE];
extern DNS_REPLY_CACHE dns_cache_entry[MAX_NUMBER_OF_CACHE];

/* sudha 12-Feb-2000. For DNS memory leakage problem */
extern RESOURCE_REC *ans_rr[MAX_WAN_PORTS], *auth_rr[MAX_WAN_PORTS], *add_rr[MAX_WAN_PORTS];

extern ULONG str_to_net (BYTE *);
extern BYTE *net_to_str (BYTE *Addr, ULONG Address);
enum TEST initialize_cache ();

extern int ip_addr_rcvd[MAX_WAN_PORTS];

/* sudhir 13/5/97 */
extern BYTE resolve_cname[MAX_WAN_PORTS];
extern void update_dns_server_address_in_dhcp_address_list (server_address);

/* sudha 20 Nov 1998 */
void 	update_dns_server_address_in_resolver (ULONG primary_server_address,
		ULONG secondary_server_address);

void initialize_reference_info_from_sbelt (USHORT port_number)
{
	BYTE temp_ptr1[25],temp_ptr2[25];

	net_to_str (temp_ptr1, dns.config.s_belt.dns_ip_addr1);
	net_to_str (temp_ptr2, dns.config.s_belt.dns_ip_addr2);

/*
sudhir, may 2nd 1997
*/
	if (dns.config.s_belt.dns_ip_addr1 != 0x00000000L)
		query_info[port_number].reference_info[query_info[port_number].no_of_ns++].Serveraddr = dns.config.s_belt.dns_ip_addr1;
   	if (dns.config.s_belt.dns_ip_addr2 != 0x00000000L)
		query_info[port_number].reference_info[query_info[port_number].no_of_ns].Serveraddr = dns.config.s_belt.dns_ip_addr2;
}

enum TEST initialize_dns (void)
{
	USHORT i =0;

	if (dns.enabled == FALSE)
		return (PASS);
	/* to be modified later */
	dns.config.s_belt.dns_ip_addr1 = str_to_net (dns.config.s_belt.temp_dns_ip_addr1);
	dns.config.s_belt.dns_ip_addr2 = str_to_net (dns.config.s_belt.temp_dns_ip_addr2);

	if (dns.config.s_belt.dns_ip_addr1)
	{
		printf ("DNS: Updating DNS primary Server address in DHCP Info\n");
		update_dns_server_address_in_dhcp_address_list (dns.config.s_belt.dns_ip_addr1);
	}
	else if (dns.config.s_belt.dns_ip_addr2)
	{
		printf ("DNS: Updating DNS secondary Server address in DHCP Info\n");
		update_dns_server_address_in_dhcp_address_list (dns.config.s_belt.dns_ip_addr2);
	}

#if 0
	dns.enabled = TRUE;


	dns.config.max_timeout = 45;
	dns.config.min_timeout = 4;
	dns.index_of_cache = 0;

/*   dns.config.dns_server_ip_address = str_to_net (ip_address);  */
	dns.config.max_references = 20;
   
	dns.index_of_cache = 0;
#endif

	for ( i = 0; i < MAX_WAN_PORTS ; i++)
	{
		dns.port[i].in_use = FALSE;
		dns.port[i].time_counter = 0;
		dns.port[i].dns_state = IDLE;
		dns.port[i].server_ip_address = 0;  /*str_to_net (ip_address); */
		dns.port[i].number_of_retries = 0;
		dns.port[i].current_timer_value = dns.config.min_timeout;
		dns.port[i].fptr_complete_routine = NULL;
/*
sudhir, 30th April 1997
*/
		dns.port[i].rcvd_buff_len = 0;
		dns.port[i].rcvd_buff_index = 0;

		query_info[i].S_TYPE = 0;
		query_info[i].S_CLASS = 0;
		query_info[i].match_count = 0;
		query_info[i].num_of_referals = 0;
		query_info[i].identifier = 0;
		query_info[i].index_of_ref_info = 0;
		query_info[i].no_of_ns = 0;
		initialize_reference_info_from_sbelt (i);
		ip_addr_rcvd[i] = 0;

/* sudhir 13/5/97 */
		resolve_cname[i] = 0;

/* sudha 12-Feb-2000. For DNS memory leakage problem ... */
		ans_rr[i] = NULL;
		auth_rr[i] = NULL;
		add_rr[i] = NULL;
/* ... sudha 12-Feb-2000. For DNS memory leakage problem */
	}

/* sudha 05-Nov-1999... */
   dns.no_of_connections = 0; 
/* ...sudha 05-Nov-1999 */

	if (initialize_cache () == FAIL)
	{
		printf("DNS: Cache init failed\n");
		return FAIL;
	}

/* above portion can be removed after adding the parameters in roucon */
	
	return PASS;

}


enum TEST initialize_cache ()
{
	USHORT i=0;

	for (i = 0; i < MAX_NUMBER_OF_CACHE; i++)
	{
		dns_cache[i].match_count = 0;
		dns_cache[i].in_use = FALSE;
		dns_cache[i].resource_rec = (RESOURCE_REC *)malloc (sizeof (RESOURCE_REC));
		if (dns_cache[i].resource_rec == NULL)
		{
			printf("DNS: Memory alloc failed\n");
			return FAIL;
		}

/* sudha 14 sep 1998 */
		dns_cache_entry[i].in_use = FALSE;
/* sudha 12-Feb-2000. For DNS memory leakage problem ... */
		dns_cache_entry[i].send_quest = NULL;
		dns_cache_entry[i].rr_min_ttl = 0;
		dns_cache_entry[i].data_len = 0;
		dns_cache_entry[i].reply_pkt = NULL;
/* ... sudha 12-Feb-2000. For DNS memory leakage problem */
	}
	return PASS;
}


void 	update_dns_server_address_in_resolver (ULONG primary_server_address,
		ULONG secondary_server_address)
{
	USHORT port_number=0;

	for (port_number = 0; port_number < MAX_WAN_PORTS ; port_number++)
	{
		if (primary_server_address!= 0x00000000L)
			query_info[port_number].reference_info[query_info[port_number].no_of_ns++].Serveraddr = primary_server_address;
	  	if (secondary_server_address != 0x00000000L)
			query_info[port_number].reference_info[query_info[port_number].no_of_ns].Serveraddr = secondary_server_address;
	}
	printf ("Updated address for all ports\n");
}

