/*--------------------------------------------------------------------------*\

Changes History : 

{sudha 12-Feb-2000. get_dns_header_from_rxed_packet(), resolve_domain_name(), 
	received_dns_packet(), allocate_buffers_and_copy_RRs(), 
	copy_all_RRs_from_recv_buffer() functions - for DNS memory leakage problem} 

\*--------------------------------------------------------------------------*/

#include "dns.h"
#include "ip.h"
#include "kdns.h"
#include "vdnsstr.h"

#include <string.h>

#define MAXIMUM_DOMAIN_LENGTH 255
 
extern USHORT net_to_host_short (USHORT);
extern int toupper (int);
extern int strcmpi (char *, char *);

extern DNS_CLASS dns;
extern QUERY_INFORMATION query_info[MAX_WAN_PORTS];
extern SEND_PACKET *pkt_to_send[MAX_WAN_PORTS];
extern RESOURCE_REC *ans_rr[MAX_WAN_PORTS], *auth_rr[MAX_WAN_PORTS], *add_rr[MAX_WAN_PORTS];
extern DNS_LOCAL_CACHE dns_cache[MAX_NUMBER_OF_CACHE];
enum BOOLEAN validate_dns_response_packet (HEADER *dns_header, BYTE *rcvd_buff, USHORT port_number);
USHORT get_domain_name_length (BYTE *input_buff, BYTE *ptr_to_name);

extern DNS_REPLY_CACHE dns_cache_entry[MAX_NUMBER_OF_CACHE] ;
extern ULONG min_ttl_value ;

/* sudhir 13/5/97 */
BYTE resolve_cname[MAX_WAN_PORTS];

void dns_hdr_ntoh (HEADER *sptr_new_hdr, HEADER *sptr_old_hdr)
{
   sptr_new_hdr->send_id = net_to_host_short (sptr_old_hdr->send_id);
   sptr_new_hdr->ctrl_fld= net_to_host_short (sptr_old_hdr->ctrl_fld);
   sptr_new_hdr->qdcnt   = net_to_host_short (sptr_old_hdr->qdcnt);
   sptr_new_hdr->ancnt   = net_to_host_short (sptr_old_hdr->ancnt);
   sptr_new_hdr->nscnt   = net_to_host_short (sptr_old_hdr->nscnt);
   sptr_new_hdr->arcnt   = net_to_host_short (sptr_old_hdr->arcnt);
}

void free_allocated_buffers (HEADER *dns_hdr_type, USHORT port_number)
{
   USHORT i=0;
   RESOURCE_REC *ptr_to_rr;

   if (ans_rr[port_number])
   {
	ptr_to_rr = ans_rr[port_number];
	for (i = 0; i < dns_hdr_type->ancnt; i++,ptr_to_rr++)
	{
		if (ptr_to_rr->re_name)
		{
		    free(ptr_to_rr->re_name);
/* sudha 05-Nov-1999... */
		    ptr_to_rr->re_name = NULL;
/* ...sudha 05-Nov-1999 */
		}
		if (ptr_to_rr->re_rdata)
		{
		    free(ptr_to_rr->re_rdata);
/* sudha 05-Nov-1999... */
		    ptr_to_rr->re_rdata = NULL;
/* ...sudha 05-Nov-1999 */
		}
	}
	free(ans_rr[port_number]);
	ans_rr[port_number] = NULL;
   }
   if (auth_rr[port_number])
   {
	ptr_to_rr = auth_rr[port_number];
	for (i = 0; i < dns_hdr_type->nscnt; i++,ptr_to_rr++)
	{
		if (ptr_to_rr->re_name)
		{
		    free(ptr_to_rr->re_name);
/* sudha 05-Nov-1999... */
		    ptr_to_rr->re_name = NULL;
/* ...sudha 05-Nov-1999 */
		}
		if (ptr_to_rr->re_rdata)
		{
		    free(ptr_to_rr->re_rdata);
/* sudha 05-Nov-1999... */
		    ptr_to_rr->re_rdata = NULL;
/* ...sudha 05-Nov-1999 */
		}
	}
	free(auth_rr[port_number]);
	auth_rr[port_number] = NULL;
   }
   if (add_rr[port_number])
   {
	ptr_to_rr = add_rr[port_number];
	for (i = 0; i < dns_hdr_type->arcnt; i++,ptr_to_rr++)
	{
		if (ptr_to_rr->re_name)
		{
		    free(ptr_to_rr->re_name);
/* sudha 05-Nov-1999... */
		    ptr_to_rr->re_name = NULL;
/* ...sudha 05-Nov-1999 */
		}
		if (ptr_to_rr->re_rdata)
		{
		    free(ptr_to_rr->re_rdata);
/* sudha 05-Nov-1999... */
		    ptr_to_rr->re_rdata = NULL;
/* ...sudha 05-Nov-1999 */
		}
	}
	free(add_rr[port_number]);
	add_rr[port_number] = NULL;
   }
}


HEADER *get_dns_header_from_rxed_packet (BYTE *in_buff)
{
   BYTE *temp_buff;
   HEADER *ptr_to_dns_hdr, *temp_hdr_ptr;

/* sudha 12-Feb-2000. For DNS memory leakage problem. */
/* Typecasted to (BYTE *) */
   temp_buff = (BYTE *) malloc (sizeof(HEADER));
   if (temp_buff == NULL)
   {
		printf("DNS: Malloc failed in receive\n");
/* sudha 12-Feb-2000. For DNS memory leakage problem. */
/* "return 0" changed to "return NULL" */
		return NULL;
   }

/* sudha 12-Feb-2000. For DNS memory leakage problem. */
/* Typecasted to (HEADER *) */
   ptr_to_dns_hdr = (HEADER *) malloc (sizeof (HEADER));
   if (ptr_to_dns_hdr == NULL)
   {
		free (temp_buff);
		printf("DNS: Malloc failed in receive\n");
/* sudha 12-Feb-2000. For DNS memory leakage problem. */
/* "return 0" changed to "return NULL" */
		return NULL;
   }

   memcpy (temp_buff, in_buff, sizeof (HEADER)); 
   temp_hdr_ptr = (HEADER *) temp_buff;

   dns_hdr_ntoh (ptr_to_dns_hdr, temp_hdr_ptr);  
   free (temp_buff);

   return ptr_to_dns_hdr;
}

ULONG resolve_domain_name (USHORT port_number, BYTE *rcvd_buf, HEADER *dns_hdr_type)
{
   USHORT proxy_dns_quest_len = 0 ;
	ULONG ip_address;
	
   /* Allocate memory for all the rrs in reply pkt */
   if (allocate_buffers_and_copy_rrs (dns_hdr_type, rcvd_buf,port_number, proxy_dns_quest_len ) == FAIL)
   {
		printf("DNS: Malloc failed for rrs\n");
/* sudha 12-Feb-2000. For DNS memory leakage problem */
   	free_allocated_buffers (dns_hdr_type, port_number);
		return 0;
   }

   ip_address = get_ip_address_from_rr_if_any (ans_rr[port_number], dns_hdr_type->ancnt, port_number );  

   if (ip_address != 0)
   {
      dns.port[port_number].dns_state = RESOLVED;
/*	Here give the control to app which called dns */
      free_allocated_buffers (dns_hdr_type, port_number);
      return ip_address;
   }
   return 0;
}

ULONG process_rrs_and_forward (USHORT port_number, BYTE *rcvd_buf, HEADER *dns_hdr_type)
{
   USHORT is_cname=0;
   ULONG ip_addr;
   BYTE cname_buff[255];

   is_cname = check_for_cname_in_ans_section (ans_rr[port_number],dns_hdr_type->ancnt,cname_buff);
   if (is_cname)
   {
/*
sudhir 1st may 1997
*/
      strcpy (query_info[port_number].S_NAME, cname_buff);
/*
sudhir , 30th April 1997
*/
/*
sudhir 13/5/97
*/
      resolve_cname[port_number] = 1;

      ip_addr = resolve_with_cname (cname_buff, dns_hdr_type, port_number);

/*
sudhir 13/5/97
*/
      resolve_cname[port_number] = 0;

      if (ip_addr)
         return ip_addr;
      else
/*
sudhir 1st may 1997
*/
         return 0;
   }
   else
   {
/*
sudhir 1st may 1997. This is just for testing. We will not be supporting
iterative servers at this moment of time. Remove the return 0 after the
test.
*/
      return 0;
      locate_name_server_and_resolve (query_info[port_number].S_NAME, dns_hdr_type, port_number);
   }
/*
Sudhir 2nd May 1997
   free (cname_buff);
*/
   return 0;
}


ULONG received_dns_packet (BYTE *rcvd_buf, USHORT rcvd_len, USHORT port_number)
{  
   HEADER *dns_hdr_type;
   ULONG ip_address;

   dns_hdr_type = get_dns_header_from_rxed_packet (rcvd_buf);
   if (dns_hdr_type == NULL)
      return 0;

   
#ifdef DEBUG
   printf ("ID %d\n",dns_hdr_type->send_id);
   printf ("CTL %d\n",dns_hdr_type->ctrl_fld);
   printf ("QDCNT %d\n",dns_hdr_type->qdcnt);
   printf ("ANCNT %d\n",dns_hdr_type->ancnt);
   printf ("NSCNT %d\n",dns_hdr_type->nscnt);
   printf ("ARCNT %d\n",dns_hdr_type->arcnt);
#endif 

   /* compare the first two bytes with id */
   if (dns_hdr_type->send_id != pkt_to_send[port_number]->send_hdr.send_id)
   {
/*
sudhir may 2nd 1997
*/
      free (dns_hdr_type);
      dns.port[port_number].dns_state = READY_TO_RECV;
      return 0;
   }

   /* check the first bit of 3rd byte for qr */
   if (!CHECK_IF_RESPONSE_PKT (dns_hdr_type))
   {
/*
sudhir may 2nd 1997
*/
	   free (dns_hdr_type);
/*   	printf("DNS: Not a response packet\n"); */
     	dns.port[port_number].dns_state = READY_TO_RECV;
     	return 0;
   }

   /* check RCODE for error returns */

   if (!CHECK_IF_ERROR_PKT (dns_hdr_type))
   {
/* sudhir 19/9/97 */
      if (validate_dns_response_packet (dns_hdr_type, rcvd_buf, port_number) == FALSE)
   	{
	      printf("DNS: Incomplete response from server\n");
/* sudha 12-Feb-2000. For DNS memory leakage problem */   
		   free (dns_hdr_type);
		   return 0;	
   	}

      ip_address = resolve_domain_name (port_number, rcvd_buf, dns_hdr_type); 
      if (ip_address != 0)
		{
/* sudha 12-Feb-2000. For DNS memory leakage problem */   
		   free (dns_hdr_type);
         return ip_address;
		}
      else
      {
         if (CHECK_IF_REC_ALLOWED (dns_hdr_type))
         {
/* sudhir , 30th April 1997 */
            ip_address = process_rrs_and_forward (port_number, rcvd_buf, dns_hdr_type);
            if (ip_address != 0)
				{
/* sudha 12-Feb-2000. For DNS memory leakage problem */   
				   free (dns_hdr_type);
               return ip_address;
				}
	         else
      	   {
/* sudhir may 2nd 1997 */
        	      dns.port[port_number].dns_state = RESOLVE_ERR;
/* sudha 12-Feb-2000. For DNS memory leakage problem */   
				   free (dns_hdr_type);
      		   return 0;
	         }
         }
         else
			{
/* sudhir , 30th April 1997 */
            ip_address = process_rrs_and_forward (port_number, rcvd_buf, dns_hdr_type);
            if (ip_address != 0)
				{
/* sudha 12-Feb-2000. For DNS memory leakage problem */   
				   free (dns_hdr_type);
               return ip_address;
				}
	         else
      	   {
/* sudhir may 2nd 1997 */
        	      dns.port[port_number].dns_state = RESOLVE_ERR;
/* sudha 12-Feb-2000. For DNS memory leakage problem */   
				   free (dns_hdr_type);
      		   return 0;
	         }
			}
      }
   }
   else
   {
/* sudhir may 2nd 1997 */
      free (dns_hdr_type);
      dns.port[port_number].dns_state = RESOLVE_ERR;
   }

/* sudha 12-Feb-2000. For DNS memory leakage problem */   
   free (dns_hdr_type);
	return 0;
}



enum TEST allocate_buffers_and_copy_rrs (HEADER *dns_hdr_type, BYTE *rcvd_buf, USHORT port_number, USHORT proxy_dns_quest_len )
{
   BYTE *sptr_resource_rec = NULL, *rcvd_value = NULL;
   RESOURCE_REC *temp_ptr = NULL;
   USHORT rrs_copied = 0;
   
   rcvd_value = rcvd_buf;

	if (proxy_dns_quest_len == 0)
		min_ttl_value = 1; 
	else
		min_ttl_value = 0x0e10 ; /* global used in dnsresp.c to find out 
the min ttl value of all rrs in the dns response pkt. */

   if (dns_hdr_type->ancnt > 0)
   {
      temp_ptr = (RESOURCE_REC *) calloc (dns_hdr_type->ancnt, sizeof (RESOURCE_REC));
      ans_rr[port_number] = temp_ptr;
      if (ans_rr[port_number] == NULL)
      {
         dns_hdr_type->ancnt = 0;    
         return FAIL;
      }

      rcvd_value = copy_all_RRs_from_recv_buffer (temp_ptr, rcvd_buf, dns_hdr_type->ancnt, sptr_resource_rec, port_number, &rrs_copied, proxy_dns_quest_len);
      if (rcvd_value == NULL)
      {
         dns_hdr_type->ancnt = rrs_copied;         
         dns_hdr_type->nscnt = 0;
         dns_hdr_type->arcnt = 0;
         rrs_copied = 0;
         return PASS;
      }

       sptr_resource_rec = rcvd_value;
   }

   if (dns_hdr_type->nscnt > 0)
   {
      temp_ptr = (RESOURCE_REC *) calloc (dns_hdr_type->nscnt, sizeof (RESOURCE_REC));
      auth_rr[port_number] = temp_ptr;
      if (auth_rr[port_number] == NULL)
      {
         dns_hdr_type->nscnt = 0;    
/* sudha 12-Feb-2000. For DNS memory leakage problem */
         dns_hdr_type->arcnt = 0;    
         return FAIL;
      }

      rcvd_value = copy_all_RRs_from_recv_buffer (temp_ptr, rcvd_buf, dns_hdr_type->nscnt, sptr_resource_rec, port_number,&rrs_copied, proxy_dns_quest_len );
      if (rcvd_value == NULL)
      {
         dns_hdr_type->nscnt = rrs_copied;
         dns_hdr_type->arcnt = 0;
         rrs_copied = 0;
         return PASS;
      }
      sptr_resource_rec = rcvd_value;
   }

   if (dns_hdr_type->arcnt > 0)
   {
      temp_ptr = (RESOURCE_REC *) calloc (dns_hdr_type->arcnt, sizeof (RESOURCE_REC));
      add_rr[port_number] = temp_ptr;
      if (add_rr[port_number] == NULL)
      {
         dns_hdr_type->arcnt = 0;    
         return FAIL;
      }

      rcvd_value = copy_all_RRs_from_recv_buffer (temp_ptr, rcvd_buf, dns_hdr_type->arcnt, sptr_resource_rec, port_number,&rrs_copied, proxy_dns_quest_len );
      if (rcvd_value == NULL)
      {
         dns_hdr_type->arcnt = rrs_copied;
         return PASS;
      }
   }
   return PASS;
}


BYTE *copy_all_RRs_from_recv_buffer (RESOURCE_REC *dest_rr, BYTE *input_buff, USHORT count, BYTE *ptr_to_next_sec, USHORT port_number, USHORT *no_of_rrs_copied, USHORT proxy_dns_quest_len )
{
   BYTE *ptr_to_rr = NULL, *ptr_to_qname = NULL;
   USHORT i = 0, name_len = 0, offset = 0, offset_of_next_fld = 0, copied_count = 0;
   BYTE *temp_buff = NULL;
   RESOURCE_REC *ptr_to_dest_rr = NULL;
  
   *no_of_rrs_copied = 0;

   if (dest_rr == NULL)
      return NULL;

   ptr_to_dest_rr = dest_rr;

   if (ptr_to_next_sec == NULL)
   {
		if (proxy_dns_quest_len == 0)
	      offset = sizeof (HEADER) + strlen (pkt_to_send[port_number]->send_quest) 
						+ 1 + (2 * sizeof (USHORT));
		else
	      offset = sizeof (HEADER) + proxy_dns_quest_len + 1 + (2 * sizeof (USHORT));

      ptr_to_rr = (BYTE *)(input_buff + (ULONG) offset);
      ptr_to_next_sec = ptr_to_rr;

		if ( proxy_dns_quest_len == 0 )
	      dns.port[port_number].rcvd_buff_index += offset;
   }

   temp_buff = malloc (255);
   if (temp_buff == NULL)
      return NULL;

   for (i = 0; i < count; i++, ptr_to_dest_rr++)
   {
/*
sudhir , 30th April 1997
checking wheather the rcv len exceeded
*/
      if ((proxy_dns_quest_len == 0) && 
			  (dns.port[port_number].rcvd_buff_index >= dns.port[port_number].rcvd_buff_len))
      {
         printf("DNS1 : Incomplete packet received\n");
         *no_of_rrs_copied = copied_count;
/* sudha 12-Feb-2000. For DNS memory leakage problem */
			free (temp_buff);
         return NULL;
      }

      ptr_to_qname = ptr_to_next_sec;
      name_len = copy_name_from_rr (temp_buff, ptr_to_qname, input_buff, ptr_to_next_sec, &offset_of_next_fld); 
      ptr_to_next_sec += offset_of_next_fld;

      ptr_to_dest_rr->re_name = (BYTE *)malloc (name_len);
      if (ptr_to_dest_rr->re_name == NULL)
      {
/* sudha 12-Feb-2000. For DNS memory leakage problem */
         *no_of_rrs_copied = copied_count;
		   free (temp_buff);
         return NULL;
      }
      
      memcpy ((void *)ptr_to_dest_rr->re_name, (void *)temp_buff, name_len);

/*
sudhir , 30th April 1997
*/
		if ( proxy_dns_quest_len == 0 )
		{
	      dns.port[port_number].rcvd_buff_index += offset_of_next_fld;
   	   if (dns.port[port_number].rcvd_buff_index >= dns.port[port_number].rcvd_buff_len)
      	{
         	printf("DNS2 : Incomplete packet received\n");
	         *no_of_rrs_copied = copied_count;
/* sudha 12-Feb-2000. For DNS memory leakage problem */
				free (temp_buff);
   	      return NULL;
      	}
		}

      ptr_to_dest_rr->re_type = net_to_host_short (*(USHORT *) ptr_to_next_sec); 

      ptr_to_next_sec += sizeof (USHORT) ;

/*
sudhir , 30th April 1997
*/
		if ( proxy_dns_quest_len == 0 )
		{
	      dns.port[port_number].rcvd_buff_index += sizeof(USHORT);
   	   if (dns.port[port_number].rcvd_buff_index >= dns.port[port_number].rcvd_buff_len)
      	{
         	printf("DNS3 : Incomplete packet received\n");
	         *no_of_rrs_copied = copied_count;
/* sudha 12-Feb-2000. For DNS memory leakage problem */
				free (temp_buff);
   	      return NULL;
      	}
		}

      ptr_to_dest_rr->re_class = net_to_host_short (*(USHORT *) ptr_to_next_sec);  
     
      ptr_to_next_sec += sizeof (USHORT) ;
/*
sudhir , 30th April 1997
*/
		if ( proxy_dns_quest_len == 0 )
		{
	      dns.port[port_number].rcvd_buff_index += sizeof(USHORT);
   	   if (dns.port[port_number].rcvd_buff_index >= dns.port[port_number].rcvd_buff_len)
      	{
         	printf("DNS4 : Incomplete packet received\n");
	         *no_of_rrs_copied = copied_count;
/* sudha 12-Feb-2000. For DNS memory leakage problem */
				free (temp_buff);
   	      return NULL;
      	}
		}

      ptr_to_dest_rr->re_ttl = net_to_host_long (*(ULONG *) ptr_to_next_sec);  
/* Sudha 02 Nov 1998 */
		if (min_ttl_value > ptr_to_dest_rr->re_ttl)
			min_ttl_value = ptr_to_dest_rr->re_ttl;
      ptr_to_next_sec += sizeof (ULONG);
/*
sudhir , 30th April 1997
*/
		if ( proxy_dns_quest_len == 0 )
		{
	      dns.port[port_number].rcvd_buff_index += sizeof(ULONG);
   	   if (dns.port[port_number].rcvd_buff_index >= dns.port[port_number].rcvd_buff_len)
      	{
         	printf("DNS5 : Incomplete packet received\n");
	         *no_of_rrs_copied = copied_count;
/* sudha 12-Feb-2000. For DNS memory leakage problem */
				free (temp_buff);
   	      return NULL;
      	}
		}

      ptr_to_dest_rr->re_rdlen  = net_to_host_short (*(USHORT *) ptr_to_next_sec); 
      ptr_to_next_sec += sizeof (USHORT) ;
/*
sudhir , 30th April 1997
*/
		if ( proxy_dns_quest_len == 0 )
		{
	      dns.port[port_number].rcvd_buff_index += sizeof(USHORT);
   	   if (dns.port[port_number].rcvd_buff_index >= dns.port[port_number].rcvd_buff_len)
      	{
         	printf("DNS6 : Incomplete packet received\n");
	         *no_of_rrs_copied = copied_count;
/* sudha 12-Feb-2000. For DNS memory leakage problem */
				free (temp_buff);
   	      return NULL;
      	}
		}
      
      if (ptr_to_dest_rr->re_type == 1)
      {
         ptr_to_dest_rr->re_rdata = (BYTE *) malloc (ptr_to_dest_rr->re_rdlen);
         if (ptr_to_dest_rr->re_rdata == NULL)
         {
/* sudha 12-Feb-2000. For DNS memory leakage problem */
	         *no_of_rrs_copied = copied_count;
				free (temp_buff);
            return NULL;
         }
         memcpy ((void *) ptr_to_dest_rr->re_rdata, (void *) ptr_to_next_sec, ptr_to_dest_rr->re_rdlen); 
         ptr_to_next_sec += ptr_to_dest_rr->re_rdlen;
/*
sudhir , 30th April 1997
*/
		if ( proxy_dns_quest_len == 0 )
         dns.port[port_number].rcvd_buff_index += ptr_to_dest_rr->re_rdlen;
      }
      else
      {
          name_len = copy_name_from_rr (temp_buff, ptr_to_next_sec,input_buff, ptr_to_next_sec, &offset_of_next_fld);        
          ptr_to_dest_rr->re_rdata = (BYTE *) malloc (name_len);
          if (ptr_to_dest_rr->re_rdata == NULL)
          {
/* sudha 12-Feb-2000. For DNS memory leakage problem */
	         *no_of_rrs_copied = copied_count;
				free (temp_buff);
            return NULL;
          }
          memcpy ((void *) ptr_to_dest_rr->re_rdata, (void *) temp_buff, name_len ); 
          ptr_to_next_sec += ptr_to_dest_rr->re_rdlen;
/*
sudhir, 30th April 1997
*/
			if ( proxy_dns_quest_len == 0 )
   	      dns.port[port_number].rcvd_buff_index += ptr_to_dest_rr->re_rdlen;
         ptr_to_dest_rr->re_rdlen = name_len;
      }
      copied_count++;

#ifdef DEBUG
      printf ("RR_NAME: %s\n",ptr_to_dest_rr->re_name);
      printf ("RR_TYPE: %d\n",ptr_to_dest_rr->re_type);
      printf ("RR_CLASS: %d\n",ptr_to_dest_rr->re_class);
      printf ("RR_TTL: %d\n",ptr_to_dest_rr->re_ttl);
      printf ("RR_RDLEN: %d\n",ptr_to_dest_rr->re_rdlen);
      if (ptr_to_dest_rr->re_type == 2)
         printf ("RR_DATA is %s\n",ptr_to_dest_rr->re_rdata);
      else
         printf ("RR_RDATA: %d%d%d%d\n",((USHORT)(*ptr_to_dest_rr->re_rdata)),
               ((USHORT)(*(ptr_to_dest_rr->re_rdata+1))),((USHORT)(*(ptr_to_dest_rr->re_rdata+2))),((USHORT)(*(ptr_to_dest_rr->re_rdata+3))));

#endif 
   }
   free (temp_buff);
/* sudha 12-Feb-2000. For DNS memory leakage problem */
	*no_of_rrs_copied = copied_count;
   return ptr_to_next_sec;
}

USHORT copy_name_from_rr (BYTE *temp_buff, BYTE *ptr_to_name, BYTE *input_buf, BYTE *sptr_resource_rec, USHORT *offset)
{
   USHORT name_len=0;
   BYTE *temp_ptr;
/* sudha 05-Nov-1999... */
	int data_start_pointer = 0;
/* ...sudha 05-Nov-1999 */
   
   temp_ptr = temp_buff;
/*
Satish/Sudhir, 2nd May 1997.
*/
   *offset = 0;
   while (*ptr_to_name)
   {
/* Sudha 18 July 1998 */
		if ((*ptr_to_name & (BYTE) 0xC0 ) == (BYTE) 0xC0)
      {
/*	Satish/Sudhir, 2nd May 1997.*/
		   if (*offset == 0)
         	*offset = name_len + 2;			/* Incr the offset */
							/* only once	*/
/* sudha 05-Nov-1999... */
				/*
				# Retreive the data pointer.
				*/
				data_start_pointer = ((((BYTE)(*ptr_to_name) & (BYTE) 0x3F) << 8 ) 
												| (BYTE)(*(ptr_to_name+1)));
	         ptr_to_name = input_buf + data_start_pointer;
/* ...sudha 05-Nov-1999 */
      }
/* sudha 05-Nov-1999... */
		if ((*ptr_to_name != 0x00) && 
			(((BYTE)(*ptr_to_name) & (BYTE) 0xC0 ) != (BYTE) 0xC0)) /* Sudha */
		{
/* ...sudha 05-Nov-1999 */

	      name_len++;
   	   *temp_ptr++ = *ptr_to_name++;
		}
   }
   *temp_ptr = 0;
   name_len = strlen (temp_buff)+1 ;
   if (*offset == 0)
      *offset = name_len;
   return name_len;
}

RESOURCE_REC *get_free_entry_from_cache ()
{
   USHORT i =0;

   for (i = 0; i < MAX_NUMBER_OF_CACHE; i++)
   {
      if (dns_cache[i].in_use == FALSE)
      {
         dns_cache[i].in_use = TRUE;         
         return (dns_cache[i].resource_rec);
      }
   }
   return NULL;
}


enum BOOLEAN update_cache_with_new_entry (RESOURCE_REC *ptr_to_rr, USHORT port_number)
{
   RESOURCE_REC *temp_ptr, *ptr_to_cache;
   USHORT name_len=0;


   if (ptr_to_rr == NULL)
   {
      return FALSE;
   }

   temp_ptr = ptr_to_rr;

   ptr_to_cache = get_free_entry_from_cache();
   if (ptr_to_cache == NULL)
   {
      return FALSE;
   }

/* sudhir 4/10/97 */
/*
   name_len = strlen (ptr_to_rr->re_name);
   ptr_to_cache->re_name = (BYTE *) malloc (name_len);
   if (ptr_to_cache->re_name == NULL)
   {
      return FALSE;
   }
*/
   ptr_to_cache->re_rdata = (BYTE *) malloc (ptr_to_rr->re_rdlen);
   if (ptr_to_cache->re_rdata == NULL)
   {
/* sudhir 4/10/97 */
/*      free (ptr_to_cache->re_name); */
	return FALSE;
   }

/* sudhir 13/5/97 */
   if (resolve_cname[port_number])
   {
/* sudhir 4/10/97 */
	name_len = strlen (pkt_to_send[port_number]->send_quest) + 1;
	ptr_to_cache->re_name = (BYTE *) malloc (name_len);
	if (ptr_to_cache->re_name == NULL)
	{
	    	free(ptr_to_cache->re_rdata);
/* sudha 05-Nov-1999... */
    	ptr_to_cache->re_rdata = NULL;
/* ...sudha 05-Nov-1999 */
		return FALSE;
	}
	strcpy (ptr_to_cache->re_name, pkt_to_send[port_number]->send_quest);
   }
   else
   {
/* sudhir 4/10/97 */
	name_len = strlen (ptr_to_rr->re_name) + 1;
	ptr_to_cache->re_name = (BYTE *) malloc (name_len);
	if (ptr_to_cache->re_name == NULL)
	{
	    	free(ptr_to_cache->re_rdata);
/* sudha 05-Nov-1999... */
    	ptr_to_cache->re_rdata = NULL;
/* ...sudha 05-Nov-1999 */
		return FALSE;
	}
	strcpy (ptr_to_cache->re_name, ptr_to_rr->re_name);
   }

   ptr_to_cache->re_type = ptr_to_rr->re_type;
   ptr_to_cache->re_class = ptr_to_rr->re_class;
   ptr_to_cache->re_ttl = ptr_to_rr->re_ttl;
   ptr_to_cache->re_rdlen = ptr_to_rr->re_rdlen;
   ptr_to_cache->re_rdlen = ptr_to_rr->re_rdlen;
   memcpy (ptr_to_cache->re_rdata, ptr_to_rr->re_rdata, ptr_to_rr->re_rdlen);
   return(TRUE);
}

/* sudha 05-Nov-1999... */
/*
# PANKAJ->It might be possible in the case of an ALIAS that the name in the 
# resource record domain might not be the same as the one in the orignal query.
# So removed the check that used to compare the orignal query name and the
# resource record domain name.
*/
/* ...sudha 05-Nov-1999 */

ULONG get_ip_address_from_rr_if_any (RESOURCE_REC *ptr_to_rr, USHORT num_of_rrs, USHORT port_number)
{
   USHORT i=0, ret_val=0, j ;
   RESOURCE_REC *ptr_to_current_rr;
   ULONG resolved_ip_addr=0;
   USHORT rr_type,rr_class,rr_rdlen;
   ULONG *temp_dns_ip_addr;

   if (ptr_to_rr == NULL)
      return 0;

   ptr_to_current_rr = ptr_to_rr;

/* Sudha 23 June 1998 */
		
   dns.port[port_number].dns_resolved_multi_ip_addr.count = 0;
/* Sudha 20 July 1998 */
	if ( num_of_rrs > 0 )
	{
	   temp_dns_ip_addr = (ULONG *) calloc (num_of_rrs, sizeof (ULONG));
   	dns.port[port_number].dns_resolved_multi_ip_addr.ip_address = temp_dns_ip_addr;

	   if ( dns.port[port_number].dns_resolved_multi_ip_addr.ip_address == NULL )
		{
			printf("\n\rDNS: Malloc failed for storing multiple IP addresses.\n\r");
   	   return 0;
		}
   
   	*temp_dns_ip_addr = 0;
	}
	else
	{
		printf("\n\rDNS: No Resource records to process in the reply packet.\n\r");
		return 0;
	}
   for (i = 0; i < num_of_rrs; i++, ptr_to_current_rr++)
   {
/* sudha 05-Nov-1999... */
	    	/*
		# PANKAJ->Removed this check because for the ALIAS the orignal query name
		# might not match with the resource records domain name. */

#if 0
      if (strcmpi (query_info[port_number].S_NAME,ptr_to_current_rr->re_name))
         continue; 
#endif

/* ...sudha 05-Nov-1999 */

#if 0 
      rr_type = net_to_host_short (ptr_to_current_rr->re_type);
      printf ("ptr_to_rr rdlen %d\n",ptr_to_current_rr->re_rdlen);
      rr_rdlen = net_to_host_short (ptr_to_current_rr->re_rdlen);
      rr_class = net_to_host_short (ptr_to_current_rr->re_class); 


      printf ("TYPE: %d\n", rr_type);
      printf ("CLASS: %d\n",rr_class);
      printf ("TTL: %lu\n", ptr_to_current_rr->re_ttl);
      printf ("rdat len %d\n",rr_rdlen );
      
      printf ("ret_val is %d\n", ret_val);
#endif
      if ((ptr_to_current_rr->re_type != HOST_ADDRESS) || (ptr_to_current_rr->re_rdlen != 4))   
     	   continue;

      resolved_ip_addr = net_to_host_long(*((ULONG *)ptr_to_current_rr->re_rdata));

/* Sudha 23 June 1998 */
      if ( resolved_ip_addr != 0 )
      {
         *(temp_dns_ip_addr) = resolved_ip_addr;
         dns.port[port_number].dns_resolved_multi_ip_addr.count++;
         temp_dns_ip_addr++;
#if 0		/* Commented by Sreelu */
    	   update_cache_with_new_entry (ptr_to_current_rr,port_number);
#endif	/* Commented by Sreelu */
      }
/*    break; Sudha 23 June 1998 */
   }

/*   return resolved_ip_addr; Sudha 28 June 1998 */
	  return (*(dns.port[port_number].dns_resolved_multi_ip_addr.ip_address));	
}


USHORT check_for_cname_in_ans_section (RESOURCE_REC *ptr_to_rr, USHORT num_of_rrs,BYTE *input_buff)
{
   RESOURCE_REC *ptr_to_current_rr;
   USHORT i=0;

   if (ptr_to_rr == NULL)
      return 0;

   ptr_to_current_rr = ptr_to_rr;
   for (i = 0; i < num_of_rrs; i++,ptr_to_current_rr++)
   {
      if (ptr_to_current_rr->re_type != CNAME)
         continue;
/* sudha 05-Nov-1999... */
/*      strncpy_null((void *)input_buff, (void *) ptr_to_current_rr->re_rdata, ptr_to_current_rr->re_rdlen); */
      memcpy ((void *)input_buff, (void *) ptr_to_current_rr->re_rdata, ptr_to_current_rr->re_rdlen);
/* ...sudha 05-Nov-1999 */
      return 1;
   }
   return 0;
}


ULONG resolve_with_cname (BYTE *cname_buff, HEADER *dns_header_type, USHORT port_number)
{
   ULONG ip_addr;

   ip_addr = get_ip_address_from_rr_if_any (ans_rr[port_number],dns_header_type->ancnt, port_number);

   if (ip_addr)
   {
      dns.port[port_number].dns_state = RESOLVED;
/*
sudhir, 30th April 1997
*/
/* Sudha 26 June 1998 */
/*	Here give the control to app which called dns */
      free_allocated_buffers (dns_header_type, port_number);
      return (ip_addr);
   }
   else
   {
      ip_addr = get_ip_address_from_rr_if_any (add_rr[port_number],dns_header_type->arcnt, port_number);
      if (ip_addr)
      {
         dns.port[port_number].dns_state = RESOLVED;
/*
sudhir, 30th April 1997
*/
/* Sudha 26 June 1998 */
/*	Here give the control to app which called dns */
         free_allocated_buffers (dns_header_type, port_number);
         return(ip_addr);
      }
      else
      {
/*
sudhir 1st may 1997. This is just for testing. We will not be supporting
iterative servers at this moment of time. Remove the return 0 after the
test */
/* & also the freeing up function. Sudha 26 June 1998 */
/*	Here give the control to app which called dns */
         free_allocated_buffers (dns_header_type, port_number);
         return 0;
         get_name_server_and_resolve (cname_buff, dns_header_type, port_number);
      }
   }
   return 0;
}

void locate_name_server_and_resolve (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT port_number)
{
   BYTE *ptr_to_match;
   USHORT name_server=0, server_addr=0;

   ptr_to_match = locate_suitable_entry_from_auth (ptr_to_name, dns_hdr_type, port_number);
   if (ptr_to_match == NULL)
   {
      dns.port[port_number].dns_state = READY_TO_SEND;
      free_allocated_buffers (dns_hdr_type, port_number);
   }
   else
   {
/*      name_server = search_in_auth_rr_for_name (ptr_to_name, dns_hdr_type); */
      name_server = search_in_auth_rr_for_name (ptr_to_match, dns_hdr_type, port_number);
      if (name_server == 0)
      {
         dns.port[port_number].dns_state = READY_TO_SEND;
         free_allocated_buffers (dns_hdr_type, port_number);
      }
      else
      {
         server_addr = locate_server_addr_from_add_rr (dns_hdr_type, port_number);
         if (server_addr == 0)
         {
            dns.port[port_number].dns_state = READY_TO_SEND;
            free_allocated_buffers (dns_hdr_type, port_number);
         }
         else
         {
            dns.port[port_number].dns_state = READY_TO_SEND;
            free_allocated_buffers (dns_hdr_type, port_number);
            dns.port[port_number].server_ip_address = 0;
         }
      }
   }
   return;
}

BYTE *locate_suitable_entry_from_auth (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT port_number)
{
   USHORT i,match_cnt=0;
   RESOURCE_REC *ptr_to_rr;
   BYTE *ptr_to_data;

   ptr_to_rr = auth_rr[port_number];
   for (i = 0; i < dns_hdr_type->nscnt; i++,ptr_to_rr++)
   {
      match_cnt = calculate_match_count (ptr_to_rr->re_name);
      if (match_cnt > query_info[port_number].match_count)
      {
         query_info[port_number].match_count = match_cnt;
         ptr_to_data = ptr_to_rr->re_name;
      }
   }
   return ptr_to_data;
}

USHORT calculate_match_count (BYTE *ptr_to_name)
{
   USHORT ret_val=0;
   BYTE *ptr_to_rd_name;

   ptr_to_rd_name = ptr_to_name;

   while (*ptr_to_rd_name)
   {
      ptr_to_rd_name += (((ULONG )*ptr_to_rd_name)+1);
      ret_val++;
   }
   return ret_val;
}

static BYTE *to_upper (BYTE *in_str, USHORT name_len )
{
   BYTE *ptr = in_str;

   while(name_len)
   {
      *ptr = (char) toupper ((int) *in_str);
      ptr++;name_len--;
   }
   return in_str;
}

USHORT search_in_auth_rr_for_name (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT port_number)
{
   RESOURCE_REC *ptr_to_rr;
   USHORT i,j=0, name_len=0,ret_val=0;
   BYTE *temp_ptr1, *temp_ptr2;

   ptr_to_rr = auth_rr[port_number];
   for (i = 0; i < dns_hdr_type->nscnt; i++, ptr_to_rr++)
   {
      name_len = strlen (ptr_to_rr->re_name);
      temp_ptr1 = to_upper (ptr_to_rr->re_name, name_len);
      temp_ptr2 = to_upper (ptr_to_name, name_len);

      if (!memcmp ((void*) temp_ptr1, (void *) temp_ptr2, name_len))
      {
         if (ptr_to_rr->re_type == NAME_SERVER)
         {
            memcpy ( query_info[port_number].reference_info[j].Servername, ptr_to_rr->re_rdata, ptr_to_rr->re_rdlen);
            j++;
            ret_val = 1;
         }
      }
   }
   return ret_val;
}

USHORT locate_server_addr_from_add_rr (HEADER *dns_hdr_type, USHORT port_number)
{
   RESOURCE_REC *ptr_to_rr;
   USHORT i, j=0, name_len=0, ret_val=0;

   ptr_to_rr = add_rr[port_number];

   for (i = 0; i < dns_hdr_type->arcnt; i++, ptr_to_rr++)
   {
      name_len = strlen (ptr_to_rr->re_name);

      if ((!memcmp (query_info[port_number].reference_info[j].Servername, ptr_to_rr->re_name, name_len)) && (ptr_to_rr->re_type == HOST_ADDRESS))
      {
         query_info[port_number].reference_info[j].Serveraddr = *(ULONG *)ptr_to_rr->re_rdata;
         j++;
         ret_val = 1;
         query_info[port_number].no_of_ns = j;
      }
   }
   return ret_val;
}

void get_name_server_and_resolve (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT port_number)
{
   USHORT server_addr=0;   
   
   get_name_server_from_auth_rr (ptr_to_name, dns_hdr_type, port_number);
   server_addr = locate_server_addr_from_add_rr (dns_hdr_type, port_number);
   if (server_addr != 0)
   {
        dns.port[port_number].dns_state = READY_TO_SEND;
   }
   else
   {
      dns.port[port_number].number_of_references++;
      if (dns.port[port_number].number_of_references >= dns.config.max_references)
      {
         dns.port[port_number].dns_state = RESOLVE_ERR;
         return;
      }
      dns.port[port_number].server_ip_address = 0;
      dns.port[port_number].dns_state = READY_TO_SEND;
   }
   
}

void get_name_server_from_auth_rr (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT port_number)
{
   USHORT name_server;
      
   while (*ptr_to_name)
   {
      name_server = search_in_auth_rr_for_name (ptr_to_name, dns_hdr_type, port_number);
      if (name_server == 0)
         ptr_to_name += (((ULONG ) *ptr_to_name)+1);
   }
}

/* sudhir 19/9/97  exclusively for RAS*/

USHORT get_domain_name_length (BYTE *input_buff, BYTE *ptr_to_name)
{
	USHORT name_len=0;
	USHORT offset=0;		
/* sudha 05-Nov-1999... */
	int data_start_pointer = 0;
/* ...sudha 05-Nov-1999 */

	while (*ptr_to_name)
	{
/* Sudha 17 July 1998 */
		if ((*ptr_to_name & (BYTE) 0xC0 ) == (BYTE) 0xC0)
		{
			 if (offset == 0)
				offset = name_len + 2;			/* Incr the offset */
									/* only once	*/
/* sudha 05-Nov-1999... */
				/*
				# Retreive the data pointer.
				*/
				data_start_pointer = ((((BYTE)(*ptr_to_name) & (BYTE) 0x3F) << 8 ) 
												| (BYTE)(*(ptr_to_name+1)));
	         ptr_to_name = input_buff + data_start_pointer;
/* ...sudha 05-Nov-1999 */
		}
/* sudha 05-Nov-1999... */
		if ((*ptr_to_name != 0x00) && 
			(((BYTE)(*ptr_to_name) & (BYTE) 0xC0 ) != (BYTE) 0xC0)) /* Sudha */
		{
/* ...sudha 05-Nov-1999 */
			ptr_to_name++;
			name_len++;
		}
	}
	name_len++;				/* to include the null at the end*/
	if (offset == 0)
      		offset = name_len;
	return offset;
}

#if 0
enum BOOLEAN validate_dns_response_packet (HEADER *dns_header, BYTE *rcvd_buff, USHORT port_number)
{
	BYTE *ptr_to_rrs_in_response_pkt;
	USHORT index = 0, actual_packet_length = 0, offset = 0, data_length=0;
	
	ptr_to_rrs_in_response_pkt = (BYTE *) (rcvd_buff + (sizeof (HEADER) + strlen (pkt_to_send[port_number]->send_quest)+ 1 + 2*sizeof (USHORT)));
		
	for (index = 0; index < dns_header->ancnt; index++)
	{
		offset = get_domain_name_length (rcvd_buff, ptr_to_rrs_in_response_pkt);
		ptr_to_rrs_in_response_pkt += offset;
		actual_packet_length += offset;			
														
		ptr_to_rrs_in_response_pkt += (2 * sizeof (USHORT) + sizeof (ULONG));
		actual_packet_length += (2 * sizeof (USHORT) + sizeof (ULONG));

		data_length = net_to_host_short (*(USHORT *) ptr_to_rrs_in_response_pkt);

		ptr_to_rrs_in_response_pkt += (sizeof (USHORT) + data_length);
		actual_packet_length += (sizeof (USHORT) + data_length);
	}

	for (index = 0; index < dns_header->nscnt; index++)
	{
		offset = get_domain_name_length (rcvd_buff, ptr_to_rrs_in_response_pkt);
		ptr_to_rrs_in_response_pkt += offset;
		actual_packet_length += offset;			
														
		ptr_to_rrs_in_response_pkt += (2 * sizeof (USHORT) + sizeof (ULONG));
		actual_packet_length += (2 * sizeof (USHORT) + sizeof (ULONG));

		data_length = net_to_host_short (*(USHORT *) ptr_to_rrs_in_response_pkt);

		ptr_to_rrs_in_response_pkt += (sizeof (USHORT) + data_length);
		actual_packet_length += (sizeof (USHORT) + data_length);
	}

	for (index = 0; index < dns_header->arcnt; index++)
	{
		offset = get_domain_name_length (rcvd_buff, ptr_to_rrs_in_response_pkt);
		ptr_to_rrs_in_response_pkt += offset;
		actual_packet_length += offset;			
														
		ptr_to_rrs_in_response_pkt += (2 * sizeof (USHORT) + sizeof (ULONG));
		actual_packet_length += (2 * sizeof (USHORT) + sizeof (ULONG));

		data_length = net_to_host_short (*(USHORT *) ptr_to_rrs_in_response_pkt);

		ptr_to_rrs_in_response_pkt += (sizeof (USHORT) + data_length);
		actual_packet_length += (sizeof (USHORT) + data_length);
	}

	if (actual_packet_length > dns.port[port_number].rcvd_buff_len)
  		return FALSE;

	return TRUE;
}
#endif

enum BOOLEAN validate_dns_response_packet (HEADER *dns_header, BYTE *rcvd_buff, USHORT port_number)
{
	BYTE *ptr_to_rrs_in_response_pkt;
	USHORT index = 0, actual_packet_length = 0, offset = 0, data_length=0, rcvd_packet_length;
	
	rcvd_packet_length = dns.port[port_number].rcvd_buff_len;

	ptr_to_rrs_in_response_pkt = (BYTE *) (rcvd_buff + (sizeof (HEADER) + strlen (pkt_to_send[port_number]->send_quest)+ 1 + 2*sizeof (USHORT)));
	actual_packet_length =  sizeof (HEADER) + strlen (pkt_to_send[port_number]->send_quest) + 1 + 2*sizeof (USHORT);
		
	for (index = 0; index < dns_header->ancnt; index++)
	{
		offset = get_domain_name_length (rcvd_buff, ptr_to_rrs_in_response_pkt);
		if (offset > MAXIMUM_DOMAIN_LENGTH || offset > rcvd_packet_length)
			return FALSE;

		ptr_to_rrs_in_response_pkt += offset;
		actual_packet_length += offset;			
		
		if (actual_packet_length+ (3 * sizeof (USHORT) + sizeof (ULONG)) > rcvd_packet_length)										
			return FALSE;

		ptr_to_rrs_in_response_pkt += (2 * sizeof (USHORT) + sizeof (ULONG));
		actual_packet_length += (2 * sizeof (USHORT) + sizeof (ULONG));

		data_length = net_to_host_short (*(USHORT *) ptr_to_rrs_in_response_pkt);

		if ((actual_packet_length+ sizeof (USHORT)+ data_length) > rcvd_packet_length)										
			return FALSE;

		ptr_to_rrs_in_response_pkt += (sizeof (USHORT) + data_length);
		actual_packet_length += (sizeof (USHORT) + data_length);
	}

	for (index = 0; index < dns_header->nscnt; index++)
	{
		offset = get_domain_name_length (rcvd_buff, ptr_to_rrs_in_response_pkt);
		if (offset > MAXIMUM_DOMAIN_LENGTH)
			return FALSE;
		if ((actual_packet_length + offset) > rcvd_packet_length)										
			return FALSE;

		ptr_to_rrs_in_response_pkt += offset;
		actual_packet_length += offset;			
		
		if (actual_packet_length+ (3 * sizeof (USHORT) + sizeof (ULONG)) > rcvd_packet_length)										
			return FALSE;
														
		ptr_to_rrs_in_response_pkt += (2 * sizeof (USHORT) + sizeof (ULONG));
		actual_packet_length += (2 * sizeof (USHORT) + sizeof (ULONG));

		data_length = net_to_host_short (*(USHORT *) ptr_to_rrs_in_response_pkt);
		
		if ((actual_packet_length+ sizeof (USHORT)+ data_length) > rcvd_packet_length)										
			return FALSE;

		ptr_to_rrs_in_response_pkt += (sizeof (USHORT) + data_length);
		actual_packet_length += (sizeof (USHORT) + data_length);
	}

	for (index = 0; index < dns_header->arcnt; index++)
	{
		offset = get_domain_name_length (rcvd_buff, ptr_to_rrs_in_response_pkt);
		if (offset > MAXIMUM_DOMAIN_LENGTH)
			return FALSE;

		if ((actual_packet_length + offset) > rcvd_packet_length)										
			return FALSE;
	
		ptr_to_rrs_in_response_pkt += offset;
		actual_packet_length += offset;			

		if (actual_packet_length+ (3 * sizeof (USHORT) + sizeof (ULONG)) > rcvd_packet_length)										
			return FALSE;

		ptr_to_rrs_in_response_pkt += (2 * sizeof (USHORT) + sizeof (ULONG));
		actual_packet_length += (2 * sizeof (USHORT) + sizeof (ULONG));

		data_length = net_to_host_short (*(USHORT *) ptr_to_rrs_in_response_pkt);

		if ((actual_packet_length+ sizeof (USHORT)+ data_length) > rcvd_packet_length)										
			return FALSE;
	
		ptr_to_rrs_in_response_pkt += (sizeof (USHORT) + data_length);
		actual_packet_length += (sizeof (USHORT) + data_length);
	}

	if (actual_packet_length != dns.port[port_number].rcvd_buff_len)
  		return FALSE;

	return TRUE;
}


