#include	"defs.h"
/*
 * $Log: /IP/ICMPTX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: icmptx.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<string.h>
#include	"ip.h"
/****************************************************************************/
static enum BOOLEAN check_if_icmp_error_message_should_actually_be_sent (USHORT port_number,
	IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet, enum ICMP_MESSAGE_TYPE type);
static enum TEST allocate_icmp_packet_and_build_header (USHORT port_number, USHORT icmp_packet_size,
	ICMP_HEADER **ptr_to_sptr_icmp_header, ICMP_PACKET **ptr_to_sptr_icmp_packet, IP_PARAMETERS *sptr_ip_parameters,
	enum ICMP_MESSAGE_TYPE type);
static void	process_icmp_header_based_on_icmp_type (ICMP_HEADER *sptr_icmp_header, UNION_ICMP_PARAMETER *uptr_option_data,
	BYTE code, enum ICMP_MESSAGE_TYPE type);
static void increment_mib_counters_for_these_icmp_types (enum ICMP_MESSAGE_TYPE type);
static void	build_icmp_packet (USHORT port_number, ICMP_HEADER **ptr_to_sptr_icmp_header, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	ICMP_PACKET *sptr_icmp_packet, enum ICMP_MESSAGE_TYPE type, BYTE code);
static void	set_up_icmp_source_and_destination_addresses (IP_PARAMETERS *sptr_ip_parameters,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters);
static void	build_ip_upper_layer_parameters (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, BYTE protocol_id,
	IP_PARAMETERS *sptr_ip_parameters);
static void	copy_other_original_options_to_the_new_options (IP_PARAMETERS *sptr_ip_parameters, BYTE *bptr_options,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters);
static void icmp_setup_ip_header (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	IP_PARAMETERS *sptr_ip_parameters, BYTE protocol_id);
static USHORT get_size_of_icmp_message (enum ICMP_MESSAGE_TYPE type);
static void	determine_next_hop_ip_address_and_redirect_code (IP_ROUTE_ENTRY *sptr_route_entry,
	IP_PARAMETERS *sptr_ip_parameters, UNION_ICMP_CODES *uptr_icmp_error_code,
	UNION_ICMP_PARAMETER *uptr_icmp_parameter, IP_PORT_CLASS *sptr_incoming_port);
/****************************************************************************/
void send_icmp_error_packet (USHORT port_number, IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet,
	enum ICMP_MESSAGE_TYPE type, BYTE code, UNION_ICMP_PARAMETER *uptr_option_data)
{
	USHORT icmp_packet_size;
	ICMP_PACKET *sptr_icmp_packet;
	ICMP_HEADER *sptr_icmp_header;
	IP_UPPER_LAYER_PARAMETERS ip_upper_layer_parameters;
	USHORT icmp_data_size ;

	if (check_if_icmp_error_message_should_actually_be_sent (port_number, sptr_ip_parameters, uptr_ip_rx_packet, type)
		== FALSE)
	{
		return;
	}

	if (type == ICMP_REDIRECT_TYPE)
	{
		icmp_data_size = get_size_of_icmp_message (type) + sptr_ip_parameters->header_length ;
		icmp_packet_size = (USHORT) (sizeof (UNION_MAC_HEADER) + MINIMUM_IP_HEADER_LENGTH + icmp_data_size) ;
	}

/* Sachin 07/10/1996 */
	else if (type == ICMP_TIME_EXCEEDED_TYPE)
	{
		icmp_data_size = sptr_ip_parameters->header_length + get_size_of_icmp_message (type) ;
		icmp_packet_size = (USHORT) (sizeof (UNION_MAC_HEADER) + sptr_ip_parameters->header_length + icmp_data_size) ;
	}
	/*
		Accordingly, a change has been made in the function get_size_of_icmp_message()
		to handle ICMP_TIME_EXCEEDED_TYPE.
	*/
/* Sachin 07/10/1996 */

	else
	{
		icmp_data_size = get_size_of_icmp_message (type) + sptr_ip_parameters->header_length ;
		icmp_packet_size = (USHORT) (sizeof (UNION_MAC_HEADER) + sptr_ip_parameters->header_length + icmp_data_size) ;
	}

	if (allocate_icmp_packet_and_build_header (port_number, icmp_packet_size, &sptr_icmp_header, &sptr_icmp_packet,
		sptr_ip_parameters, type) == FAIL)
	{
		return;
	}

	memset (&ip_upper_layer_parameters, 0x00, sizeof (IP_UPPER_LAYER_PARAMETERS));

	build_icmp_packet (port_number, &sptr_icmp_header, sptr_ip_parameters, uptr_ip_rx_packet, &ip_upper_layer_parameters,
		sptr_icmp_packet, type, code);

	process_icmp_header_based_on_icmp_type (sptr_icmp_header, uptr_option_data, code, type);

/* Sachin 07/10/1996 */
	/*
		build_icmp_packet() puts the source address wrongly in some cases.
		Here, we set the source_ip_address feild of the error message packet
		correctly.
	*/
	ip_upper_layer_parameters.source_address =
		ip_get_address_of_outgoing_interface (sptr_ip_parameters->source_address);

/* sudhir 2/1/98 
	This is to avoid sending icmp error packets with source ip address 
	0.0.0.0
*/

	if (ip_upper_layer_parameters.source_address == INTERNET_ADDRESS_ANY)
		ip_upper_layer_parameters.source_address = get_ip_address (sptr_ip_parameters->rx_port_number);		
/* sudhir 2/1/98 */


	sptr_icmp_header->checksum = 0 ;

	sptr_icmp_header->checksum = calculate_ip_checksum ((PSEUDO_IP_PARAMETERS *) NULL,
		(BYTE *) sptr_icmp_header,
		icmp_data_size) ;
		/* (USHORT) (sptr_ip_parameters->header_length + get_size_of_icmp_message (type))) ; */

/* Sachin 07/10/1996 */

	print_icmp_header (sptr_icmp_header);

/* Sachin 02/05/1997 */
   /* Remember, the packet is alloced using get_an_icmp_send_packet().
   So, the completion function is different */
   /* send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_icmp_packet, icmp_packet_size,
		(void (*) (USHORT port_number, IP_PACKET *sptr_ip_packet)) send_completion_ip_packet); */

   send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_icmp_packet, icmp_packet_size,
		(void (*) (USHORT port_number, IP_PACKET *sptr_ip_packet)) send_completion_icmp_packet, sptr_ip_parameters->rx_port_number);
/* Sachin 02/05/1997 */
}
/****************************************************************************/
static enum BOOLEAN check_if_icmp_error_message_should_actually_be_sent (USHORT port_number,
	IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet, enum ICMP_MESSAGE_TYPE type)
{
	ICMP_HEADER *sptr_icmp_header;

	if (sptr_ip_parameters->offset != 0x0000)
		{
		return (FALSE);
		}

	if (received_broadcast_from_interface (port_number, uptr_ip_rx_packet) == TRUE)
		{
		return (FALSE);
		}

	sptr_icmp_header = (ICMP_HEADER *) ((ULONG) uptr_ip_rx_packet + sizeof (UNION_MAC_HEADER) +
		sptr_ip_parameters->header_length);

	/* Do not send another icmp error message in response to an icmp error message except for redirect */

	if ((sptr_ip_parameters->protocol == ICMP_PROTOCOL) && (type != ICMP_REDIRECT_TYPE))
		{
		switch (sptr_icmp_header->type)
			{
			case ICMP_ECHO_REPLY_TYPE:
			case ICMP_ECHO_REQUEST_TYPE:
			case ICMP_TIMESTAMP_TYPE:
			case ICMP_TIMESTAMP_REPLY_TYPE:
			case ICMP_INFO_REQUEST_TYPE:
			case ICMP_INFO_REPLY_TYPE:

				break;

			default:

				return (FALSE);
			}
		}

	return (TRUE);
}
/****************************************************************************/
static enum TEST allocate_icmp_packet_and_build_header (USHORT port_number, USHORT icmp_packet_size,
	ICMP_HEADER **ptr_to_sptr_icmp_header, ICMP_PACKET **ptr_to_sptr_icmp_packet, IP_PARAMETERS *sptr_ip_parameters,
	enum ICMP_MESSAGE_TYPE type)
{
/* Sachin 02/05/1997 */
	/* *ptr_to_sptr_icmp_packet = (ICMP_PACKET *) get_an_ip_send_packet (port_number, icmp_packet_size); */
   *ptr_to_sptr_icmp_packet = (ICMP_PACKET *) get_an_icmp_send_packet (icmp_packet_size) ;
/* Sachin 02/05/1997 */

	if (*ptr_to_sptr_icmp_packet == NULL)
		{
		++ip.icmp.mib.icmpOutErrors;

		return (FAIL);
		}

	if (type == ICMP_REDIRECT_TYPE)
		{
		*ptr_to_sptr_icmp_header = (ICMP_HEADER *) ((ULONG) *ptr_to_sptr_icmp_packet + sizeof (UNION_MAC_HEADER) +
			MINIMUM_IP_HEADER_LENGTH);
		}
	else
		{
		*ptr_to_sptr_icmp_header = (ICMP_HEADER *) ((ULONG) *ptr_to_sptr_icmp_packet + sizeof (UNION_MAC_HEADER) +
			sptr_ip_parameters->header_length);
		}

	return (PASS);
}
/****************************************************************************/
static void	process_icmp_header_based_on_icmp_type (ICMP_HEADER *sptr_icmp_header, UNION_ICMP_PARAMETER *uptr_option_data,
	BYTE code, enum ICMP_MESSAGE_TYPE type)
{
	switch (type)
		{
		case ICMP_PARAMETER_PROBLEM_TYPE:

			++ip.icmp.mib.icmpOutParmProbs;

			sptr_icmp_header->option.parameter_problem_message.pointer = uptr_option_data->pointer;

			break;

		case ICMP_REDIRECT_TYPE:

			++ip.icmp.mib.icmpOutRedirects;

			sptr_icmp_header->option.redirect_message.gateway = host_to_net_long (uptr_option_data->gateway_address);

			break;

		case ICMP_DESTINATION_UNREACHABLE_TYPE:

			if (code == ICMP_FRAGMENT_NEEDED_CODE)
				{
				sptr_icmp_header->option.unreachable_message.mtu = host_to_net_short (uptr_option_data->mtu);
				}

			++ip.icmp.mib.icmpOutDestUnreachs;

			break;

		case ICMP_ADDRESS_MASK_TYPE:

			sptr_icmp_header->option.address_mask_message.identifier = host_to_net_short (ip.icmp.mask_request_id);
			sptr_icmp_header->option.address_mask_message.sequence_number = host_to_net_short (ip.icmp.mask_sequence_number);
			sptr_icmp_header->option.address_mask_message.mask = host_to_net_long (uptr_option_data->address_mask);

			++ip.icmp.mask_request_id;
			++ip.icmp.mask_sequence_number;

			++ip.icmp.mib.icmpOutAddrMasks;

			break;

		case ICMP_ADDR_MASK_REPLY_TYPE:

			sptr_icmp_header->option.address_mask_message.mask = host_to_net_long (uptr_option_data->address_mask);

			++ip.icmp.mib.icmpOutAddrMaskReps;

			break;

		case ICMP_INFO_REQUEST_TYPE:
		case ICMP_INFO_REPLY_TYPE:

			break;

		case ICMP_TIMESTAMP_REPLY_TYPE:
		case ICMP_ECHO_REQUEST_TYPE:
		case ICMP_ECHO_REPLY_TYPE:
		case ICMP_TIMESTAMP_TYPE:
		case ICMP_TIME_EXCEEDED_TYPE:
		case ICMP_SOURCE_QUENCH_TYPE:

			increment_mib_counters_for_these_icmp_types (type);

			break;

		}
}
/****************************************************************************/
static void increment_mib_counters_for_these_icmp_types (enum ICMP_MESSAGE_TYPE type)
{
	switch (type)
		{
		case ICMP_ECHO_REQUEST_TYPE:

			++ip.icmp.mib.icmpOutEchos;

			break;

		case ICMP_ECHO_REPLY_TYPE:

			++ip.icmp.mib.icmpOutEchoReps;

			break;

		case ICMP_TIMESTAMP_TYPE:

			++ip.icmp.mib.icmpOutTimestamps;

			break;

		case ICMP_TIMESTAMP_REPLY_TYPE:

			++ip.icmp.mib.icmpOutTimestampReps;

			break;

		case ICMP_TIME_EXCEEDED_TYPE:

			++ip.icmp.mib.icmpOutTimeExcds;

			break;

		case ICMP_SOURCE_QUENCH_TYPE:

			++ip.icmp.mib.icmpOutSrcQuenchs;

			break;
		}
}
/****************************************************************************/
static void	build_icmp_packet (USHORT port_number, ICMP_HEADER **ptr_to_sptr_icmp_header, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	ICMP_PACKET *sptr_icmp_packet, enum ICMP_MESSAGE_TYPE type, BYTE code)
{
	if (uptr_ip_rx_packet != NULL)
		{
		setup_reflected_ip_header (sptr_ip_upper_layer_parameters, sptr_ip_parameters, ICMP_PROTOCOL,
			(BYTE *) &uptr_ip_rx_packet->ip.options_or_data, ptr_to_sptr_icmp_header, sptr_icmp_packet);

		/* copy the received datagram's ip header and data into the icmp ip-data portion */

		memcpy ((char *) &(*ptr_to_sptr_icmp_header)->option.redirect_message.ip_data, &uptr_ip_rx_packet->ip.header,
			sptr_ip_parameters->header_length);
		}
	else
		{
		icmp_setup_ip_header (sptr_ip_upper_layer_parameters, sptr_ip_parameters, ICMP_PROTOCOL);
		}

/* Sachin 07/10/1996 */
	if ((type == ICMP_REDIRECT_TYPE) || (type == ICMP_TIME_EXCEEDED_TYPE))
	{
		memcpy ((BYTE *) &(*ptr_to_sptr_icmp_header)->option.time_exceeded_message.data,
		        &uptr_ip_rx_packet->ip.options_or_data.data, 8) ;
	}
/* Sachin 07/10/1996 */

	(*ptr_to_sptr_icmp_header)->type = (BYTE_ENUM (ICMP_MESSAGE_TYPE)) type;
	(*ptr_to_sptr_icmp_header)->code.generic = code;
	(*ptr_to_sptr_icmp_header)->option.unused = 0x00000000L;

	++ip.icmp.mib.icmpOutMsgs;

	/* calculate icmp checksum */

	(*ptr_to_sptr_icmp_header)->checksum = 0x0000;

	(*ptr_to_sptr_icmp_header)->checksum = calculate_ip_checksum ((PSEUDO_IP_PARAMETERS *) NULL,
		(BYTE *) *ptr_to_sptr_icmp_header, (USHORT) (sptr_ip_parameters->total_length - sptr_ip_parameters->header_length));

	sptr_ip_upper_layer_parameters->virtual_port_number = port_number;
}
/****************************************************************************/
void setup_reflected_ip_header (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, IP_PARAMETERS *sptr_ip_parameters,
	BYTE protocol_id, BYTE *bptr_options, ICMP_HEADER **ptr_to_sptr_icmp_header, ICMP_PACKET *sptr_icmp_packet)
{
	set_up_icmp_source_and_destination_addresses (sptr_ip_parameters, sptr_ip_upper_layer_parameters);

	build_ip_upper_layer_parameters (sptr_ip_upper_layer_parameters, protocol_id, sptr_ip_parameters);

	if (sptr_ip_parameters->options_length == 0x00)
		{
		sptr_ip_upper_layer_parameters->option_length = 0x00;

		if (sptr_icmp_packet != NULL)
			{
			*ptr_to_sptr_icmp_header = (ICMP_HEADER *) ((ULONG) sptr_icmp_packet + sizeof (UNION_MAC_HEADER) +
				MINIMUM_IP_HEADER_LENGTH);
			}
		}
	else
		{
		/* If the original ip datagram has ip source route option, use it in reversed order.
		 * The source route option has been saved in global memory. Take it and reverse the order and put them into
		 *	ip_upper_layer_parameters block. Notice the destination ip address in ip_upper_layer_parameters may be changed by
		 *	this routine. */

/*
		ULONG original_ip_source_address;

		original_ip_source_address = sptr_ip_parameters->source_address;

		ip_setup_source_route (sptr_ip_upper_layer_parameters, original_ip_source_address);
*/

		copy_other_original_options_to_the_new_options (sptr_ip_parameters, bptr_options, sptr_ip_upper_layer_parameters);

		if (sptr_icmp_packet != NULL)
			{
			*ptr_to_sptr_icmp_header = (ICMP_HEADER *) ((ULONG) sptr_icmp_packet + sizeof (UNION_MAC_HEADER) +
				MINIMUM_IP_HEADER_LENGTH + sptr_ip_upper_layer_parameters->option_length);
			}
		}

	sptr_ip_upper_layer_parameters->vptr_cached_route = (IP_ROUTE_CACHE_ENTRY *) NULL;
}
/****************************************************************************/
static void	set_up_icmp_source_and_destination_addresses (IP_PARAMETERS *sptr_ip_parameters,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters)
{
	ULONG ip_address_to_check;
	USHORT port_number;

	if ((sptr_ip_parameters->source_address == INTERNET_ADDRESS_ANY) ||
		(sptr_ip_parameters->source_address == INTERNET_ADDRESS_BROADCAST))
		{
		sptr_ip_upper_layer_parameters->destination_address = INTERNET_ADDRESS_BROADCAST;
		}
	else
		{
		sptr_ip_upper_layer_parameters->destination_address = sptr_ip_parameters->source_address;
		}

	ip_address_to_check = sptr_ip_parameters->destination_address;

	if (ip_match_full_address_to_port (ip_address_to_check) != NO_SUCH_PORT)
		{
		/* yes, we are the destination of the original ip packet */

		sptr_ip_upper_layer_parameters->source_address = ip_address_to_check;
		}
	else
		{
		port_number = ip_match_subnet_address_to_port (ip_address_to_check);

		if (port_number != NO_SUCH_PORT)
			{
			sptr_ip_upper_layer_parameters->source_address = ip.port[port_number].config.ip_address;
			}
		else
			{
			/* uses the outgoing port's ip address. */

			sptr_ip_upper_layer_parameters->source_address =
				ip_get_address_of_outgoing_interface (sptr_ip_parameters->source_address);
			}
		}
}
/****************************************************************************/
static void	build_ip_upper_layer_parameters (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, BYTE protocol_id,
	IP_PARAMETERS *sptr_ip_parameters)
{
	sptr_ip_upper_layer_parameters->do_not_fragment_flag = FALSE;
	sptr_ip_upper_layer_parameters->type_of_service = sptr_ip_parameters->type_of_service;
	sptr_ip_upper_layer_parameters->sequence_id = 0x0000;
	sptr_ip_upper_layer_parameters->time_to_live = 0x00;
	sptr_ip_upper_layer_parameters->protocol = protocol_id;
}
/****************************************************************************/
static void	copy_other_original_options_to_the_new_options (IP_PARAMETERS *sptr_ip_parameters, BYTE *bptr_options,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters)
{
	USHORT current_option_length;
	BYTE option_code;
	USHORT option_length;
	IP_OPTION *sptr_option;

	/* copy other original options to the new options */

	for (option_length = sptr_ip_parameters->options_length; option_length > 0x0000;
		option_length = (USHORT) (option_length - current_option_length))
		{
		sptr_option = (IP_OPTION *) bptr_options;

	   option_code = (BYTE) sptr_option->code.option_number;

		if (option_code == IP_EOL_OPTION)
			{
			break;
			}

	   if (option_code == IP_NOOP_OPTION)
			{
		 	current_option_length = 0x0001;
			}
	   else
			{
		 	current_option_length = sptr_option->length;

		 	if ((current_option_length == 0x0000 ) || (current_option_length > option_length))
				{
			 	break;
				}
		 	}

	   if ((option_code == IP_RECORD_ROUTE_OPTION) || (option_code == IP_TIMESTAMP_OPTION))
			{
			if ((sptr_ip_upper_layer_parameters->option_length + current_option_length) > MAXIMUM_IP_OPTION_LENGTH)
				{
				break;
				}

			memcpy ((sptr_ip_upper_layer_parameters->user_options.char_options + sptr_ip_upper_layer_parameters->option_length),
				bptr_options, current_option_length);

			sptr_ip_upper_layer_parameters->option_length =
				(BYTE) (sptr_ip_upper_layer_parameters->option_length + current_option_length);
		   }

		bptr_options += current_option_length;
		}
}
/****************************************************************************/
void send_icmp_redirect_message (USHORT port_number, IP_ROUTE_ENTRY *sptr_route_entry, IP_PORT_CLASS *sptr_incoming_port,
	IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet)
{
	UNION_ICMP_CODES icmp_error_code;
	UNION_ICMP_PARAMETER icmp_parameter;

	/* Send it, if outgoing port is the same as the port on which the packet was received */

	if (received_broadcast_from_interface (port_number, uptr_ip_rx_packet) == TRUE)
		{
		/* don't need to broadcast again */

		return;
		}

	determine_next_hop_ip_address_and_redirect_code (sptr_route_entry, sptr_ip_parameters, &icmp_error_code, &icmp_parameter,
		sptr_incoming_port);

	send_icmp_error_packet (sptr_route_entry->port_number, sptr_ip_parameters, uptr_ip_rx_packet, ICMP_REDIRECT_TYPE,
		icmp_error_code.generic, &icmp_parameter);
}
/****************************************************************************/
void send_icmp_request_message (USHORT port_number, IP_PARAMETERS *sptr_ip_parameters, enum ICMP_MESSAGE_TYPE type, BYTE code,
	UNION_ICMP_PARAMETER *uptr_option_data)
{
	USHORT icmp_data_size;
	USHORT icmp_packet_size;
	ICMP_HEADER *sptr_icmp_header;
	ICMP_PACKET *sptr_icmp_packet;
	IP_UPPER_LAYER_PARAMETERS ip_upper_layer_parameters;

	icmp_data_size = get_size_of_icmp_message (type);

	icmp_packet_size = (USHORT) (sizeof (UNION_MAC_HEADER) + sptr_ip_parameters->header_length +	icmp_data_size);

	if (allocate_icmp_packet_and_build_header (port_number, icmp_packet_size, &sptr_icmp_header, &sptr_icmp_packet,
		sptr_ip_parameters, type) == FAIL)
		{
		return;
		}

	sptr_ip_parameters->total_length = (USHORT) (sptr_ip_parameters->header_length + icmp_data_size);

	memset (&ip_upper_layer_parameters, 0x00, sizeof (IP_UPPER_LAYER_PARAMETERS));

	build_icmp_packet (port_number, &sptr_icmp_header, sptr_ip_parameters, (UNION_IP_PACKET *) NULL,
		&ip_upper_layer_parameters, sptr_icmp_packet, type, code);

	process_icmp_header_based_on_icmp_type (sptr_icmp_header, uptr_option_data, code, type);

	print_icmp_header (sptr_icmp_header);

/* Sachin 02/05/1997 */
	/* send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_icmp_packet, icmp_packet_size,
		(void (*) (USHORT port_number, IP_PACKET *sptr_ip_packet)) send_completion_ip_packet);
   */

	send_ip_packet_from_upper_layer (&ip_upper_layer_parameters, FALSE, (IP_PACKET *) sptr_icmp_packet, icmp_packet_size,
		(void (*) (USHORT port_number, IP_PACKET *sptr_ip_packet)) send_completion_icmp_packet, sptr_ip_parameters->rx_port_number);

/* Sachin 02/05/1997 */
}
/****************************************************************************/
static void icmp_setup_ip_header (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	IP_PARAMETERS *sptr_ip_parameters, BYTE protocol_id)
{
	sptr_ip_upper_layer_parameters->source_address = sptr_ip_parameters->source_address;
	sptr_ip_upper_layer_parameters->destination_address = sptr_ip_parameters->destination_address;

	sptr_ip_upper_layer_parameters->gateway = sptr_ip_parameters->gateway;

	build_ip_upper_layer_parameters (sptr_ip_upper_layer_parameters, protocol_id, sptr_ip_parameters);

	sptr_ip_upper_layer_parameters->option_length = 0x00;

	sptr_ip_upper_layer_parameters->vptr_cached_route = (IP_ROUTE_CACHE_ENTRY *) NULL;
}
/****************************************************************************/
static USHORT get_size_of_icmp_message (enum ICMP_MESSAGE_TYPE type)
{
	USHORT size_of_message;

	if ((type == ICMP_ECHO_REQUEST_TYPE) || (type == ICMP_ECHO_REPLY_TYPE))
		{
		size_of_message = sizeof (BYTE) + sizeof (UNION_ICMP_CODES) + sizeof (USHORT) + sizeof (ICMP_ECHO_MESSAGE);
		}
	else if ((type == ICMP_ADDRESS_MASK_TYPE) || (type == ICMP_ADDR_MASK_REPLY_TYPE))
		{
		size_of_message = sizeof (BYTE) + sizeof (UNION_ICMP_CODES) + sizeof (USHORT) + sizeof (ICMP_ADDRESS_MASK_MESSAGE);
		}
	else if (type == ICMP_REDIRECT_TYPE)
		{
/* Sachin 09/10/1996 */
		/* size_of_message = sizeof (BYTE) + sizeof (UNION_ICMP_CODES) + sizeof (USHORT) + sizeof (ICMP_REDIRECT_MESSAGE); */
		size_of_message = sizeof (BYTE) + sizeof (UNION_ICMP_CODES) + sizeof (USHORT) + 4 + 8 ;
		/* 4 bytes of gateway address, 8 bytes of data */
/* Sachin 09/10/1996 */
		}
	else if (type == ICMP_DESTINATION_UNREACHABLE_TYPE)
		{
		size_of_message = sizeof (BYTE) + sizeof (UNION_ICMP_CODES) + sizeof (USHORT) + sizeof (ICMP_UNREACHABLE_MESSAGE);
		}

/* Sachin 07/10/1996 */
	else if (type == ICMP_TIME_EXCEEDED_TYPE)
		{
			return (4 + 4 + 8) ;
			/*
				4 bytes for type, code and checksum,
				4 unused bytes,
				8 bytes for the first 8 bytes of data
			*/
		}
/* Sachin 07/10/1996 */

	else
		{
		size_of_message = sizeof (ICMP_HEADER);
		}

	return (size_of_message);
}
/****************************************************************************/
static void	determine_next_hop_ip_address_and_redirect_code (IP_ROUTE_ENTRY *sptr_route_entry,
	IP_PARAMETERS *sptr_ip_parameters, UNION_ICMP_CODES *uptr_icmp_error_code,
	UNION_ICMP_PARAMETER *uptr_icmp_parameter, IP_PORT_CLASS *sptr_incoming_port)
{
	ULONG next_hop_ip_address;

	IP_PORT_CLASS *sptr_port;

	if (sptr_route_entry->gateway != 0x00000000L)
		{
		next_hop_ip_address = sptr_route_entry->gateway;
		}
	else
		{
		next_hop_ip_address = sptr_ip_parameters->destination_address;
		}

	/* If the destination is reached by a route to host, or is on a subnet of a local net, or is directly
	 * on the attached net (!), use host redirect. (We may be the correct first hop for other subnets.) */

	if ((sptr_route_entry->flags.host_route == TRUE) || (sptr_route_entry->gateway == 00000000L))
		{
		uptr_icmp_error_code->redirect = ICMP_REDIRECT_HOST_CODE;
		}
	else
		{
		sptr_port = &ip.port[sptr_route_entry->port_number];

		if ((sptr_port->config.subnetmask != sptr_port->netmask) &&
			((next_hop_ip_address & sptr_port->netmask) == sptr_port->net_address))
			{
			/* This is a further subdivided subnet. Next hop's ip address net portion is same as port's net portion. */

			uptr_icmp_error_code->redirect = ICMP_REDIRECT_HOST_CODE;
			}
		else
			{
			uptr_icmp_error_code->redirect = ICMP_REDIRECT_NET_CODE;
			}
		}

	++sptr_incoming_port->statistics.number_of_packets_redirected;

	uptr_icmp_parameter->gateway_address = next_hop_ip_address;
}
