#include	"defs.h"
/*
 * $Log: /IP/IPCONFIG.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipconfig.c$  $version: 1.13$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 03/03/94 yarran
1.1 03/03/94 yarran Initial release.
1.2 03/03/94 yarran Handle NVRAM parameters directly by IP
1.3 03/10/94 yarran IP does not support multiple frame types per port yet.
1.4 05/02/94 yarran added rfc1042 changes.
1.5 06/15/94 yarran lint changes.
1.6 08/25/94 ross fixed scanf bug.  Courtesy of Danny.
1.7 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.8 12/20/94 ross
1.9 12/27/94 ross added better table instrumentation via new snmp.
1.10 01/26/95 ross SNMP name change, printf change.
1.11 03/03/95 ross added lsl control.
1.12 06/29/95 ross new snmp access routine
1.13 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1992 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stddef.h>
#include	<string.h>
#include	<stdio.h>
#include <stdlib.h>
#include "ip.h"
#include	<vnvrmstr.h>

/* sudhir 1/4/97 */
#include "dns.h"
#include "kdns.h"
#include "vdnsstr.h"
extern DNS_CLASS dns;
#include	"vnvip.h"
/****************************************************************************/
static void get_information_on_protocol_stack (enum PROTOCOL_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
static enum TEST initialize_socket_protocol_stack_interface (ULONG parameter_0, ULONG parameter_1);
static enum TEST ip_initialize_socket_protocol_stack_interface (TRANSPORT_INTERFACE *sptr_transport_interface);
static void initialize_stack_function_pointers (ULONG parameter_0, ULONG parameter_1);
static enum TEST initialize_protocol_function_pointers (void);
static USHORT ip_get_port_number_and_string (char *cptr_port_number_and_value, char *return_string);
static void ip_check_port_number (char *cptr_port_number_string);
static ULONG ip_get_port_number_and_value (char *cptr_port_number_and_value, USHORT *usptr_port_number);
/****************************************************************************/
enum TEST ip_configuration (enum PROTOCOL_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	switch (command)
		{
		case IS_PROTOCOL_STACK_ENABLED:

			*((BYTE_ENUM (BOOLEAN) *) parameter_1) = (BYTE_ENUM (BOOLEAN)) ip.enabled;

			break;

		case GET_NUMBER_OF_PROTOCOL_STACKS_VIRTUAL_PORTS:
		case GET_PROTOCOL_STACK_TYPE:
		case GET_PROTOCOL_STACK_PROTOCOL_ID:
		case GET_PROTOCOL_STACK_SSAP:
		case GET_PROTOCOL_STACK_DSAP:
		case GET_PROTOCOL_STACK_VIRTUAL_PORT_PACKET_TYPE:
		case GET_PROTOCOL_STACK_REAL_PORT_NUMBER_USING_VIRTUAL_PORT_NUMBER:

			get_information_on_protocol_stack (command, parameter_0, parameter_1);

			break;

		case INITIALIZE_SOCKET_PROTOCOL_STACK_INTERFACE:

			if (initialize_socket_protocol_stack_interface (parameter_0, parameter_1) == FAIL)
				{
				return (FAIL);
				}

			break;

		case INITIALIZE_STACK_FUNCTION_POINTERS:

			initialize_stack_function_pointers (parameter_0, parameter_1);

			break;

		case INITIALIZE_PROTOCOL_FUNCTION_POINTERS:

			if (initialize_protocol_function_pointers () == FAIL)
				{
				return (FAIL);
				}

			break;

		default:

			return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
static void get_information_on_protocol_stack (enum PROTOCOL_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	switch (command)
		{
		case GET_NUMBER_OF_PROTOCOL_STACKS_VIRTUAL_PORTS:

/*			*((ULONG *) parameter_1) = ip.number_of_ports;*/
			*((USHORT *) parameter_1) = ip.number_of_ports;

			break;

		case GET_PROTOCOL_STACK_TYPE:

			*((BYTE_ENUM (PROTOCOL_STACK_TYPE) *) parameter_1) = IP_PROTOCOL_STACK;

			break;

		case GET_PROTOCOL_STACK_PROTOCOL_ID:

			*((USHORT_ENUM (SNAP_PROTOCOL_ID) *) parameter_1) = SNAP_IP_PACKET;

			break;

		case GET_PROTOCOL_STACK_SSAP:

			*((BYTE_ENUM (SAP_TYPES) *) parameter_1) = (enum SAP_TYPES) 0x00;

			break;

		case GET_PROTOCOL_STACK_DSAP:

			*((BYTE_ENUM (SAP_TYPES) *) parameter_1) = (enum SAP_TYPES) 0x00;

			break;

		case GET_PROTOCOL_STACK_VIRTUAL_PORT_PACKET_TYPE:

			*((USHORT_ENUM (LSL_PACKET_TYPE) *) parameter_1) =
				(USHORT_ENUM (LSL_PACKET_TYPE)) ip.port[parameter_0].config.lsl_packet_type;

			break;

		case GET_PROTOCOL_STACK_REAL_PORT_NUMBER_USING_VIRTUAL_PORT_NUMBER:

			*((USHORT *) parameter_1) = (USHORT) parameter_0;

			break;

		default:

			break;
		}
}
/****************************************************************************/
static enum TEST initialize_socket_protocol_stack_interface (ULONG parameter_0, ULONG parameter_1)
{
	TRANSPORT_INTERFACE *sptr_transport_interface;

	if (parameter_0 == (ULONG) IP_PROTOCOL_STACK)
		{
		sptr_transport_interface = (TRANSPORT_INTERFACE *) parameter_1;

		ip_initialize_socket_protocol_stack_interface (sptr_transport_interface);

		return (PASS);
		}

	return (FAIL);
}
/****************************************************************************/
static enum TEST ip_initialize_socket_protocol_stack_interface (TRANSPORT_INTERFACE *sptr_transport_interface)
{
	sptr_transport_interface->socket =
		(BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket, USHORT protocol))	socket_udp;

	sptr_transport_interface->bind = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket)) socket_udp_bind;

	sptr_transport_interface->connect = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket)) socket_udp_connect;

	sptr_transport_interface->receive =
		(USHORT (*) (struct USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length,
		SOCKADDR *sptr_sockaddr, USHORT *usptr_address_length, enum TEST *eptr_error))
		socket_udp_receive;

	sptr_transport_interface->send =
		(USHORT (*) (struct USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length,
		SOCKADDR *sptr_sockaddr, enum TEST *eptr_error)) socket_udp_send;

	sptr_transport_interface->queue_length =
		(USHORT (*) (struct USER_SOCKET *sptr_user_socket, USHORT queue_type, enum TEST *eptr_error))
		socket_udp_queue_length;

	sptr_transport_interface->close = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket)) socket_udp_close;

	sptr_transport_interface->status = (BYTE_ENUM (TEST) (*) (struct USER_SOCKET *sptr_user_socket)) socket_udp_status;

	sptr_transport_interface->check = (BYTE_ENUM (TEST) (*) (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length))
		check_ip_address;

	return (PASS);
}
/****************************************************************************/
static void	initialize_stack_function_pointers (ULONG parameter_0, ULONG parameter_1)
{
	IP_FUNCTION_POINTERS *sptr_ip_function_pointers;

	sptr_ip_function_pointers = (IP_FUNCTION_POINTERS *) parameter_1;

	if ((enum ISO_LAYER_TYPE) parameter_0 == TRANSPORT_LAYER_TYPE)
		{
		sptr_ip_function_pointers->fptr_get_ip_mtu = ip_get_mtu_for_outgoing_port;
		sptr_ip_function_pointers->fptr_check_ip_address = check_ip_address;
		sptr_ip_function_pointers->fptr_send_ip_packet_from_upper_layer = send_ip_packet_from_upper_layer;
		}
}
/****************************************************************************/
static enum TEST initialize_protocol_function_pointers (void)
{
	if (((enum TEST) lsl_control ((ULONG) INITIALIZE_SOCKET_FUNCTION_POINTERS, (ULONG) SOCKETS_INTERFACE,
		(ULONG) INITIALIZE_FUNCTION_POINTERS, (ULONG) NETWORK_LAYER_TYPE, (ULONG) &ip.udp.socket_fptrs)) == FAIL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/UDP: failed to initialize function pointers to the socket library\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
enum TEST set_ip_port_frame_type (char *cptr_port_number_and_tx_frame_type_string)
{
	char tx_frame_type_string[20];
	USHORT port_number;

/*	port_number = ip_get_port_number_and_string (cptr_port_number_and_tx_frame_type_string, &tx_frame_type_string[0]);*/

	port_number = get_port_number_and_string (cptr_port_number_and_tx_frame_type_string,&tx_frame_type_string[0]);

	if (strstr (strlwr (tx_frame_type_string), "raw") != NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALWAYS_PRINTF, "IP: CONFIGURATION: failed to configure port frame type (RAW is illegal on port %d)\n",
			port_number);
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}
	else if (strstr (strlwr (tx_frame_type_string), "llc") != NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALWAYS_PRINTF, "IP: CONFIGURATION: failed to configure port frame type (LLC is illegal on port %d)\n",
			port_number);
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}
	else if (strstr (strlwr (tx_frame_type_string), "snap") != NULL)
		{
		ip.port[port_number].config.lsl_packet_type = SNAP_PACKET;
		}
	else if (strstr (strlwr (tx_frame_type_string), "type_ii") != NULL)
		{
		ip.port[port_number].config.lsl_packet_type = ETHERNET_TYPE_II;
		}
	else if (strstr (strlwr (tx_frame_type_string), "wan") != NULL)
		{
		ip.port[port_number].config.lsl_packet_type = WAN_PACKET;
		}
	else if (strstr (strlwr (tx_frame_type_string), "same_type_as_rx_frame") != NULL)
		{
		ip.port[port_number].config.lsl_packet_type = SAME_TYPE_AS_RX_PACKET_;
		}

	return (PASS);
}
/****************************************************************************/
enum TEST set_ip_static_route (char *cptr_target_gateway_metric_string)
{
	NVRAM_ROUTE_ENTRY *sptr_nvram_route_entry;
	BYTE target_array[SIZE_OF_IP_ADDRESS];
	BYTE gateway_array[SIZE_OF_IP_ADDRESS];
	BYTE mask_array[SIZE_OF_IP_ADDRESS];
	ULONG port;
	

	sptr_nvram_route_entry = (NVRAM_ROUTE_ENTRY *) table_malloc (1, sizeof (NVRAM_ROUTE_ENTRY));

	if (sptr_nvram_route_entry == NULL)
		{
		ip_printf (IP_ALARM_PRINTF, "IP: table_malloc () failed\n");

		return (FAIL);
		}

	sscanf (cptr_target_gateway_metric_string, "%03ju.%03ju.%03ju.%03ju, %03ju.%03ju.%03ju.%03ju, %03ju.%03ju.%03ju.%03ju, %04u, %04u",
		(int *) &target_array[0], (int *) &target_array[1], (int *) &target_array[2], (int *) &target_array[3],
		(int *) &gateway_array[0], (int *) &gateway_array[1], (int *) &gateway_array[2], (int *) &gateway_array[3],
		(int *) &mask_array[0], (int *) &mask_array[1], (int *) &mask_array[2], (int *) &mask_array[3],
		(int *) &sptr_nvram_route_entry->metric, &port);

	sptr_nvram_route_entry->target = net_to_host_long ( *((ULONG *) &target_array[0]));
	sptr_nvram_route_entry->gateway = net_to_host_long ( *((ULONG *) &gateway_array[0]));
	sptr_nvram_route_entry->mask = net_to_host_long ( *((ULONG *) &mask_array[0]));
	sptr_nvram_route_entry->port = (USHORT) port;


#if 0
	printf("\r\n target %x", sptr_nvram_route_entry->target); 
	printf("  gateway %x", sptr_nvram_route_entry->gateway); 
	printf("  with mask %x", sptr_nvram_route_entry->mask); 
	printf("  at a metric %x", sptr_nvram_route_entry->metric); 
	printf("  port %x\r\n", sptr_nvram_route_entry->port); 
#endif

#if Ravi
	if ((sptr_nvram_route_entry->target == 0x00000000L) || (sptr_nvram_route_entry->gateway == 0x00000000L) ||
		(sptr_nvram_route_entry->mask == 0x00000000L) || (sptr_nvram_route_entry->metric >= 16))
#endif

	if ((sptr_nvram_route_entry->target == 0x00000000L) || (sptr_nvram_route_entry->mask == 0x00000000L) 
			|| (sptr_nvram_route_entry->metric >= 16))
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALWAYS_PRINTF, "IP: CONFIGURATION: failed to configure static route\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	if (sptr_nvram_route_entry->mask == 0xffffffffL)
		{
		sptr_nvram_route_entry->host = TRUE;
		}
	else
		{
		sptr_nvram_route_entry->host = FALSE;
		}

	add_entry_to_list ((LINK *) &ip.list_of_nvram_static_route_entries, (LINK *) sptr_nvram_route_entry);

	return (PASS);
}
/****************************************************************************/
enum TEST set_ip_default_route (char *cptr_default_gateway_address_metric_string)
{
	NVRAM_ROUTE_ENTRY *sptr_nvram_route_entry;
	BYTE gateway_address_array[SIZE_OF_IP_ADDRESS];
	IP_PORT_CONFIGURATION_CLASS *sptr_port_configuration ;

	sptr_nvram_route_entry = (NVRAM_ROUTE_ENTRY *) table_malloc (1, sizeof (NVRAM_ROUTE_ENTRY));

/* Sudhir 30/10/1996 */

	sptr_port_configuration = &ip.port[0].config ;

/* Sudhir 30/10/1996 */

	if (sptr_nvram_route_entry == NULL)
		{
		ip_printf (IP_ALARM_PRINTF, "IP: table_malloc () failed\n");

		return (FAIL);
		}
/* Vidy 10/06/96 */
/*	sscanf (cptr_default_gateway_address_metric_string, "%03ju.%03ju.%03ju.%03ju, %02hu", */
	sscanf (cptr_default_gateway_address_metric_string, "%03ju.%03ju.%03ju.%03ju, %04u",
		(int *) &gateway_address_array[0], (int *) &gateway_address_array[1], (int *) &gateway_address_array[2],
		(int *) &gateway_address_array[3], (int *) &sptr_nvram_route_entry->metric);

	sptr_nvram_route_entry->target = 0x00000000L;
	sptr_nvram_route_entry->gateway = net_to_host_long (*((ULONG *) &gateway_address_array[0]));

/* Sudhir 30/10/1996 */

	sptr_port_configuration->default_gateway = net_to_host_long (*((ULONG *) &gateway_address_array[0]));

/* Sudhir 30/10/1996 */

	if ((sptr_nvram_route_entry->metric >= 16) || (sptr_nvram_route_entry->gateway == 0x00000000L))
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALWAYS_PRINTF, "IP: CONFIGURATION: failed to configure default route\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

/*	add_entry_to_list ((LINK *) &ip.list_of_nvram_static_route_entries, (LINK *) sptr_nvram_route_entry);*/

	return (PASS);
}
/****************************************************************************/
enum TEST set_largest_token_ring_frame_size (char *cptr_port_number_and_size)
{
	USHORT port_number;
	USHORT port_value;

	port_value = (USHORT) ip_get_port_number_and_value (cptr_port_number_and_size, &port_number);

	if (port_value <= 516)
		{
		ip.port[port_number].config.token_ring_largest_frame = _516;
		}
	else if (port_value <= 1470)
		{
		ip.port[port_number].config.token_ring_largest_frame = _1470;
		}
	else if (port_value <= 2052)
		{
		ip.port[port_number].config.token_ring_largest_frame = _2052;
		}
	else if (port_value <= 4472)
		{
		ip.port[port_number].config.token_ring_largest_frame = _4472;
		}
	else if (port_value <= 8144)
		{
		ip.port[port_number].config.token_ring_largest_frame = _8144;
		}
	else if (port_value <= 11407)
		{
		ip.port[port_number].config.token_ring_largest_frame = _11407;
		}
	else if (port_value <= 17800)
		{
		ip.port[port_number].config.token_ring_largest_frame = _17800;
		}
	else if (port_value == 0xffff)
		{
		ip.port[port_number].config.token_ring_largest_frame = INITIAL_VALUE_OF_BROADCAST_FRAMES;
		}
	else
		{
		ip.port[port_number].config.token_ring_largest_frame = _516;
		}

	return (PASS);
}
/****************************************************************************/
enum TEST add_ip_port_forward_filter_entry (char *cptr_port_number_ip_address_string)
{
	BYTE ip_address_array[SIZE_OF_IP_ADDRESS];
	BYTE netmask[SIZE_OF_IP_ADDRESS];
	USHORT port_number[SIZE_OF_PORT_NUMBER];
	IP_PORT_CLASS *sptr_port;
	IP_FORWARD_FILTER *sptr_new_filter;
	IP_FORWARD_FILTER *sptr_old_filter;

	sscanf (cptr_port_number_ip_address_string, "%02hu, %03ju.%03ju.%03ju.%03ju, %03ju.%03ju.%03ju.%03ju", (int *) &port_number[0],
		(int *) &ip_address_array[0], (int *) &ip_address_array[1], (int *) &ip_address_array[2], (int *) &ip_address_array[3],
		(int *) &netmask[0], (int *) &netmask[1], (int *) &netmask[2], (int *) &netmask[3]);

	sptr_port = &ip.port[port_number[0]];

	sptr_new_filter = (IP_FORWARD_FILTER *) table_malloc (1, sizeof (IP_FORWARD_FILTER));

	if (sptr_new_filter == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALWAYS_PRINTF, "IP: CONFIGURATION: table_malloc failed\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	sptr_new_filter->sptr_forward = (IP_FORWARD_FILTER *) NULL;
	sptr_new_filter->ip_address = net_to_host_long (*((ULONG *) &ip_address_array[0]));
	sptr_new_filter->mask_bits = net_to_host_long (*((ULONG *) &netmask[0]));

	if (sptr_port->sptr_forward_filter_list != NULL)
		{
		sptr_old_filter = sptr_port->sptr_forward_filter_list;

		while (sptr_old_filter->sptr_forward != NULL)
			{
			sptr_old_filter = sptr_old_filter->sptr_forward;
			}

		sptr_old_filter->sptr_forward = sptr_new_filter;
		}
	else
		{
		sptr_port->sptr_forward_filter_list = sptr_new_filter;
		}

	return (PASS);
}
/****************************************************************************/
ULONG get_ip_configuration_table_address (void)
{
	ULONG return_value;

	return_value = (ULONG) &ip_configuration_table;

	return (return_value);
}
#if 0
/****************************************************************************/
static USHORT ip_get_port_number_and_string (char *cptr_port_number_and_value, char *return_string)
{
	ULONG port_number;
	USHORT return_value;

	ip_check_port_number (cptr_port_number_and_value);

	*return_string = '\0';

	sscanf (cptr_port_number_and_value, "%02u,%s", (int *) &port_number, return_string);

	return_value = (USHORT) port_number;

	return (return_value);
}
#endif
/****************************************************************************/
static void ip_check_port_number (char *cptr_port_number_string)
{
	if ((*cptr_port_number_string != '0') && (*cptr_port_number_string != '1'))
		{
		while (TRUE)
			{
		#ifdef __IP_ALARM_DEBUG__
			ip_printf (IP_ALWAYS_PRINTF, "IP: CONFIGURATION: Illegal Port Enabled Value %s\n", cptr_port_number_string);
		#endif /* __IP__ALARM_DEBUG__ */
			}
		}
}
/****************************************************************************/
static ULONG ip_get_port_number_and_value (char *cptr_port_number_and_value, USHORT *usptr_port_number)
{
	USHORT port_number[2];
	USHORT value[12];
	ULONG return_value;

	ip_check_port_number (cptr_port_number_and_value);

	memset (&value[0], (int) NULL, 12);

	sscanf (cptr_port_number_and_value, "%02hu,%08lu", (int *) &port_number[0], (ULONG *) &value[0]);

	*usptr_port_number = port_number[0];

	return_value = *((ULONG *) &value[0]);

	return (return_value);
}
