#include	"defs.h"
/*
 * $Log: /IP/IPEXCNFG.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<string.h>
#include	<stdio.h>
#include <stdlib.h>
#include "ip.h"
/****************************************************************************/
static enum TEST build_and_add_neighbor_list_entry (char *cptr_node_ip_address_string);
static enum TEST build_and_add_reject_list_entry (char *cptr_node_ip_address_string, USHORT port_number);
static enum TEST build_and_add_advertise_list_entry (char *cptr_node_ip_address_string, USHORT port_number);
static void set_ip_default_values_for_port (USHORT port_number);
static void set_rip_default_values_for_port (USHORT port_number, enum BOOLEAN set_default_values);
static enum BOOLEAN ip_is_parameter_enabled (char *cptr_parameter_string);
static enum TEST rarp_configure_table_entry (char *cptr_iaddr_and_haddr_string, USHORT port_number);
/****************************************************************************/
enum TEST parse_and_build_reject_list_entries (char *cptr_ip_address_string)
{
	char *cptr_current_token;
	USHORT port_number[SIZE_OF_PORT_NUMBER];

	cptr_current_token = strtok (cptr_ip_address_string, ",");

	sscanf (cptr_current_token, "%02hu", (int *) &port_number[0]);

	cptr_current_token = strtok ((char *) '\0', ",;");

	if (cptr_current_token != NULL)
		{
		if (build_and_add_reject_list_entry (cptr_current_token, port_number[0]) == FAIL)
			{
			return (FAIL);
			}
		}
	else
		{
		return (FAIL);
		}

	do
		{
		cptr_current_token = strtok ((char *) '\0', ",;");

		if (cptr_current_token != NULL)
			{
			if (build_and_add_reject_list_entry (cptr_current_token, port_number[0]) == FAIL)
				{
				break;
				}
			}
		}
	while (cptr_current_token != NULL);

	return (PASS);
}
/****************************************************************************/
static enum TEST build_and_add_reject_list_entry (char *cptr_node_ip_address_string, USHORT port_number)
{
	BYTE ip_address_array[SIZE_OF_IP_ADDRESS];
	RIP_DESTINATION_ENTRY *sptr_destination_entry;

	sscanf (cptr_node_ip_address_string, "%03u.%03u.%03u.%03u",
		(int *) &ip_address_array[0], (int *) &ip_address_array[1], (int *) &ip_address_array[2], (int *) &ip_address_array[3]);

	sptr_destination_entry = (RIP_DESTINATION_ENTRY *) table_malloc (1, sizeof (RIP_DESTINATION_ENTRY));

	if (sptr_destination_entry == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALWAYS_PRINTF, "IP: CONFIGURATION: failed to build reject list entry (table_malloc failed)\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	sptr_destination_entry->ip_address = net_to_host_long (*((ULONG *) &ip_address_array[0]));

	add_entry_to_list ((LINK *) &ip.rip.port[port_number].reject_list, (LINK *) sptr_destination_entry);

	return (PASS);
}
/****************************************************************************/
enum TEST parse_and_build_advertise_list_entries (char *cptr_ip_address_string)
{
	char *cptr_current_token;
	USHORT port_number[SIZE_OF_PORT_NUMBER];

	cptr_current_token = strtok (cptr_ip_address_string, ",;");

	sscanf (cptr_current_token, "%02hu", (int *) &port_number[0]);

	cptr_current_token = strtok ((char *) '\0', ",;");

	if (cptr_current_token != NULL)
		{
		if (build_and_add_advertise_list_entry (cptr_current_token, port_number[0]) == FAIL)
			{
			return (FAIL);
			}
		}
	else
		{
		return (FAIL);
		}

	do
		{
		cptr_current_token = strtok ((char *) '\0', ",;");

		if (cptr_current_token != NULL)
			{
			if (build_and_add_advertise_list_entry (cptr_current_token, port_number[0]) == FAIL)
				{
				break;
				}
			}
		}
	while (cptr_current_token != NULL);

	return (PASS);
}
/****************************************************************************/
static enum TEST build_and_add_advertise_list_entry (char *cptr_node_ip_address_string, USHORT port_number)
{
	BYTE ip_address_array[SIZE_OF_IP_ADDRESS];
	RIP_DESTINATION_ENTRY *sptr_destination_entry;

	sscanf (cptr_node_ip_address_string, "%03ju.%03ju.%03ju.%03ju",
		(int *) &ip_address_array[0], (int *) &ip_address_array[1], (int *) &ip_address_array[2], (int *) &ip_address_array[3]);

	sptr_destination_entry = (RIP_DESTINATION_ENTRY *) table_malloc (1, sizeof (RIP_DESTINATION_ENTRY));

	if (sptr_destination_entry == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALWAYS_PRINTF, "IP: CONFIGURATION: failed to build advertise list entry (table_malloc failed)\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	sptr_destination_entry->ip_address = net_to_host_long (*((ULONG *) &ip_address_array[0]));

	add_entry_to_list ((LINK *) &ip.rip.port[port_number].advertise_list, (LINK *) sptr_destination_entry);

	return (PASS);
}
/****************************************************************************/
enum TEST parse_and_build_neighbor_list_entries (char *cptr_ip_address_string)
{
	char *cptr_current_token;

	cptr_current_token = strtok (cptr_ip_address_string, ",;");

	if (cptr_current_token != NULL)
		{
		if (build_and_add_neighbor_list_entry (cptr_current_token) == FAIL)
			{
			return (FAIL);
			}
		}
	else
		{
		return (FAIL);
		}

	do
		{
		cptr_current_token = strtok ((char *) '\0', ",;");

		if (cptr_current_token != NULL)
			{
			if (build_and_add_neighbor_list_entry (cptr_current_token) == FAIL)
				{
				break;
				}
			}
		}
	while (cptr_current_token != NULL);

	return (PASS);
}
/****************************************************************************/
static enum TEST build_and_add_neighbor_list_entry (char *cptr_node_ip_address_string)
{
	BYTE ip_address_array[SIZE_OF_IP_ADDRESS];
	RIP_NEIGHBOR_ENTRY *sptr_neighbor_entry;

	sscanf (cptr_node_ip_address_string, "%03ju.%03ju.%03ju.%03ju",
		(int *) &ip_address_array[0], (int *) &ip_address_array[1], (int *) &ip_address_array[2], (int *) &ip_address_array[3]);

	sptr_neighbor_entry = (RIP_NEIGHBOR_ENTRY *) table_malloc (1, sizeof (RIP_NEIGHBOR_ENTRY));

	if (sptr_neighbor_entry == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALWAYS_PRINTF, "IP: CONFIGURATION: failed to build neighbor list entry (table_malloc failed)\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	sptr_neighbor_entry->ip_address = net_to_host_long ( *((ULONG *) &ip_address_array[0]));

	add_entry_to_list ((LINK *) &ip.rip.neighbor_list, (LINK *) sptr_neighbor_entry);

	++ip.rip.number_of_neighbor_list_entries;

	return (PASS);
}
/****************************************************************************/
enum TEST parse_and_build_static_route_table_entries (char *cptr_ip_address_string)
{
	char *cptr_current_token;

	cptr_current_token = strtok (cptr_ip_address_string, ";");

	if (cptr_current_token != NULL)
		{
		if (set_ip_static_route (cptr_current_token) == FAIL)
			{
			return (FAIL);
			}
		}
	else
		{
		return (FAIL);
		}

	do
		{
		cptr_current_token = strtok ((char *) '\0', ";");

		if (cptr_current_token != NULL)
			{
			if (set_ip_static_route (cptr_current_token) == FAIL)
				{
				break;
				}
			}
		}
	while (cptr_current_token != NULL);

	return (PASS);
}
/****************************************************************************/
enum TEST parse_and_build_rarp_server_table_entries (char *cptr_ip_address_string)
{
	char *cptr_current_token;
	USHORT port_number[SIZE_OF_PORT_NUMBER];

	cptr_current_token = strtok (cptr_ip_address_string, ",");

	sscanf (cptr_current_token, "%02hu", (int *) &port_number[0]);

	cptr_current_token = strtok ((char *) '\0', ";");

	if (cptr_current_token != NULL)
		{
		if (rarp_configure_table_entry (cptr_current_token, port_number[0]) == FAIL)
			{
			return (FAIL);
			}
		}
	else
		{
		return (FAIL);
		}

	do
		{
		cptr_current_token = strtok ((char *) '\0', ";");

		if (cptr_current_token != NULL)
			{
			if (rarp_configure_table_entry (cptr_current_token, port_number[0]) == FAIL)
				{
				break;
				}
			}
		}
	while (cptr_current_token != NULL);

	return (PASS);
}
/*************************************************************************/
static enum TEST rarp_configure_table_entry (char *cptr_iaddr_and_haddr_string, USHORT port_number)
{
	BYTE ip_address_array[SIZE_OF_IP_ADDRESS];
	BYTE hardware_address_array[SIZE_OF_MAC_ADDRESS];

	sscanf (cptr_iaddr_and_haddr_string, "%03ju.%03ju.%03ju.%03ju, %02x%02x%02x%02x%02x%02x",
		(int *) &ip_address_array[0], (int *) &ip_address_array[1], (int *) &ip_address_array[2], (int *) &ip_address_array[3],
		(int *) &hardware_address_array[0], (int *) &hardware_address_array[1], (int *) &hardware_address_array[2],
		(int *) &hardware_address_array[3], (int *) &hardware_address_array[4], (int *) &hardware_address_array[5]);

	*((ULONG *) &ip_address_array[0]) = net_to_host_long (*((ULONG *) &ip_address_array[0]));

	if (add_rarp_table_entry (port_number, *((ULONG *) &ip_address_array[0]), (MAC_ADDRESS *) &hardware_address_array[0])
		== NULL)
		{
		return (FAIL);
		}

	return (PASS);
}
/****************************************************************************/
enum TEST set_ip_default_values (char *cptr_value_string)
{
	if (ip_is_parameter_enabled (cptr_value_string) == TRUE)
		{
		ip.mib.ipForwarding = TRUE;
		ip.mib.ipDefaultTTL = DEFAULT_TTL;
		ip.mib.ipReasmTimeout = DEFAULT_IP_REASSEMBLY_TIMEOUT;
		ip.icmp.mask_request_timeout = DEFAULT_ICMP_MASK_REQUEST_TIMEOUT;

		set_ip_default_values_for_port (NO_SUCH_PORT);

		set_rip_protocol_and_default_values (TRUE);

		ip.default_values_have_been_set = TRUE;
		}

	return (PASS);
}
/****************************************************************************/
static void set_ip_default_values_for_port (USHORT port_number)
{
	if (port_number == NO_SUCH_PORT)
		{
		for (port_number = 0x0000; port_number < NUMBER_OF_IP_PORTS; ++port_number)
			{
			ip.port[port_number].config.metric = 0x01;
			ip.port[port_number].config.mtu = 1500;
			ip.port[port_number].config.lsl_packet_type = ETHERNET_TYPE_II;
			ip.port[port_number].config.icmp_mask_request_enabled = TRUE;
			ip.port[port_number].config.icmp_mask_reply_enabled = TRUE;
			ip.port[port_number].config.icmp_redirect_enabled = TRUE;
			ip.port[port_number].config.arp_enabled = TRUE;
			ip.port[port_number].config.maximum_reassembly_size = DEFAULT_IP_MAXIMUM_REASSEMBLY_SIZE;
			ip.arp.port[port_number].config.cache_timeout = DEFAULT_ARP_CACHE_TIMEOUT;
			ip.arp.port[port_number].config.reply_timeout = DEFAULT_ARP_REPLY_TIMEOUT;
			ip.arp.port[port_number].config.number_of_retries = DEFAULT_MAXIMUM_NUMBER_OF_RETRIES;
			}
		}
	else
		{
		ip.port[port_number].config.metric = 0x01;
		ip.port[port_number].config.mtu = 1500;
		ip.port[port_number].config.lsl_packet_type = ETHERNET_TYPE_II;
		ip.port[port_number].config.icmp_mask_request_enabled = TRUE;
		ip.port[port_number].config.icmp_mask_reply_enabled = TRUE;
		ip.port[port_number].config.icmp_redirect_enabled = TRUE;
		ip.port[port_number].config.arp_enabled = TRUE;
		ip.port[port_number].config.maximum_reassembly_size = DEFAULT_IP_MAXIMUM_REASSEMBLY_SIZE;
		ip.arp.port[port_number].config.cache_timeout = DEFAULT_ARP_CACHE_TIMEOUT;
		ip.arp.port[port_number].config.reply_timeout = DEFAULT_ARP_REPLY_TIMEOUT;
		ip.arp.port[port_number].config.number_of_retries = DEFAULT_MAXIMUM_NUMBER_OF_RETRIES;
		}
}
/****************************************************************************/
void set_rip_protocol_and_default_values (enum BOOLEAN set_default_values)
{
	if (set_default_values == TRUE)
		{
		ip.rip.config.update_time_interval = DEFAULT_RIP_RESPONSE_INTERVAL;
		ip.rip.config.route_aging_timeout_value = DEFAULT_RIP_ROUTE_AGING_TIME;
		ip.rip.config.route_garbage_collection_timeout_value = DEFAULT_RIP_GARBAGE_COLLECTION_TIMEOUT;
		ip.rip.config.minimum_ttl = 0x01;

		set_rip_default_values_for_port (NO_SUCH_PORT, set_default_values);
		}
	else
		{
		ip.rip.config.update_time_interval = 0x0000;
		ip.rip.config.route_aging_timeout_value = 0x0000;
		ip.rip.config.route_garbage_collection_timeout_value = 0x0000;
		ip.rip.config.minimum_ttl = 0x00;
		}
}
/****************************************************************************/
static void set_rip_default_values_for_port (USHORT port_number, enum BOOLEAN set_default_values)
{
	if (set_default_values == TRUE)
		{
		if (port_number == NO_SUCH_PORT)
			{
			for (port_number = 0x0000; port_number < NUMBER_OF_IP_PORTS; ++port_number)
				{
				ip.rip.port[port_number].send_requests = TRUE;
				ip.rip.port[port_number].send_response_updates = TRUE;
				ip.rip.port[port_number].route_summarization_enabled = TRUE;
				ip.rip.port[port_number].route_holddown_enabled = FALSE;
				ip.rip.port[port_number].split_horizon_enabled = TRUE;
				ip.rip.port[port_number].poison_reverse_enabled = TRUE;
				ip.rip.port[port_number].announce_default_route_enabled = TRUE;
				ip.rip.port[port_number].announce_host_routes_enabled = TRUE;
				}
			}
		else
			{
			ip.rip.port[port_number].send_requests = TRUE;
			ip.rip.port[port_number].send_response_updates = TRUE;
			ip.rip.port[port_number].route_summarization_enabled = TRUE;
			ip.rip.port[port_number].route_holddown_enabled = FALSE;
			ip.rip.port[port_number].split_horizon_enabled = TRUE;
			ip.rip.port[port_number].poison_reverse_enabled = TRUE;
			ip.rip.port[port_number].announce_default_route_enabled = TRUE;
			ip.rip.port[port_number].announce_host_routes_enabled = TRUE;
			}
		}
	else
		{
		for (port_number = 0x0000; port_number < NUMBER_OF_IP_PORTS; ++port_number)
			{
			ip.rip.port[port_number].send_requests = FALSE;
			ip.rip.port[port_number].send_response_updates = FALSE;
			ip.rip.port[port_number].route_summarization_enabled = FALSE;
			ip.rip.port[port_number].route_holddown_enabled = FALSE;
			ip.rip.port[port_number].split_horizon_enabled = FALSE;
			ip.rip.port[port_number].poison_reverse_enabled = FALSE;
			ip.rip.port[port_number].announce_default_route_enabled = FALSE;
			ip.rip.port[port_number].announce_host_routes_enabled = FALSE;
			}
		}
}
/****************************************************************************/
static enum BOOLEAN ip_is_parameter_enabled (char *cptr_parameter_string)
{
	if (strstr (strlwr (cptr_parameter_string), "enable") != NULL)
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
