#include	"defs.h"
/*
 * $Log: /IP/IPPRINT.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipprint.c$  $version: 1.9$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 03/10/94 yarran Add printf for MEMORY and DATA.
1.4 05/02/94 yarran added rfc1042 changes.
1.5 09/01/94 ross added BYTE and USHORT_ENUM support.
1.6 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.7 01/17/95 ross fixed arp problems from snmp
1.8 01/26/95 ross SNMP name change, printf change.
1.9 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<stdio.h>
#include	<stdarg.h>
#include	"ip.h"
#include "vipprint.h"
/*************************************************************************/
static void set_protocol_print_string (enum IP_PRINTF_GROUPS printf_group, enum BOOLEAN *eptr_print_string);
static void set_normal_print_string (enum IP_PRINTF_GROUPS printf_group, enum BOOLEAN *eptr_print_string);
/*************************************************************************/
void enable_or_disable_ip_printing (enum BOOLEAN enable_or_disable)
{
	ip.print_class.ip_print_switch_on = (BYTE_ENUM (BOOLEAN)) enable_or_disable;
}
/*************************************************************************/
void enable_or_disable_ip_group_printing (enum BOOLEAN enable_or_disable, enum IP_PRINTF_GROUPS printf_group)
{
	switch (printf_group)
		{
		case IP_PRINTF:

			ip.print_class.ip_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_ROUTE_PRINTF:

			ip.print_class.ip_route_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_CACHE_PRINTF:

			ip.print_class.ip_cache_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_TX_PRINTF:

			ip.print_class.tx_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_RX_PRINTF:

			ip.print_class.rx_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_FRAGMENT_PRINTF:

			ip.print_class.fragment_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_REASSEMBLY_PRINTF:

			ip.print_class.reassembly_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_RIP_PRINTF:

			ip.print_class.rip_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case ICMP_PRINTF:

			ip.print_class.icmp_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case ARP_PRINTF:

			ip.print_class.arp_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case RARP_PRINTF:

			ip.print_class.rarp_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case UDP_PRINTF:

			ip.print_class.udp_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_ALARM_PRINTF:

			ip.print_class.alarm_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_DIAGNOSTIC_PRINTF:

			ip.print_class.diagnostic_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_MEMORY_PRINTF:

			ip.print_class.memory_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;

		case IP_DATA_PRINTF:

			ip.print_class.data_printing_enabled = (BYTE_ENUM (BOOLEAN)) enable_or_disable;

			break;
		}
}
/*************************************************************************/
/* Select from an array of strings, or return ascii number if out of range */

char *select_print_message (char *cptr_print_array[], USHORT total_messages, USHORT message_index)
{
	char *cptr;

	if ((message_index < total_messages) && (cptr_print_array[message_index] != (char *) NULL))
		{
		return (cptr_print_array[message_index]);
		}
	else
		{
		sprintf (&ip.print_buffer[0], "%u", message_index);

		cptr = &ip.print_buffer[0];

		return (cptr);
		}
}
/*************************************************************************/
char *select_print_ip_message (char *cptr_print_array[], USHORT total_messages, USHORT message_index, ULONG destination_address)
{
	char *cptr;

	if ((message_index < total_messages) && (cptr_print_array[message_index] != (char *) NULL))
		{
		sprintf ((char *) &ip.print_buffer[0], cptr_print_array[message_index], 
			convert_ip_address_to_dot_format (&ip.print_buffer_3[0], destination_address));
		}
	else
		{
		sprintf ((char *) &ip.print_buffer[0], "%u", message_index);
		}

	cptr = (char *) &ip.print_buffer[0];

	return (cptr);
}
/*************************************************************************/
void ip_printf (enum IP_PRINTF_GROUPS printf_group, const char *cptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr, cptr_format);

	if (ip.print_class.ip_print_switch_on == FALSE)
		{
		va_end (argptr);

		return;
		}

	switch (printf_group)
		{
		case IP_PRINTF:
		case IP_ROUTE_PRINTF:
		case IP_CACHE_PRINTF:
		case IP_TX_PRINTF:
		case IP_RX_PRINTF:
		case IP_FRAGMENT_PRINTF:
		case IP_REASSEMBLY_PRINTF:
		case IP_RIP_PRINTF:
		case ICMP_PRINTF:
		case ARP_PRINTF:
		case RARP_PRINTF:
		case UDP_PRINTF:

			set_protocol_print_string (printf_group, &print_string);

			break;

		case IP_ALARM_PRINTF:
		case IP_DIAGNOSTIC_PRINTF:
		case IP_MEMORY_PRINTF:
		case IP_DATA_PRINTF:

			set_normal_print_string (printf_group, &print_string);

			break;

		case IP_ALWAYS_PRINTF:

			print_string = TRUE;

			break;

      case IP_DNS_PRINTF:

         print_string = ip.print_class.dns_printing_enabled ;
         break;

		default:

			print_string = FALSE;

			break;
		}

	if (print_string == TRUE)
		{
		vprintf (cptr_format, argptr);
		}

	va_end (argptr);
}
/*************************************************************************/
static void set_protocol_print_string (enum IP_PRINTF_GROUPS printf_group, enum BOOLEAN *eptr_print_string)
{
	switch (printf_group)
		{
		case IP_PRINTF:

			*eptr_print_string = ip.print_class.ip_printing_enabled;

			break;

		case IP_ROUTE_PRINTF:

			*eptr_print_string = ip.print_class.ip_route_printing_enabled;

			break;

		case IP_CACHE_PRINTF:

			*eptr_print_string = ip.print_class.ip_cache_printing_enabled;

			break;

		case IP_TX_PRINTF:

			*eptr_print_string = ip.print_class.tx_printing_enabled;

			break;

		case IP_RX_PRINTF:

			*eptr_print_string = ip.print_class.rx_printing_enabled;

			break;

		case IP_FRAGMENT_PRINTF:

			*eptr_print_string = ip.print_class.fragment_printing_enabled;

			break;

		case IP_REASSEMBLY_PRINTF:

			*eptr_print_string = ip.print_class.reassembly_printing_enabled;

			break;

		case IP_RIP_PRINTF:

			*eptr_print_string = ip.print_class.rip_printing_enabled;

			break;

		case ICMP_PRINTF:

			*eptr_print_string = ip.print_class.icmp_printing_enabled;

			break;

		case ARP_PRINTF:

			*eptr_print_string = ip.print_class.arp_printing_enabled;

			break;

		case RARP_PRINTF:

			*eptr_print_string = ip.print_class.rarp_printing_enabled;

			break;

		case UDP_PRINTF:

			*eptr_print_string = ip.print_class.udp_printing_enabled;

			break;

		default:

			*eptr_print_string = FALSE;

			break;
		}
}
/*************************************************************************/
static void set_normal_print_string (enum IP_PRINTF_GROUPS printf_group, enum BOOLEAN *eptr_print_string)
{
	switch (printf_group)
		{
		case IP_ALARM_PRINTF:

			*eptr_print_string = ip.print_class.alarm_printing_enabled;

			break;

		case IP_DIAGNOSTIC_PRINTF:

			*eptr_print_string = ip.print_class.diagnostic_printing_enabled;

			break;

		case IP_MEMORY_PRINTF:

			*eptr_print_string = ip.print_class.memory_printing_enabled;

			break;

		case IP_DATA_PRINTF:

			*eptr_print_string = ip.print_class.data_printing_enabled;

			break;

		default:

			*eptr_print_string = FALSE;

			break;
		}
}
/*************************************************************************/
void ip_print_protocol_statistics (void)
{
	ip_printf (IP_PRINTF, "IP PROTOCOL STATISTICS:\n");

	if (ip.statistics.number_of_packets_that_couldnot_be_forwarded > 0x0)
		{
		ip_printf (IP_PRINTF, "   number of packets that could not be forwarded : %u\n",
			ip.statistics.number_of_packets_that_couldnot_be_forwarded);
		}

	if (ip.statistics.number_of_times_out_of_memory_while_allocating_ip_packet > 0x0)
		{
		ip_printf (IP_PRINTF, "   number of times out of memory while allocating ip packet : %u\n",
			ip.statistics.number_of_times_out_of_memory_while_allocating_ip_packet);
		}

	if (ip.statistics.total_transport_buffers_allocated > 0x0)
		{
		ip_printf (IP_PRINTF, "   total number of transport buffers allocated : %u\n",
			ip.statistics.total_transport_buffers_allocated);
		}

	if (ip.statistics.outstanding_transport_ip_list_packets > 0x0)
		{
		ip_printf (IP_PRINTF, "   outstanding transport ip list packets : %u\n",
			ip.statistics.outstanding_transport_ip_list_packets);
		}

	if (ip.statistics.number_of_packets_routed_by_igrp > 0x0)
		{
		ip_printf (IP_PRINTF, "   number of packets routed by igrp : %u\n", ip.statistics.number_of_packets_routed_by_igrp);
		}

	if (ip.statistics.number_of_packets_routed_by_some_other_transport_protocol > 0x0)
		{
		ip_printf (IP_PRINTF, "   number of packets routed by some other transport protocol : %u\n",
			ip.statistics.number_of_packets_routed_by_some_other_transport_protocol);
		}

	if (ip.statistics.number_of_packets_routed_by_rip > 0x0)
		{
		ip_printf (IP_PRINTF, "   number of packets routed by rip : %u\n", ip.statistics.number_of_packets_routed_by_rip);
		}

	if (ip.statistics.number_of_packets_for_which_no_routes_were_found > 0x0)
		{
		ip_printf (IP_PRINTF, "   number of packets for which no routes were found : %u\n",
			ip.statistics.number_of_packets_for_which_no_routes_were_found);
		}
}
/*************************************************************************/
void ip_print_port_statistics (void)
{
	USHORT port_number;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if (ip.port[port_number].config.port_enabled == FALSE)
			{
			continue;
			}

		ip_printf (IP_PRINTF, "IP PORT STATISTICS:\n");

		ip_printf (IP_PRINTF, "   PORT: %u:\n", port_number);

		if (ip.port[port_number].statistics.number_of_ip_packets_rxed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of ip packets rxed : %u\n",
				ip.port[port_number].statistics.number_of_ip_packets_rxed);
			}

		if (ip.port[port_number].statistics.number_of_arp_packets_rxed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of arp packets rxed : %u\n",
				ip.port[port_number].statistics.number_of_arp_packets_rxed);
			}

		if (ip.port[port_number].statistics.number_of_rarp_packets_rxed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of rarp packets rxed : %u\n",
				ip.port[port_number].statistics.number_of_rarp_packets_rxed);
			}

		if (ip.port[port_number].statistics.number_of_non_ip_packets_rxed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of non ip packets rxed : %u\n",
				ip.port[port_number].statistics.number_of_non_ip_packets_rxed);
			}

		if (ip.port[port_number].statistics.number_of_packets_rxed_on_disabled_port > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of packets rxed on disabled port : %u\n",
				ip.port[port_number].statistics.number_of_packets_rxed_on_disabled_port);
			}

		if (ip.port[port_number].statistics.number_of_icmp_packets_rxed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of icmp packets rxed : %u\n",
				ip.port[port_number].statistics.number_of_icmp_packets_rxed);
			}

		if (ip.port[port_number].statistics.number_of_udp_packets_rxed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of udp packets rxed : %u\n",
				ip.port[port_number].statistics.number_of_udp_packets_rxed);
			}

		if (ip.port[port_number].statistics.number_of_tcp_packets_rxed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of tcp packets rxed : %u\n",
				ip.port[port_number].statistics.number_of_tcp_packets_rxed);
			}

		if (ip.port[port_number].statistics.number_of_igrp_packets_rxed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of igrp packets rxed : %u\n",
				ip.port[port_number].statistics.number_of_igrp_packets_rxed);
			}

		if (ip.port[port_number].statistics.number_of_unrecognized_packets_rxed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of unrecognized packets rxed : %u\n",
				ip.port[port_number].statistics.number_of_unrecognized_packets_rxed);
			}

		if (ip.port[port_number].statistics.number_of_rxed_packets_forwarded > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of rxed packets forwarded : %u\n",
				ip.port[port_number].statistics.number_of_rxed_packets_forwarded);
			}

		if (ip.port[port_number].statistics.number_of_rxed_icmp_packets_forwarded > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of rxed icmp packets forwarded : %u\n",
				ip.port[port_number].statistics.number_of_rxed_icmp_packets_forwarded);
			}

		if (ip.port[port_number].statistics.number_of_rxed_udp_packets_forwarded > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of rxed udp packets forwarded : %u\n",
				ip.port[port_number].statistics.number_of_rxed_udp_packets_forwarded);
			}

		if (ip.port[port_number].statistics.number_of_rxed_tcp_packets_forwarded > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of rxed tcp packets forwarded : %u\n",
				ip.port[port_number].statistics.number_of_rxed_tcp_packets_forwarded);
			}

		if (ip.port[port_number].statistics.number_of_rxed_unrecognized_packets_forwarded > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of rxed unrecognized packets forwarded : %u\n",
				ip.port[port_number].statistics.number_of_rxed_unrecognized_packets_forwarded);
			}

		if (ip.port[port_number].statistics.number_of_packets_not_forwarded > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of packets not forwarded : %u\n",
				ip.port[port_number].statistics.number_of_packets_not_forwarded);
			}

		if (ip.port[port_number].statistics.number_of_rxed_packets_filtered > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of rxed packets filtered : %u\n",
				ip.port[port_number].statistics.number_of_rxed_packets_filtered);
			}

		if (ip.port[port_number].statistics.number_of_txed_packets_filtered > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of txed packets filtered : %u\n",
				ip.port[port_number].statistics.number_of_txed_packets_filtered);
			}

		if (ip.port[port_number].statistics.number_of_short_ip_packets_received > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of short ip packets received : %u\n",
				ip.port[port_number].statistics.number_of_short_ip_packets_received);
			}

		if (ip.port[port_number].statistics.number_of_ip_packets_txed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of ip packets txed : %u\n",
				ip.port[port_number].statistics.number_of_ip_packets_txed);
			}

		if (ip.port[port_number].statistics.number_of_icmp_packets_txed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of icmp packets txed : %u\n",
				ip.port[port_number].statistics.number_of_icmp_packets_txed);
			}

		if (ip.port[port_number].statistics.number_of_udp_packets_txed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of udp packets txed : %u\n",
				ip.port[port_number].statistics.number_of_udp_packets_txed);
			}

		if (ip.port[port_number].statistics.number_of_tcp_packets_txed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of tcp packets txed : %u\n",
				ip.port[port_number].statistics.number_of_tcp_packets_txed);
			}

		if (ip.port[port_number].statistics.number_of_igrp_packets_txed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of igrp packets txed : %u\n",
				ip.port[port_number].statistics.number_of_igrp_packets_txed);
			}

		if (ip.port[port_number].statistics.number_of_unrecognized_packets_txed > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of unrecognized packets txed : %u\n",
				ip.port[port_number].statistics.number_of_unrecognized_packets_txed);
			}

		if (ip.port[port_number].statistics.number_of_packets_redirected > 0x0)
			{
			ip_printf (IP_PRINTF, "      number of packets redirected : %u\n",
				ip.port[port_number].statistics.number_of_packets_redirected);
			}
		}
}
