/* This c files contains the functions of RED-BLACK tree for Inserting,
	Deleting, Search,etc.. the DESCRIPTOR_FOR_USER_DATABASE
*/

#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>

#include <redblack.h>
#include "iprb.h"


DESCRIPTOR_FOR_USER_DATABASE_NODE *sptr_descriptor_for_user_database_tree;
extern char *status_debug_convert_ip_address_to_dot_format (char *cptr_array_to_store_dot_format_address, ULONG ip_address);

static DESCRIPTOR_FOR_USER_DATABASE_NODE *get_new_descriptor_rb_node ()
{
	return ((DESCRIPTOR_FOR_USER_DATABASE_NODE *) malloc (sizeof (DESCRIPTOR_FOR_USER_DATABASE_NODE))) ;
}

int descriptor_RB_demo_insert_node(DESCRIPTOR_FOR_USER_DATABASE_NODE *Tree, DESCRIPTOR_FOR_USER_DATABASE_KEY_TYPE  key, DESCRIPTOR_FOR_USER_DATABASE *info, DESCRIPTOR_FOR_USER_DATABASE_NODE **ptr_sptr_new_node)
{
	DESCRIPTOR_FOR_USER_DATABASE_NODE *nptr ;

	int retVal ;

	retVal = descriptor_rb_demo_compare_key(Tree, key);	 

	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (descriptor_RB_demo_insert_node ((DESCRIPTOR_FOR_USER_DATABASE_NODE *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_descriptor_rb_node() ;
			if (nptr == NULL)
			{
				return DESCRIPTOR_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
	
			nptr->key = key ;
			nptr->info = info ;
		
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER *)nptr ;

			return DESCRIPTOR_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
			return (descriptor_RB_demo_insert_node ((DESCRIPTOR_FOR_USER_DATABASE_NODE *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_descriptor_rb_node() ;
			if (nptr == NULL)
			{
				return DESCRIPTOR_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;

			nptr->key = key ;
			nptr->info = info ;

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER *) nptr ;

			return DESCRIPTOR_RB_NEW_ENTRY ;
		}
	}

	return DESCRIPTOR_RB_UPDATED ;
}

int descriptor_RB_demo_insert(DESCRIPTOR_FOR_USER_DATABASE_KEY_TYPE key, DESCRIPTOR_FOR_USER_DATABASE *info)
{
	DESCRIPTOR_FOR_USER_DATABASE_NODE *nptr, *sptr_new_node ;
	int retVal ;

	if (sptr_descriptor_for_user_database_tree == (DESCRIPTOR_FOR_USER_DATABASE_NODE *)sptr_RB_sentinal_node)
	{
		nptr = get_new_descriptor_rb_node() ;

		if (nptr == NULL)
			return DESCRIPTOR_RB_INSERT_OVERFLOW ;

		nptr->key = key ;
		nptr->info = info ;

		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_descriptor_for_user_database_tree = nptr ;

		return DESCRIPTOR_RB_NEW_ENTRY ;
	}

	retVal = descriptor_RB_demo_insert_node (sptr_descriptor_for_user_database_tree, key, info, &sptr_new_node) ;

	if (retVal == DESCRIPTOR_RB_NEW_ENTRY)
	{
		sptr_descriptor_for_user_database_tree = (DESCRIPTOR_FOR_USER_DATABASE_NODE *) RB_red_balance ((RED_BLACK_NODE_HEADER *)sptr_new_node, (RED_BLACK_NODE_HEADER *)sptr_descriptor_for_user_database_tree) ;
	}

	return retVal ;
}

void add_entry_to_descriptor_rb_tree (DESCRIPTOR_FOR_USER_DATABASE *user_info,unsigned char *vptr_buffer)
{
	DESCRIPTOR_FOR_USER_DATABASE *info;

	if (sptr_descriptor_for_user_database_tree == NULL)
		sptr_descriptor_for_user_database_tree = (DESCRIPTOR_FOR_USER_DATABASE_NODE *) sptr_RB_sentinal_node;

	info = user_info;

   descriptor_RB_demo_insert (*((DESCRIPTOR_FOR_USER_DATABASE_KEY_TYPE *)(vptr_buffer)), info) ;
}


DESCRIPTOR_FOR_USER_DATABASE_NODE *descriptor_rb_demo_search(DESCRIPTOR_FOR_USER_DATABASE_NODE *Tree, DESCRIPTOR_FOR_USER_DATABASE_KEY_TYPE key)
{
	int ret_val ;
	
	if (Tree == NULL)
		return NULL ;

	if (Tree == (DESCRIPTOR_FOR_USER_DATABASE_NODE  *)sptr_RB_sentinal_node)
		return NULL ;

	ret_val = descriptor_rb_demo_compare_key(Tree, key);	 

	if (ret_val < 0)
	{
		return descriptor_rb_demo_search ((DESCRIPTOR_FOR_USER_DATABASE_NODE *)Tree->rb_header.RChild, key) ;
	}
	else if (ret_val > 0)
	{	
	 	return descriptor_rb_demo_search((DESCRIPTOR_FOR_USER_DATABASE_NODE *)Tree->rb_header.LChild, key) ;
	}
	else
	{
 		return Tree ;
 	}
}

int delete_entry_from_descriptor_rb_tree (DESCRIPTOR_FOR_USER_DATABASE_KEY_TYPE key)
{
   DESCRIPTOR_FOR_USER_DATABASE_NODE *sptr_node_to_delete ;

   sptr_node_to_delete = descriptor_rb_demo_search (sptr_descriptor_for_user_database_tree, key) ;

   if (sptr_node_to_delete)
   {
      sptr_descriptor_for_user_database_tree = RB_delete ((RED_BLACK_NODE_HEADER *)sptr_descriptor_for_user_database_tree, (RED_BLACK_NODE_HEADER *)sptr_node_to_delete, (unsigned long) sizeof (DESCRIPTOR_FOR_USER_DATABASE_NODE), (RED_BLACK_NODE_HEADER **)&sptr_node_to_delete) ;
		free(sptr_node_to_delete);
      return (1) ;
   }
   return (0) ;
}


int descriptor_rb_demo_compare_key ( DESCRIPTOR_FOR_USER_DATABASE_NODE *Tree, DESCRIPTOR_FOR_USER_DATABASE_KEY_TYPE key)
{
	if(Tree->key.source_address == key.source_address)
	{
		if(Tree->key.source_port == key.source_port)
		{
			if(Tree->key.destination_port == key.destination_port)
					return 0;
			else
				return(Tree->key.destination_port - key.destination_port);
		}
		else
			return(Tree->key.source_port - key.source_port);
	}
	else
		return(Tree->key.source_address - key.source_address);			
}


void age_descriptor_rb_tree ()
{
	DESCRIPTOR_FOR_USER_DATABASE_NODE *sptr_temp, *sptr_next_node ;

	if(sptr_descriptor_for_user_database_tree == NULL)
		return;

	sptr_next_node = (DESCRIPTOR_FOR_USER_DATABASE_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_descriptor_for_user_database_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;
      sptr_next_node = (DESCRIPTOR_FOR_USER_DATABASE_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;

      if (sptr_temp->info->age_timer)
      {
         sptr_temp->info->age_timer-- ;
      }
      else
      {
         sptr_descriptor_for_user_database_tree = (DESCRIPTOR_FOR_USER_DATABASE_NODE *)
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_descriptor_for_user_database_tree,
				          (RED_BLACK_NODE_HEADER *)sptr_temp,
                      (unsigned long) sizeof (DESCRIPTOR_FOR_USER_DATABASE_NODE),
                      (RED_BLACK_NODE_HEADER **)&sptr_temp) ;
			free(sptr_temp);
      }
   }
}

void display_descriptor_tree ()
{
	int index=0 ;
   BYTE source_address_string[50];
   BYTE destination_address_string[50];

	DESCRIPTOR_FOR_USER_DATABASE_NODE  *sptr_root = sptr_descriptor_for_user_database_tree, *sptr_next_node;

	if(sptr_descriptor_for_user_database_tree == NULL)
		return;

	sptr_next_node = (DESCRIPTOR_FOR_USER_DATABASE_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	if (sptr_next_node == NULL)
	{
		printf("\n The Descriptor for User database Tree is empty ") ;
		return;
	}

	printf ("\n **");
	printf ("\n        Descriptor for User database     			  ") ;
	printf ("\n **");

	while (sptr_next_node)
	{
		printf ("\n [%s] [%s] [%d] [%d] ", status_debug_convert_ip_address_to_dot_format(source_address_string, sptr_next_node->info->source_address),
													  status_debug_convert_ip_address_to_dot_format(destination_address_string, sptr_next_node->info->destination_address),
													  sptr_next_node->info->source_port, sptr_next_node->info->destination_port); 														

		++index ;
					
		sptr_next_node = (DESCRIPTOR_FOR_USER_DATABASE_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}

	printf ("\n **");
	printf ("\n         Number of Entries  : %d    ", index);
	printf ("\n **\n\n");
}

