/*--------------------------------------------------------------------------*\

Changes History : 

	{sudha 04-Jan-2000. route_ip_rx_packet() function - Firewall routing 
		scheme}
	{sudha 22-Jan-2000. route_ip_rx_packet() function - Trace Route support}
	{sudha 02-Feb-2000. route_ip_rx_packet() function - NAT pasv FTP support}
	{sudha 07-Feb-2000. route_ip_rx_packet() function - virtual server loopback
		support}

\*--------------------------------------------------------------------------*/

#include	"defs.h"


/*
 * $Log: /IP/IPRX.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: iprx.c$  $version: 1.16$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/09/94 yarran fix reassembly bug
1.4 02/22/94 yarran Fix i960 compiler error for header.vptr_data casting
1.5 02/28/94 yarran Change route, port flags from bit map to enum BOOLEAN.
1.6 03/01/94 yarran Split iprx.c to multiple files.
1.7 03/17/94 yarran Change type_of_service type.
1.8 05/02/94 yarran added rfc1042 changes.
1.9 07/06/94 ross fixed time to live bug with count of one.
1.10 09/22/94 ross
1.11 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.12 11/04/94 ross remote access testing and fixes.
1.13 12/20/94 ross
1.14 01/17/95 ross fixed arp problems from snmp
1.15 06/29/95 ross new snmp access routine
1.16 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdio.h>
#include "ip.h"
#include "..\..\rwutils\evntstr.h"
#ifdef IP_FILTERING
#include "ipfilt.h"
#endif


#if IP_DEBUG
   extern int ip_debugger_on;
#endif

/****************************************************************************/
static enum BOOLEAN is_received_packet_recognized (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet, USHORT size_of_packet,
	LSL_IP_HEADER *sptr_lsl_packet, enum IP_PACKET_STATE *eptr_return_code);
static enum IP_PACKET_STATE route_ip_rx_packet (USHORT rx_port_number, UNION_IP_PACKET *uptr_ip_rx_packet,
	USHORT number_of_bytes_rxed);
static enum TEST verify_ip_rx_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	IP_PORT_CLASS *sptr_incoming_port, IP_ROUTE_ENTRY **sptr_route_entry, enum BOOLEAN *eptr_source_route_flag,
	enum BOOLEAN *eptr_need_new_checksum, enum BOOLEAN *eptr_change_ip_destination_for_source_route,
	USHORT *usptr_processed_option_length, USHORT *usptr_number_of_bytes_rxed);
static enum BOOLEAN check_if_ip_packet_length_and_header_length_and_checksum_are_valid (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_ip_packet, USHORT *usptr_number_of_bytes_rxed, IP_PORT_CLASS *sptr_incoming_port);
static enum BOOLEAN check_if_ip_version_is_valid (IP_PARAMETERS *sptr_ip_parameters);
static void	send_icmp_source_quench_message_if_memory_is_low (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	IP_PORT_CLASS *sptr_incoming_port);
static void	adjust_number_of_bytes_received_and_initialize_certain_fields (IP_PARAMETERS *sptr_ip_parameters,
	USHORT *usptr_number_of_bytes_rxed, enum BOOLEAN *eptr_source_route_flag, enum BOOLEAN *eptr_need_new_checksum,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route);
enum BOOLEAN check_if_packet_is_destined_to_us (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet,
	IP_PARAMETERS *sptr_ip_parameters);
static enum BOOLEAN check_if_ip_rx_packet_is_to_be_forwarded (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_ip_packet, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, enum BOOLEAN source_route_flag,
	IP_PORT_CLASS *sptr_incoming_port, USHORT processed_option_length);

/* Added by Ravi on 24 Nov 1999 */
static enum TEST check_for_fragmented_packet (IP_PARAMETERS *sptr_ip_parameters);

/*	Kamalnath 12\02\1997 Removed static to call from iprxbc.c */
enum BOOLEAN check_if_time_to_live_field_in_ip_packet_is_valid (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT processed_option_length);
/* Kamalnath 12\02\1997 */
/*
static enum BOOLEAN check_if_time_to_live_field_in_ip_packet_is_valid (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT processed_option_length);
*/
static enum TEST get_route_on_which_to_forward_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet,
	IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, IP_PORT_CLASS *sptr_incoming_port, USHORT processed_option_length);
static void	send_redirect_icmp_if_necessary (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_ROUTE_ENTRY *sptr_route_entry, enum BOOLEAN source_route_flag,
	IP_PORT_CLASS *sptr_incoming_port);
#ifdef __IP_DEBUG__
static void print_rxed_mac_header (LSL_IP_HEADER *sptr_lsl_header);
#endif /* __IP__DEBUG__ */

/* sudhir 11//7/97 for proxy  */
enum BOOLEAN is_proxy_response_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, ULONG *client_ip_address, USHORT *destination_port, enum IP_PROTOCOL_VALUE *, USHORT *, void *);
extern enum BOOLEAN check_if_packet_is_to_be_proxied (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *, enum BOOLEAN *, USHORT, enum IP_PROTOCOL_VALUE *, USHORT *, void **, enum BOOLEAN *eptr_size_modified, IP_ROUTE_ENTRY *sptr_static_route_entry);
extern void set_source_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT mapped_port, enum IP_PROTOCOL_VALUE protocol_type);
extern void set_destination_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT mapped_port, enum IP_PROTOCOL_VALUE protocol_type);
extern void process_proxy_ip_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
		USHORT mapped_port, enum IP_PROTOCOL_VALUE protocol_type, USHORT tx_port, BYTE *proxy_server_info, enum BOOLEAN ftp_port_command);
extern void process_proxy_response_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
	  USHORT destination_port, enum IP_PROTOCOL_VALUE protocol_type, ULONG client_ip_address, void *);
/*  Neelu added for NAT */
/* sudha 02-Feb-2000. Added one more var for NAT pasv FTP support */
extern enum BOOLEAN check_and_process_the_packets_to_or_from_internet_servers (UNION_IP_PACKET *,
	IP_PARAMETERS *, USHORT *, enum BOOLEAN *, enum BOOLEAN *);
/*---------Neelu Ends----------------*/

/* Ravi added for User Authentication */
extern enum BOOLEAN check_if_packet_is_authenticated_for_access (UNION_IP_PACKET *, IP_PARAMETERS *, enum BOOLEAN *, enum BOOLEAN *);
extern void receive_tcp_packet (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters, BYTE *uptr_ip_rx_packet,
			USHORT pkt_length);

extern void event_broadcast_packets_on_all_ports (EVENT_HEADER *event_packet);
     
USHORT firewall_forward_packet_port(USHORT rx_port_number);

extern USHORT get_insecured_lan_port_number();
extern BYTE is_insecured_lan(USHORT port_number);
extern void increment_count_of_unauthorized_packets();
extern BYTE is_secured_lan_port(USHORT port_number);
/* sudhir 11//7/97 for proxy  */

/* added by Ravi */
extern USHORT get_application_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT *destination_port, enum IP_PROTOCOL_VALUE *protocol_type);

extern void process_the_packet_meant_to_or_from_our_web_server(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
			USHORT destination_port, USHORT source_port, USHORT rx_port_number, enum USER_DATABASE_PACKET_TYPE packet_type);

extern enum BOOLEAN check_if_packet_is_destined_to_configured_static_routes (ULONG destination_address, IP_ROUTE_ENTRY **route_entry_ptr);

/* added by Ravi */

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
extern enum BOOLEAN check_and_process_if_virtual_server_loopback_request_packet (UNION_IP_PACKET *uptr_ip_rx_packet, 
	IP_PARAMETERS *sptr_ip_parameters, enum BOOLEAN *eptr_size_modified);
extern enum BOOLEAN is_virtual_server_loopback_response_packet (BYTE *uptr_ip_rx_packet, 
	IP_PARAMETERS *sptr_ip_parameters, enum BOOLEAN *eptr_size_modified); 
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */


/****************************************************************************/



/* sachin 1/1/98 */
#if TCP_CSUM_DEBUG
ULONG tcp_checksum_failed_packets = 0 ;
extern void tcp_checksum (ULONG source_address, ULONG destination_address, BYTE *packet, USHORT packet_length) ;

BYTE temp_tcp_buffer[3000] ;

void bad_tcp_packet_received ()
{
	return;
}

enum BOOLEAN debug_verify_tcp_checksum (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet)
{
   USHORT computed_checksum, actual_checksum ;

   if (sptr_ip_parameters->protocol != TCP_PROTOCOL)
      return (TRUE) ;

   memcpy (&temp_tcp_buffer[0], (BYTE *)(&uptr_ip_rx_packet->ip.header) + sptr_ip_parameters->header_length,
      sptr_ip_parameters->total_length - sptr_ip_parameters->header_length) ;

   actual_checksum = *((USHORT *)&temp_tcp_buffer[16]) ;

   tcp_checksum (sptr_ip_parameters->source_address, sptr_ip_parameters->destination_address,
      &temp_tcp_buffer[0], sptr_ip_parameters->total_length  - sptr_ip_parameters->header_length) ;

   computed_checksum = *((USHORT *)&temp_tcp_buffer[16]) ;

   if (actual_checksum == computed_checksum)
      return (TRUE) ;
   else
	{
		bad_tcp_packet_received ();	
		set_tcp_checksum (uptr_ip_rx_packet,sptr_ip_parameters,0);
      return (FALSE) ;
	}
}
#endif
/* sachin 1/1/98 */


enum RX_PACKET_STATE ip_router_rx_packet (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet, USHORT size_of_packet)
{
	enum IP_PACKET_STATE return_code;
	LSL_IP_HEADER *sptr_lsl_packet;

#ifdef __IP_BREAKPOINT__
	check_for_ip_runtime_breakpoint ();
#endif /* __IP_BREAKPOINT__ */

	sptr_lsl_packet = (LSL_IP_HEADER *) ((ULONG) uptr_ip_rx_packet - sizeof (USHORT_ENUM (SNAP_PROTOCOL_ID)));

	switch (sptr_lsl_packet->lsl_packet_type)
		{
		case RAW_8023:
		case LLC_PACKET:

			/* illegal types for IP */

			return (PACKET_NOT_RECOGNIZED);

		case ETHERNET_TYPE_II:
		case SNAP_PACKET:
			
			if (ip.port[port_number].config.port_enabled == FALSE)
			{
				++ip.port[port_number].statistics.number_of_packets_rxed_on_disabled_port;
#if 0
				switch (((LSL_IP_HEADER *)sptr_lsl_packet)->protocol_type)
				{
					case (SNAP_IP_RARP_PACKET) :
					case (SNAP_IP_ARP_PACKET) :
					case (SNAP_IP_PACKET) :
						return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED) ;

					default :
						return (PACKET_NOT_RECOGNIZED) ;
				}
#endif
				return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
/*				return (PACKET_NOT_RECOGNIZED);*/
			}

			if (is_received_packet_recognized (port_number, uptr_ip_rx_packet, size_of_packet, sptr_lsl_packet, &return_code)
				== FALSE)
				{
				return (PACKET_NOT_RECOGNIZED);
				}

			break;

		default:

			return (PACKET_NOT_RECOGNIZED);
		}

	if (return_code == IP_DATA_PACKET_RXED_AND_WAS_FORWARDED)
		{
		return (PACKET_RECOGNIZED_AND_FORWARDED);
		}
	else
		{
		++ip.port[port_number].statistics.number_of_packets_not_forwarded;

		return (PACKET_RECOGNIZED_BUT_NOT_FORWARDED);
		}
}
/****************************************************************************/
static enum BOOLEAN is_received_packet_recognized (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet, USHORT size_of_packet,
	LSL_IP_HEADER *sptr_lsl_packet_header, enum IP_PACKET_STATE *eptr_return_code)
{
	switch (sptr_lsl_packet_header->protocol_type)
		{
		case SNAP_IP_RARP_PACKET:

			++ip.port[port_number].statistics.number_of_rarp_packets_rxed;

		#ifdef __IP_DEBUG__
			print_rxed_mac_header (sptr_lsl_packet_header);
		#endif /* __IP__DEBUG__ */

			*eptr_return_code = rarp_packet_received (port_number, &uptr_ip_rx_packet->rarp, size_of_packet);

			break;

		case SNAP_IP_PACKET:

			++ip.port[port_number].statistics.number_of_ip_packets_rxed;

		#ifdef __IP_DEBUG__
			print_rxed_mac_header (sptr_lsl_packet_header);
		#endif /* __IP__DEBUG__ */

			*eptr_return_code = route_ip_rx_packet (port_number, uptr_ip_rx_packet, size_of_packet);

			break;

		case SNAP_IP_ARP_PACKET:

			++ip.port[port_number].statistics.number_of_arp_packets_rxed;

		#ifdef __IP_DEBUG__
			print_rxed_mac_header (sptr_lsl_packet_header);
		#endif /* __IP__DEBUG__ */

			*eptr_return_code = arp_packet_received (port_number, &uptr_ip_rx_packet->arp, size_of_packet);

			break;

		default:

			++ip.port[port_number].statistics.number_of_non_ip_packets_rxed;

			return (FALSE);
		}
	return (TRUE);
}
/****************************************************************************/
static enum IP_PACKET_STATE route_ip_rx_packet (USHORT rx_port_number, UNION_IP_PACKET *uptr_ip_rx_packet,
	USHORT number_of_bytes_rxed)
{
	enum BOOLEAN change_ip_destination_for_source_route;
	enum FORWARD_STATUS  forward_return_code = FORWARD_FAIL;
	enum BOOLEAN source_route_flag;
	enum BOOLEAN need_new_checksum;
	USHORT processed_option_length;
	IP_PARAMETERS ip_parameters;
	IP_ROUTE_ENTRY *sptr_route_entry, *sptr_static_route_entry;
	IP_PORT_CLASS *sptr_incoming_port;
	enum IP_PACKET_STATE return_value;

/* sudhir 11/7/97 for proxy server */
	USHORT outgoing_port_number=0;
	USHORT mapped_port=0;
	enum BOOLEAN abort_forwarding=FALSE, user_authenticated = TRUE;
	void *proxy_server_info;
	enum IP_PROTOCOL_VALUE protocol_type;
	int old_length = 0;
	enum BOOLEAN size_modified , is_my_packet=FALSE/*Neelu for NAT*/;
   enum IP_SEND_CONFIRMATION result_code;
	IP_UPPER_LAYER_PARAMETERS dummy_parameters;
   USHORT application_port_number=0, source_port=0;

/*-------Neelu added for NAT------------------*/	
#ifdef __PROXY_SERVER_
	if (outgoing_port_number != NO_SUCH_PORT)
	{ 
		dummy_parameters.gateway = ip.port[outgoing_port_number].config.point_to_point_remote_ip_address; 
	} 
#endif
/*--------Neelu Ends-----------------------*/ 	


	++ip.mib.ipInReceives;

	sptr_incoming_port = &ip.port[rx_port_number];

	ip_parameters.rx_port_number = rx_port_number;

	sptr_route_entry = NULL;

/* Shifted by Ravi 1 line up */
	ip_parameters.union_ip_packet_is_to_be_freed = FALSE;
/* Shifted by Ravi 1 line up */

	if (verify_ip_rx_packet (&ip_parameters, uptr_ip_rx_packet, sptr_incoming_port, &sptr_route_entry, &source_route_flag,
		&need_new_checksum, &change_ip_destination_for_source_route, &processed_option_length, &number_of_bytes_rxed) == FAIL)
	{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
	}

/* Added by Ravi on 24 Nov 1999 ... */
/* Discard all the fragmented packets. Remove this check when we support
	fragmentation. */

	if (check_for_fragmented_packet(&ip_parameters) == PASS)
	{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
	}
/* ... Added by Ravi on 24 Nov 1999 */

	sptr_static_route_entry = NULL;
   
#ifdef __IP_DEBUG__
	print_rxed_ip_header (&uptr_ip_rx_packet->ip.header, rx_port_number);
#endif /* __IP__DEBUG__ */

	if (check_if_packet_is_destined_to_us (rx_port_number, uptr_ip_rx_packet, &ip_parameters) == TRUE)  
	{
/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
		if (is_secured_lan_port(rx_port_number)) 
		{
			/* Check if the destination address is our Secure LAN IP Address */
			if (ip_parameters.destination_address == get_ip_address(rx_port_number))
			{
				old_length = ip_parameters.total_length;
				if (is_virtual_server_loopback_response_packet (uptr_ip_rx_packet,
					&ip_parameters, &size_modified) == TRUE)
				{
					if (size_modified == TRUE)
					{
						number_of_bytes_rxed += (ip_parameters.total_length - old_length);
					}
					else
					{
						/* nothing required to be done */
					}
					
#ifdef __STATIC_ROUTE_
					sptr_static_route_entry	= NULL;
					check_if_packet_is_destined_to_configured_static_routes(ip_parameters.destination_address, 
						&sptr_static_route_entry);
#endif
					outgoing_port_number = rx_port_number;
					result_code = send_ip_packet (&ip_parameters, uptr_ip_rx_packet, number_of_bytes_rxed,
						(IP_ROUTE_CACHE_ENTRY *) NULL, outgoing_port_number, TRUE, FALSE, TRUE, NULL,
			         (ULONG)*((BYTE*)&ip_parameters.type_of_service), &dummy_parameters,
					  	THIS_IS_VIRTUAL_SERVER_LOOPBACK_RESPONSE_PACKET, rx_port_number, sptr_static_route_entry);

					if(result_code == IP_SEND_OK) 
					{
						return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
					}
					else
					{						
						return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
					}
				}
				else
				{
					/* May be secure LAN client request to our telnet/web server */
					ip_printf(IP_RX_PRINTF, "No matching of Virtual Server Loopback Response.\n");
				}
			}
			else
			{
				ip_printf(IP_RX_PRINTF, "Packet destined to us. Rxed from Secured LAN. But not our Secure LAN IP.\n");
				
				/* Virtual Server Loopback Request for our interface address 
					NAT mapping. */
				
		      old_length = ip_parameters.total_length;

				if (check_and_process_if_virtual_server_loopback_request_packet (uptr_ip_rx_packet,
					&ip_parameters, &size_modified) == TRUE)
				{
					if (size_modified == TRUE)
					{
						number_of_bytes_rxed += (ip_parameters.total_length - old_length);
					}
					else
					{
						/* nothing required to be done */
					}

					/* Forward the packet onto the secured LAN. */
#ifdef __STATIC_ROUTE_
					sptr_static_route_entry	= NULL;
					check_if_packet_is_destined_to_configured_static_routes(ip_parameters.destination_address, 
						&sptr_static_route_entry);
#endif
					outgoing_port_number = rx_port_number;

					result_code = send_ip_packet (&ip_parameters, uptr_ip_rx_packet, number_of_bytes_rxed,
						(IP_ROUTE_CACHE_ENTRY *) NULL, outgoing_port_number, TRUE, FALSE, TRUE, NULL,
			         (ULONG)*((BYTE*)&ip_parameters.type_of_service), &dummy_parameters,
					  	THIS_IS_VIRTUAL_SERVER_LOOPBACK_REQUEST_PACKET, rx_port_number, sptr_static_route_entry);

					if(result_code == IP_SEND_OK) 
					{
						return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
					}
					else
					{						
						return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
					}
				}
				else
				{
					/* packet to be passed to our upper layer */
					ip_printf(IP_RX_PRINTF, "Packet destined to us. Not a Virtual Server Loopback Request packet.\n");
				}
			}
		}
		else
		{
			ip_printf(IP_RX_PRINTF, "Packet destined to us. But not from secured LAN.\n");
		}
	
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

		return_value = pass_ip_packet_to_upper_layer (rx_port_number, &ip_parameters, uptr_ip_rx_packet, number_of_bytes_rxed, sptr_static_route_entry);

		/* Naveen 4/2/1998... */
		/* If Rxed packet was proxy response and if it is forwarded then we must 
	   return. */

      if (return_value == IP_DATA_PACKET_RXED_AND_WAS_FORWARDED)
      {
         return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
      }
		else
		{
/* Ravi : When Ras is implemented in Firewall, Do remove this condition and
			 necessary action are to be taken in order to support a full
			 fledged Ras. As all other condition are absoultely not relavent,
			 in Proxy Environment, it would be wise to remove it and hence
			 return IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED */

         return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}
	}

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
	/* Packet not destined to us. Check if it is from secure LAN. */
	if (is_secured_lan_port(rx_port_number))
	{
		/* Check if it a Virtual Server Loopback request packet with valid IP 
			address other than our interface address in NAT mapping. */
		
		old_length = ip_parameters.total_length;

		if (check_and_process_if_virtual_server_loopback_request_packet (uptr_ip_rx_packet,
					&ip_parameters, &size_modified) == TRUE)
		{
			if (size_modified == TRUE)
			{
				number_of_bytes_rxed += (ip_parameters.total_length - old_length);
			}
			else
			{
				/* nothing required to be done */
			}

#ifdef __STATIC_ROUTE_
			sptr_static_route_entry	= NULL;
			check_if_packet_is_destined_to_configured_static_routes (ip_parameters.destination_address, 
				&sptr_static_route_entry);
#endif
			outgoing_port_number = rx_port_number;

			result_code = send_ip_packet (&ip_parameters, uptr_ip_rx_packet, number_of_bytes_rxed,
				(IP_ROUTE_CACHE_ENTRY *) NULL, outgoing_port_number, TRUE, FALSE, TRUE, NULL,
			   (ULONG)*((BYTE*)&ip_parameters.type_of_service), &dummy_parameters,
			  	THIS_IS_VIRTUAL_SERVER_LOOPBACK_REQUEST_PACKET, rx_port_number, sptr_static_route_entry);

			if (result_code == IP_SEND_OK) 
			{
				return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
			}
			else
			{
				return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
			}
		}
		else
		{
			/* May be proxy request or nat response packet */
			ip_printf(IP_RX_PRINTF, "Packet not destined to us. Not a Virtual Server Loopback request packet.\n");
		}
	}
	else
	{
		/* May be NAT Request packet */
		ip_printf(IP_RX_PRINTF, "Packet not destined to us. Rx port is not Secure LAN.\n");
	}

#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

/* sachin 1/1/98 
	This is to verify the csum of the packet received. In case a packet with
	a wrong csum is received it will be forwarded with a new tcp csum of value 0 
*/

#if TCP_CSUM_DEBUG
   if (debug_verify_tcp_checksum (&ip_parameters, uptr_ip_rx_packet) == FALSE)
   {
		if (ip_parameters.more_fragment_flag == FALSE)
		{
      	printf ("TCP Packet (from %s to %s, id : %04X) failed checksum validation\n",
         	convert_ip_address_to_dot_format (&ip.print_buffer[0], ip_parameters.source_address),
         	convert_ip_address_to_dot_format (&ip.print_buffer_2[0], ip_parameters.destination_address),
				ip_parameters.id) ;
      	tcp_checksum_failed_packets++ ;
		}
   }
#endif

/* sudha 22-Jan-2000.Support for trace route ... */ 
	if ((is_secured_lan_port(rx_port_number)) && 
		 (ip_parameters.protocol == ICMP_PROTOCOL) && 
		 (check_if_time_to_live_field_in_ip_packet_is_valid (rx_port_number, 
		 	&ip_parameters, uptr_ip_rx_packet, processed_option_length) == FALSE))
	{
		return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
	}	
	else
	{
		/* nothing required to be done */
	}
/* ... sudha 22-Jan-2000.Support for trace route. */	
	
#ifdef __STATIC_ROUTE_
	if (check_if_packet_is_destined_to_configured_static_routes(ip_parameters.destination_address, &sptr_static_route_entry) == TRUE)
	{
		if (rx_port_number == sptr_static_route_entry->port_number)
		{
/* ICMP Redirect */
			uptr_ip_rx_packet->ip.header.time_to_live += (BYTE) 1;
			send_icmp_redirect_message (rx_port_number, sptr_static_route_entry, sptr_incoming_port, &ip_parameters,
				uptr_ip_rx_packet);
			uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1;
/* ICMP Redirect */

			forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
									 change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number, THIS_IS_A_PROXY_REQUEST_PACKET, sptr_static_route_entry);

			if (forward_return_code == FORWARD_OK)
				return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
			else
				return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}
	}
#endif

#ifdef __USER_AUTHENTICATION_
	if (is_secured_lan_port(rx_port_number))
	{
		user_authenticated = TRUE;

		if (check_if_packet_is_authenticated_for_access (uptr_ip_rx_packet, &ip_parameters, &abort_forwarding, &user_authenticated) == FALSE)
		{
#if Ravi
			if (!user_authenticated)
			{
				application_port_number = get_application_port_number (uptr_ip_rx_packet, &ip_parameters, &source_port, &protocol_type);

				if (application_port_number == 80 && protocol_type == TCP_PROTOCOL)
				{	
					/* Change the destination IP Address and pass it to the upper
						layer. The same has to be accounted in the Descriptor
						RB tree for further processing */
		
					process_the_packet_meant_to_or_from_our_web_server(uptr_ip_rx_packet, &ip_parameters, 
											application_port_number, source_port, rx_port_number, PACKET_TO_WEB_SERVER);

					receive_tcp_packet (ip_parameters.rx_port_number, &ip_parameters, (BYTE *)uptr_ip_rx_packet,
					(USHORT) (ip_parameters.total_length - ip_parameters.header_length));
				}
			}
#endif

			return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}
	}
#endif	

#ifdef __PROXY_SERVER_

	/* vidy 02/04/99 - move this if condition to be before the
	"check_if_packet_is_to_be_proxied". */

/* Naveen 27/2/1998: If the packet is not from SECURED LAN then if the packet
       is from INTERNET LAN then forward it onto the WAN PORT else if the
       packet is from WAN PORT then forward the packet INTERNET LAN...
*/

/* sudha 02-Feb-2000. For NAT pasv FTP support ... */
	old_length = ip_parameters.total_length;
	if (check_and_process_the_packets_to_or_from_internet_servers (uptr_ip_rx_packet,
			&ip_parameters, &outgoing_port_number, &is_my_packet, &size_modified) == TRUE)
	{
/* We need to check the Static Route table since, the destination IP address
   will change if there is NAT mapping. This condition occur when some of
   workstation try to contact our Virtual Servers */

		if (size_modified)
		{
			number_of_bytes_rxed += (ip_parameters.total_length - old_length);
		}
		else
		{
			/* nothing required to be done */
		}

/* ... sudha 02-Feb-2000. For NAT pasv FTP support */

#ifdef __STATIC_ROUTE_
		sptr_static_route_entry	= NULL;
		
		check_if_packet_is_destined_to_configured_static_routes(ip_parameters.destination_address, &sptr_static_route_entry);
#endif

		result_code = send_ip_packet (&ip_parameters, uptr_ip_rx_packet, number_of_bytes_rxed,
								(IP_ROUTE_CACHE_ENTRY *) NULL,outgoing_port_number, TRUE, FALSE, TRUE, NULL,
					         (ULONG)*((BYTE*)&ip_parameters.type_of_service),&dummy_parameters,
							  	THIS_IS_NOT_A_PROXY_RESPONSE, rx_port_number, sptr_static_route_entry);
		               

		if(result_code == IP_SEND_OK) 
				return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
		else
				return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);

	}

/* Naveen 27/2/1998: added one more condition to check whether the packet is
          from SECURED LAN if so proxy the packet
*/

	if (is_secured_lan_port(rx_port_number))
	{
		if (check_if_packet_is_to_be_proxied (uptr_ip_rx_packet, &ip_parameters, &mapped_port, &abort_forwarding,
			rx_port_number, &protocol_type, &outgoing_port_number,&proxy_server_info, &size_modified, sptr_static_route_entry) == TRUE)
		{
			/* This is necessary in case we happen to do something that could
			change the packet size */

	      old_length = ip_parameters.total_length ;
			process_proxy_ip_packet (uptr_ip_rx_packet, &ip_parameters, mapped_port, protocol_type, outgoing_port_number, proxy_server_info, size_modified);
			if (size_modified)
				number_of_bytes_rxed += (ip_parameters.total_length - old_length) ;

			/* sudhir 1/1/98 
			This flag is used at a later stage to determine wheather the buffer
			is freed by device driver. Most of the cases the default value will
			be FALSE. Some cases it is TRUE. In that case buffer won't be freed.
			This will cause ethernet device driver buffer leakage. So we need to 
			make this flag FALSE here
			*/
		
			ip_parameters.union_ip_packet_is_to_be_freed = FALSE;

			/* sudhir 1/1/98 */

			forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
										 change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number, THIS_IS_A_PROXY_REQUEST_PACKET, sptr_static_route_entry);

			if (forward_return_code == FORWARD_OK)
				return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
			else
				return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}
		else if (abort_forwarding)
		{
			return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
		}
	}

/* sudha 04-Jan-2000. For Firewall routing ... */
/* If packet is from Internet Domain ( WAN or Internet LAN ) & no NAT entry
matching ( from Internet Domain to Secured LAN domain ), then check if packet 
has to be forwarded from one Internet Domain to the other Internet Domain 
( may be from Internet LAN to WAN / from WAN to Internet LAN ). This can be
done by checking the destination address net matching with same net as that 
of the Internet Domain's net. If yes, then forward the packet respectively. */

	else
	{
/* First check if any static route entry is matching for the destination 
address. If yes, check the outgoing port number. It should be other than 
Secured LAN. Because, no direct forwarding of packets from Internet Domain 
to Secured Domain ( other than Proxy Response pkts in which case reverse 
proxying happens or NAT request pkts in which case NAT translation happens 
much before forwarding those packets, which has been taken care by the 
previous checks ). */

#ifdef __STATIC_ROUTE_
		if (check_if_packet_is_destined_to_configured_static_routes(ip_parameters.destination_address, &sptr_static_route_entry) == TRUE)
		{
			ip_printf(IP_RX_PRINTF, "\n\rROUTING : Static route exists on port %d for packet whose destination is %lX received on port %d",
				sptr_static_route_entry->port_number, ip_parameters.destination_address,
				rx_port_number);
			if (!(is_secured_lan_port(sptr_static_route_entry->port_number)))
			{
				forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
										 change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number, THIS_IS_ROUTING_PACKET, sptr_static_route_entry);

				if (forward_return_code == FORWARD_OK)
				{
					return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
				}
				else
				{
					return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
				}
			}
			else
			{
				printf("Hacking attempt : %s from port %d to %s\n\r",
         	convert_ip_address_to_dot_format (&ip.print_buffer[0], ip_parameters.source_address),
					 rx_port_number, 
         	convert_ip_address_to_dot_format (&ip.print_buffer_2[0], ip_parameters.destination_address));
			}
		}	
#endif /* __STATIC_ROUTE_ */		
		else
		{
			ip_printf(IP_RX_PRINTF, "\n\rROUTING : No static route for packet whose destination is %lX received on port %d",
				ip_parameters.destination_address, rx_port_number);

			forward_return_code = forward_ip_packet (&ip_parameters, uptr_ip_rx_packet, TRUE,
									 change_ip_destination_for_source_route, number_of_bytes_rxed, outgoing_port_number, THIS_IS_ROUTING_PACKET, sptr_static_route_entry);

			if (forward_return_code == FORWARD_OK)
			{
				return (IP_DATA_PACKET_RXED_AND_WAS_FORWARDED);
			}
			else
			{
				return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
			}
		}
	}
/* ... sudha 04-Jan-2000. For Firewall routing */

#endif
   
	return (IP_DATA_PACKET_RXED_AND_WAS_NOT_FORWARDED);
}

      
/****************************************************************************/
static enum TEST verify_ip_rx_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	IP_PORT_CLASS *sptr_incoming_port, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, enum BOOLEAN *eptr_source_route_flag,
	enum BOOLEAN *eptr_need_new_checksum, enum BOOLEAN *eptr_change_ip_destination_for_source_route,
	USHORT *usptr_processed_option_length, USHORT *usptr_number_of_bytes_rxed)
{
	enum TEST return_code;
	if (check_if_ip_packet_length_and_header_length_and_checksum_are_valid (sptr_ip_parameters, sptr_ip_packet,
		usptr_number_of_bytes_rxed, sptr_incoming_port) == FALSE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet %s --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	extract_ip_header (sptr_ip_parameters, &sptr_ip_packet->ip.header, sptr_ip_parameters->header_length);

	if (check_if_ip_version_is_valid (sptr_ip_parameters) == FALSE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet %s --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	if (ip_check_if_destination_address_is_valid (sptr_ip_parameters->destination_address) == FALSE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet to --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	if (ip_check_if_source_address_is_valid (sptr_ip_parameters->source_address, sptr_ip_parameters->rx_port_number) == FALSE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet from <-- %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	if (ip_rx_filter (sptr_incoming_port, sptr_ip_packet) == TRUE)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: filtered packet %s --> %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		++sptr_incoming_port->statistics.number_of_rxed_packets_filtered;

		return (FAIL);
		}

	send_icmp_source_quench_message_if_memory_is_low (sptr_ip_parameters, sptr_ip_packet, sptr_incoming_port);

	adjust_number_of_bytes_received_and_initialize_certain_fields (sptr_ip_parameters, usptr_number_of_bytes_rxed,
		eptr_source_route_flag, eptr_need_new_checksum, eptr_change_ip_destination_for_source_route);

	return_code = process_ip_options (sptr_ip_packet, sptr_ip_parameters, eptr_source_route_flag, eptr_need_new_checksum,
		ptr_to_sptr_route_entry, usptr_processed_option_length, eptr_change_ip_destination_for_source_route);

	return (return_code);
}
/****************************************************************************/
static enum BOOLEAN check_if_ip_packet_length_and_header_length_and_checksum_are_valid (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_ip_packet, USHORT *usptr_number_of_bytes_rxed, IP_PORT_CLASS *sptr_incoming_port)
{
	if (*usptr_number_of_bytes_rxed < MINIMUM_IP_HEADER_LENGTH)
		{
		++sptr_incoming_port->statistics.number_of_short_ip_packets_received;

		return (FALSE);
		}

	sptr_ip_parameters->header_length = (USHORT) (sptr_ip_packet->ip.header.version_header_length.header_length << 2);

	if (sptr_ip_parameters->header_length < MINIMUM_IP_HEADER_LENGTH)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: rxed packet with short header (from port %d) is discarded\n",
			sptr_incoming_port->config.virtual_port_number);
	#endif /* __IP_ALARM_DEBUG__ */

		++ip.mib.ipInHdrErrors;

		return (FALSE);
		}

	sptr_ip_parameters->total_length = sptr_ip_packet->ip.header.total_length;

	if (sptr_ip_parameters->total_length < sptr_ip_parameters->header_length)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: rxed packet with short header (from port %d) is discarded\n",
			sptr_incoming_port->config.virtual_port_number);
	#endif /* __IP_ALARM_DEBUG__ */

		++ip.mib.ipInHdrErrors;

		return (FALSE);
		}

	if (calculate_ip_checksum (NULL, (BYTE *) &sptr_ip_packet->ip.header, sptr_ip_parameters->header_length) != 0x0000)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: rxed bad header checksum from port %d\n",
			sptr_incoming_port->config.virtual_port_number);
	#endif /* __IP_ALARM_DEBUG__ */

		++ip.mib.ipInHdrErrors;

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static enum BOOLEAN check_if_ip_version_is_valid (IP_PARAMETERS *sptr_ip_parameters)
{
	if (sptr_ip_parameters->version != IP_VERSION)		/* wrong version of IP */
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: rxed bad version from %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address));
	#endif /* __IP_ALARM_DEBUG__ */

		++ip.mib.ipInHdrErrors;

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static void	send_icmp_source_quench_message_if_memory_is_low (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
	IP_PORT_CLASS *sptr_incoming_port)
{
	/* if running low on memory, return an ICMP source quench message */

	if (memory_is_low () == TRUE)
		{
		send_icmp_error_packet (sptr_incoming_port->config.virtual_port_number, sptr_ip_parameters, sptr_ip_packet,
			ICMP_SOURCE_QUENCH_TYPE, 0, NULL);
		}
}
/****************************************************************************/
static void	adjust_number_of_bytes_received_and_initialize_certain_fields (IP_PARAMETERS *sptr_ip_parameters,
	USHORT *usptr_number_of_bytes_rxed, enum BOOLEAN *eptr_source_route_flag, enum BOOLEAN *eptr_need_new_checksum,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route)
{
	/* adjust byte_count because the actual ip data may be shorter than what is received from the network.*/

	*usptr_number_of_bytes_rxed = (USHORT) (sptr_ip_parameters->total_length + sizeof (UNION_MAC_HEADER));

	*eptr_source_route_flag = FALSE;
	*eptr_need_new_checksum = FALSE;
	*eptr_change_ip_destination_for_source_route = FALSE;

	ip.source_route_working_area.number_of_hops_in_source_route = 0x0000;
}
/****************************************************************************/
enum BOOLEAN check_if_packet_is_destined_to_us (USHORT port_number, UNION_IP_PACKET *uptr_ip_rx_packet,
	IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT port_index, internet_lan_port_number;
	IP_PORT_CLASS *sptr_port;
	ULONG destination_address;
	enum BOOLEAN broadcast_from_interface;

	destination_address = sptr_ip_parameters->destination_address;
	if ((destination_address == INTERNET_ADDRESS_BROADCAST) || (destination_address == INTERNET_ADDRESS_ANY))
		{
		return (TRUE);
   	}

	broadcast_from_interface = received_broadcast_from_interface (port_number, uptr_ip_rx_packet);

	if (broadcast_from_interface == TRUE)
		{
		return (TRUE);
   	}

	for (port_index = 0x0000; port_index < ip.number_of_ports; ++port_index)
		{
		sptr_port = &ip.port[port_index];	/* vidy moved this line 1 up 21/08/97*/

		if ((ip.port[port_index].config.port_enabled == TRUE) && (sptr_port->config.ip_address != 0x0000))
			{

			if (sptr_port->config.ip_address == destination_address)
				{

#if 1
/* Naveen 8/2/1998 : If a User Try's to PING Secured LAN Port from INSecured 
         LAN then we should filter those ICMP PACKETS
...*/
               if (sptr_ip_parameters->protocol == ICMP_PROTOCOL)
               {
                  if (!(is_secured_lan_port(port_number)) && is_secured_lan_port(port_index))
                     continue;
               }
/* ... Naveen 8/2/1998 (For FIREWALL) */
#endif

				return (TRUE);
		   	}
#if 0         
         printf("DEST: %X, subnet_bc: %X net_bc: %X subnet_add: %X net_address: %X\n", 
                 destination_address, 
                 sptr_port->subnet_broadcast_address, 
                 sptr_port->net_broadcast_address, 
                 sptr_port->subnet_address,
                 sptr_port->net_address);
#endif
			if ((sptr_port->subnet_broadcast_address == destination_address) ||
				(sptr_port->net_broadcast_address == destination_address) ||
				/* for old broadcast host portion 0 */
				(destination_address == sptr_port->subnet_address) || (destination_address == sptr_port->net_address))
				{
				return (TRUE);
				}
			}
		}
/* Added by Naveen on 11/08/1998 ... */
   /* Check if DHCP Client is Enabled on Internet LAN and a DHCP request
      has been sent on Internet LAN and if we rx a Unicasted DHCP
      response then assume that packet is destined to us. If the packet
      is not response we are looking for, then that packet will be droped at
      DHCP level 
   */
   internet_lan_port_number = get_insecured_lan_port_number();
   if ((port_number == internet_lan_port_number) &&
       ip.port[internet_lan_port_number].config.port_enabled == TRUE && 
       ip.port[internet_lan_port_number].config.dhcp_client_enabled == TRUE &&
       ip.port[internet_lan_port_number].dhcp_status == DHCP_STATUS_DISCOVER_REQUEST_MADE)
   {
#if 0
         printf("IP: Rxed Unicast response for DHCP request made...\n");
#endif
         return (TRUE);
   }
/* ... Added by Naveen on 11/08/1998 */

	return (FALSE);
}
/****************************************************************************/
static enum BOOLEAN check_if_ip_rx_packet_is_to_be_forwarded (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, enum BOOLEAN source_route_flag,
	IP_PORT_CLASS *sptr_incoming_port, USHORT processed_option_length)
{
	if (ip.mib.ipForwarding == (BYTE) FALSE)
		{
		return (FALSE);
		}

	if (check_if_time_to_live_field_in_ip_packet_is_valid (rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet,
		processed_option_length) == FALSE)
		{
		return (FALSE);
		}

	if (get_route_on_which_to_forward_packet (sptr_ip_parameters, uptr_ip_rx_packet, ptr_to_sptr_route_entry, sptr_incoming_port,
		processed_option_length) == FAIL)
		{
		return (FALSE);
		}

	send_redirect_icmp_if_necessary (rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet, *ptr_to_sptr_route_entry,
		source_route_flag, sptr_incoming_port);

	return (TRUE);
}
/****************************************************************************/
enum BOOLEAN check_if_time_to_live_field_in_ip_packet_is_valid (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT processed_option_length)
{
	UNION_ICMP_PARAMETER icmp_parameter;

	uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1;

	if ((uptr_ip_rx_packet->ip.header.time_to_live == 0x00) &&
		(check_if_packet_is_destined_to_us (rx_port_number, uptr_ip_rx_packet, sptr_ip_parameters) == FALSE))
		{
		++ip.mib.ipInHdrErrors;

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP: dropped packet due to time-to-live from %s to %s\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_ip_parameters->source_address),
			convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_ip_parameters->destination_address));
	#endif /* __IP__ALARM_DEBUG__ */

		icmp_parameter.pointer = (BYTE) (MINIMUM_IP_HEADER_LENGTH + processed_option_length);

/* Sachin 07/10/1996 */
			uptr_ip_rx_packet->ip.header.time_to_live += (BYTE) 1 ;
		/*
			Set the ttl value back to what it originally was. It is required to
			have the image of the header in the packet that is being sent, exactly
			as it was received. This change was made in response to the problem
			with PCTCP's trace that was reported from Bombay.
		*/
/* Sachin 07/10/1996 */

		send_icmp_error_packet (rx_port_number, sptr_ip_parameters, uptr_ip_rx_packet, ICMP_TIME_EXCEEDED_TYPE,
			ICMP_TTL_EXCEEDED_CODE, &icmp_parameter);

/* Sachin 07/10/1996 */
		/* Restore the ttl value */
		uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1 ;
/* Sachin 07/10/1996 */

		return (FALSE);
		}

	return (TRUE);
}
/****************************************************************************/
static enum TEST get_route_on_which_to_forward_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet,
	IP_ROUTE_ENTRY **ptr_to_sptr_route_entry, IP_PORT_CLASS *sptr_incoming_port, USHORT processed_option_length)
{
	UNION_ICMP_PARAMETER icmp_parameter;
	ULONG type_of_service;

	if (*ptr_to_sptr_route_entry == NULL)
		{
		/* route has not been determined by the source route option */

		type_of_service = (ULONG) 0x01;

		*ptr_to_sptr_route_entry = ip_find_route_and_update_cache (sptr_ip_parameters->destination_address, type_of_service);

		if (*ptr_to_sptr_route_entry == NULL)
			{
			/* this is not good */

			++ip.mib.ipOutNoRoutes;

			icmp_parameter.pointer = (BYTE) (MINIMUM_IP_HEADER_LENGTH + processed_option_length);

/* Sachin 07/10/1996 */
			uptr_ip_rx_packet->ip.header.time_to_live += (BYTE) 1 ;
/* Sachin 07/10/1996 */
#if Ravi
			send_icmp_error_packet (sptr_incoming_port->config.virtual_port_number, sptr_ip_parameters, uptr_ip_rx_packet,
				ICMP_DESTINATION_UNREACHABLE_TYPE, ICMP_HOST_UNREACHABLE_CODE, &icmp_parameter);
#endif
/* Sachin 07/10/1996 */
			uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1 ;
/* Sachin 07/10/1996 */

			return (FAIL);
			}
		else
			{
			++((*ptr_to_sptr_route_entry)->use_count);
			}

		}

	return (PASS);
}
/****************************************************************************/
static void	send_redirect_icmp_if_necessary (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, IP_ROUTE_ENTRY *sptr_route_entry, enum BOOLEAN source_route_flag,
	IP_PORT_CLASS *sptr_incoming_port)
{
	/* check if redirect icmp should be sent: If outgoing port is the same as the incoming port,
	 * send a ICMP redirect to the sender but with the following conditions:
	 * 	- sender is on the directly connected networks
	 * 	- the packet was not source routed (or has any options)
	 *		- forwarding does not use a default route or a route modified by a redirect. */

	if ((sptr_incoming_port->config.virtual_port_number == sptr_route_entry->port_number) &&
		(source_route_flag == FALSE) && (sptr_incoming_port->config.icmp_redirect_enabled == TRUE) &&
		((sptr_ip_parameters->source_address & sptr_incoming_port->config.subnetmask) == sptr_incoming_port->subnet_address))
	{
/* Sachin 17/06/1996 */
/*
		if ((remote_access_enabled_for_lan (sptr_route_entry->port_number) == FALSE) &&
			(ip.port[sptr_route_entry->port_number].config.proxy_arp_enabled == FALSE))
*/
/* Sachin 17/06/1996 */
		{
			if (sptr_route_entry != &ip.default_route)
			{
				/* By now we have decremented the ttl feild. Increment it and
				   restore it. Just give the send_icmp_redirect_message()
					as we received it. But do not forget to restore the value bacause
					the checksum is computed for the decremented ttl.
				*/
				uptr_ip_rx_packet->ip.header.time_to_live += (BYTE) 1;
				send_icmp_redirect_message (rx_port_number, sptr_route_entry, sptr_incoming_port, sptr_ip_parameters,
					uptr_ip_rx_packet);
				uptr_ip_rx_packet->ip.header.time_to_live -= (BYTE) 1;
			}
		}
	}
}
#ifdef __IP_DEBUG__
/****************************************************************************/
static void print_rxed_mac_header (LSL_IP_HEADER *sptr_lsl_header)
{
	ip_printf (IP_RX_PRINTF, "IP: rxed packet mac %8x:%4x --> mac %8x:%4x\n",
		net_to_host_long (sptr_lsl_header->source_address._ulong),
		net_to_host_short (sptr_lsl_header->source_address._ushort),
		net_to_host_long (sptr_lsl_header->destination_address._ulong),
		net_to_host_short (sptr_lsl_header->destination_address._ushort));
}
#endif /* __IP__DEBUG__ */



/* Naveen 27/2/1998... */

USHORT firewall_forward_packet_port(USHORT rx_port_number)
{
#define FIREWALL_WAN_PORT_NUMBER 2
   if (is_secured_lan_port(rx_port_number))
   {
      printf("IP: Trying to forward the packet came from SECURED LAN....\n");
      return 0;
   }

   if(is_insecured_lan(rx_port_number))
      return FIREWALL_WAN_PORT_NUMBER;
   else
      return get_insecured_lan_port_number();
#undef FIREWALL_WAN_PORT_NUMBER
}
/* ...Naveen 27/2/1998 */

/* Added by Ravi on 24 Nov 1999 ... */
static enum TEST check_for_fragmented_packet (IP_PARAMETERS *sptr_ip_parameters)
{
	if ((sptr_ip_parameters->offset > 0x0000) || (sptr_ip_parameters->more_fragment_flag == TRUE))
	{
		/* Discard all the fragmented packets for now */
		return (PASS);
	}
	else
	{
	 	return (FAIL);
	}
}
/* ... Added by Ravi on 24 Nov 1999 */

