#include	"defs.h"
/*
 * $Log: /IP/IPSNMP.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ipsnmp.c$  $version: 1.8$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 06/15/94 yarran
1.1 06/15/94 yarran added copyright.
1.2 10/10/94 ross added rarp, proxy arp, remote access functions
1.3 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.4 12/20/94 ross
1.5 12/27/94 ross added better table instrumentation via new snmp.
1.6 01/26/95 ross SNMP name change, printf change.
1.7 06/29/95 ross new snmp access routine
1.8 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stddef.h>
#include "ip.h"
#include	<visnpstr.h>
#include "vipsnmp.h"
#include "varpsnmp.h"
#include "vicmsnmp.h"
#include "vudpsnmp.h"
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
enum TEST get_rfc1213_arp_table_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST return_code;

	return_code = process_mib_variable (mib_operation, cptr_mib_string, bptr_variable_value,
		usptr_size_of_variable_value, usptr_size_of_table_indices, sptr_table_indices, eptr_end_of_table,
		ptr_to_cptr_next_variable_name, &arp_snmp_table[0x00]);

	return (return_code);
}					  
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
enum TEST get_rfc1213_ip_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST return_code;

	return_code = process_mib_variable (mib_operation, cptr_mib_string, bptr_variable_value,
		usptr_size_of_variable_value, usptr_size_of_table_indices, sptr_table_indices, eptr_end_of_table,
		ptr_to_cptr_next_variable_name, &ip_snmp_table[0x00]);

	return (return_code);
}					  
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
enum TEST get_rfc1213_icmp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST return_code;

	return_code = process_mib_variable (mib_operation, cptr_mib_string, bptr_variable_value,
		usptr_size_of_variable_value, usptr_size_of_table_indices, sptr_table_indices, eptr_end_of_table,
		ptr_to_cptr_next_variable_name, &icmp_snmp_table[0x00]);

	return (return_code);
}					  
/**********************************************************************************/
/* Srikar, Mar 20, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
enum TEST get_rfc1213_udp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST return_code;

	return_code = process_mib_variable (mib_operation, cptr_mib_string, bptr_variable_value,
		usptr_size_of_variable_value, usptr_size_of_table_indices, sptr_table_indices, eptr_end_of_table,
		ptr_to_cptr_next_variable_name, &udp_snmp_table[0x00]);

	return (return_code);
}

/* Srikar, Mar 24, 1997. Added the following function to do range validation of the forwarding assignment. */

/**********************************************************************************/
enum TEST snmp_get_or_set_ipForwarding (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG	forwarding;

	forwarding = 0;
	if  (mib_operation == GET_OPERATION || mib_operation == GET_NEXT_OPERATION)
		{
		forwarding = *(BYTE *) (_class + offset + (size * port_number));
		switch (forwarding)
		{
			case TRUE :
				forwarding = 1;		/* This is the value to be sent to the manager. */
				break;
			case FALSE :
				forwarding = 2;		/* This is the value to be sent to the manager. */
				break;
			default :
				break;
		}
		*(ULONG *) vptr_mib_value_obtained = swap_long (forwarding);
		}
	else if (mib_operation == SET_OPERATION)
		{
		forwarding = *(ULONG *) vptr_mib_value_obtained;
		switch (forwarding)
		{
			case 1 :		/* Set forwarding to TRUE. */
				forwarding = TRUE;
				break;
			case 2 :
				forwarding = FALSE;
				break;
			default :
				return(FAIL);
		}
		*(BYTE *) (_class + offset + (size * port_number)) = (BYTE) forwarding;
		}
	*usptr_length_of_mib_obtained = sizeof (ULONG);
	return (PASS);
}

/* Srikar, Mar 24, 1997. Added the following function to do range validation of the default TTL. */

/**********************************************************************************/
enum TEST snmp_get_or_set_ipDefaultTTL (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG	new_ttl_value;

	if  (mib_operation == SET_OPERATION)
		{
		new_ttl_value = (*(ULONG *) vptr_mib_value_obtained);
		if (new_ttl_value > 255)
			return(FAIL);
		}
	return (snmp_get_or_set_ulong (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained,
		usptr_length_of_mib_obtained));
}

/* Srikar, Mar 24, 1997. Added the following function to do increment the index on */
/* get & decrement the index on set for ipRouteIfIndex. */

/**********************************************************************************/
enum TEST snmp_get_or_set_ipRouteIfIndex (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG value;
	ULONG number_of_ports;

	value = 0;
	if  (mib_operation == GET_OPERATION || mib_operation == GET_NEXT_OPERATION)
		{
		value = *(USHORT *) (_class + offset + (size * port_number));
		*(ULONG *) vptr_mib_value_obtained = swap_long (value + 1);
		}
	else if (mib_operation == SET_OPERATION)
		{
		value = (*(USHORT *) vptr_mib_value_obtained);
		number_of_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS) + lsl_control(GET_NUMBER_OF_WAN_PORTS);
		if (value > 0 && value < number_of_ports)
			*(USHORT *) (_class + offset + (size * port_number)) = (value - 1);
		else
			return(FAIL);
		}
	*usptr_length_of_mib_obtained = sizeof(ULONG);
	return(PASS);
}
