#include	"defs.h"
/*
 * $Log: /IP/IPTIMER.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: iptimer.c$  $version: 1.11$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/28/94 yarran Change port, route flags from bit map to enum BOOLEAN.
1.4 03/01/94 yarran Style changes.
1.5 05/02/94 yarran added rfc1042 changes.
1.6 09/01/94 ross added BYTE and USHORT_ENUM support.
1.7 09/22/94 ross
1.8 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.9 12/20/94 ross
1.10 12/27/94 ross added better table instrumentation via new snmp.
1.11 10/25/95 ross
* 	$lge$
*/

/* History of Changes Made :
		{Ravi, 23/09/1999, changed condition in call_rip_timer_if_enabled}
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include	<string.h>
#include	"ip.h"
/****************************************************************************/
static void	call_reassembly_timer (void);
static void ip_reassembly_timeout (REASSEMBLY *sptr_reassembly_block);
static void call_rip_timer_if_enabled (void);
static void	rip_send_periodic_icmp_address_mask_request (void);

/* sudhir 1/4/97 */
extern void dns_timer ();
extern int dhcp_inited;

#ifdef __USER_AUTHENTICATION_
extern void age_descriptor_rb_tree();
#endif


#ifndef __LSL__
static void call_timer_routines_of_other_transport_protocols (void);
#endif /* __LSL__ */

/* Added by Ravi on 25 Sept 1999 ... */
void call_aging_routing_table();
extern void delete_ip_route_entry (IP_ROUTE_ENTRY *sptr_route_entry);

/* ... Added by Ravi on 25 Sept 1999 */
/****************************************************************************/
/* Gets called every tick */
void ip_router_timer (void)
{
   USHORT port;

	if (ip.timer_enabled == FALSE)
		{
		return;
		}

	++ip.tick_counter;

/* Added by Naveen for Firewall 3/6/1998 ... */
   if (dhcp_inited)
   {
      for ( port = 0 ; port < lsl_control(GET_NUMBER_OF_LAN_PORTS); ++port)
      {
         if ( ip.port[port].config.port_enabled == TRUE )
         {
      		if (ip.port[port].config.dhcp_client_enabled == TRUE)
            {
               if (ip.port[port].dhcp_status == DHCP_STATUS_NO_OPERATION)
               {
                  if (ip.port[port].config.ip_address == 0x0000)
                  {
				         printf("DHCP CLIENT: Issuing DHCP Discover for client on port %04X\r\n", port);
				         lsl_control(DHCP_CONTROL_OPERATION, DHCP_APPLICATION, ISSUE_DHCP_BROADCAST,  port , DHCPDISCOVER);
				         ip.port[port].dhcp_status = DHCP_STATUS_DISCOVER_REQUEST_MADE;
                   }
               }
            }
         }
      }
   }
/* ... Added by Naveen for Firewall 3/6/1998 */


	if (ip.tick_counter >= ip.clock_ticks_per_second)
		{

/* Added by Ravi */
#if Ravi
#ifdef __USER_AUTHENTICATION_
	 age_descriptor_rb_tree();
#endif
#endif
		call_reassembly_timer ();

		call_arp_timer_if_enabled ();

		rarp_client_timer ();

/* Added by Ravi on 25 Sept 1999 ... */
/* Changed the call's respectively to support proper aging in the routing
	table */
		if (ip.rip.protocol_enabled == TRUE)
		{
			call_rip_timer_if_enabled ();
		}
		else
		{
			call_aging_routing_table();
		}
/* ... Added by Ravi on 25 Sept 1999 */

/* sudhir 1/4/97 */
	dns_timer ();

	#ifndef __LSL__

		call_timer_routines_of_other_transport_protocols ();

	#endif /* __LSL__ */

		ip.tick_counter = 0x00000000L;
		}
}
/****************************************************************************/
static void	call_reassembly_timer (void)
{
	REASSEMBLY *sptr_reassembly_block_prev;
	REASSEMBLY *sptr_reassembly_block;
	REASSEMBLY *sptr_timed_out_reassembly_block;

	sptr_reassembly_block_prev = NULL;

	sptr_reassembly_block = ip.sptr_reassembly_link_list;

	while (sptr_reassembly_block != NULL)
		{
		if (sptr_reassembly_block->timer_in_seconds >= ip.mib.ipReasmTimeout)
			{
			sptr_timed_out_reassembly_block = sptr_reassembly_block;

			if (ip.sptr_reassembly_link_list == sptr_reassembly_block)
				{
				ip.sptr_reassembly_link_list = sptr_reassembly_block->sptr_forward;
				}
			else
				{
				sptr_reassembly_block_prev->sptr_forward = sptr_reassembly_block->sptr_forward;
				}

			sptr_reassembly_block = sptr_reassembly_block->sptr_forward;

			ip_reassembly_timeout (sptr_timed_out_reassembly_block);
			}
		else
			{
			++sptr_reassembly_block->timer_in_seconds;

			sptr_reassembly_block_prev = sptr_reassembly_block;

			sptr_reassembly_block = sptr_reassembly_block->sptr_forward;
			}
		}
}
/****************************************************************************/
/* Handle reassembly timeouts by deleting all reassembly resources */

static void ip_reassembly_timeout (REASSEMBLY *sptr_reassembly_block)
{
	print_reassembly_control_block (sptr_reassembly_block);

	free_reassembly (sptr_reassembly_block);

	++ip.mib.ipReasmFails;
}
/****************************************************************************/
static void call_rip_timer_if_enabled (void)
{
	if ((ip.rip.protocol_enabled == TRUE) && (ip.rip.timer_enabled == TRUE))
		{
		++ip.rip.periodic_time_counter;

		if ((ip.rip.need_update == TRUE) && (ip.rip.periodic_time_counter >= ip.rip.next_trigger_broadcast_time))
			{
			rip_broadcast_updates (TRUE, NO_SUCH_PORT);

			rip_set_next_trigger_broadcast_time ();

			ip.rip.need_update = FALSE;
			}
		else if (ip.rip.periodic_time_counter >= ip.rip.next_regular_update_time)
			{
			rip_periodic_timer ();

			ip.rip.need_update = FALSE;

			ip.rip.next_trigger_broadcast_time = 0x00000000L;

			ip.rip.periodic_time_counter = 0x0000;

			rip_set_next_trigger_broadcast_time ();

			rip_set_next_regular_update ();
			}

		++ip.icmp.periodic_mask_request_timer;

		if (ip.icmp.periodic_mask_request_timer >= ip.icmp.mask_request_timeout)
			{
			rip_send_periodic_icmp_address_mask_request ();

			ip.icmp.periodic_mask_request_timer = 0x0000;
			}
		}
}
/****************************************************************************/
static void	rip_send_periodic_icmp_address_mask_request (void)
{
	IP_ROUTE_ENTRY *sptr_route_entry;
	IP_PARAMETERS ip_parameters;
	UNION_ICMP_PARAMETER icmp_option_data;

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
	sptr_route_entry = get_first_ip_route_entry ();
#else
	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);
#endif

	while (sptr_route_entry != NULL)
		{
		if ((sptr_route_entry->number_of_subnet_mask_bits == SEND_ADDRESS_MASK_REQUEST) &&
			(sptr_route_entry->flags.no_subnet_mask == TRUE))
			{
			memset (&ip_parameters, 0x00, sizeof (IP_PARAMETERS));

			setup_ip_parameters_and_icmp_option_data (sptr_route_entry, &ip_parameters, &icmp_option_data);

			send_icmp_request_message (sptr_route_entry->port_number, &ip_parameters, ICMP_ADDRESS_MASK_TYPE, 0x00,
				&icmp_option_data);
			}

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
		sptr_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
		sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif
		}
}
#ifndef __LSL__
/****************************************************************************/
static void call_timer_routines_of_other_transport_protocols (void)
{
	USHORT index_of_other_transport_protocols;

	/* code added by Titus begins here */

	for (index_of_other_transport_protocols = 0x0000; index_of_other_transport_protocols <
		ip.number_of_other_transport_protocols; ++index_of_other_transport_protocols)
		{
		if (ip.other_transport_protocols[index_of_other_transport_protocols].fptr_timer != NULL)
			{
			(*ip.other_transport_protocols[index_of_other_transport_protocols].fptr_timer) ();
			}
		}

	/* code added by Titus ends here */
}
#endif /* __LSL__ */


/* Added by Ravi on 25 Sept 1999 ... */
void call_aging_routing_table()
{
	IP_ROUTE_ENTRY *sptr_route_entry;
	IP_ROUTE_ENTRY *sptr_next_route_entry;

/* scan all route entries */
#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
	sptr_route_entry = get_first_ip_route_entry ();
#else
	sptr_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &ip.route_list);
#endif

	while (sptr_route_entry != NULL)
	{
#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
		sptr_next_route_entry = get_next_ip_route_entry (sptr_route_entry);
#else
		sptr_next_route_entry = (IP_ROUTE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *) sptr_route_entry);
#endif

		if (sptr_route_entry->flags.do_no_aging == FALSE)
		{
			sptr_route_entry->aging_timer++;

			if (sptr_route_entry->aging_timer >= ROUTING_AGE_TIMER)
				delete_ip_route_entry (sptr_route_entry);
		}
		sptr_route_entry = sptr_next_route_entry;
	}
}
/* ... Added by Ravi on 25 Sept 1999 */

