#include	"defs.h"

/*
 * $Log: /IP/IPTXPR.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stddef.h>
#include	<stdio.h>
#include	"ip.h"
#ifdef IP_FILTERING
#include "ipfilt.h"
/*#define PRINTF 1*/
#endif

/****************************************************************************/
static void *get_last_entry_in_list (LINK *sptr_list_link);
static enum TEST get_next_hop_for_ip_destination_address ( ULONG ip_destination_address,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, USHORT tx_port_number);
void modify_outgoing_port_number_to_support_ip_extensions (USHORT *usptr_outgoing_port_number,
	ULONG ip_destination_address);
extern BYTE is_insecured_lan(USHORT port_number);

/****************************************************************************/
enum TEST lookup_route_cache (ULONG destination_address, ULONG *ulptr_next_hop_ip_address,
	USHORT *usptr_outgoing_port_number, IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters)
{
	BYTE hash_value;
	IP_ROUTE_CACHE_HASH_BUCKET *sptr_bucket;
	IP_ROUTE_CACHE_ENTRY *sptr_route_cache_entry;

#ifdef __IP_DEBUG__
	if (ip.sptr_most_recently_used_route != NULL)
		{
		print_most_recently_used_cache_entry (ip.sptr_most_recently_used_route);
		}
#endif /* __IP__DEBUG__ */

	hash_value = (BYTE) (((destination_address & 0xff000000L) >> 24) + ((destination_address & 0x00ff0000L) >> 16) +
		((destination_address & 0x0000ff00L) >> 8) + (destination_address & 0x000000ffL));

	if (ip.number_of_route_cache_hash_table_buckets == 0x00)
		{
		return (FAIL);
		}

	hash_value = (BYTE) (hash_value % ip.number_of_route_cache_hash_table_buckets);

#ifdef __IP_DEBUG__
	ip_printf (IP_CACHE_PRINTF, "IP: hash value for route cache is %x\n", hash_value);

	print_route_cache ();
#endif /* __IP__DEBUG__ */

	if (ip.sptr_route_cache != NULL)
		{
		sptr_bucket = (IP_ROUTE_CACHE_HASH_BUCKET *) ((ULONG) ip.sptr_route_cache +
			hash_value * sizeof (IP_ROUTE_CACHE_HASH_BUCKET));

		sptr_route_cache_entry = (IP_ROUTE_CACHE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &sptr_bucket->links);

		while (sptr_route_cache_entry != NULL)
			{
			if (sptr_route_cache_entry->target == destination_address)
				{
				*usptr_outgoing_port_number = sptr_route_cache_entry->port_number;

				*ulptr_next_hop_ip_address = sptr_route_cache_entry->gateway;

				if (sptr_route_cache_entry->ulptr_to_route_table_entry_use_count != NULL)
					{
					++(*sptr_route_cache_entry->ulptr_to_route_table_entry_use_count);
					}

				sptr_ip_upper_layer_parameters->vptr_cached_route = sptr_route_cache_entry;

				ip.sptr_most_recently_used_route = sptr_route_cache_entry;

			#ifdef __IP_DEBUG__
				print_matching_route_cache_entry (sptr_route_cache_entry);
			#endif /* __IP__DEBUG__ */

				++sptr_bucket->use_count;

				return (PASS);
				}

			sptr_route_cache_entry = (IP_ROUTE_CACHE_ENTRY *) get_pointer_to_next_entry_in_list (
				(LINK *) sptr_route_cache_entry);
			}
		}

	return (FAIL);
}
/****************************************************************************/
void print_route_cache (void)
{
	char *ptr_to_string;
	IP_ROUTE_CACHE_HASH_BUCKET *sptr_bucket;
	USHORT bucket;
	USHORT entry;
	IP_ROUTE_CACHE_ENTRY *sptr_route_cache_entry;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		sptr_bucket = ip.sptr_route_cache;

		if (sptr_bucket == NULL)
			{
			return;
			}

		ptr_to_string = &ip.string_to_print[0];

		ptr_to_string += sprintf (ptr_to_string, "IP: route cache:\n");

		for (bucket = 0x0000; bucket < ip.number_of_route_cache_hash_table_buckets; ++bucket)
			{
			ptr_to_string += sprintf (ptr_to_string, "   bucket %u (num:%u, use:%u):\n", bucket, sptr_bucket->number_of_entries,
				sptr_bucket->use_count);

			ip_printf (IP_CACHE_PRINTF, &ip.string_to_print[0]);

			sptr_route_cache_entry = (IP_ROUTE_CACHE_ENTRY *) get_pointer_to_first_entry_in_list ((LINK *) &sptr_bucket->links);

			for (entry = 0x0000; entry < sptr_bucket->number_of_entries; ++entry)
				{
				if ((sptr_route_cache_entry != NULL) && (sptr_route_cache_entry->target != 0x00000000L))
					{
					ptr_to_string = &ip.string_to_print[0];

					convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_route_cache_entry->target);

					convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_route_cache_entry->mask);

					convert_ip_address_to_dot_format (&ip.print_buffer_3[0], sptr_route_cache_entry->gateway);

					ptr_to_string += sprintf (ptr_to_string, "      entry %s (%s) --> %s on port %u\n",
						&ip.print_buffer[0], &ip.print_buffer_2[0], &ip.print_buffer_3[0], sptr_route_cache_entry->port_number);

					ip_printf (IP_CACHE_PRINTF, &ip.string_to_print[0]);
					}

				sptr_route_cache_entry = (IP_ROUTE_CACHE_ENTRY *) get_pointer_to_next_entry_in_list (
					(LINK *) sptr_route_cache_entry);
				}

			ptr_to_string = &ip.string_to_print[0];

			++sptr_bucket;
			}
		}
}
/****************************************************************************/
void print_most_recently_used_cache_entry (IP_ROUTE_CACHE_ENTRY *sptr_route_cache_entry)
{
	char *ptr_to_string;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_route_cache_entry->target);

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_route_cache_entry->mask);

		convert_ip_address_to_dot_format (&ip.print_buffer_3[0], sptr_route_cache_entry->gateway);

		ptr_to_string += sprintf (ptr_to_string, "IP: MRU (%u) cache entry %s (%s) --> %s on port %u\n",
			ip.number_of_times_mru_route_was_used,
			&ip.print_buffer[0], &ip.print_buffer_2[0], &ip.print_buffer_3[0], sptr_route_cache_entry->port_number);

		ip_printf (IP_CACHE_PRINTF, &ip.string_to_print[0]);
		}
}
/****************************************************************************/
void print_matching_route_cache_entry (IP_ROUTE_CACHE_ENTRY *sptr_route_cache_entry)
{
	char *ptr_to_string;

	if (ip.print_class.ip_printing_enabled == TRUE)
		{
		ptr_to_string = &ip.string_to_print[0];

		convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_route_cache_entry->target);

		convert_ip_address_to_dot_format (&ip.print_buffer_2[0], sptr_route_cache_entry->mask);

		convert_ip_address_to_dot_format (&ip.print_buffer_3[0], sptr_route_cache_entry->gateway);

		ptr_to_string += sprintf (ptr_to_string, "IP: matching cache entry %s (%s) --> %s on port %u\n",
			&ip.print_buffer[0], &ip.print_buffer_2[0], &ip.print_buffer_3[0], sptr_route_cache_entry->port_number);

		ip_printf (IP_CACHE_PRINTF, &ip.string_to_print[0]);
		}
}
/****************************************************************************/
enum TEST set_up_routing_data (USHORT *usptr_outgoing_port_number, ULONG *ulptr_next_hop_ip_address,
	IP_ROUTE_CACHE_ENTRY *sptr_route_cache, ULONG ip_destination_address, ULONG type_of_service,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, USHORT tx_port_number)
{
	IP_ROUTE_ENTRY *sptr_route_entry;

	/* convert_ip_address_to_dot_format (&ip.print_buffer[0], ip_destination_address); */
	/* printf ("In set_up_routing_data() for %s\n", &ip.print_buffer[0]) ; */

	if (/*(ip.mib.ipForwarding == FALSE) && */ (ip.rip.protocol_enabled == FALSE))
	{
		/* node is a host and not a router */

		if (get_next_hop_for_ip_destination_address (ip_destination_address, sptr_ip_upper_layer_parameters, tx_port_number) == FAIL)
		{
			++ip.mib.ipOutNoRoutes;

			return (FAIL);
		}

		sptr_route_cache = (IP_ROUTE_CACHE_ENTRY *) sptr_ip_upper_layer_parameters->vptr_cached_route;

		*ulptr_next_hop_ip_address = sptr_route_cache->gateway;

		*usptr_outgoing_port_number = sptr_route_cache->port_number;

		return (PASS);
	}
	else
	{
		sptr_route_entry = ip_find_route_and_update_cache (ip_destination_address, type_of_service);

		if (sptr_route_entry == NULL)
		{
			++ip.mib.ipOutNoRoutes;

			return (FAIL);
		}

		++sptr_route_entry->use_count;

		sptr_ip_upper_layer_parameters->vptr_cached_route = cache_route_in_hash_table (ip_destination_address,
			sptr_route_entry->gateway, sptr_route_entry->port_number, sptr_route_entry->mask, &sptr_route_entry->use_count);

		if (sptr_route_entry->gateway == 0x00000000L)
		{
			*ulptr_next_hop_ip_address = ip_destination_address;
		}
		else
		{
			*ulptr_next_hop_ip_address = sptr_route_entry->gateway;
		}

		*usptr_outgoing_port_number = sptr_route_entry->port_number;

		/* convert_ip_address_to_dot_format (&ip.print_buffer[0], ip_destination_address); */
		/* printf ("Calling modify_outgoing_port...() for target %s\n", &ip.print_buffer[0]) ; */
		modify_outgoing_port_number_to_support_ip_extensions (usptr_outgoing_port_number, ip_destination_address);
	}

	return (PASS);
}
/*************************************************************************/
IP_ROUTE_CACHE_ENTRY *cache_route_in_hash_table (ULONG target, ULONG gateway, USHORT port_number, ULONG mask,
	ULONG *ulptr_use_count)
{
	BYTE hash_value;
	IP_ROUTE_CACHE_HASH_BUCKET *sptr_bucket;
	IP_ROUTE_CACHE_ENTRY *sptr_route_cache_entry;

	hash_value = (BYTE) (((target & 0xff000000L) >> 24) + ((target & 0x00ff0000L) >> 16) + ((target & 0x0000ff00L) >> 8) +
		(target & 0x000000ffL));

	hash_value = (BYTE) (hash_value % ip.number_of_route_cache_hash_table_buckets);

	sptr_bucket = (IP_ROUTE_CACHE_HASH_BUCKET *) ((ULONG) ip.sptr_route_cache +
		hash_value * sizeof (IP_ROUTE_CACHE_HASH_BUCKET));

	if (sptr_bucket->number_of_entries == 0x0000)
		{
		sptr_route_cache_entry = get_pointer_to_first_entry_in_list ((LINK *) &sptr_bucket->links);
		}
	else if ((sptr_bucket->number_of_entries > 0x0000) &&	(sptr_bucket->number_of_entries <= ip.number_of_routes_in_bucket))
		{
		sptr_route_cache_entry = (IP_ROUTE_CACHE_ENTRY *) get_last_entry_in_list ((LINK *) &sptr_bucket->links);

		if (sptr_bucket->number_of_entries == ip.number_of_routes_in_bucket)
			{
			--sptr_bucket->number_of_entries;
			}

		if (sptr_route_cache_entry != NULL)
			{
			add_entry_to_front_of_list ((LINK *) &sptr_bucket->links, (LINK *) sptr_route_cache_entry);
			}
		}
	else
		{
		sptr_route_cache_entry = NULL;
		}

	if (sptr_route_cache_entry == NULL)
		{
	#ifdef __IP_DEBUG__
		ip_printf (IP_CACHE_PRINTF, "IP: tried to cache route but failed: hash value %x\n", hash_value);
	#endif /* __IP__DEBUG__ */

		return (NULL);
		}

	++sptr_bucket->number_of_entries;
	++sptr_bucket->use_count;

	sptr_route_cache_entry->target = target;
	sptr_route_cache_entry->port_number = port_number;
	sptr_route_cache_entry->mask = mask;
	sptr_route_cache_entry->ulptr_to_route_table_entry_use_count = ulptr_use_count;

	if (gateway == 0x00000000L)
		{
		sptr_route_cache_entry->gateway = target;
		}
	else
		{
		sptr_route_cache_entry->gateway = gateway;
		}

	ip.sptr_most_recently_used_route = sptr_route_cache_entry;

#ifdef __IP_DEBUG__
	ip_printf (IP_CACHE_PRINTF, "IP: route has been cached: hash value %x\n", hash_value);
#endif /* __IP__DEBUG__ */

	return (sptr_route_cache_entry);
}
/*************************************************************************/
static void *get_last_entry_in_list (LINK *sptr_list_link)
{
	LINK *sptr_return_link;

	sptr_return_link = sptr_list_link->sptr_backward_link;

	if (sptr_return_link == NULL)
		{
		return (NULL);
		}

	if ((sptr_return_link->sptr_forward_link == NULL) && (sptr_return_link->sptr_backward_link == NULL)) /* 1 entry in list */
		{
		sptr_list_link->sptr_forward_link = NULL;
		sptr_list_link->sptr_backward_link = NULL;

		return (sptr_return_link);
		}

	sptr_return_link->sptr_backward_link->sptr_forward_link = NULL;

	/* new last entry in list because we're deleting the end*/

	sptr_list_link->sptr_backward_link = sptr_return_link->sptr_backward_link;

	return (sptr_return_link);
}
/*************************************************************************/
static enum TEST get_next_hop_for_ip_destination_address ( ULONG ip_destination_address,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, USHORT tx_port_number)
{
	USHORT port_number;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
/* Changed the if condition : Ravi 18 Aug 1999*/
		if ((ip.port[port_number].config.port_enabled == FALSE) || (ip.port[port_number].config.ip_address == 0x00000000L))
			{
			continue;
			}

		if ((ip.port[port_number].config.ip_address & ip.port[port_number].config.subnetmask) ==
			(ip_destination_address & ip.port[port_number].config.subnetmask))
			{
				sptr_ip_upper_layer_parameters->vptr_cached_route = cache_route_in_hash_table (ip_destination_address,
					ip_destination_address, port_number, ip.port[port_number].config.subnetmask, NULL);

				return (PASS);
			}
		}

/* Naveen 1/3/1998 : GATEWAY for INTERNET LAN removed after WAN coming into
                     picture 
*/

/* Added By Naveen for GATEWAY for INTERNET LAN ...*/
#if 0 
   if (is_insecured_lan(tx_port_number))
   {
      if (ip.port[tx_port_number].config.default_gateway != 0x00000000L)
      {
			sptr_ip_upper_layer_parameters->vptr_cached_route = cache_route_in_hash_table (ip_destination_address,
				ip.port[tx_port_number].config.default_gateway, tx_port_number, 0xffffffffL, NULL);

			return (PASS);
      }
      else
         return (FAIL);
   }
#endif
/* ... Added By Naveen for GATEWAY for INTERNET LAN */

#if Ravi
/* Since we have two Default Gateways, one for secure lan and one for Internet
   lan, this scheme wouldn't be suitable. The Gateway and outgoing port no
   is determined in determine_next_hop_ip_address. Hence can safely return
   a FAIL here
*/
	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		if (ip.port[port_number].config.port_enabled == FALSE)
			{
			continue;
			}

		if (ip.port[port_number].config.default_gateway != 0x00000000L)
			{
			sptr_ip_upper_layer_parameters->vptr_cached_route = cache_route_in_hash_table (ip_destination_address,
				ip.port[port_number].config.default_gateway, port_number, 0xffffffffL, NULL);

			return (PASS);
			}
		}
#endif

	return (FAIL);
}
/*************************************************************************/
void modify_outgoing_port_number_to_support_ip_extensions (USHORT *usptr_outgoing_port_number,
	ULONG ip_destination_address)
{
	REMOTE_ACCESS_TABLE_ENTRY *sptr_remote_access_entry;
	ARP_TABLE_ENTRY *sptr_arp_table_entry;

	ip_destination_address = net_to_host_long (ip_destination_address);

	sptr_remote_access_entry = find_remote_access_target (ip_destination_address);

	if (sptr_remote_access_entry != NULL)
	{
		/* convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_remote_access_entry->ip_address); */
		*usptr_outgoing_port_number = sptr_remote_access_entry->remote_port_number;
		/* printf ("Modified outgoing port to %d for target %s\n", *usptr_outgoing_port_number, &ip.print_buffer[0]) ; */
	}
	else
	{
		/*
			Sachin :
			Actually this is never going to be of any use for us
			because Proxy ARP is always disabled on the RAS ports, if any.
			Can think of junking this code because it has quite an amount
			of overhead in the form of the arp-table-search.
		*/
		sptr_arp_table_entry = find_arp_table_entry (*usptr_outgoing_port_number, ip_destination_address, TRUE);

		if (sptr_arp_table_entry != NULL)
		{
			if (ip.port[sptr_arp_table_entry->port_number].config.proxy_arp_enabled == TRUE)
			{
				*usptr_outgoing_port_number = sptr_arp_table_entry->port_number;
			}
		}
	}
}
/****************************************************************************/
enum BOOLEAN ip_tx_filter (USHORT outgoing_port_number, UNION_IP_PACKET *sptr_ip_packet)
{
	/* user defined implementation */

#ifndef IP_FILTERING

	PARAMETER_NOT_USED (outgoing_port_number);
	PARAMETER_NOT_USED (sptr_ip_packet);

	return (FALSE);

#else

	IP_FILTERING_ENTRY *ip_filtering_entry ;

#ifdef PRINTF
	char c1, c2, c3, c4, *temp_ptr = (char *)&sptr_ip_packet->ip.header.destination_ip_address ;
	c1 = *(temp_ptr+0) ;
	c2 = *(temp_ptr+1) ;
	c3 = *(temp_ptr+2) ;
	c4 = *(temp_ptr+3) ;
#endif

	if (ip_filtering_inited == FALSE)
		return (FALSE) ;

	ip_filtering_entry = ip_get_dest_filtering_entry (sptr_ip_packet->ip.header.destination_ip_address,
                         sptr_ip_packet->udp.header.destination_port,
                         sptr_ip_packet->ip.header.protocol) ;
	if (ip_filtering_entry == NULL)
	{
		if (ip_filter_default_tx_action == IP_FILTER_DEFAULT_ACTION_FILTER)
			return (TRUE) ;
		else
			return (FALSE) ;
	}

	if (ip_filtering_entry->port != outgoing_port_number)
	{
		if (ip_filter_default_tx_action == IP_FILTER_DEFAULT_ACTION_FILTER)
			return (TRUE) ;
		else
			return (FALSE) ;
	}

	if ((ip_filtering_entry->type == IP_FILTER_ON_DESTINATION_ADDRESS) ||
	    (ip_filtering_entry->type == IP_FILTER_ON_DESTINATION_PORT) ||
	    (ip_filtering_entry->type == IP_FILTER_ON_DESTINATION_RANGE))
	{
#ifdef PRINTF
			ip_printf (IP_FILTER_PRINTF, "\nIP Filter : Packet to %d.%d.%d.%d filtered off",
			       c1, c2, c3, c4) ;
#endif
		 	return (TRUE) ;
	}
	else
	if ((ip_filtering_entry->type == IP_FORWARD_ON_DESTINATION_ADDRESS) ||
	    (ip_filtering_entry->type == IP_FORWARD_ON_DESTINATION_PORT) ||
	    (ip_filtering_entry->type == IP_FORWARD_ON_DESTINATION_RANGE))
	{
#ifdef PRINTF
			ip_printf (IP_FILTER_PRINTF, "\nIP Filter : Packet to %d.%d.%d.%d forwarded",
			       c1, c2, c3, c4) ;
#endif
		 	return (FALSE) ;
	}

	if (ip_filter_default_tx_action == IP_FILTER_DEFAULT_ACTION_FILTER)
		return (TRUE) ;
	
	return (FALSE) ;

#endif
}


/*************************************************************************/
void keep_count_of_the_type_of_packet_that_was_forwarded (IP_PARAMETERS *sptr_ip_parameters)
{
	++ip.port[sptr_ip_parameters->rx_port_number].statistics.number_of_rxed_packets_forwarded;

	if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
		{
		++ip.port[sptr_ip_parameters->rx_port_number].statistics.number_of_rxed_tcp_packets_forwarded;
		}
	else if (sptr_ip_parameters->protocol == ICMP_PROTOCOL)
		{
		++ip.port[sptr_ip_parameters->rx_port_number].statistics.number_of_rxed_icmp_packets_forwarded;
		}
	else if (sptr_ip_parameters->protocol == UDP_PROTOCOL)
		{
		++ip.port[sptr_ip_parameters->rx_port_number].statistics.number_of_rxed_udp_packets_forwarded;
		}
	else
		{
		++ip.port[sptr_ip_parameters->rx_port_number].statistics.number_of_rxed_unrecognized_packets_forwarded;
		}
}

