/*	$Modname: karp.h$  $version: 1.6$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 05/02/94 yarran added rfc1042 changes.
1.4 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.5 12/27/94 ross added better table instrumentation via new snmp.
1.6 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _KARP_H_
#define _KARP_H_

#define MINIMUM_ARP_PACKET_LENGTH 								sizeof (ARP_PACKET)

#define DEFAULT_ARP_CACHE_TIMEOUT 								600							/* delete entry in 600 seconds */

#define DEFAULT_ARP_REPLY_TIMEOUT 								3								/* retransmit request in 3 seconds */

#define DEFAULT_MAXIMUM_NUMBER_OF_RETRIES 					3

#define DEFAULT_MAXIMUM_NUMBER_OF_ARP_TABLE_ENTRIES 		255

#define IP_ADDRESS_LENGTH 											4

#define MAXIMUM_SIZE_OF_RIF 										18



enum ARP_OPERATION_CODES
{
	ARP_REQUEST					= BIG_ENDIAN_CONSTANT (0x0001),
	ARP_REPLY					= BIG_ENDIAN_CONSTANT (0x0002),
	REVERSE_ARP_REQUEST		= BIG_ENDIAN_CONSTANT (0x0003),
	REVERSE_ARP_REPLY			= BIG_ENDIAN_CONSTANT (0x0004),

	_ARP_USHORT_FILLER 		= 0x0100
};


/* Hardware types 
 *  Operation Code (op)
 *
 *          1   REQUEST
 *          2   REPLY

 * Hardware Type (hrd)

 *    Type   Description                                   References
 *    ----   -----------                                   ----------
 *      1    Ethernet (10Mb)                                    [JBP]
 *      2    Experimental Ethernet (3Mb)                        [JBP]
 *      3    Amateur Radio AX.25                                [PXK]
 *      4    Proteon ProNET Token Ring                          [JBP]
 *      5    Chaos                                              [GXP]
 *      6    IEEE 802 Networks                                  [JBP]
 *      7    ARCNET                                             [JBP]
 *      8    Hyperchannel                                       [JBP]
 *      9    Lanstar                                             [TU]
 *     10    Autonet Short Address                             [MXB1]
 *     11    LocalTalk                                         [JKR1]
 *     12    LocalNet (IBM PCNet or SYTEK LocalNET)             [JXM]
 *     13    Ultra link                                        [RXD2]
 *     14    SMDS                                              [GXC1]
 *     15    Frame Relay                                        [AGM]
 *     16    Asynchronous Transmission Mode (ATM)              [JXB2]

 * Protocol Type (pro)

 *    Use the same codes as listed in the section called "Ethernet
 *    Numbers of Interest" (all hardware types use this code set for the
 *    protocol type).
 */


enum ARP_HARDWARE_TYPES
{
	ARP_HARDWARE_ETHERNET 					= BIG_ENDIAN_CONSTANT (0x0001),
	ARP_HARDWARE_IEEE_802_NETWORKS 		= BIG_ENDIAN_CONSTANT (0x0006),

	_ARP_USHORT_FILLER_ 						= 0x0100
};


enum ARP_TABLE_ENTRY_TYPE
{
	OTHER_ARP_ENTRY 			= 1,
	INVALID_ARP_ENTRY 		= 2,
	DYNAMIC_ARP_ENTRY 		= 3,
	STATIC_ARP_ENTRY 			= 4
};


#endif /* _KARP_H_ */
