#ifndef _PPTPRB_

#define _PPTPRB_

#define PPTP_COLOR_BLACK 0
#define PPTP_COLOR_RED 1


#define PPTP_RB_INSERT_OVERFLOW 0
#define PPTP_RB_NEW_ENTRY 1
#define PPTP_RB_UPDATED 2



typedef struct
{
	USHORT call_id; 
/*	ULONG source_ip_address; */
	ULONG destination_ip_address;
} PPTP_RB_KEY_TYPE ;

typedef struct 
{
	BYTE *ptr_to_pptp_descriptor;
}PPTP_RB_INFO_TYPE;

typedef struct
{
	RED_BLACK_NODE_HEADER rb_header ;
	PPTP_RB_KEY_TYPE key ;
	PPTP_RB_INFO_TYPE info ;
} PPTP_PAC_DESCRIPTOR_NODE ;



typedef struct
{
	ULONG  destination_address;
	USHORT call_id; 
} PPTP_PNS_RB_KEY_TYPE ;


typedef struct 
{
	BYTE *ptr_to_pptp_descriptor;
}PPTP_PNS_RB_INFO_TYPE;


typedef struct
{
	RED_BLACK_NODE_HEADER rb_header ;
	PPTP_PNS_RB_KEY_TYPE key ;
	PPTP_PNS_RB_INFO_TYPE info ;
} PPTP_PNS_DESCRIPTOR_NODE ;

/* function prototypes in pptprb1.c - the pac tree */
PPTP_PAC_DESCRIPTOR_NODE *pptp_pac_descriptor_search_with_client_call_id
					(PPTP_PAC_DESCRIPTOR_NODE *Tree, PPTP_RB_KEY_TYPE key);
PPTP_PAC_DESCRIPTOR_NODE *pptp_pac_descriptor_search
					(PPTP_PAC_DESCRIPTOR_NODE *Tree, PPTP_RB_KEY_TYPE key);
int delete_entry_from_pptp_pac_tree (PPTP_RB_KEY_TYPE key);


/* function prototypes in pptprb2.c - the pns tree */

PPTP_PNS_DESCRIPTOR_NODE *pptp_pns_descriptor_search_with_server_call_id
				(PPTP_PNS_DESCRIPTOR_NODE *Tree, PPTP_PNS_RB_KEY_TYPE key);
PPTP_PNS_DESCRIPTOR_NODE *pptp_pns_descriptor_search
				(PPTP_PNS_DESCRIPTOR_NODE *Tree, PPTP_PNS_RB_KEY_TYPE key);
int delete_entry_from_pptp_pns_tree (PPTP_PNS_RB_KEY_TYPE key);

#endif

