#include	"defs.h"
/*
 * $Log: /IP/RIPINIT.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: ripinit.c$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include "ip.h"
/****************************************************************************/
static void reset_rip_statistics (void);
/****************************************************************************/
enum TEST rip_initialization (void)
{
	IP_SOCKET local_socket;
	ULONG present_time;

	ip.rip.periodic_time_counter = 0x0000;
	ip.rip.next_trigger_broadcast_time = 0x00000000L;
	ip.rip.last_broadcast_time = 0x00000000L;
	ip.rip.need_update = FALSE;
	ip.rip.sptr_udp_registration = NULL;

	if (ip.rip.config.update_time_interval == 0x0000)
		{
		ip.rip.config.update_time_interval = DEFAULT_RIP_RESPONSE_INTERVAL;
		ip.rip.maximum_update_time_offset = MAXIMUM_UPDATE_TIME_OFFSET;
		}
	else
		{
		ip.rip.maximum_update_time_offset = (USHORT) (ip.rip.config.update_time_interval / 10);
		}

	ip.rip.minimum_update_time_interval =
		(USHORT) (ip.rip.config.update_time_interval - (ip.rip.maximum_update_time_offset / 2));

	present_time = (ULONG) time (NULL);

	srand (present_time);

	rip_set_next_regular_update ();

	rip_set_next_trigger_broadcast_time ();

	reset_rip_statistics ();

	local_socket.ip_address = INTERNET_ADDRESS_ANY;
	local_socket.port = RIP_PORT;

	ip.rip.sptr_udp_registration = (UDP_CONTROL_BLOCK *) open_udp (&local_socket, rip_receive_packet, NATIVE_UDP_USER);

	if (ip.rip.sptr_udp_registration == NULL)
		{
		return (FAIL);
		}

	ip.rip.timer_enabled = TRUE;

#ifdef __IP_DEBUG__
	ip_print_routing_table ();
#endif /* __IP__DEBUG__ */

	return (PASS);
}
/****************************************************************************/
static void reset_rip_statistics (void)
{
	memset (&ip.rip.statistics, (int) NULL, sizeof (RIP_STATISTICS));
}
/****************************************************************************/
enum TEST rip_add_static_route_entry (NVRAM_ROUTE_ENTRY *sptr_static_route)
{
	USHORT output_port;
	ROUTE_FLAGS flags;
	BYTE bits;
	IP_ROUTE_ENTRY *sptr_route_entry;

	if ((ip.mib.ipForwarding == FALSE) && (ip.rip.protocol_enabled == FALSE))
		{
		/* node is a host and not a router */

	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RIP: static route dropped: since Forwarding is disabled\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

#if Ravi
	if (sptr_static_route->gateway != 0x00000000L)
		{
      output_port = get_port_from_ip_address (sptr_static_route->gateway);
/* Sachin, 03/04/1997 for correct calculation of port for default route */
#if 0
		output_port = ip_match_subnet_address_to_port (sptr_static_route->gateway);
#endif
		}
	else
		{
      output_port = get_port_from_ip_address (sptr_static_route->target);
#if 0
		output_port = ip_match_subnet_address_to_port (sptr_static_route->target);
#endif
		}
#endif

	output_port = (USHORT) sptr_static_route->port;

	if (output_port == NO_SUCH_PORT)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "IP/RIP: static route gateway %s is not reachable\n",
			convert_ip_address_to_dot_format (&ip.print_buffer[0], sptr_static_route->gateway));
	#endif /* __IP__ALARM_DEBUG__ */

		return (FAIL);
		}

	memset (&flags, 0, sizeof (ROUTE_FLAGS));

	flags.private_route = TRUE;
	flags.do_no_aging = TRUE;

	if (sptr_static_route->target == 0x00000000L)
		{
		/* default route */

		sptr_route_entry = add_ip_route_entry (sptr_static_route->target, 0, sptr_static_route->gateway, output_port,
			sptr_static_route->metric, &flags);
		}
	else
		{
		if (sptr_static_route->host == TRUE)
			{
			flags.host_route = TRUE;

			sptr_route_entry = add_ip_route_entry (sptr_static_route->target, 32, sptr_static_route->gateway, output_port,
				sptr_static_route->metric, &flags);
			}
		else
			{
			bits = ip_convert_mask_to_bits (sptr_static_route->mask);

			sptr_route_entry = add_ip_route_entry (sptr_static_route->target, bits, sptr_static_route->gateway, output_port,
				sptr_static_route->metric, &flags);
			}
		}

	sptr_route_entry->ipRouteProto = LOCALLY_CONFIGURED_TYPE;

	return (PASS);
}
/****************************************************************************/
/* Delete route entries routes set up for this port. This includes the internal net route, subnet route and
 * Point-to-point remote address route. Routes learned from RIP coming via this port will be aged out. */

#if 0
void rip_delete_route_for_port (USHORT port_number)
{
	USHORT bits;
	ULONG target;
	IP_ROUTE_ENTRY *sptr_route_entry;
	IP_PORT_CLASS  *sptr_port;

	sptr_port = &ip.port[port_number];

	if (sptr_port->is_point_to_point == TRUE)
		{
		target = sptr_port->config.point_to_point_remote_ip_address;

		bits = 32;
		}
	else
		{
		target = sptr_port->subnet_address;

		bits = ip_convert_mask_to_bits (sptr_port->subnet_address);
		}

	sptr_route_entry = rip_search_route_table_with_bits (target, bits);

	if ((sptr_route_entry != NULL) &&
		((sptr_route_entry->flags.local_interface_route == TRUE) && (sptr_route_entry->flags.route_down == FALSE)))
		{
		sptr_route_entry->metric = INFINITY_METRIC_VALUE;

		sptr_route_entry->flags.route_down = TRUE;

		sptr_route_entry->aging_timer = ip.rip.config.route_aging_timeout_value; 	/* keep it for 60 seconds */

		rip_initiate_triggered_broadcast (port_number);

	#ifdef __IP_DEBUG__
		ip_print_routing_table ();
	#endif /* __IP__DEBUG__ */
		}
}
#endif

void rip_delete_route_for_port (USHORT port_number)
{
	USHORT bits;
	ULONG target ;
	IP_ROUTE_ENTRY *sptr_route_entry;
	IP_PORT_CLASS  *sptr_port;

	sptr_port = &ip.port[port_number];

	if (sptr_port->is_point_to_point == TRUE)
	{
		/* If it is P-P-link, it is required to down 
			(a). the entry corresponding to the network
			(b). the entry corresponding to the host at the remote end
		*/

		target = sptr_port->subnet_address;
		bits = ip_convert_mask_to_bits (sptr_port->netmask);

		/* for the network */
		sptr_route_entry = rip_search_route_table_with_bits (target, bits);

		if ((sptr_route_entry != NULL) &&
		((sptr_route_entry->flags.local_interface_route == TRUE) && (sptr_route_entry->flags.route_down == FALSE)))
		{
			sptr_route_entry->metric = INFINITY_METRIC_VALUE;

			sptr_route_entry->flags.route_down = TRUE;

			sptr_route_entry->aging_timer = ip.rip.config.route_aging_timeout_value; 	/* keep it for 60 seconds */
		}
		
		target = sptr_port->config.point_to_point_remote_ip_address;
		bits = 32;

		/* for the host */

		sptr_route_entry = rip_search_route_table_with_bits (target, bits);

		if ((sptr_route_entry != NULL) &&
		((sptr_route_entry->flags.local_interface_route == TRUE) && (sptr_route_entry->flags.route_down == FALSE)))
		{
			sptr_route_entry->metric = INFINITY_METRIC_VALUE;

			sptr_route_entry->flags.route_down = TRUE;

			sptr_route_entry->aging_timer = ip.rip.config.route_aging_timeout_value; 	/* keep it for 60 seconds */

		}
	}
	else
	{
		target = sptr_port->subnet_address;

		bits = ip_convert_mask_to_bits (sptr_port->netmask); /* 23/05/96 Sachin */

		sptr_route_entry = rip_search_route_table_with_bits (target, bits);

		if ((sptr_route_entry != NULL) &&
		((sptr_route_entry->flags.local_interface_route == TRUE) && (sptr_route_entry->flags.route_down == FALSE)))
		{
			sptr_route_entry->metric = INFINITY_METRIC_VALUE;

			sptr_route_entry->flags.route_down = TRUE;

			sptr_route_entry->aging_timer = ip.rip.config.route_aging_timeout_value; 	/* keep it for 60 seconds */
		}
	}
	rip_initiate_triggered_broadcast (port_number);

}


/*************************************************************************/
void rip_print_statistics (void)
{
	ip_printf (IP_PRINTF, "RIP STATISTICS:\n");

	ip_printf (IP_PRINTF, "   number of request packets sent : %u\n", ip.rip.statistics.number_of_request_packets_sent);

	ip_printf (IP_PRINTF, "   number of response packets sent : %u\n", ip.rip.statistics.number_of_response_packets_sent);

	ip_printf (IP_PRINTF, "   number of packets received : %u\n", ip.rip.statistics.number_of_packets_received);

	ip_printf (IP_PRINTF, "   number of request packets received : %u\n", ip.rip.statistics.number_of_request_packets_received);

	ip_printf (IP_PRINTF, "   number of response packets received : %u\n",
		ip.rip.statistics.number_of_response_packets_received);

	ip_printf (IP_PRINTF, "   number of unrecongnized packets received : %u\n",
		ip.rip.statistics.number_of_unrecongnized_packets_received);

	ip_printf (IP_PRINTF, "   number of bad versions : %u\n", ip.rip.statistics.number_of_bad_versions);

	ip_printf (IP_PRINTF, "   number of bad address families : %u\n", ip.rip.statistics.number_of_bad_address_families);

	ip_printf (IP_PRINTF, "   number of bad request formats : %u\n", ip.rip.statistics.number_of_bad_request_formats);

	ip_printf (IP_PRINTF, "   number of bad metrics : %u\n", ip.rip.statistics.number_of_bad_metrics);

	ip_printf (IP_PRINTF, "   number of bad response formats : %u\n", ip.rip.statistics.number_of_bad_response_formats);

	ip_printf (IP_PRINTF, "   number of responses not from rip port : %u\n",
		ip.rip.statistics.number_of_responses_not_from_rip_port);

	ip_printf (IP_PRINTF, "   number of responses received from loopback interface : %u\n",
		ip.rip.statistics.number_of_responses_received_from_loopback_interface);

	ip_printf (IP_PRINTF, "   number of packets rejected : %u\n", ip.rip.statistics.number_of_packets_rejected);
}
/*************************************************************************/
void free_ip_rip_list_entries (void)
{
	USHORT port_number;
	RIP_NEIGHBOR_ENTRY *sptr_neighbor_entry;
	RIP_DESTINATION_ENTRY *sptr_destination;

	for (port_number = 0x0000; port_number < ip.number_of_ports; ++port_number)
		{
		sptr_destination = (RIP_DESTINATION_ENTRY *) get_entry_from_list (
			(LINK *) &ip.rip.port[port_number].reject_list);

		while (sptr_destination != NULL)
			{
		#ifdef __IP_DEBUG__
			ip_printf (IP_MEMORY_PRINTF, "IP: freeing rip reject list entry %p\n", sptr_destination);
		#endif /* __IP__DEBUG__ */

			table_free (sptr_destination);

			sptr_destination = (RIP_DESTINATION_ENTRY *) get_entry_from_list (
				(LINK *) &ip.rip.port[port_number].reject_list);
			}

		sptr_destination = (RIP_DESTINATION_ENTRY *) get_entry_from_list (
			(LINK *) &ip.rip.port[port_number].advertise_list);

		while (sptr_destination != NULL)
			{
		#ifdef __IP_DEBUG__
			ip_printf (IP_MEMORY_PRINTF, "IP: freeing rip advertise list entry %p\n", sptr_destination);
		#endif /* __IP__DEBUG__ */

			table_free (sptr_destination);

			sptr_destination = (RIP_DESTINATION_ENTRY *) get_entry_from_list (
				(LINK *) &ip.rip.port[port_number].advertise_list);
			}
		}

	sptr_neighbor_entry = (RIP_NEIGHBOR_ENTRY *) get_entry_from_list ((LINK *) &ip.rip.neighbor_list);

	while (sptr_neighbor_entry != NULL)
		{
		#ifdef __IP_DEBUG__
			ip_printf (IP_MEMORY_PRINTF, "IP: freeing rip neighbor list entry %p\n", sptr_neighbor_entry);
		#endif /* __IP__DEBUG__ */

		table_free (sptr_neighbor_entry);

		sptr_neighbor_entry = (RIP_NEIGHBOR_ENTRY *) get_entry_from_list ((LINK *) &ip.rip.neighbor_list);
		}
}


/* Sachin 03/04/1997 */
extern USHORT port_index_list[] ;
USHORT get_port_from_ip_address (ULONG target)
{
	int i ;
	USHORT port_index ;
	ULONG subnet_mask ;

	for (i = 0 ; i < ip.number_of_ports ; i++)
	{
		port_index = port_index_list[i] ;
		if ((ip.port[port_index].config.port_enabled == FALSE) ||
		    (ip.port[port_index].config.remote_access_enabled == TRUE))
			 continue ;

		subnet_mask = ip.port[port_index].config.subnetmask ;
		if ((subnet_mask & target) == (subnet_mask & ip.port[port_index].config.ip_address))
			return (port_index) ;
	}
	return (NO_SUCH_PORT) ;
}
/* Sachin 03/04/1997 */

