#include	"defs.h"
/*
 * $Log: /IP/UDPSOCK.C $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: udpsock.c$  $version: 1.8$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 10/10/94 ross
1.1 10/10/94 ross added copyrights, udp fixes.
1.2 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.3 12/20/94 ross
1.4 12/27/94 ross added better table instrumentation via new snmp.
1.5 01/26/95 ross SNMP name change, printf change.
1.6 03/03/95 ross added lsl control.
1.7 06/29/95 ross new snmp access routine
1.8 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#include <stdlib.h>
#include "ip.h"	  
/*********************************************************************************/
static void socket_udp_receive_call (UDP_CONTROL_BLOCK *sptr_udp_control_block, USHORT count, void *vptr_user_data,
	IP_SOCKET *sptr_ip_socket);
static LSL_MESSAGE *udp_generate_message (USER_SOCKET *sptr_user_socket, UDP_CONTROL_BLOCK *sptr_udp_control_block,
	enum APPLICATION_CONTROL_OPERATION command);
static void	autobind (USER_SOCKET *sptr_user_socket);
/*********************************************************************************/
enum TEST socket_udp (USER_SOCKET *sptr_user_socket, USHORT protocol)
{
	PARAMETER_NOT_USED (protocol);

	sptr_user_socket->socket_type_of_service = TYPE_UDP;

	return (PASS);
}
/*********************************************************************************/
enum TEST socket_udp_bind (USER_SOCKET *sptr_user_socket)
{
	ULONG socket_descriptor;
	SOCKADDR_IN *sptr_sockaddr_in;
	IP_SOCKET local_socket;

	socket_descriptor = sptr_user_socket->socket_descriptor;

	sptr_sockaddr_in = (SOCKADDR_IN *) sptr_user_socket->vptr_address;

	local_socket.ip_address = sptr_sockaddr_in->sin_addr.s_addr;

	local_socket.port = sptr_sockaddr_in->sin_port;

	sptr_user_socket->vptr_protocol_control_block = open_udp (&local_socket,
		(void (*) (USHORT rx_port_number, IP_SOCKET *sptr_remote_socket, void *vptr_packet_received, USHORT rx_user_data_size,
		IP_PARAMETERS *sptr_ip_parameters)) socket_udp_receive_call, SOCKET_USER);

	if (sptr_user_socket->vptr_protocol_control_block != NULL)
		{
		((UDP_CONTROL_BLOCK *) sptr_user_socket->vptr_protocol_control_block)->user_link = socket_descriptor;
		}
	else
		{
		return (FAIL);
		}

	return (PASS);
}
/*********************************************************************************/
enum TEST socket_udp_connect (USER_SOCKET *sptr_user_socket)
{
	if (sptr_user_socket->vptr_address == NULL)
		{
		autobind (sptr_user_socket);
		}

	return (PASS);
}
/*********************************************************************************/
USHORT socket_udp_receive (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	USHORT *usptr_sockaddr_length, enum TEST *eptr_error)
{
	UDP_CONTROL_BLOCK *sptr_udp_control_block;
	SOCKADDR_IN *sptr_remote_sockaddr_in;
	IP_SOCKET remote_ip_socket;
	ULONG error_number;

	remote_ip_socket.ip_address = 0x00000000L;
	remote_ip_socket.port = 0x0000;

	sptr_udp_control_block = (UDP_CONTROL_BLOCK *) sptr_user_socket->vptr_protocol_control_block;

	while (sptr_udp_control_block != NULL)
		{
		if (get_data_from_udp_receive_queue ((void *) sptr_udp_control_block, &remote_ip_socket, vptr_data, &length) != FAIL)
			{
			break;
			}

		if (sptr_user_socket->do_not_block == TRUE)
			{
			(*ip.udp.socket_fptrs.fptr_set_socket_class_error_number) (WOULD_BLOCK_ERROR);

			*eptr_error = FAIL;

			return (0x0000);
			}

		error_number = (*ip.udp.socket_fptrs.fptr_wait_on_socket_event) (sptr_user_socket, RECEIVE_EVENT);

		(*ip.udp.socket_fptrs.fptr_set_socket_class_error_number) ((USHORT) error_number);

		if (error_number != PASS)
			{
			*eptr_error = FAIL;

			return (0x0000);
			}
		}

	if (sptr_udp_control_block == NULL)
		{
		/* Connection went away */

		(*ip.udp.socket_fptrs.fptr_set_socket_class_error_number) (NOT_CONNECTED_ERROR);

		*eptr_error = FAIL;

		return (0x0000);
		}
	if ((sptr_sockaddr != NULL) && (usptr_sockaddr_length != NULL) && ( ( *((ULONG *)usptr_sockaddr_length) ) >= sizeof (SOCKADDR) ) )
		{
		sptr_remote_sockaddr_in = (SOCKADDR_IN *) sptr_sockaddr;

		sptr_remote_sockaddr_in->sin_family = AF_INET;
		sptr_remote_sockaddr_in->sin_addr.s_addr = remote_ip_socket.ip_address;
		sptr_remote_sockaddr_in->sin_port = remote_ip_socket.port;

/* Added by Naveen 12/6/1998 ... */
		sptr_remote_sockaddr_in->sin_zero[0] = remote_ip_socket.virtual_port_number;
/* ... Added by Naveen 12/6/1998 */

		*usptr_sockaddr_length = sizeof (SOCKADDR);
		}

	return (length);
}
/*********************************************************************************/
USHORT socket_udp_send (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	enum TEST *eptr_error)
{
	SOCKADDR_IN *sptr_local_sockaddr_in;
	SOCKADDR_IN *sptr_remote_sockaddr_in;
	IP_SOCKET local_socket;
	IP_SOCKET remote_socket;

	*eptr_error = PASS;

	if (sptr_user_socket->vptr_address == NULL)
		{
		autobind (sptr_user_socket);
		}

	sptr_local_sockaddr_in = (SOCKADDR_IN *) sptr_user_socket->vptr_address;

	local_socket.ip_address = sptr_local_sockaddr_in->sin_addr.s_addr;
	local_socket.port = sptr_local_sockaddr_in->sin_port;

	if (sptr_sockaddr != NULL)
		{
		sptr_remote_sockaddr_in = (SOCKADDR_IN *) sptr_sockaddr;
		}
	else if (sptr_user_socket->vptr_peer_address != NULL)
		{
		sptr_remote_sockaddr_in = (SOCKADDR_IN *) sptr_user_socket->vptr_peer_address;
		}
	else
		{
		buffer_free ((void *) vptr_data);

		(*ip.udp.socket_fptrs.fptr_set_socket_class_error_number) (NOT_CONNECTED_ERROR);

		*eptr_error = FAIL;

		return (0x0000);
		}

	remote_socket.ip_address = sptr_remote_sockaddr_in->sin_addr.s_addr;
	remote_socket.port = sptr_remote_sockaddr_in->sin_port;
/* Added by Naveen 12/6/1998 ... */
	remote_socket.virtual_port_number = sptr_remote_sockaddr_in->sin_zero[0];
/* ... Added by Naveen 12/6/1998 */

	build_and_send_udp_packet (&local_socket, &remote_socket, sptr_user_socket->internet_type_of_service, vptr_data, length,
		(UDP_CONTROL_BLOCK *) sptr_user_socket->vptr_protocol_control_block);

	return (length);
}
/*********************************************************************************/
USHORT socket_udp_queue_length (USER_SOCKET *sptr_user_socket, USHORT queue_type, enum TEST *eptr_error)
{
	USHORT length;

	*eptr_error = PASS;

	if (sptr_user_socket->vptr_protocol_control_block == NULL)
		{
		*eptr_error = FAIL;

		return (0x0000);
		}

	switch (queue_type)
		{
		case RECEIVE_QUEUE:

			length = ((UDP_CONTROL_BLOCK *) sptr_user_socket->vptr_protocol_control_block)->receive_count;

			return (length);

		case SEND_QUEUE:

			return (0x0000);

		default:

			*eptr_error = FAIL;

			return (0x0000);
		}
}
/*********************************************************************************/
enum TEST socket_udp_shut (USER_SOCKET *sptr_user_socket, USHORT channel)
{
	ULONG socket_descriptor;

	PARAMETER_NOT_USED (channel);

	socket_descriptor = sptr_user_socket->socket_descriptor;

	(*ip.udp.socket_fptrs.fptr_closesocket) ((int) socket_descriptor);

	return (PASS);
}
/*********************************************************************************/
enum TEST socket_udp_close (USER_SOCKET *sptr_user_socket)
{
	if (sptr_user_socket->vptr_protocol_control_block != NULL)
		{
		delete_udp_control_block ((UDP_CONTROL_BLOCK *) sptr_user_socket->vptr_protocol_control_block);
		}

	return (PASS);
}
/*********************************************************************************/
static void socket_udp_receive_call (UDP_CONTROL_BLOCK *sptr_udp_control_block, USHORT count, void *vptr_user_data,
	IP_SOCKET *sptr_ip_socket)
{
	USER_SOCKET *sptr_user_socket;
	LSL_MESSAGE *sptr_lsl_message;

	if (sptr_udp_control_block->user_link != INVALID_SOCKET_DESCRIPTOR)
		{
		sptr_user_socket = (USER_SOCKET *) sptr_udp_control_block->user_link;
		put_data_into_udp_receive_queue (sptr_udp_control_block, count, vptr_user_data, sptr_ip_socket);

		if (sptr_user_socket->do_not_block == FALSE)
			{
			(*ip.udp.socket_fptrs.fptr_wakeup_those_waiting_on_socket_event) (sptr_user_socket, RECEIVE_EVENT);
			}
		else
			{
			sptr_lsl_message = udp_generate_message (sptr_user_socket, sptr_udp_control_block, READ_DATA_FROM_SOCKET);

		#ifdef __LSL__
			lsl_control ((ULONG) ADD_LSL_MESSAGE, (ULONG) LINK_SERVICES_LAYER_TYPE, (ULONG) ADD_MESSAGE_TO_QUEUE,
				sptr_lsl_message,NULL);
		#else
			PARAMETER_NOT_USED (sptr_lsl_message);
		#endif

		#ifdef __IP_DEBUG__
			ip_printf (IP_PRINTF, "UDP: READ DATA FROM SOCKET message placed in mailbox\n");
		#endif /* __IP__DEBUG__ */
			}
		}
	else
		{
	#ifdef __IP_DEBUG__
		ip_printf (IP_PRINTF, "UDP: READ DATA FROM SOCKET: pointer to user socket is invalid\n");
	#endif /* __IP__DEBUG__ */
		}
}
/*****************************************************************************************/
static LSL_MESSAGE *udp_generate_message (USER_SOCKET *sptr_user_socket, UDP_CONTROL_BLOCK *sptr_udp_control_block,
	enum APPLICATION_CONTROL_OPERATION command)
{
	LSL_MESSAGE *sptr_lsl_message;

/*	sptr_lsl_message = (LSL_MESSAGE *) lsl_control (ALLOCATE_LSL_MESSAGE, sizeof (LSL_MESSAGE));*/

	sptr_lsl_message = (LSL_MESSAGE *) table_malloc (1, sizeof (LSL_MESSAGE));

#ifdef __IP_DEBUG__
	ip_printf (IP_PRINTF, "UDP: lsl message allocated at %p (%u)\n", sptr_lsl_message, sizeof (LSL_MESSAGE));
#endif /* __IP_DEBUG__	*/

	if (sptr_lsl_message == NULL)
		{
	#ifdef __IP_ALARM_DEBUG__
		ip_printf (IP_ALARM_PRINTF, "UDP: table_malloc failed\n");
	#endif /* __IP__ALARM_DEBUG__ */

		return (NULL);
		}
	sptr_lsl_message->command = command;

	sptr_lsl_message->socket_descriptor = sptr_user_socket->socket_descriptor;

	sptr_lsl_message->vptr_context = (void *) sptr_udp_control_block;

	sptr_lsl_message->destination_id = sptr_user_socket->application_id;

	sptr_lsl_message->destination_iso_layer_type = APPLICATION_LAYER_TYPE;

	sptr_lsl_message->source_id = ip.stack_id;

	sptr_lsl_message->source_iso_layer_type = NETWORK_LAYER_TYPE;

	return (sptr_lsl_message);
}
/*********************************************************************************/
/*
 * Issue an automatic bind of a local address
 */
static void	autobind (USER_SOCKET *sptr_user_socket)
{
	SOCKADDR_IN sptr_local_sockaddr_in;
	ULONG socket_descriptor;

	socket_descriptor = sptr_user_socket->socket_descriptor;

	sptr_local_sockaddr_in.sin_family = AF_INET;
	sptr_local_sockaddr_in.sin_addr.s_addr = INADDR_ANY;
	sptr_local_sockaddr_in.sin_port = (*ip.udp.socket_fptrs.fptr_get_number_of_already_allocated_ports_in_socket_class) ();

	++sptr_local_sockaddr_in.sin_port;

	(*ip.udp.socket_fptrs.fptr_set_number_of_already_allocated_ports_in_socket_class) (sptr_local_sockaddr_in.sin_port);

	(*ip.udp.socket_fptrs.fptr_bind) ((int) socket_descriptor, (SOCKADDR *) &sptr_local_sockaddr_in, sizeof (SOCKADDR_IN));
}
/*********************************************************************************/
enum TEST socket_udp_status (USER_SOCKET *sptr_user_socket)
{
	udp_print_control_block ((UDP_CONTROL_BLOCK *) sptr_user_socket->vptr_protocol_control_block);

	return (PASS);
}
/*****************************************************************************************/
enum TEST check_ip_address (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length)
{
	SOCKADDR_IN *sptr_sockaddr_in;

	sptr_sockaddr_in = (SOCKADDR_IN *) sptr_sockaddr;

	if ((sptr_sockaddr_in->sin_family != AF_INET) || (sockaddr_length < sizeof (SOCKADDR_IN)))
		{
		return (FAIL);
		}

	return (PASS);
}

