/*
 * $Log: /IP/VARPSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: varpstr.h$  $version: 1.10$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 03/01/94 yarran Change ARP_FLAGS bit structure to enum BOOLEAN structure.
1.4 05/02/94 yarran added rfc1042 changes.
1.5 06/15/94 yarran added port_number to arp table entry.
1.6 09/01/94 ross added BYTE and USHORT_ENUM support.
1.7 11/04/94 ross remote access testing and fixes.
1.8 12/27/94 ross added better table instrumentation via new snmp.
1.9 01/17/95 ross fixed arp problems from snmp
1.10 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VARPSTR_H_
#define _VARPSTR_H_


typedef struct ARP_HEADER
{
	USHORT_ENUM (ARP_HARDWARE_TYPES) 	hardware_type;
	USHORT 										protocol;
	BYTE 											hardware_address_length;
	BYTE 											protocol_address_length;
	USHORT_ENUM (ARP_OPERATION_CODES) 	operation_code;
	MAC_ADDRESS									sender_hardware_address;
	ULONG											sender_protocol_address;
	MAC_ADDRESS 								target_hardware_address;
	ULONG	 										target_protocol_address;
} ARP_HEADER;


typedef struct ARP_PACKET 
{
	UNION_MAC_HEADER							mac_header;
	ARP_HEADER 									header;
} ARP_PACKET;


typedef struct ARP_STATISTICS 
{
	ULONG 		bad_length_field;
	ULONG 		unsupported_hardware;
	ULONG 		unsupported_protocol;
	ULONG 		bad_address;
	ULONG 		total_number_of_packets_received;
	ULONG 		total_number_of_short_packets_received;
	ULONG 		total_number_of_packets_from_me_received;
	ULONG 		total_number_of_source_broadcasts_received;
	ULONG 		total_number_of_replies_sent;
	ULONG 		total_number_of_incoming_requests;
	ULONG			total_number_of_pending_packets_discarded;
	ULONG			total_number_of_requests_sent;
} ARP_STATISTICS;


typedef struct ARP_CONFIGURATION_CLASS
{
	ULONG 		cache_timeout;
	USHORT 		reply_timeout;
	USHORT 		number_of_retries;
} ARP_CONFIGURATION_CLASS;


typedef	struct	ARP_PORT_CLASS
{
	ARP_CONFIGURATION_CLASS			config;
	ARP_TABLE_ENTRY					*sptr_cached_arp_entry;
	ULONG 								number_of_times_cached_entry_was_used;
	USHORT 								number_of_arp_table_entries_awaiting_reply;
	ARP_TABLE_ENTRY_LINK 			current_list;
} ARP_PORT_CLASS;


typedef struct ARP_CLASS
{
	ARP_PORT_CLASS						port[NUMBER_OF_IP_PORTS];
	enum BOOLEAN						timer_enabled;
	ULONG									second_counter;
	ARP_STATISTICS  					statistics;
} ARP_CLASS;


#endif /* _VARPSTR_H_ */
