 
typedef struct SAFETY_BELT
{
   char temp_dns_ip_addr1[25];
   char temp_dns_ip_addr2[25];
   ULONG dns_ip_addr1;
   ULONG dns_ip_addr2;
}SAFETY_BELT;

typedef struct DNS_CONFIG
{
   USHORT max_retransmissions ;
   USHORT max_timeout ;
   USHORT min_timeout ;
   ULONG dns_server_ip_address ;
   USHORT max_references ;
   SAFETY_BELT s_belt;
} DNS_CONFIG ;

/* Sudha 23 June 1998 */
typedef struct DNS_RESOLVED_MULTI_IP_ADDR
{
   USHORT count;
   ULONG *ip_address;
}DNS_RESOLVED_MULTI_IP_ADDR;

typedef struct
{
   BYTE_ENUM(BOOLEAN) in_use ;
   USHORT number_of_retries ;
   USHORT current_timer_value;
   USHORT time_counter ;
   enum DNS_STATE dns_state;
   int socket_num;
   ULONG server_ip_address ;
   ULONG resolved_address;
	DNS_RESOLVED_MULTI_IP_ADDR dns_resolved_multi_ip_addr; /* Sudha 23 June 1998 */
   USHORT number_of_references;   /* this number of references allowed 20 */
/*
sudhir, 30th April 1997
*/
   USHORT rcvd_buff_len;
   USHORT rcvd_buff_index;
   void  (*fptr_complete_routine)(ULONG*, USHORT,USHORT, USHORT);
} DNS_PORT_CLASS ;

typedef struct
{
   BYTE_ENUM(BOOLEAN) enabled ;
   DNS_CONFIG config ;
   DNS_PORT_CLASS port[MAX_WAN_PORTS] ;
   USHORT index_of_cache;
   USHORT no_of_connections;
} DNS_CLASS ;

typedef struct  HEADER
{
   USHORT send_id;
   USHORT ctrl_fld;
   USHORT qdcnt;
   USHORT ancnt;
   USHORT nscnt;
   USHORT arcnt;
}HEADER;

typedef struct SEND_PACKET
{
   HEADER send_hdr;
   BYTE  *send_quest;
   USHORT send_qtype;
   USHORT send_qclass;
}SEND_PACKET;

typedef struct REF_INFO
{
   ULONG Serveraddr;
   BYTE Servername[255];
}REF_INFO;


typedef struct QUERY_INFORMATION
{
   BYTE   S_NAME[255];
   USHORT    S_TYPE;
   USHORT    S_CLASS;
   USHORT    match_count;
   USHORT    num_of_referals;
   USHORT    identifier;
   USHORT    rtx_timeout;
   USHORT    index_of_ref_info;
   USHORT    no_of_ns;
   REF_INFO  reference_info[5];
}QUERY_INFORMATION;

struct RCVD_PACKET
{
   HEADER rcvd_hdr;
   BYTE *send_quest;
   USHORT send_qtype;
   USHORT send_qclass;
   BYTE *rcv_ans;
   BYTE *rcv_auth;
   BYTE *rcv_Add;
};

typedef struct RESOURCE_REC
{
   BYTE  *re_name;
   USHORT  re_type;
   USHORT  re_class;
   ULONG  re_ttl;
   USHORT  re_rdlen;
   BYTE  *re_rdata;
}RESOURCE_REC;

typedef struct DNS_LOCAL_CACHE
{
   RESOURCE_REC *resource_rec;
   USHORT match_count;
   enum BOOLEAN  in_use;
}DNS_LOCAL_CACHE;

/* sudha 18 sep 1998 */

typedef struct DNS_REPLY_CACHE
{
	BYTE in_use;
	BYTE *send_quest ;
	ULONG rr_min_ttl ;
	USHORT data_len ;
	BYTE *reply_pkt;
}DNS_REPLY_CACHE;
/* sudha 18 sep 1998 */

enum TEST initialize_dns (void);
ULONG received_dns_packet (BYTE *rcvd_buf, USHORT rcvd_len, USHORT port_number);
enum TEST allocate_buffers_and_copy_rrs (HEADER *dns_hdr_type, BYTE *rcvd_buf, USHORT, USHORT proxy_dns_quest_len );
BYTE *copy_all_RRs_from_recv_buffer (RESOURCE_REC *dest_rr, BYTE *input_buff, USHORT count, BYTE *ptr_to_next_sec, USHORT, USHORT *, USHORT proxy_dns_quest_len );
USHORT copy_name_from_rr (BYTE *temp_buff, BYTE *ptr_to_name, BYTE *input_buf, BYTE *sptr_resource_rec, USHORT *offset);
ULONG get_ip_address_from_rr_if_any (RESOURCE_REC *ptr_to_rr, USHORT num_of_rrs, USHORT port_number);
USHORT check_for_cname_in_ans_section (RESOURCE_REC *ptr_to_rr, USHORT num_of_rrs,BYTE *input_buff);
/*
sudhir, 30th April 1997
*/
ULONG resolve_with_cname (BYTE *cname_buff, HEADER *dns_header_type, USHORT);

void locate_name_server_and_resolve (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT port_number);
BYTE *locate_suitable_entry_from_auth (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT port_number);
USHORT calculate_match_count (BYTE *ptr_to_name);
USHORT search_in_auth_rr_for_name (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT port_number);
USHORT locate_server_addr_from_add_rr (HEADER *dns_hdr_type, USHORT port_number);
void dns_timer();
enum TEST get_ip_address_from_name (BYTE *domain_name, USHORT port_number, void (*fptr_complete_routine)(ULONG *, USHORT,USHORT, enum TEST));
enum TEST initialize_dns_socket (USHORT port_number);
enum TEST send_query_to_the_address (USHORT port_number);
enum BOOLEAN form_quest_portion (BYTE *fill_addr, BYTE *domain_name);
void get_name_server_and_resolve (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT);
void get_name_server_from_auth_rr (BYTE *ptr_to_name, HEADER *dns_hdr_type, USHORT);
enum BOOLEAN process_dns_response_and_store_in_local_cache ( BYTE *ptr_to_dns_pkt, BYTE *domain_name, USHORT dns_len ) ;
BYTE *get_dns_response_from_local_cache_if_any ( BYTE *domain_name, USHORT *data_len, USHORT dns_id) ;

