/*
 * $Log: /IP/VIPMCSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vipmcstr.h$  $version: 1.1$		 $date: 10/25/95$	  */
/*
* 	$lgb$
1.0 10/25/95 titus
1.1 10/25/95 titus
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VIPMCSTR_H_
#define  _VIPMCSTR_H_

/* rfc1042 data structures */

typedef	struct	SOURCE_ADDRESS
{
	unsigned	char 		sr_byte:6;
	unsigned	char		bit_address:1;
	unsigned	char		routing_field_present:1;
	unsigned	char		_byte:8;
	ULONG					_ulong;
} SOURCE_ADDRESS;


typedef	struct	ROUTING_CONTROL_FIELD
{
	unsigned	char												length_of_routing_field:5;
	BIT_FIELD (enum,BROADCAST_INDICATOR_TYPE)			broadcast_indicators:3;
	unsigned	char												reserved:4;
	BIT_FIELD (enum,LARGEST_FRAME)						largest_frame:3;
	unsigned	char												direction:1;
} ROUTING_CONTROL_FIELD;


typedef	union	UNION_ROUTING_CONTROL_FIELD
{
	ROUTING_CONTROL_FIELD 		_bit;
	USHORT							_ushort;
} UNION_ROUTING_CONTROL_FIELD;


typedef	struct	ROUTE_DESIGNATOR_FIELD
{
	unsigned	char 		ring_number_high:8;
	unsigned	char		bridge_number:4;
	unsigned	char		ring_number:4;
} ROUTE_DESIGNATOR_FIELD;


typedef	union	UNION_ROUTE_DESIGNATOR_FIELD
{
	ROUTE_DESIGNATOR_FIELD		_bit;
	USHORT							_ushort;
} UNION_ROUTE_DESIGNATOR_FIELD;


typedef	struct	ROUTING_INFORMATION_FIELD
{
	UNION_ROUTING_CONTROL_FIELD		control;
	UNION_ROUTE_DESIGNATOR_FIELD		path[8];
} ROUTING_INFORMATION_FIELD;


typedef	struct	SOURCE_ROUTED_NORMALIZED_IP_PACKET
{
	ROUTING_INFORMATION_FIELD		route_information_field;
	BYTE									length_of_rif;
	SNAP_HEADER							snap_header;
	UNION_MAC_HEADER					mac_header;							/* pointer to packet starts here */
	IP_HEADER							ip_header;
} SOURCE_ROUTED_NORMALIZED_IP_PACKET;


#endif /* _VIPMCSTR_H_ */
