/*
 * $Log: /IP/VIPSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vipstr.h$  $version: 1.28$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 02/15/94 yarran Add trace transport buffer in ip class, add debug statistic in port statictics.
1.4 02/22/94 yarran Change function prototype for i960 compiler warnings.
1.5 02/28/94 yarran Change port flag from USHORT to enum BOOLEAN structure.
1.6 03/01/94 yarran
1.7 03/03/94 yarran Handle NVRAM parameters directly by IP
1.8 03/04/94 yarran Add udp_user_get_buffer();
1.9 03/09/94 yarran Add ipconfig.c profile.
1.10 03/10/94 yarran Add memory/data_printing_enabled in IP_PRINT_CLASS.
1.11 03/17/94 yarran Move PSEUDO_IP_HEADER to vipusstr.h.
1.12 03/17/94 yarran Move IP_HEADER to vipktstr.h.
1.13 03/17/94 yarran Change type_of_service type.
1.14 03/17/94 yarran Add register_to_ip_from_upper_layer routine.
1.15 05/02/94 yarran added rfc1042 changes.
1.16 06/15/94 yarran cosmetic changes.
1.17 09/01/94 ross added BYTE and USHORT_ENUM support.
1.18 09/22/94 ross
1.19 10/10/94 ross added rarp, proxy arp, remote access functions
1.20 10/10/94 ross added copyrights, udp fixes.
1.21 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.22 11/04/94 ross remote access testing and fixes.
1.23 12/20/94 ross
1.24 12/27/94 ross added better table instrumentation via new snmp.
1.25 01/17/95 ross fixed arp problems from snmp
1.26 03/03/95 ross added lsl control.
1.27 06/29/95 ross new snmp access routine
1.28 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VIPSTR_H_
#define _VIPSTR_H_


typedef struct NVRAM_ROUTE_LINK
{
	struct NVRAM_ROUTE_ENTRY 			*sptr_forward;
	struct NVRAM_ROUTE_ENTRY 			*sptr_backward;
} NVRAM_ROUTE_LINK;


typedef struct NVRAM_ROUTE_ENTRY
{
	NVRAM_ROUTE_LINK			links;
	ULONG 						target;				/* net, subnet or full host ip address */
	ULONG 						gateway;				/* 0: local attached subnet, or point-to-point link */
	ULONG 						mask;					/* subnet mask */
	ULONG 						metric;
	BYTE_ENUM (BOOLEAN) 		host;					/* TRUE: host, FALSE: net*/
	USHORT						port; 			   /* Added by Ravi */
} NVRAM_ROUTE_ENTRY;


typedef	struct	IP_FORWARD_FILTER
{
	struct IP_FORWARD_FILTER 		*sptr_forward;
	ULONG									ip_address;
	ULONG									mask_bits;
} IP_FORWARD_FILTER;


typedef	struct	IP_PORT_STATISTICS
{
	ULONG 		number_of_ip_packets_rxed;
	ULONG 		number_of_arp_packets_rxed;
	ULONG 		number_of_rarp_packets_rxed;
	ULONG 		number_of_non_ip_packets_rxed;
	ULONG			number_of_icmp_packets_rxed;
	ULONG			number_of_udp_packets_rxed;
	ULONG			number_of_tcp_packets_rxed;
	ULONG			number_of_rip_packets_rxed;
	ULONG			number_of_igrp_packets_rxed;
	ULONG 		number_of_ospf_packets_rxed;
	ULONG			number_of_unrecognized_packets_rxed;
	ULONG 		number_of_packets_rxed_on_disabled_port;
	ULONG			number_of_rxed_packets_forwarded;
	ULONG			number_of_rxed_icmp_packets_forwarded;
	ULONG			number_of_rxed_udp_packets_forwarded;
	ULONG			number_of_rxed_tcp_packets_forwarded;
	ULONG			number_of_rxed_unrecognized_packets_forwarded;
	ULONG			number_of_packets_not_forwarded;
	ULONG 		number_of_rxed_packets_filtered;
	ULONG 		number_of_txed_packets_filtered;
	ULONG 		number_of_short_ip_packets_received;
	ULONG 		number_of_ip_packets_txed;
	ULONG 		number_of_icmp_packets_txed;
	ULONG 		number_of_udp_packets_txed;
	ULONG 		number_of_tcp_packets_txed;
	ULONG 		number_of_rip_packets_txed;
	ULONG 		number_of_igrp_packets_txed;
	ULONG 		number_of_ospf_packets_txed;
	ULONG			number_of_unrecognized_packets_txed;
	ULONG 		number_of_packets_redirected;
} IP_PORT_STATISTICS;


typedef	struct	IP_PORT_CONFIGURATION_CLASS
{
	BYTE_ENUM (BOOLEAN) 					port_enabled;
	USHORT 									virtual_port_number;
	ULONG 									ip_address;
	ULONG 									subnetmask;
	ULONG 									default_gateway;
	USHORT 									maximum_reassembly_size;

	USHORT_ENUM (LSL_PACKET_TYPE) 	lsl_packet_type;
	BYTE_ENUM (BOOLEAN)					rfc1042_enabled;
	BYTE_ENUM (BOOLEAN)					token_ring;
	BYTE_ENUM (LARGEST_FRAME)			token_ring_largest_frame;

	BYTE_ENUM (BOOLEAN)					port_is_loopback;
	USHORT									lan_port_number;

	BYTE_ENUM (BOOLEAN) 					point_to_point_link;
	ULONG 									point_to_point_remote_ip_address;	  /* should be changed also by PPP */

	USHORT 									mtu;
										/* IP level Maximum Transmit Unit size, minimum 28 bytes - 20 bytes IP header, 8 bytes data */
	USHORT									metric;

	BYTE_ENUM (BOOLEAN)					arp_enabled;
	BYTE_ENUM (BOOLEAN)					proxy_arp_enabled;
	BYTE_ENUM (BOOLEAN) 					remote_access_enabled;
	BYTE_ENUM (BOOLEAN)					icmp_mask_request_enabled;
	BYTE_ENUM (BOOLEAN)					icmp_mask_reply_enabled;
	BYTE_ENUM (BOOLEAN)					icmp_redirect_enabled;
	BYTE_ENUM (BOOLEAN)					bootp_enabled;
/* Added by Naveen for Firewall on 3/6/1998... */
	BYTE_ENUM (BOOLEAN)					dhcp_client_enabled;
/* ...Added by Naveen for Firewall on 3/6/1998 */
} IP_PORT_CONFIGURATION_CLASS;


typedef	struct	IP_PORT_CLASS
{
	IP_PORT_CONFIGURATION_CLASS 		config;			  				/* this portion is configured by NVRAM */

	ULONG 									net_address;	  				/* this portion is configured by ip */
	ULONG 									subnet_address;
	ULONG 									netmask;
	ULONG 									net_broadcast_address;
	ULONG 									subnet_broadcast_address;

	BYTE										hardware_address_length;
	MAC_ADDRESS	 							mac_address; 					/* in Big Endian format, i.e. Most Sig. Bit in high order bit */

	BYTE_ENUM (BOOLEAN)					allow_broadcast;
	BYTE_ENUM (BOOLEAN)					is_point_to_point;
	BYTE_ENUM (BOOLEAN)					port_is_up;

	IP_PORT_STATISTICS 					statistics;	  
	IP_FORWARD_FILTER 					*sptr_forward_filter_list;
	enum BOOLEAN							icmp_packet_type_filters[NUMBER_OF_RECOGNIZED_ICMP_PACKET_TYPES] ;
/* Added by Naveen for Firewall on 3/6/1998... */
	BYTE										dhcp_status;
/* ... Added by Naveen for Firewall on 3/6/1998 */
} IP_PORT_CLASS;


typedef	struct	IP_ADDRESS_ENTRY_LINK
{
	struct IP_ADDRESS_ENTRY 			*sptr_forward;
	struct IP_ADDRESS_ENTRY 			*sptr_backward;
} IP_ADDRESS_ENTRY_LINK;


typedef	struct	IP_ADDRESS_ENTRY
{
	IP_ADDRESS_ENTRY_LINK 		links;
	ULONG 							ulptr_to_ipAdEntAddr;
	USHORT 							usptr_to_ipAdEntIfIndex;
	ULONG 							ulptr_to_ipAdEntNetMask;
	ULONG 							ulptr_to_ipAdEntBcastAddr;
	USHORT 							usptr_to_ipAdEntReasmMaxSize;
} IP_ADDRESS_ENTRY;


typedef	struct IP_MIB
{
	/* the first three should be set by NVRAM */
	BYTE			ipForwarding;
	ULONG 		ipDefaultTTL;
	ULONG			ipReasmTimeout;

	/* these are counters */
	ULONG 		ipInReceives;
	ULONG			ipInHdrErrors;
	ULONG			ipInAddrErrors;
	ULONG			ipForwDatagrams;
	ULONG			ipInUnknownProtos;
	ULONG			ipInDiscards;
	ULONG			ipInDelivers;
	ULONG			ipOutRequests;
	ULONG			ipOutDiscards;
	ULONG			ipOutNoRoutes;
	ULONG			ipReasmReqds;
	ULONG			ipReasmOKs;
	ULONG			ipReasmFails;
	ULONG			ipFragOKs;
	ULONG			ipFragFails;
	ULONG			ipFragCreates;
	ULONG			ipRoutingDiscards;
} IP_MIB;


typedef struct IP_STATISTICS
{
	ULONG			ipReasmOverlap;
	ULONG 		number_of_packets_that_couldnot_be_forwarded;
	ULONG 		number_of_times_out_of_memory_while_allocating_ip_packet;
	ULONG 		number_of_allocated_packets_waiting_for_transmit_completes;
	ULONG 		total_transport_buffers_allocated;
	ULONG 		outstanding_transport_ip_list_packets;
	ULONG 		number_of_packets_routed_by_igrp;
	ULONG 		number_of_packets_routed_by_some_other_transport_protocol;
	ULONG 		number_of_packets_routed_by_rip;
	ULONG 		number_of_packets_for_which_no_routes_were_found;
} IP_STATISTICS;


typedef struct IP_OPTION_HEADER
{
#ifndef BIG_ENDIAN
	unsigned char 		option_number:5;
	unsigned char		option_class:2;
	unsigned char		copy_option_on_fragmentation:1;
#else
	unsigned char		copy_option_on_fragmentation:1;
	unsigned char		option_class:2;
	unsigned char		option_number:5;
#endif
} IP_OPTION_HEADER;


typedef struct IP_OPTION
{
	IP_OPTION_HEADER 		code;
	BYTE						length;
	BYTE						pointer;
} IP_OPTION;


typedef	struct	LIST_HEADER_LINKS
{
	struct LIST_HEADER 		*sptr_forward_link;
	struct LIST_HEADER 		*sptr_backward_link;
} LIST_HEADER_LINKS;


typedef	struct	LIST_HEADER
{
	LIST_HEADER_LINKS			links;
	BYTE_ENUM (BOOLEAN)		in_use;
	USHORT						number_of_bytes;
	USHORT						byte_count;
	void 							*vptr_data;
	BYTE 							reserved[9 + 64];
} LIST_HEADER;


/* Fragment descriptor in a reassembly list */

typedef struct FRAGMENT 
{
	struct FRAGMENT 				*sptr_forward;						/* NULL for the last fragment */
	struct FRAGMENT 				*sptr_backward;					/* NULL for the first fragment */
	struct LIST_HEADER_LINKS	list_packet_links;
	USHORT 							offset;
	USHORT 							offset_of_last_byte;	  
} FRAGMENT;


typedef struct REASSEMBLY 
{
	struct REASSEMBLY 		*sptr_forward; 
	USHORT	 					timer_in_seconds;
	FRAGMENT 					*sptr_fragment_link;
	USHORT 						length;			  							/* Entire datagram length, if known */
	ULONG 						source_address;
	ULONG 						destination_address;
	USHORT 						id;
	BYTE 							protocol;
} REASSEMBLY;


typedef	struct IP_PRINT_CLASS
{
	BYTE_ENUM (BOOLEAN) 		ip_print_switch_on;
	BYTE_ENUM (BOOLEAN) 		ip_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		ip_route_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		ip_cache_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		tx_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		rx_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		fragment_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		reassembly_printing_enabled;
	BYTE_ENUM (BOOLEAN)		rip_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		arp_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		rarp_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		icmp_printing_enabled;
	BYTE_ENUM (BOOLEAN) 		udp_printing_enabled;
	BYTE_ENUM (BOOLEAN)		alarm_printing_enabled;
	BYTE_ENUM (BOOLEAN)		memory_printing_enabled;
	BYTE_ENUM (BOOLEAN)		data_printing_enabled;
	BYTE_ENUM (BOOLEAN)		diagnostic_printing_enabled;
#ifdef IP_FILTERING
	BYTE_ENUM (BOOLEAN)		ip_filter_printing_enabled;
#endif
	BYTE_ENUM (BOOLEAN)		dns_printing_enabled;
} IP_PRINT_CLASS;


typedef struct IP_SOURCE_ROUTE_WORKING_AREA 
{
	USHORT			number_of_hops_in_source_route;
	BYTE				nop;			  
	IP_OPTION 		source_route_option;															/* code, length, pointer */
	ULONG 			source_routes[MAXIMUM_IP_OPTION_LENGTH / sizeof (ULONG)];
} IP_SOURCE_ROUTE_WORKING_AREA;


typedef 	struct 	OTHER_TRANSPORT_PROTOCOLS
{
	USHORT_ENUM (IP_PROTOCOL_VALUE)	protocol;

#ifndef __LSL__
	void 		 								(*fptr_timer) (void);

	enum TEST 								(*fptr_control) (enum TRANSPORT_CONTROL_OPERATION command, ULONG parameter_0,
													ULONG parameter_1);
#endif /* __LSL__ */

	void		 								(*fptr_receive_packet) (IP_PARAMETERS *sptr_ip_parameters, void *vptr_rx_packet,
													USHORT packet_size);

	enum TEST 								(*fptr_find_route_and_update_cache) (ULONG type_of_service, ULONG destination_ip_address,
														IP_ROUTE_ENTRY **ptr_to_sptr_route_entry);
} OTHER_TRANSPORT_PROTOCOLS;


typedef	union		UNION_IP_PACKET
{
	ARP_PACKET 			arp;
	RARP_PACKET 		rarp;
	IP_PACKET			ip;
	ICMP_PACKET			icmp;
	RIP_PACKET			rip;
	UDP_PACKET			udp;
} UNION_IP_PACKET;


typedef	struct	IP_LIST_PACKET
{
	LIST_HEADER				header;
	UNION_IP_PACKET 		type;
} IP_LIST_PACKET;


typedef	struct 	IP_CLASS
{
	/* the following portion is set by NVRAM */

	BYTE_ENUM (BOOLEAN) 					enabled;
	BYTE_ENUM (BOOLEAN) 					shutdown_has_begun;
	BYTE_ENUM (BOOLEAN) 					default_values_have_been_set;
	BYTE_ENUM (BOOLEAN) 					initialization_breakpoint;
	BYTE_ENUM (BOOLEAN) 					runtime_breakpoint;
	BYTE_ENUM (BOOLEAN) 					configuration_breakpoint;
	BYTE_ENUM (BOOLEAN) 					shutdown_breakpoint;
	ULONG 									number_of_ports;
/* Added By Naveen for FIREWALL on 23/3/1998... */
   ULONG                            internet_gateway_address;
   ULONG                            internet_gateway_port;
/* ...Added By Naveen for FIREWALL on 23/3/1998 */
	IP_PORT_CLASS							port[NUMBER_OF_IP_PORTS];

	IP_ADDRESS_ENTRY_LINK 				address_list;
	IP_MIB									mib;											/* the first three mibs are set by NVRAM */

	/* the following portion are not set by NVRAM */

	ULONG										stack_id;
	USHORT 									sequence_id;
	char										host_name[HOST_NAME_SIZE];

	BYTE_ENUM (BOOLEAN) 					timer_enabled;
	ULONG										tick_counter;
	ULONG										clock_ticks_per_second;

	IP_ROUTE_ENTRY_LINK 	 				route_list;
	BYTE 										number_of_route_cache_hash_table_buckets;
	BYTE 										number_of_routes_in_bucket;
	IP_ROUTE_CACHE_ENTRY 				*sptr_most_recently_used_route;
	ULONG										number_of_times_mru_route_was_used;				/* mru is for most recently used */
	IP_ROUTE_CACHE_HASH_BUCKET 		*sptr_route_cache;
	IP_ROUTE_ENTRY 						default_route;
	NVRAM_ROUTE_LINK						list_of_nvram_static_route_entries;
	IP_SOURCE_ROUTE_WORKING_AREA		source_route_working_area;

	REASSEMBLY 								*sptr_reassembly_link_list;
	void 										(*fptr_snmp_trap_function) (USHORT port_number, void *vptr_packet, USHORT length);

	ICMP_CLASS 								icmp;
	ARP_CLASS 								arp;
	RARP_CLASS 								rarp;
	UDP_CLASS 								udp;
	RIP_CLASS 								rip;
	IP_REMOTE_ACCESS_CLASS				remote_access;

	USHORT									number_of_other_transport_protocols;
	OTHER_TRANSPORT_PROTOCOLS			other_transport_protocols[MAXIMUM_NUMBER_OF_OTHER_TRANSPORT_PROTOCOLS];

	IP_PRINT_CLASS							print_class;
	char										print_buffer[PRINT_BUFFER_SIZE];
	char										print_buffer_2[PRINT_BUFFER_SIZE];
	char										print_buffer_3[PRINT_BUFFER_SIZE];
	char										string_to_print[MAXIMUM_SIZE_OF_PRINTF];
	IP_STATISTICS							statistics;
} IP_CLASS;


/* iptransp.c */

enum TEST ip_register_upper_layer_protocol (enum IP_PROTOCOL_VALUE protocol_type,
	void (*fptr_receive_packet) (IP_PARAMETERS *sptr_ip_parameters, void *vptr_rx_packet, USHORT packet_size),
	enum TEST (*fptr_find_route_and_update_cache) (ULONG type_of_service, ULONG destination_ip_address,
	void **ptr_to_vptr_route_entry));


/* ipinit.c */

ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...);
enum TEST initialize_ip (ULONG clock_ticks_per_second);
void reset_ip_port_statistics (IP_PORT_CLASS *sptr_port);
enum TEST initialize_all_virtual_ports (void);
enum TEST set_up_port_class_data (USHORT virtual_port_number);
enum TEST initialize_virtual_port (USHORT port_number);
void free_ip_route_cache_entries (void);
#ifdef __IP_BREAKPOINT__
void check_for_ip_initialization_breakpoint (void);
#endif /* __IP_BREAKPOINT__ */


/* ipctrl.c */

enum TEST ip_control (enum PROTOCOL_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1, ULONG parameter_2);
void flush_route_cache (void);


/* ipconfig.c */

enum TEST ip_configuration (enum PROTOCOL_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
enum TEST set_ip_port_frame_type (char *cptr_port_number_and_tx_frame_type_string);
enum TEST set_ip_static_route (char *cptr_target_gateway_metric_string);
enum TEST set_ip_default_route (char *cptr_default_gateway_address_metric_string);
enum TEST add_ip_port_forward_filter_entry (char *cptr_port_number_ip_address_string);
enum TEST set_largest_token_ring_frame_size (char *cptr_port_number_and_size);
ULONG get_ip_configuration_table_address (void);


/* ipexcnfg.c */

enum TEST parse_and_build_reject_list_entries (char *cptr_neighbor_ip_address_string);
enum TEST parse_and_build_advertise_list_entries (char *cptr_neighbor_ip_address_string);
enum TEST parse_and_build_neighbor_list_entries (char *cptr_neighbor_ip_address_string);
enum TEST set_ip_default_values (char *cptr_value_string);
void set_rip_protocol_and_default_values (enum BOOLEAN set_default_values);
enum TEST parse_and_build_static_route_table_entries (char *cptr_ip_address_string);
enum TEST parse_and_build_rarp_server_table_entries (char *cptr_ip_address_string);


/* ipnwcnfg.c */

ULONG special_configuration_function_processing (ULONG parameter[]);


/* iptimer.c */

void ip_router_timer (void);


/* iputil.c */

enum BOOLEAN is_broadcast_address (ULONG ip_address);
USHORT calculate_ip_checksum (PSEUDO_IP_PARAMETERS *sptr_pseudo_header, BYTE *bptr_start_from, USHORT length);
void extract_ip_header (IP_PARAMETERS *sptr_ip_parameters, IP_HEADER *sptr_ip_pdu, USHORT header_length);
void ip_clear_all_counters (void);
USHORT ip_get_mtu_for_outgoing_port (ULONG destination_address);
void ip_send_snmp_trap (USHORT port_number, void *vptr_packet, USHORT length);
UNION_IP_PACKET *get_an_ip_send_packet (USHORT port_number, ULONG size_of_packet);
void free_an_ip_send_packet (USHORT port_number, void *vptr_txed_packet);
USHORT get_size_of_ip_link_layer_type_header (USHORT port_number);
void send_completion_ip_list_packet (USHORT port_number, IP_LIST_PACKET *sptr_tx_packet);
enum BOOLEAN received_broadcast_from_interface (USHORT port_number, UNION_IP_PACKET *uptr_ip_packet);
void set_ip_class_to_zero (void);
void ip_print_routing_table (void);

/* Sachin 02/04/1997 */
extern ICMP_PACKET *get_an_icmp_send_packet (USHORT packet_size) ;
extern void send_completion_icmp_packet (USHORT port_number, ICMP_PACKET *sptr_icmp_tx_packet) ;
/* Sachin 02/04/1997 */

#ifdef ADD_IP_DEFAULT_ROUTE_TO_ROUTE_LIST
/* vidy added this to fix the SNMP-manager-not-showing-default-route problem */
/* this routine skips the default route(target= 0 for default_route) */
IP_ROUTE_ENTRY *get_first_ip_route_entry(void);
/* this routine skips the default route(target= 0 for default_route) */
IP_ROUTE_ENTRY *get_next_ip_route_entry( IP_ROUTE_ENTRY *sptr_route_entry);
#endif


/* ipbuf.c */

enum BOOLEAN memory_is_low (void);
IP_LIST_PACKET *get_ip_list_packet (USHORT size);
void free_ip_list_packet (IP_LIST_PACKET *sptr_ip_list_packet);
IP_LIST_PACKET *copy_ip_list_packet (USHORT ip_list_packet_size, USHORT header_length, USHORT data_size_to_copy,
	BYTE *bptr_packet_to_copy_from);


/* ipoptns.c  */

enum TEST process_ip_options (UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters,
	enum BOOLEAN *eptr_source_route_flag, enum BOOLEAN *eptr_need_new_checksum, IP_ROUTE_ENTRY **sptr_route_entry,
	USHORT *usptr_total_processed_option_length, enum BOOLEAN *eptr_change_ip_destination_for_source_route);
enum TEST clear_options (BYTE *bptr_option, USHORT option_length);


/* ipsrcrt.c  */

void ip_setup_source_route (IP_UPPER_LAYER_PARAMETERS *sptr_ip_request, ULONG ip_source_address);
enum TEST process_source_route_option (IP_OPTION *sptr_option, USHORT processed_option_length,
	UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, enum BOOLEAN strict_source_route_flag,
	USHORT current_option_length, enum BOOLEAN *eptr_need_new_checksum,
	enum BOOLEAN *eptr_change_ip_destination_for_source_route, IP_ROUTE_ENTRY **sptr_route_entry);
enum TEST process_record_route_option (IP_OPTION *sptr_option, USHORT processed_option_length,
	UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters,
	USHORT current_option_length, enum BOOLEAN *eptr_need_new_checksum, IP_ROUTE_ENTRY **sptr_route_entry);


/* iprx.c  */

enum RX_PACKET_STATE ip_router_rx_packet (USHORT port_number, UNION_IP_PACKET *uptr_rx_packet, USHORT size_of_packet);


/* iprxpr.c  */

enum BOOLEAN ip_check_if_destination_address_is_valid (ULONG target);
enum BOOLEAN ip_check_if_source_address_is_valid (ULONG target, USHORT port_number);
enum BOOLEAN ip_rx_filter (IP_PORT_CLASS *sptr_incoming_port, UNION_IP_PACKET *sptr_ip_packet);
enum BOOLEAN check_if_packet_is_to_be_forwarded_onto_a_directly_attached_network (USHORT rx_port_number,
	UNION_IP_PACKET *uptr_ip_rx_packet);
void print_rxed_ip_header (IP_HEADER *sptr_ip_header, USHORT port_number);
#ifdef __IP_BREAKPOINT__
void check_for_ip_runtime_breakpoint (void);
#endif /* __IP_BREAKPOINT__ */


/* iprxassm.c */

void free_reassembly (REASSEMBLY *sptr_reassembly_to_free);
void print_reassembly_control_block (REASSEMBLY *sptr_reassembly);
enum IP_PACKET_STATE pass_ip_packet_to_upper_layer (USHORT incoming_port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *uptr_ip_rx_packet, USHORT number_of_bytes_rxed, IP_ROUTE_ENTRY *sptr_static_route_entry);
void print_reassembled_ip_header (IP_HEADER *sptr_ip_header);
void free_ip_reassembly_control_blocks (void);


/* ipreassm.c */

enum TEST put_packet_into_reassembly_queue (REASSEMBLY *sptr_reassembly, USHORT first_byte_offset_of_current_packet,
	USHORT last_byte_offset_of_current_packet, IP_LIST_PACKET *sptr_ip_list_packet);
void free_fragment (FRAGMENT *sptr_fragment);
enum TEST check_if_the_whole_datagram_has_been_reassembled (UNION_IP_PACKET **ptr_to_uptr_ip_rx_packet,
	IP_PARAMETERS *sptr_ip_parameters, REASSEMBLY *sptr_reassembly);


/* iptx.c  */

void send_ip_packet_from_upper_layer (IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters,
	enum BOOLEAN forwarded_packet, IP_PACKET *sptr_ip_packet, USHORT number_of_bytes,
	void (*fptr_tx_completion) (USHORT port_number, IP_PACKET *sptr_ip_packet), USHORT rx_port_number);
void send_completion_ip_packet (USHORT port_number, void *vptr_txed_packet);
UNION_IP_PACKET *normalize_ip_send_packet_header (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet);
enum FORWARD_STATUS forward_ip_packet (IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet,
		enum BOOLEAN need_new_checksum, enum BOOLEAN change_ip_destination_for_source_route,
		USHORT number_of_bytes, USHORT, enum PROXY_PACKET_TYPE is_this_a_proxy_response, IP_ROUTE_ENTRY *sptr_static_route_entry);


/* iptxpr.c  */

enum TEST lookup_route_cache (ULONG destination_address, ULONG *ulptr_next_hop_ip_address,
	USHORT *usptr_outgoing_port_number, IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters);
void print_route_cache (void);
void print_most_recently_used_cache_entry (IP_ROUTE_CACHE_ENTRY *sptr_route_cache_entry);
void print_matching_route_cache_entry (IP_ROUTE_CACHE_ENTRY *sptr_route_cache_entry);
enum TEST set_up_routing_data (USHORT *usptr_outgoing_port_number, ULONG *ulptr_next_hop_ip_address,
	IP_ROUTE_CACHE_ENTRY *sptr_route_cache, ULONG ip_destination_address, ULONG type_of_service,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, USHORT tx_port_number);
IP_ROUTE_CACHE_ENTRY *cache_route_in_hash_table (ULONG target, ULONG gateway, USHORT port_number, ULONG mask,
	ULONG *ulptr_use_count);
enum BOOLEAN ip_tx_filter (USHORT outgoing_port_number, UNION_IP_PACKET *sptr_tx_packet);
void keep_count_of_the_type_of_packet_that_was_forwarded (IP_PARAMETERS *sptr_ip_parameters);


/* ipfragtx.c */

enum IP_SEND_CONFIRMATION check_for_fragmentation_and_send_packet (IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_ip_packet, USHORT number_of_bytes, IP_PORT_CLASS *sptr_outgoing_port, enum BOOLEAN do_checksum,
	USHORT outgoing_port_number, enum BOOLEAN is_broadcast, enum BOOLEAN forwarded_packet, ULONG next_hop_ip_address,
	void (*fptr_tx_completion) (USHORT port_number, UNION_IP_PACKET *sptr_ip_packet));
enum IP_SEND_CONFIRMATION resolve_mac_address_and_send (USHORT tx_port_number, UNION_IP_PACKET *sptr_ip_packet,
	USHORT number_of_bytes, enum BOOLEAN forwarded_packet, ULONG tx_ip_address, enum BOOLEAN is_broadcast,
	void (*fptr_tx_completion) (USHORT port_number, void *vptr_ip_packet));
enum TEST fragment_packet_and_forward (IP_PARAMETERS *sptr_ip_parameters, USHORT max_tx_unit_size, USHORT number_of_bytes,
	enum BOOLEAN is_broadcast, USHORT outgoing_port_number, ULONG next_router_ip_address,
	UNION_IP_PACKET *sptr_rx_packet);
enum TEST send_packet_to_lsl (USHORT tx_port_number, UNION_IP_PACKET *sptr_tx_packet, USHORT number_of_bytes,
	enum BOOLEAN forwarded_packet, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet),
	enum SNAP_PROTOCOL_ID protocol_type, MAC_ADDRESS *destination_mac_address);
void print_txed_ip_header (IP_HEADER *sptr_ip_header, USHORT port_number);
void print_forwarded_ip_header (IP_HEADER *sptr_ip_header, USHORT port_number);


/* ipprint.c */

void enable_or_disable_ip_printing (enum BOOLEAN enable_or_disable);
void enable_or_disable_ip_group_printing (enum BOOLEAN enable_or_disable, enum IP_PRINTF_GROUPS printf_group);
char *select_print_message (char *ptr_print_array[], USHORT total_messages, USHORT message_index);
char *select_print_ip_message (char *cptr_print_array[], USHORT total_messages, USHORT message_index,
	ULONG destination_address);
void ip_printf (enum IP_PRINTF_GROUPS printf_group, const char *cptr_format,  ...);
void ip_print_protocol_statistics (void);
void ip_print_port_statistics (void);


/* icmprx.c */

enum TEST initialize_icmp (void);
enum IP_PACKET_STATE receive_icmp_packet (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PACKET *sptr_icmp_packet, USHORT icmp_packet_size);


/* icmprxpr.c */

enum IP_PACKET_STATE process_icmp_packet (ICMP_PACKET *sptr_icmp_packet, IP_PARAMETERS *sptr_ip_parameters,
	ICMP_PARAMETERS *sptr_icmp_parameters, USHORT icmp_packet_size, USHORT);

/* icmptx.c */

void send_icmp_error_packet (USHORT port_number, IP_PARAMETERS *sptr_ip_parameters,
	UNION_IP_PACKET *sptr_ip_packet, enum ICMP_MESSAGE_TYPE type, BYTE code, UNION_ICMP_PARAMETER *uptr_option_data);
void setup_reflected_ip_header (IP_UPPER_LAYER_PARAMETERS *sptr_ip_request, IP_PARAMETERS *sptr_ip_parameters,
	BYTE protocol_id, BYTE *bptr_options, ICMP_HEADER **ptr_to_sptr_icmp_header, ICMP_PACKET *sptr_icmp_packet);
void send_icmp_redirect_message (USHORT port_number, IP_ROUTE_ENTRY *sptr_route_entry, IP_PORT_CLASS *sptr_incoming_port,
	IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *sptr_ip_packet);
void send_icmp_request_message (USHORT port_number, IP_PARAMETERS *sptr_ip_parameters, enum ICMP_MESSAGE_TYPE type, BYTE code,
	UNION_ICMP_PARAMETER *uptr_option_data);


/* icmpprnt.c */

void print_icmp_header (ICMP_HEADER *sptr_icmp_header);


/* udprx.c */

enum TEST initialize_udp (void);
void *open_udp (IP_SOCKET *sptr_local_socket,
	void (*fptr_call_udp_user) (USHORT rx_port_number, IP_SOCKET *sptr_remote_socket, void *vptr_packet_received,
	USHORT rx_user_data_size, IP_PARAMETERS *sptr_ip_parameters), enum USER_TYPE user_type);
void receive_udp_packet (USHORT rx_port_number, IP_PARAMETERS *sptr_ip_parameters, UNION_IP_PACKET *uptr_ip_rx_packet,
	USHORT udp_packet_size);
enum TEST put_data_into_udp_receive_queue (UDP_CONTROL_BLOCK *sptr_udp_control_block, USHORT number_of_data_bytes,
	void *vptr_user_data, IP_SOCKET *sptr_ip_socket);
enum TEST get_data_from_udp_receive_queue (void *vptr_context, IP_SOCKET *sptr_ip_socket, void *vptr_buffer,
	USHORT *usptr_count);
void udp_print_control_block (UDP_CONTROL_BLOCK *sptr_udp_control_block);
enum TEST delete_udp_control_block (UDP_CONTROL_BLOCK *sptr_udp_control_block_to_delete);
void free_udp_control_blocks (void);
enum TEST create_pseudo_header_and_verify_checksum (USHORT packet_size, IP_PARAMETERS *sptr_ip_parameters,
	USHORT checksum, BYTE *bptr_to_checksummed_data, BYTE protocol_id);


/* udptx.c */

USHORT send_udp (USHORT tx_port_number, IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket,
	SERVICE_TYPE_BIT_STRUCTURE type_of_service,
	BYTE time_to_live, void *vptr_udp_packet, USHORT sequence_identifier, enum BOOLEAN do_not_fragment_flag,
	USHORT number_of_bytes, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet), void *vptr_control_block);
USHORT build_and_send_udp_packet (IP_SOCKET *sptr_local_socket, IP_SOCKET *sptr_remote_socket, BYTE type_of_service,
	void *vptr_data, USHORT number_of_bytes, UDP_CONTROL_BLOCK *sptr_udp_control_block);
void print_udp_header (UDP_HEADER *sptr_udp_header);


/* udpsock.c */

enum TEST socket_udp (USER_SOCKET *sptr_user_socket, USHORT protocol);
enum TEST socket_udp_bind (USER_SOCKET *sptr_user_socket);
enum TEST socket_udp_connect (USER_SOCKET *sptr_user_socket);
USHORT socket_udp_receive (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	USHORT *usptr_sockaddr_length, enum TEST *eptr_error);
USHORT socket_udp_send (USER_SOCKET *sptr_user_socket, void *vptr_data, USHORT length, SOCKADDR *sptr_sockaddr,
	enum TEST *eptr_error);
USHORT socket_udp_queue_length (USER_SOCKET *sptr_user_socket, USHORT queue_type, enum TEST *eptr_error);
enum TEST socket_udp_close (USER_SOCKET *sptr_user_socket);
enum TEST socket_udp_status (USER_SOCKET *sptr_user_socket);
enum TEST check_ip_address (SOCKADDR *sptr_sockaddr, USHORT sockaddr_length);


/* arp.c */

enum TEST initialize_arp (void);
void call_arp_timer_if_enabled (void);
void arp_print_table (void);


/* arprx.c */

enum IP_PACKET_STATE arp_packet_received (USHORT port_number, ARP_PACKET *sptr_arp_packet, USHORT number_of_bytes_rxed);
void add_token_ring_rif_to_arp_table_entry (ARP_PACKET *sptr_arp_packet, ARP_TABLE_ENTRY *sptr_arp_table_entry);
void add_rif_to_token_ring_packet (UNION_IP_PACKET *uptr_ip_packet, ARP_TABLE_ENTRY *sptr_arp_table_entry);


/* arptx.c */

void send_arp_reply (USHORT port_number, ARP_PACKET *sptr_arp_packet, USHORT number_of_bytes_rxed,
	ULONG target_protocol_address, ARP_TABLE_ENTRY *sptr_arp_table_entry, enum BOOLEAN proxy_arp, enum BOOLEAN i_am_target);
enum TEST send_proxy_arp_if_enabled_when_the_target_is_not_this_router (ULONG sender_protocol_address,
	ULONG target_protocol_address, USHORT port_number, enum BOOLEAN target_to_me, ARP_TABLE_ENTRY **ptr_to_sptr_arp_table_entry,
	ARP_PACKET *sptr_arp_packet);
MAC_ADDRESS *resolve_destination_ip_address_using_arp (UNION_IP_PACKET *sptr_tx_packet, USHORT tx_port_number,
	ULONG tx_ip_address, USHORT number_of_bytes);
void *convert_ip_tx_header_to_source_routed_header (USHORT tx_port_number, UNION_IP_PACKET *uptr_ip_packet,
	enum SNAP_PROTOCOL_ID protocol_type);
enum TEST send_arp_request_packet (USHORT tx_port_number, ULONG tx_ip_address, enum BOOLEAN proxy_arp,
	MAC_ADDRESS *sptr_mac_address, ULONG sender_ip_address);


/* arplist.c */

void *add_entry_to_arp_table (USHORT port_number, ULONG ip_address, MAC_ADDRESS *sptr_mac_address,
	enum ARP_TABLE_ENTRY_TYPE type, void *vptr_packet);
void delete_arp_table_entry (ARP_TABLE_ENTRY *sptr_arp_table_entry);
ARP_TABLE_ENTRY *find_arp_table_entry (USHORT port_number, ULONG ip_address, enum BOOLEAN valid);
ARP_TABLE_ENTRY *find_arp_table_entry_on_port (USHORT port_number, ULONG ip_address, enum BOOLEAN valid);
void delete_arp_table_entry_using_ip_address (USHORT port_number, ULONG ip_address);
void free_ip_arp_entries (void);


/* ipremacc.c */

REMOTE_ACCESS_TABLE_ENTRY *find_remote_access_target (ULONG target_protocol_address);
REMOTE_ACCESS_TABLE_ENTRY *remote_access_client_up (USHORT rx_port_number, ULONG ip_address);
REMOTE_ACCESS_TABLE_ENTRY *remote_access_client_down (USHORT rx_port_number, ULONG ip_address);
enum BOOLEAN remote_access_enabled_for_lan (USHORT port_number);


/* rarp.c */

enum TEST initialize_rarp (void);
enum IP_PACKET_STATE rarp_packet_received (USHORT port_number, RARP_PACKET *sptr_rarp_packet,USHORT number_of_bytes_rxed);
void send_rarp_request (USHORT port_number);
void rarp_client_timer (void);
void *add_rarp_table_entry (USHORT port_number, ULONG ip_address, MAC_ADDRESS *sptr_mac_address);
void rarp_print_table (void);
void free_ip_rarp_entries (void);


/* iproute.c */

USHORT ip_match_full_address_to_port (ULONG ip_address);
USHORT ip_match_subnet_address_to_port (ULONG ip_address);
ULONG ip_get_address_of_outgoing_interface (ULONG destination_ip_address);
IP_ROUTE_ENTRY *ip_find_route_and_update_cache (ULONG destination_ip_address, ULONG type_of_service);
BYTE ip_determine_number_of_bits_in_net_portion (ULONG ip_address);
BYTE ip_convert_mask_to_bits (ULONG mask);
void ip_add_route_for_port (USHORT port_number);
BYTE ip_guess_the_number_of_bits_in_subnet_mask (ULONG ip_address);
ULONG ip_get_network_mask (ULONG ip_address);
void inform_neighboring_routers_of_invalid_routes (void);
BYTE ip_determine_number_of_bits_in_subnet_mask (ULONG *ulptr_target, USHORT port_number, BYTE metric);


/* ripinit.c  */

enum TEST rip_initialization (void);
enum TEST rip_add_static_route_entry (NVRAM_ROUTE_ENTRY *sptr_static_route);
void rip_delete_route_for_port (USHORT port_number);
void free_ip_rip_list_entries (void);
USHORT get_port_from_ip_address (ULONG target);


/* rip.c  */

enum BOOLEAN rip_is_it_ok_to_announce_this_route (IP_ROUTE_ENTRY *sptr_route_entry, ULONG destination_address,
	USHORT outgoing_port_number, ULONG *ulptr_netmask);
void rip_periodic_timer (void);
IP_ROUTE_ENTRY *rip_search_route_table_with_bits (ULONG destination_ip_address, USHORT bits);
IP_ROUTE_ENTRY *rip_search_route_table (ULONG destination_ip_address);
void change_route_entry (IP_ROUTE_ENTRY *sptr_route_entry, ULONG gateway_address, ULONG metric, USHORT port_number);
IP_ROUTE_ENTRY *add_ip_route_entry (ULONG target_ip_address, BYTE bits, ULONG gateway, USHORT port_number, ULONG metric,
	ROUTE_FLAGS *sptr_flags);
void delete_ip_route_entry (IP_ROUTE_ENTRY *sptr_route_entry);
void free_ip_routing_table_entries (void);
void rip_set_next_regular_update (void);


/* riptx.c */

void rip_initiate_triggered_broadcast (USHORT skip_port_number);
void rip_broadcast_request_packets_on_all_ports (void);
void rip_broadcast_updates (enum BOOLEAN triggered, USHORT port_to_skip);
void build_rip_header (RIP_HEADER *sptr_rip_header, enum RIP_PACKET_TYPE type);
void rip_send_full_response (USHORT outgoing_port_number, IP_SOCKET *sptr_remote_socket, enum BOOLEAN poison_reverse_enabled,
	enum BOOLEAN trigger_update, enum BOOLEAN include_routes_to_me);
void compute_rip_packet_size_and_number_of_routes (USHORT outgoing_port_number, USHORT *usptr_rip_packet_size,
	USHORT *usptr_number_of_entries);
enum TEST rip_set_next_trigger_broadcast_time (void);


/* riptxrep.c */

void send_rip_response_packet (IP_SOCKET *sptr_remote_socket, enum BOOLEAN poison_reverse_enabled,
	enum BOOLEAN trigger_update, enum BOOLEAN include_routes_to_me, USHORT outgoing_port_number, USHORT rip_packet_size,
	USHORT max_entries, IP_SOCKET local_socket);
void allocate_rip_response_packet_and_build_header (USHORT outgoing_port_number, USHORT rip_packet_size,
	RIP_PACKET **ptr_to_sptr_rip_tx_packet, USHORT *usptr_number_of_route_entries, RIP_ROUTE_ENTRY **ptr_to_sptr_rip_entry);
void rip_print_header (RIP_HEADER *sptr_rip_header);
void rip_print_routing_entry (RIP_ROUTE_ENTRY *sptr_rip_route_entry);


/* riprx.c */

void rip_receive_packet (USHORT rx_port_number, IP_SOCKET *sptr_remote_socket, void *vptr_rxed_packet,
	USHORT rip_packet_size, IP_PARAMETERS *sptr_ip_parameters);
enum BOOLEAN rip_check_if_target_is_a_valid_host_or_network_address (ULONG target);
enum BOOLEAN check_if_reserved_fields_are_all_zeroes_for_rip_version_one (RIP_HEADER *sptr_rip_header,
	RIP_ROUTE_ENTRY *sptr_rip_entry, ULONG sender_ip_address);


/* riprxrep.c */

void rip_process_response_packet (USHORT rx_port_number, RIP_HEADER *sptr_rip_header, USHORT size_of_routes,
	IP_SOCKET *sptr_remote_socket);


/* ripreppr.c */

USHORT process_rip_entry (USHORT rx_port_number, ULONG sender_ip_address, RIP_ROUTE_ENTRY *sptr_rip_entry);
void rip_send_icmp_address_mask_request (void);
void setup_ip_parameters_and_icmp_option_data (IP_ROUTE_ENTRY *sptr_route_entry,
	IP_PARAMETERS *sptr_ip_parameters, UNION_ICMP_PARAMETER *uptr_icmp_parameters);


/* ipsnmp.c */

/* Srikar, Mar 20, 1997. Changed the type and name of the parameter bptr_table_indices to OBJECT_ID * */
/* and sptr_table_indices */
enum TEST get_rfc1213_arp_table_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);
/* Srikar, Mar 20, 1997. Changed the type and name of the parameter bptr_table_indices to OBJECT_ID * */
/* and sptr_table_indices */
enum TEST get_rfc1213_ip_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);
/* Srikar, Mar 20, 1997. Changed the type and name of the parameter bptr_table_indices to OBJECT_ID * */
/* and sptr_table_indices */
enum TEST get_rfc1213_icmp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);
/* Srikar, Mar 20, 1997. Changed the type and name of the parameter bptr_table_indices to OBJECT_ID * */
/* and sptr_table_indices */
enum TEST get_rfc1213_udp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* iprxbc.c */

enum BOOLEAN check_if_packet_is_a_broadcast (IP_PARAMETERS *sptr_ip_parameters, USHORT rx_port_num);  
enum IP_PACKET_STATE put_ip_packet_on_all_the_concerned_ports( IP_PARAMETERS *sptr_parameters, USHORT port_number, 
		UNION_IP_PACKET *uptr_ip_rx_packet, USHORT size_of_packet, enum BOOLEAN need_checksum, USHORT processed_option_lenth);

#endif /* _VIPSTR_H_ */



