/*
 * $Log: /IP/VNVIP.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vnvip.h$  $version: 1.9$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 03/03/94 yarran
1.1 03/03/94 yarran Initial Release, including static routes, default route configuration.
1.2 03/03/94 yarran Handle NVRAM parameters directly by IP
1.3 03/10/94 yarran Fix bug in IP_PORT_CLASS configurations.
1.4 05/02/94 yarran added rfc1042 changes.
1.5 10/10/94 ross added rarp, proxy arp, remote access functions
1.6 10/25/94 ross clean up for C++ compiles. Added rwarebuf.h to bottom of meta-include.
1.7 12/27/94 ross added better table instrumentation via new snmp.
1.8 01/17/95 ross fixed arp problems from snmp
1.9 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VNVIP_H_
#define _VNVIP_H_

#ifdef IP_FILTERING
enum TEST ip_src_filter_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_dest_filter_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_src_port_filter_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_dest_port_filter_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_src_range_filter_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_dest_range_filter_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_src_forward_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_dest_forward_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_src_port_forward_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_dest_port_forward_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_src_range_forward_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_dest_range_forward_cfg_string (char *cptr_port_number_ip_address_string);
enum TEST ip_set_filtering_table_size (char *cptr_port_number_ip_address_string);
enum TEST ip_icmp_filter (char *cptr_port_number_and_string);
#if 0
enum TEST ip_set_filtering_default_rx_action (char *cptr_port_number_ip_address_string);
enum TEST ip_set_filtering_default_tx_action (char *cptr_port_number_ip_address_string);
#endif
enum TEST ip_set_filtering_default_action (char *cptr_port_number_ip_address_string);
#endif

CONFIGURATION_TABLE ip_configuration_table =
{
	{TRUE},
/* _____________________________________________________________________________________________ */

	{
	/* IP Configuration parameters */

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ip_default_values,
		NULL,
	"IP Set Default Values ="
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP =",
		(ULONG) offsetof (IP_CLASS, enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"IP Number of Ports =",
		(ULONG) offsetof (IP_CLASS, number_of_ports),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP RIP =",
		(ULONG) offsetof (IP_CLASS, rip.protocol_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port =",
		(ULONG) offsetof (IP_CLASS, port[0].config.port_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* Added by Naveen for Firewall on 3/6/1998... */
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port DHCP Client =",
		(ULONG) offsetof (IP_CLASS, port[0].config.dhcp_client_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},
/* ...Added by Naveen for Firewall on 3/6/1998 */

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"IP Port Address =",
		(ULONG) offsetof (IP_CLASS, port[0].config.ip_address),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"IP Port Address Mask =",
		(ULONG) offsetof (IP_CLASS, port[0].config.subnetmask),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		parse_and_build_static_route_table_entries,
		NULL,
	"IP Static Route Table Entries ="
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ip_default_route,
		NULL,
	"IP Default Route ="
	},

/* Added By Naveen 23/3/1998... */
/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"IP Internet Gateway Port =",
		(ULONG) offsetof (IP_CLASS, internet_gateway_port),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_ip_address_string,ULONG vptr_parameter_1, ULONG ulptr_parameter_2,ULONG size_of_parameter))
		set_ip_address_alone,
		NULL,
	"IP Internet Gateway Address =",
		(ULONG) offsetof (IP_CLASS, internet_gateway_address),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
/* ...Added By Naveen 23/3/1998 */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port Point-to-Point Link =",
		(ULONG) offsetof (IP_CLASS, port[0].config.point_to_point_link),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"IP Port Remote Address =",
		(ULONG) offsetof (IP_CLASS, port[0].config.point_to_point_remote_ip_address),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS),
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IP Port MTU =",
		(ULONG) offsetof (IP_CLASS, port[0].config.mtu),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IP Port Metric =",
		(ULONG) offsetof (IP_CLASS, port[0].config.metric),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ip_port_frame_type,
		NULL,
	"IP Port Frame Type =",
		(ULONG) offsetof (IP_CLASS, port[0].config.lsl_packet_type),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP RIP Neighbor List =",
		(ULONG) offsetof (IP_CLASS, rip.config.neighbor_list_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		parse_and_build_neighbor_list_entries,
		NULL,
	"IP RIP Neighbor List Entries ="
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RIP Announce Static Routes =",
		(ULONG) offsetof (IP_CLASS, rip.port[0].announce_static_routes_enabled),
		(ULONG) &ip,
		sizeof (RIP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		parse_and_build_reject_list_entries,
		NULL,
	"IP Port RIP Reject List Entries ="
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		parse_and_build_advertise_list_entries,
		NULL,
	"IP Port RIP Advertise List Entries ="
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RFC1042 =",
		(ULONG) offsetof (IP_CLASS, port[0].config.rfc1042_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port Token Ring =",
		(ULONG) offsetof (IP_CLASS, port[0].config.token_ring),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_largest_token_ring_frame_size,
		NULL,
	"IP Port Token Ring Largest Frame Size ="
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ip_address,
		NULL,
	"IP Port Default Gateway =",
		(ULONG) offsetof (IP_CLASS, port[0].config.default_gateway),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port BOOTP =",
		(ULONG) offsetof (IP_CLASS, port[0].config.bootp_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port ARP =",
		(ULONG) offsetof (IP_CLASS, port[0].config.arp_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RIP Split Horizon =",
		(ULONG) offsetof (IP_CLASS, rip.port[0].split_horizon_enabled),
		(ULONG) &ip,
		sizeof (RIP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RIP Poison Reverse =",
		(ULONG) offsetof (IP_CLASS, rip.port[0].poison_reverse_enabled),
		(ULONG) &ip,
		sizeof (RIP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RIP Route Holddown =",
		(ULONG) offsetof (IP_CLASS, rip.port[0].route_holddown_enabled),
		(ULONG) &ip,
		sizeof (RIP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RIP Summarize Routes =",
		(ULONG) offsetof (IP_CLASS, rip.port[0].route_summarization_enabled),
		(ULONG) &ip,
		sizeof (RIP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RIP Announce Default Route =",
		(ULONG) offsetof (IP_CLASS, rip.port[0].announce_default_route_enabled),
		(ULONG) &ip,
		sizeof (RIP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RIP Announce Host Routes =",
		(ULONG) offsetof (IP_CLASS, rip.port[0].announce_host_routes_enabled),
		(ULONG) &ip,
		sizeof (RIP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RIP Send Requests =",
		(ULONG) offsetof (IP_CLASS, rip.port[0].send_requests),
		(ULONG) &ip,
		sizeof (RIP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RIP Send Responses =",
		(ULONG) offsetof (IP_CLASS, rip.port[0].send_response_updates),
		(ULONG) &ip,
		sizeof (RIP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IP Port Maximum Reassembly Size =",
		(ULONG) offsetof (IP_CLASS, port[0].config.maximum_reassembly_size),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ulong_decimal_value,
		NULL,
	"IP Port ARP Aging Timeout =",
		(ULONG) offsetof (IP_CLASS, arp.port[0].config.cache_timeout),
		(ULONG) &ip,
		sizeof (ARP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IP Port ARP Reply Timeout =",
		(ULONG) offsetof (IP_CLASS, arp.port[0].config.reply_timeout),
		(ULONG) &ip,
		sizeof (ARP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IP Port ARP Number of Retransmissions =",
		(ULONG) offsetof (IP_CLASS, arp.port[0].config.number_of_retries),
		(ULONG) &ip,
		sizeof (ARP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port ICMP Mask Request =",
		(ULONG) offsetof (IP_CLASS, port[0].config.icmp_mask_request_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port ICMP Mask Reply =",
		(ULONG) offsetof (IP_CLASS, port[0].config.icmp_mask_reply_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port ICMP Redirect =",
		(ULONG) offsetof (IP_CLASS, port[0].config.icmp_redirect_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Forwarding =",
		(ULONG) offsetof (IP_CLASS, mib.ipForwarding),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_string,
		NULL,
	"IP Host Name =",
		(ULONG) offsetof (IP_CLASS, host_name[0]),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"IP Default TTL =",
		(ULONG) offsetof (IP_CLASS, mib.ipDefaultTTL),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
	"IP Reassembly Timeout =",
		(ULONG) offsetof (IP_CLASS, mib.ipReasmTimeout),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IP ICMP Address Mask Request Timeout =",
		(ULONG) offsetof (IP_CLASS, icmp.mask_request_timeout),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IP RIP Response Interval =",
		(ULONG) offsetof (IP_CLASS, rip.config.update_time_interval),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IP RIP Route Aging Timeout =",
		(ULONG) offsetof (IP_CLASS, rip.config.route_aging_timeout_value),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IP RIP Route Garbage Collection Timeout =",
		(ULONG) offsetof (IP_CLASS, rip.config.route_garbage_collection_timeout_value),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_byte_decimal_value,
		NULL,
	"IP RIP TTL =",
		(ULONG) offsetof (IP_CLASS, rip.config.minimum_ttl),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port Proxy ARP =",
		(ULONG) offsetof (IP_CLASS, port[0].config.proxy_arp_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port Remote Access =",
		(ULONG) offsetof (IP_CLASS, port[0].config.remote_access_enabled),
		(ULONG) &ip,
		sizeof (IP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RARP Server =",
		(ULONG) offsetof (IP_CLASS, rarp.server_enabled),
		(ULONG) &ip,
		sizeof (RARP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		parse_and_build_rarp_server_table_entries,
		NULL,
	"IP Port RARP Server Table Entries ="
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_enable,
		NULL,
	"IP Port RARP Client =",
		(ULONG) offsetof (IP_CLASS, rarp.port[0].config.client_enabled),
		(ULONG) &ip,
		sizeof (RARP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_port_and_ushort_decimal_value,
		NULL,
	"IP Port RARP Reply Timeout =",
		(ULONG) offsetof (IP_CLASS, rarp.port[0].config.reply_timeout),
		(ULONG) &ip,
		sizeof (RARP_PORT_CLASS)
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_byte_decimal_value,
		NULL,
	"IP Number of Route Cache Hash Table Buckets =",
		(ULONG) offsetof (IP_CLASS, number_of_route_cache_hash_table_buckets),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_byte_decimal_value,
		NULL,
	"IP Maximum Number of Routes Cached in Each Hash Table Bucket =",
		(ULONG) offsetof (IP_CLASS, number_of_routes_in_bucket),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Initialization Breakpoint =",
		(ULONG) offsetof (IP_CLASS, initialization_breakpoint),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Runtime Breakpoint =",
		(ULONG) offsetof (IP_CLASS, runtime_breakpoint),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Configuration Breakpoint =",
		(ULONG) offsetof (IP_CLASS, configuration_breakpoint),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Shutdown Breakpoint =",
		(ULONG) offsetof (IP_CLASS, shutdown_breakpoint),
		(ULONG) &ip,
		(ULONG) NULL
	},

#ifdef IP_FILTERING

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_set_filtering_table_size,
		NULL,
	"IP Number of Filtering Database Entries =",
		(ULONG)NULL,
	 	(ULONG)NULL
	},

#if 0

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_set_filtering_default_tx_action,
		NULL,
	"IP Filtering Default Tx Action =",
		(ULONG)NULL,
		(ULONG)NULL
	},


/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_set_filtering_default_rx_action,
		NULL,
	"IP Filtering Default Rx Action =",
		(ULONG)NULL,
		(ULONG)NULL
	},

#endif

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_set_filtering_default_action,
		NULL,
	"IP Filtering Default Action =",
		(ULONG)NULL,
		(ULONG)NULL
	},


/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_src_filter_cfg_string,
		NULL,
	"IP Filter Source Address =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_dest_filter_cfg_string,
		NULL,
	"IP Filter Destination Address =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_dest_range_filter_cfg_string,
		NULL,
	"IP Filter Destination Address Range =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_src_range_filter_cfg_string,
		NULL,
	"IP Filter Source Address Range =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_src_forward_cfg_string,
		NULL,
	"IP Forward Source Address =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_dest_forward_cfg_string,
		NULL,
	"IP Forward Destination Address =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_dest_range_forward_cfg_string,
		NULL,
	"IP Forward Destination Address Range =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_src_range_forward_cfg_string,
		NULL,
	"IP Forward Source Address Range =",
		(ULONG)NULL,
		(ULONG)NULL
	},


/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_src_port_filter_cfg_string,
		NULL,
	"IP Filter Source Port =",
		(ULONG)NULL,
		(ULONG)NULL
	},


/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_dest_port_filter_cfg_string,
		NULL,
	"IP Filter Destination Port =",
		(ULONG)NULL,
		(ULONG)NULL
	},

/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_src_port_forward_cfg_string,
		NULL,
	"IP Forward Source Port =",
		(ULONG)NULL,
		(ULONG)NULL
	},


/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_dest_port_forward_cfg_string,
		NULL,
	"IP Forward Destination Port =",
		(ULONG)NULL,
		(ULONG)NULL
	},


/* _____________________________________________________________________________________________ */

	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf Filtering =",
		(ULONG) offsetof (IP_CLASS,print_class.ip_filter_printing_enabled),
		(ULONG ) &ip,
		(ULONG) NULL
	},


/* _____________________________________________________________________________________________ */

	{(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		ip_icmp_filter,
		NULL,
	"IP Port ICMP Packet Types =",
		(ULONG)NULL,
		(ULONG)NULL
	},

#endif

	/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf =",
		(ULONG) offsetof (IP_CLASS, print_class.ip_print_switch_on),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf IP =",
		(ULONG) offsetof (IP_CLASS, print_class.ip_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf ROUTE =",
		(ULONG) offsetof (IP_CLASS, print_class.ip_route_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf CACHE =",
		(ULONG) offsetof (IP_CLASS, print_class.ip_cache_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf TRANSMIT =",
		(ULONG) offsetof (IP_CLASS, print_class.tx_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf RECEIVE =",
		(ULONG) offsetof (IP_CLASS, print_class.rx_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf FRAGMENT =",
		(ULONG) offsetof (IP_CLASS, print_class.fragment_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf REASSEMBLY =",
		(ULONG) offsetof (IP_CLASS, print_class.reassembly_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf RIP =",
		(ULONG) offsetof (IP_CLASS, print_class.rip_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf ARP =",
		(ULONG) offsetof (IP_CLASS, print_class.arp_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf RARP =",
		(ULONG) offsetof (IP_CLASS, print_class.rarp_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf ICMP =",
		(ULONG) offsetof (IP_CLASS, print_class.icmp_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf UDP =",
		(ULONG) offsetof (IP_CLASS, print_class.udp_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf Diagnostic =",
		(ULONG) offsetof (IP_CLASS, print_class.diagnostic_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf Data =",
		(ULONG) offsetof (IP_CLASS, print_class.data_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf Memory =",
		(ULONG) offsetof (IP_CLASS, print_class.memory_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf Alarm =",
		(ULONG) offsetof (IP_CLASS, print_class.alarm_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

/* sudhir 1/4/97 */
/* _____________________________________________________________________________________________ */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP Printf DNS =",
		(ULONG) offsetof (IP_CLASS, print_class.dns_printing_enabled),
		(ULONG) &ip,
		(ULONG) NULL
	},

	{
		NULL,
		(enum BOOLEAN *) TRUE,
	"IP DNS =",
		(ULONG) offsetof (DNS_CLASS, enabled),
		(ULONG) &dns,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
   {
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IP DNS Maximum Rtx timeout =",
		(ULONG) offsetof (DNS_CLASS, config.max_timeout),
		(ULONG) &dns,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
   {
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IP DNS Minimum Rtx timeout =",
		(ULONG) offsetof (DNS_CLASS, config.min_timeout),
		(ULONG) &dns,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
   {
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IP DNS Maximum Referals =",
		(ULONG) offsetof (DNS_CLASS, config.max_references),
		(ULONG) &dns,
		(ULONG) NULL
	},

   {
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
	"IP DNS Maximum Retransmissions =",
		(ULONG) offsetof (DNS_CLASS, config.max_retransmissions),
		(ULONG) &dns,
		(ULONG) NULL
	},
/* _____________________________________________________________________________________________ */
   {
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_string,
		NULL,
	   "IP DNS Server Address1 =",
		(ULONG) offsetof (DNS_CLASS, config.s_belt.temp_dns_ip_addr1),
		(ULONG) &dns,
      (ULONG) NULL
	},

/* _____________________________________________________________________________________________ */
   {
		(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_string,
		NULL,
	   "IP DNS Server Address2 =",
		(ULONG) offsetof (DNS_CLASS, config.s_belt.temp_dns_ip_addr2),
		(ULONG) &dns,
		(ULONG) NULL
	},
/* sudhir 1/4/97 */


/* _____________________________________________________________________________________________ */
	{
		NULL,
		NULL,
	"",
		(ULONG) NULL,
		(ULONG) NULL,
		(ULONG) NULL
	}

/* _____________________________________________________________________________________________ */

	}
};

#endif /* _VNVIP_H_ */
