/*
 * $Log: /IP/VRIPSTR.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	$Modname: vripstr.h$  $version: 1.11$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 02/02/94 yarran
1.1 02/02/94 yarran IP Initial Release
1.2 02/09/94 yarran Changed header files, added multiple buffer chain for fragmentation and assembly, fixed checksum bug
1.3 03/01/94 yarran
1.4 03/15/94 yarran
1.5 05/02/94 yarran added rfc1042 changes.
1.6 06/15/94 yarran cosmetic changes.
1.7 09/01/94 ross added BYTE and USHORT_ENUM support.
1.8 10/10/94 ross added rarp, proxy arp, remote access functions
1.9 12/20/94 ross
1.10 12/27/94 ross added better table instrumentation via new snmp.
1.11 10/25/95 ross
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1993 Router Engines, Inc.								*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	Router Engines, Inc., P.O. Box 3604 Newport Beach, CA 92659				*/
/************************************************************************/
#ifndef _VRIPSTR_H_
#define _VRIPSTR_H_


/* RIP statistics counters */

typedef struct RIP_STATISTICS
{
	ULONG 								number_of_request_packets_sent;
	ULONG 								number_of_response_packets_sent;
	ULONG 								number_of_packets_received;
	ULONG 								number_of_request_packets_received;
	ULONG 								number_of_response_packets_received;
	ULONG 								number_of_unrecongnized_packets_received;
	ULONG 								number_of_bad_versions;
	ULONG 								number_of_bad_address_families;
	ULONG 								number_of_bad_request_formats;
	ULONG 								number_of_bad_metrics;
	ULONG 								number_of_bad_response_formats;
	ULONG 								number_of_responses_not_from_rip_port;
	ULONG 								number_of_responses_received_from_loopback_interface;
	ULONG 								number_of_packets_rejected;
}RIP_STATISTICS;


typedef struct RIP_HEADER
{
	BYTE_ENUM (RIP_PACKET_TYPE)		type;
	BYTE										version;
	USHORT 									reserved;
} RIP_HEADER;


typedef struct RIP_ROUTE_ENTRY 
{
/* entry in RIP RESPONSE packet */

	USHORT								address_family;
	USHORT								reserved_field_1;
	ULONG									target;
	ULONG									reserved_field_2;
	ULONG									reserved_field_3;
	ULONG									metric;
} RIP_ROUTE_ENTRY;


typedef	struct	RIP_PACKET
{
	UNION_MAC_HEADER					mac_header;
	IP_HEADER							ip_header;
	UDP_HEADER							udp_header;
	RIP_HEADER							header;
	RIP_ROUTE_ENTRY					route_entry[MAXIMUM_NUMBER_OF_RIP_ENTRIES];
} RIP_PACKET;


typedef	struct	RIP_REQUEST_PACKET
{
	UNION_MAC_HEADER					mac_header;
	IP_HEADER							ip_header;
	UDP_HEADER							udp_header;
	RIP_HEADER							header;
	RIP_ROUTE_ENTRY					route_entry;
} RIP_REQUEST_PACKET;


typedef struct RIP_DESTINATION_ENTRY_LINK
{
	struct RIP_DESTINATION_ENTRY 	*sptr_forward_link;
	struct RIP_DESTINATION_ENTRY 	*sptr_backward_link;
} RIP_DESTINATION_ENTRY_LINK;


typedef struct RIP_DESTINATION_ENTRY
{
	RIP_DESTINATION_ENTRY_LINK		links;
	ULONG									ip_address;
} RIP_DESTINATION_ENTRY;


typedef struct RIP_NEIGHBOR_ENTRY_LINK
{
	struct RIP_NEIGHBOR_ENTRY 		*sptr_forward_link;
	struct RIP_NEIGHBOR_ENTRY 		*sptr_backward_link;
} RIP_NEIGHBOR_ENTRY_LINK;


typedef struct RIP_NEIGHBOR_ENTRY
{
	RIP_NEIGHBOR_ENTRY_LINK 		links;
	ULONG 								ip_address;
} RIP_NEIGHBOR_ENTRY;


typedef	struct	RIP_CONFIGURATION_CLASS
{
	USHORT								update_time_interval;								/* default 30 sec */
	USHORT		 						route_aging_timeout_value;							/* default 180 sec */
	USHORT								route_garbage_collection_timeout_value;		/* default 120 sec */

/*	USHORT								neighbor_list_enabled;*/

	BYTE_ENUM (BOOLEAN)			neighbor_list_enabled;
	BYTE 									minimum_ttl;
} RIP_CONFIGURATION_CLASS;


typedef	struct	RIP_PORT_CLASS
{
	BYTE_ENUM (BOOLEAN)				send_requests;
	BYTE_ENUM (BOOLEAN)				send_response_updates;
	BYTE_ENUM (BOOLEAN)				route_summarization_enabled;
	BYTE_ENUM (BOOLEAN)				route_holddown_enabled;
	BYTE_ENUM (BOOLEAN)				split_horizon_enabled;
	BYTE_ENUM (BOOLEAN)				poison_reverse_enabled;
	BYTE_ENUM (BOOLEAN)				announce_static_routes_enabled;
	BYTE_ENUM (BOOLEAN)				announce_host_routes_enabled;
	BYTE_ENUM (BOOLEAN)				announce_default_route_enabled;
	RIP_DESTINATION_ENTRY_LINK 	reject_list;										/* this list is initialized by NVRAM */
	RIP_DESTINATION_ENTRY_LINK 	advertise_list;									/* this list is initialized by NVRAM */
} RIP_PORT_CLASS;


typedef	struct	RIP_CLASS
{
	BYTE_ENUM (BOOLEAN) 				protocol_enabled; 								/* this portion can be set by NVRAM */
	RIP_PORT_CLASS						port[NUMBER_OF_IP_PORTS];
	RIP_CONFIGURATION_CLASS			config;		 										/* this portion can be set by NVRAM */
	RIP_NEIGHBOR_ENTRY_LINK			neighbor_list;										/* this list is initialized by NVRAM */
	ULONG									number_of_neighbor_list_entries;
	BYTE_ENUM (BOOLEAN)				timer_enabled;										/* this portion is not set by NVRAM */
	USHORT								minimum_update_time_interval;					/* 25 sec */
	USHORT								maximum_update_time_offset;					/* 10 sec */
	USHORT								periodic_time_counter;
	ULONG 								next_trigger_broadcast_time;
	ULONG									last_broadcast_time;
	USHORT 								next_regular_update_time;
	BYTE_ENUM (BOOLEAN)				need_update;
	BYTE_ENUM (BOOLEAN)				need_to_send_icmp_address_mask_request;
	UDP_CONTROL_BLOCK 				*sptr_udp_registration;
	RIP_STATISTICS 					statistics;
} RIP_CLASS;


#endif /* _VRIPSTR_H_ */
