/*
 * $Log: /IP/VUDPSNMP.H $
 * 
 * 1     1/23/96 10:52p Titus
 * Revision corresponds to IP Release 1.31
 */
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#ifndef _VUDPSNMP_H_
#define _VUDPSNMP_H_


#ifdef __MSDOS__
	SNMP_TABLE_ENTRY_PARAMETERS far	udp_snmp_table_parameters[] =
#else
	SNMP_TABLE_ENTRY_PARAMETERS	udp_snmp_table_parameters[] =
#endif
{
	{(ULONG) &ip.udp.mib,
		FALSE
		},

	{(ULONG) NULL,
		TRUE,
		0x02,
		{{
			/* Srikar, Mar 20, 1997. Changed the index_type from SNMP_SCALAR_TYPE to SNMP_IP_ADDRESS_TYPE */
			SNMP_IP_ADDRESS_TYPE,
			sizeof (ULONG),
			offsetof (UDP_CONTROL_BLOCK,local_socket.ip_address),
			FALSE
		},{
			SNMP_SCALAR_TYPE,
			/* Srikar, Mar 20, 1997. Changed the size_of_index from sizeof(ULONG) to sizeof(USHORT) */
			sizeof (USHORT),
			offsetof (UDP_CONTROL_BLOCK,local_socket.port),
			FALSE
		}},
		MIB_TABLE_AS_A_LINKED_LIST,
		&ip.udp.current_control_block_list
		}
};


#ifdef __MSDOS__
	SNMP_TABLE_ENTRY far	udp_snmp_table[] =
#else
	SNMP_TABLE_ENTRY	udp_snmp_table[] =
#endif
{
	{"udpInDatagrams",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (UDP_MIB,udpInDatagrams),
		&udp_snmp_table_parameters[0]
		},

	{"udpNoPorts",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (UDP_MIB,udpNoPorts),
		&udp_snmp_table_parameters[0]
		},

	{"udpInErrors",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (UDP_MIB,udpInErrors),
		&udp_snmp_table_parameters[0]
		},

	{"udpOutDatagrams",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (UDP_MIB,udpOutDatagrams),
		&udp_snmp_table_parameters[0]
		},

	{"udpLocalAddress",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ulong,
		FALSE,
		FALSE,
		(ULONG) offsetof (UDP_CONTROL_BLOCK,local_socket.ip_address),
		&udp_snmp_table_parameters[1]
		},

	{"udpLocalPort",sizeof (ULONG),
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		snmp_get_or_set_ushort,
		FALSE,
		FALSE,
		(ULONG) offsetof (UDP_CONTROL_BLOCK,local_socket.port),
		&udp_snmp_table_parameters[1]
		},

	{"",0x0000,
	(enum TEST (*) (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset_into_class, ULONG class_address,
		ULONG size_of_port_class, void *vptr_mib_value, USHORT *usptr_length_of_mib_obtained))
		(ULONG) NULL,
		FALSE,
		FALSE,
		(ULONG) NULL,
		NULL,
		}
};


#endif /* _VUDPSNMP_H_ */

