#include	"defs.h"
/*	$Modname: ipxsnmpa.c$  $version: 1.5$      $date: 06/27/95$   */
/*
* 	$lgb$
1.0 06/08/94 ross
1.1 06/15/94 ross initial version.
1.2 08/08/94 ross finishing end station support.
1.3 11/21/94 ross changed to compile under C++, added big sap and rip support.
1.4 01/26/95 ross changes for rwutils
1.5 06/27/95 ross mib and nlsp changes
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stddef.h>
#include	<string.h>
#include	"ipx.h"
#include	<visnpstr.h>
#include "vipxsnmp.h"

/* Srikar, Mar 17, 1997. Added the extern declaration for the function defined in ppp module */
extern enum BOOLEAN set_port_ipx_operational_state(USHORT port_number, enum BOOLEAN new_state);
extern enum BOOLEAN get_port_exist_state(USHORT port_number);
/**********************************************************************************/
enum TEST get_ipx_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
 	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_bytes_in_table_indices,
	BYTE *bptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST return_code;

	return_code = process_mib_variable (mib_operation,cptr_mib_string,bptr_variable_value,
		usptr_size_of_variable_value,usptr_number_of_bytes_in_table_indices,bptr_table_indices,eptr_end_of_table,
		ptr_to_cptr_next_variable_name,&ipx_snmp_table[0x00]);

	return (return_code);
}

/* Srikar, Mar 17, 1997. Added the following function definition for the mib
	variable ipxAdvSysMaxHops */
enum TEST snmp_get_or_set_sys_max_hops(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG max_hops;
	USHORT i;

	if  (mib_operation == SET_OPERATION)
		{
		/* NOTE: nlsp interface parameters as in register nlsp is supposed to
		use a copy of the variable being set here, hence when nlsp is to be
		implemented the copy of this variable is also to be updated */
		max_hops = *(ULONG *)vptr_mib_value_obtained;
		if (max_hops < 1 || max_hops > MAXIMUM_HOP_COUNT)
			return FAIL;
		for(i = 0; i < NUMBER_OF_IPX_PORTS; i++)
			 ipx_class.port[i].maximum_number_of_hops = max_hops;
		}
	return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size,
		vptr_mib_value_obtained, usptr_length_of_mib_obtained);
}

enum TEST snmp_get_or_set_circ_max_packet_size(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG packet_size;


	if (mib_operation == SET_OPERATION)
	{
		packet_size = *(ULONG *) vptr_mib_value_obtained;

/* Srikar 6 Jan 97 */
		/* Restrict packet sizes to within 576 and 4096 */
		if (packet_size < 576 || packet_size > 4096)
			return FAIL;
/* Srikar 6 Jan 97 */
	}
	return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size,
		vptr_mib_value_obtained, usptr_length_of_mib_obtained);
}

enum TEST snmp_get_or_set_circ_pace(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG gap_time;
	ULONG circuit_pace;

	if (mib_operation == SET_OPERATION)
	{
		circuit_pace = *(ULONG *)vptr_mib_value_obtained;
/* Srikar 6 Jan 97 */
		if (circuit_pace == 0 || circuit_pace > ipx_class.clock_ticks_per_second)
			return FAIL;
		gap_time = ipx_class.clock_ticks_per_second / circuit_pace;
		if (gap_time < 1 || gap_time > ipx_class.clock_ticks_per_second)
			return FAIL;
/* Srikar 6 Jan 97 */
		*(ULONG *) (_class + offset + (size * port_number)) = circuit_pace;
		ipx_class.gap_time_limit = gap_time;
		
		return PASS;
	}
	else
	{
		return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size,
				vptr_mib_value_obtained, usptr_length_of_mib_obtained);
	}
}

enum TEST snmp_get_or_set_circ_age_multiplier(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG hold_time;

	if (mib_operation == SET_OPERATION)
	{
		hold_time = *(ULONG *)vptr_mib_value_obtained;

		/* 60 * multiplier == aging time; 0 is do-not-age setting */
		*(ULONG *) (_class + offset + (size * port_number)) = hold_time * 60;

		return PASS;
	}
	else
	{
		*(ULONG *) vptr_mib_value_obtained = 0;
		*(ULONG *) vptr_mib_value_obtained = *(ULONG *) (_class + offset + (size * port_number));

		*(ULONG *) vptr_mib_value_obtained = swap_long (*(ULONG *) vptr_mib_value_obtained);
		*(ULONG *) vptr_mib_value_obtained = (*(ULONG *) vptr_mib_value_obtained / 60);
		return PASS;
	}
}

enum TEST snmp_get_or_set_circ_update_time(USHORT port_number, 
	enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	if (mib_operation == SET_OPERATION)
	{
/* Srikar 6 Jan 97 */
		/* Atleast a 30 second update interval is desired */
		if (*(ULONG *)vptr_mib_value_obtained < 30)
			return FAIL;
/* Srikar 6 Jan 97 */
	}
	return snmp_get_or_set_ulong(port_number, mib_operation, offset, _class, size,
				vptr_mib_value_obtained, usptr_length_of_mib_obtained);
}

/* Srikar, Mar 19, 1997. Added the following function to do range validation of the ipxExistState assignment. */

/**********************************************************************************/
enum TEST snmp_get_or_set_ipxExistState (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG	circuit_state;

	circuit_state = 0;
	if  (mib_operation == GET_OPERATION || mib_operation == GET_NEXT_OPERATION)
		{
		switch (*(BYTE *) (_class + offset + (size * port_number)))
			{
			case TRUE :
				circuit_state = 2;		/* This is the value to be sent to the manager (on). */
				break;
			case FALSE :
				circuit_state = 1;		/* This is the value to be sent to the manager (off). */
				break;
			default :
				break;
			}
		*(ULONG *) vptr_mib_value_obtained = swap_long (circuit_state);
		}
	else if (mib_operation == SET_OPERATION)
		{
		switch (*(ULONG *) vptr_mib_value_obtained)
			{
			case 2 :		/* Set circuit_state to TRUE. */
				circuit_state = TRUE;
				break;
			case 1 :
				circuit_state = FALSE;
				break;
			default :
				return(FAIL);
			}
		*(BYTE *) (_class + offset + (size * port_number)) = (BYTE) circuit_state;
		}
	*usptr_length_of_mib_obtained = sizeof (ULONG);
	return (PASS);
}

/**********************************************************************************/
/* Srikar, Mar 17, 1997. Added this function to set the operation state of an ipx Circuit */
/* to on or off */
enum TEST snmp_get_or_set_ipxOperState (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	USHORT number_of_lan_ports;

	number_of_lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);
	if  (mib_operation == GET_OPERATION || mib_operation == GET_NEXT_OPERATION)
		return snmp_get_or_set_boolean_plus_one(port_number, mib_operation, offset, _class, size,
					vptr_mib_value_obtained, usptr_length_of_mib_obtained);
	else if (mib_operation == SET_OPERATION)
		{
		/* The port_number passed is always zero. Hence we need to compute that. */
		port_number = (USHORT) ((_class - (ULONG) &ipx_class.port[0]) / sizeof(ipx_class.port[0]));

		switch (*(ULONG *) vptr_mib_value_obtained)
			{
			case 2 :		/* Set circuit_state to TRUE. */
				if (ipx_class.port[port_number].wan_port == TRUE && get_port_exist_state(port_number - number_of_lan_ports) == TRUE)
					{
					if (*(BYTE *) (_class + offset + (size * port_number)) == FALSE)
						if(set_port_ipx_operational_state(port_number - number_of_lan_ports, TRUE) == FALSE)
							return(FAIL);
					}
				else
					return(FAIL);
				break;
			case 1 :
				if (ipx_class.port[port_number].wan_port == TRUE && get_port_exist_state(port_number - number_of_lan_ports) == TRUE)
					{
					if (*(BYTE *) (_class + offset + (size * port_number)) == TRUE)
						if(set_port_ipx_operational_state(port_number - number_of_lan_ports, FALSE) == FALSE)
							return(FAIL);
					}
				else
					return(FAIL);
				break;
			default :
				return(FAIL);
			}
		}
}

/* Srikar, Mar 19, 1997. Added the following function to do range validation of the ipxCircName and ipxCircDialName */
/* assignment. The same function is used for both ipxCircName and ipxCircDialName since their lengths are same. We */
/* need to modify snmp_get_or_set_string to accommodate the validation of the length. */

/**********************************************************************************/
enum TEST snmp_get_or_set_ipxCircName_ipxCircDialName (USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained)
{
	ULONG	length;
	char	*cptr_src_or_dst;

	cptr_src_or_dst = (char *) (_class + offset + (size * port_number));
	if (mib_operation == GET_OPERATION || mib_operation == GET_NEXT_OPERATION)
		{
		length = strlen(cptr_src_or_dst) + 1;
		if (length > sizeof (ipx_class.port[0].lan_circuit_mib.ipxCircName))
			length = sizeof (ipx_class.port[0].lan_circuit_mib.ipxCircName);
		else
			length--;		/* Take off null. */
		memcpy (vptr_mib_value_obtained, cptr_src_or_dst, length);
		*usptr_length_of_mib_obtained = (USHORT) length;
		}
	else if (mib_operation == SET_OPERATION)
		{
		length = strlen(vptr_mib_value_obtained) + 1;
		if (length > sizeof (ipx_class.port[0].lan_circuit_mib.ipxCircName))
			length = sizeof (ipx_class.port[0].lan_circuit_mib.ipxCircName);
		memcpy (cptr_src_or_dst, vptr_mib_value_obtained, length);
		}
	return (PASS);
}

