/*	$Modname: viendstr.h$  $version: 1.4$      $date: 11/21/94$   */
/*
* 	$lgb$
1.0 08/08/94 ross
1.1 08/08/94 ross Added copyright
1.2 08/25/94 ross fixes for get local target
1.3 10/11/94 ross sockets.
1.4 11/21/94 ross changed to compile under C++.
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
typedef	struct	ECB_LINK
{
	struct EVENT_CONTROL_BLOCK *sptr_forward_ecb;
	struct EVENT_CONTROL_BLOCK *sptr_backward_ecb;
} ECB_LINK;

typedef	struct	SOCKET_LIST_ENTRY
{
	LINK		links;

	USHORT	socket;

	ECB_LINK	rx_ecb_list;

	ECB_LINK	tx_ecb_list;

	void		*vptr_context;

} SOCKET_LIST_ENTRY;

typedef	struct	IPX_PACKET_HEADER
{
	MAC_HEADER	mac_header;
	IPX_HEADER	ipx_header;
} IPX_PACKET_HEADER;

typedef	union	UNION_NETWARE_BUFFER
{
	void  				*vptr_buffer;
	BYTE  				*bptr_buffer;
	IPX_PACKET_HEADER *sptr_ipx_header;
	IPX_PACKET			*sptr_ipx_packet;
} UNION_NETWARE_BUFFER;

typedef struct ECB_BUFFER_DESCRIPTOR
{
	UNION_NETWARE_BUFFER 	type;
	USHORT	 					size_of_buffer;	
} ECB_BUFFER_DESCRIPTOR;

typedef struct EVENT_CONTROL_BLOCK
{
	struct EVENT_CONTROL_BLOCK *sptr_forward_ecb;
	struct EVENT_CONTROL_BLOCK *sptr_backward_ecb;

	void 								(*fptr_event_service_routine) (struct EVENT_CONTROL_BLOCK *sptr_ecb);

	enum BOOLEAN  					in_use;
	enum IPX_COMPLETION_CODE  	completion_code;
	USHORT							socket_number;

	void *							vptr_context;
	BYTE								reserved_1[12];

	MAC_ADDRESS  					immediate_address;
	USHORT							fragment_count;
	ECB_BUFFER_DESCRIPTOR		fragment_descriptor[1];
} EVENT_CONTROL_BLOCK;

typedef	struct	ECB_WITH_PACKET_LINKS
{
	struct	ECB_WITH_PACKET *sptr_forward_link;
	struct	ECB_WITH_PACKET *sptr_backward_link;
} ECB_WITH_PACKET_LINKS;

typedef	struct	ECB_WITH_PACKET
{
	ECB_WITH_PACKET_LINKS	links;

	EVENT_CONTROL_BLOCK 		ecb;

	USHORT						current_byte_index;

	void							*vptr_user_handle;

	BYTE							filler[32];

	MAC_HEADER					mac_header;

	IPX_HEADER					ipx_header;

	BYTE							data[VARIABLE_NUMBER_OF_BYTES];

} ECB_WITH_PACKET;


enum TEST register_endstation_to_ipx (char *cptr_end_station_name,
	enum RX_PACKET_STATE (*fptr_rx_routine) (void *vptr_buffer,USHORT number_of_bytes),
	void (*fptr_timer_routine) (void));

enum TEST register_transport_to_ipx (char *cptr_transport_name,enum TRANSPORT_TYPE type,
	void (*fptr_packet_transmitted) (void *vptr_buffer,USHORT number_of_bytes),
	enum RX_PACKET_STATE (*fptr_rx_routine) (void *vptr_buffer,USHORT number_of_bytes),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum TRANSPORT_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	void *vptr_context[NUMBER_OF_IPX_PORTS],
	USHORT *usptr_return_transport_id);

enum TEST register_ncp_to_ipx (char *cptr_transport_name,enum TRANSPORT_TYPE type,
	void (*fptr_packet_transmitted) (void *vptr_buffer,USHORT number_of_bytes),
	enum RX_PACKET_STATE (*fptr_rx_routine) (void *vptr_buffer,USHORT number_of_bytes),
	void (*fptr_timer_routine) (void),
	enum TEST (*fptr_control_routine) (enum TRANSPORT_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1),
	void *vptr_context[NUMBER_OF_IPX_PORTS],
	USHORT *usptr_return_transport_id);

void initialize_end_station_ipx (void);

enum IPX_COMPLETION_CODE ipx_get_local_target (IPX_ADDRESS *sptr_ipx_address,MAC_ADDRESS *sptr_destination_mac_address,
	USHORT *sptr_transport_time,USHORT *usptr_virtual_port_number);

enum TEST ipx_end_station_send_packet (EVENT_CONTROL_BLOCK *sptr_tx_ecb,enum BOOLEAN override_source_address);
enum IPX_COMPLETION_CODE ipx_listen_for_packet (EVENT_CONTROL_BLOCK *sptr_ecb,void *vptr_context);

enum IPX_COMPLETION_CODE ipx_open_socket (USHORT *usptr_socket);
enum IPX_COMPLETION_CODE ipx_close_socket (USHORT socket);
enum IPX_COMPLETION_CODE ipx_cancel_packet (EVENT_CONTROL_BLOCK *sptr_ecb);
enum IPX_COMPLETION_CODE ipx_check_socket (USHORT socket);
enum IPX_COMPLETION_CODE ipx_cancel_event (EVENT_CONTROL_BLOCK *sptr_ecb);
void ipx_get_internetwork_address (IPX_ADDRESS *sptr_ipx_address);
char *ipx_get_internal_name(void);

