#include	"defs.h"
/*	$Modname: ipxinit.c$  $version: 3.46$      $date: 10/20/95$   */
/*
* 	$lgb$
2.3 01/05/92 ross
2.4 01/21/92 ross new version control 2.3
2.5 01/26/92 ross
2.6 08/05/92 ross
2.7 08/15/92 ross added number_of_ipx_ports
2.8 10/20/92 ross
2.9 11/02/92 ross made most lines 132 columns now.
2.10 11/24/92 ross
2.11 11/24/92 ross
2.12 12/05/92 ross general clean-up moved some globals in #ifdefs
2.13 12/05/92 ross general clean-up moved some globals in #ifdefs
2.14 12/06/92 ross implemented ipx class structure - no algorithm changes
2.15 12/06/92 ross adding functions to ipxsnmp.c, added static protos for ipx.c and ipxsap.c
2.16 12/26/92 ross
2.17 01/12/93 ross Added checks for too large hop counts in ipxrout and ipxnetbs and statistics, LLC proper SAPs, netbios broadcast fix soon
2.18 01/14/93 ross added wan BOOLEAN for better wan control, upcoming IPXWAN support
3.0 01/17/93 ross fixed SNAP addition bug.
3.1 01/22/93 ross renaming to ipxinit.c
3.2 01/25/93 ross in nvram_configuration call it returns PASS instead of FAIL.
3.3 02/09/93 ross had a typo in initialize_ipx concerning the saving of the wan state. HS
3.4 02/19/93 ross in initialize router info the line that set the destination socket was removed.
3.5 03/08/93 ross added pacing logic to sap,sapls,rip,ripls, and ipxtimer
3.6 03/15/93 ross x86 version now works in real mode -just enough memory
3.7 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.8 03/30/93 ross added changes for netbios caching.
3.9 04/06/93 ross moved LSL code into ipxsnap.c, no dependencies in LSL
3.10 04/12/93 ross made variable change in vipxstr.h
3.11 05/13/93 ross added stack parameter for tunnel software
3.12 05/15/93 ross changed initialization functions to handle more parameters for rip and sap.
3.13 05/24/93 ross fixed some problems will loops going down.
3.14 07/18/93 ross added IPX_PACKET_STATE to send_ipx_packet for disabled ports.  Courtesy of Yoram.
3.15 07/18/93 ross added register protocol stack function.
3.16 10/05/93 ross moved stuff into REI_LSL for our multiplex/demultiplex layer.
3.17 10/09/93 ross delete knvram.h from the header include section.  No longer needed.
3.18 10/19/93 ross shut down bug. Courtesy of Ken.
3.19 11/01/93 ross added ipx control function.
3.20 11/04/93 ross fixes for simultaneous rip downs and secondary sap/rip lists
3.21 11/09/93 ross took out if statement from SAP down. Courtesy of Ken.
3.22 11/09/93 ross SAP and rip down port and global functions bugs fixed.  Courtesy of Ken.
3.23 11/29/93 ross transport time fix and lsl version 3.0 changes.
3.24 01/08/94 ross More lsl version 3 changes
3.25 02/02/94 ross added more control functions.
3.26 03/09/94 ross new nvram.
3.27 03/10/94 ross took out number_of_ipx_ports.
3.28 03/11/94 ross in the non malloc case, some pointers needed to be cast.  Courtesy of Lori.
3.29 03/14/94 ross cleaned up braces and white spaces for release.
3.30 03/26/94 ross removed build_router_list, this is already done once at init time.
3.31 05/09/94 ross modified wan class for ipxwan and non-ipxwan configurations
3.32 05/20/94 ross added better support for disabled port, and added add rip/sap function pointers.  Courtest of Fred and Don.
3.33 06/08/94 ross first version support for ipx and rip sap mibs. Ugh.
3.34 06/14/94 ross delete stdlib.h
3.35 08/08/94 ross finishing end station support.
3.36 10/24/94 ross added internal id function from ipxwan.
3.37 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.38 11/23/94 ross Added remote access. Added auto-configuration.
3.39 01/26/95 ross changes for rwutils
3.40 03/26/95 ross nlsp changes.
3.41 04/06/95 ross more nlsp changes.
3.42 04/20/95 ross made socket configurable for the internal network number.
3.43 06/27/95 ross mib and nlsp changes
3.44 09/25/95 ross added changes for dynamic loading
3.45 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.46 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
/************************************************************************/
#define	GLOBAL_FILE
#include	<string.h>
#include	<stdarg.h>
#include	"ipx.h"
/****************************************************************************/
static enum TEST initialize_ipx (USHORT start_port_number,USHORT number_of_ports);
static enum TEST initialize_rip_and_sap_maximum_sizes (USHORT port_number);
static void build_router_list (void);
static void build_SAP_list (void);
static void add_local_route (USHORT port_number);
static void initialize_internal_ids (void);
void init_ipx_router_network(char *);
void initialize_ipx_basic_snmp_table(void);
void initialize_ipx_adv_snmp_table(void);
void initialize_ipx_circuit_snmp_table(void);
void initialize_ipx_rip_sap_snmp_table(void);
void initialize_ipx_rip_sap_circuit_snmp_table(void);

#if 0
extern void display_ipx_filtering_table() ;
#endif
/****************************************************************************/
enum TEST initialize_IPX_router (ULONG clock_ticks_per_second)
{
	USHORT virtual_port_number;
	int delay;

	if (ipx_class.enabled == FALSE)
		{
		return (PASS);
		}
#if 0
	display_ipx_filtering_table() ;
#endif

#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_PROTOCOL_STACK,"IPX Routing",IPX_router_rx_packet,IPX_router_timer,IPX_control,
		&ipx_class.stack_id) == FAIL)
		{
		return (FAIL);
		}
#endif

	ipx_class.clock_ticks_per_second = clock_ticks_per_second;

	ipx_class.number_of_circuit_system_entries = 0x01;

	if (ipx_class.remote_access_enabled == TRUE)
		{
		++ipx_class.number_of_ports;
		}

	for (virtual_port_number = 0x0000; virtual_port_number < ipx_class.number_of_ports; ++virtual_port_number)
		{
#ifdef __LSL__
		/* lsl_control (GET_MAC_ADDRESS,virtual_port_number,ipx_class.stack_id,&ipx_class.port[virtual_port_number].ethernet_address); */
		/* Sachin 17/01/1997 */
		lsl_control (GET_MAC_ADDRESS,0,ipx_class.stack_id,&ipx_class.port[virtual_port_number].ethernet_address);
#endif
		}

	if (initialize_ipx (0x0000,ipx_class.number_of_ports) == PASS)
		{
#ifdef IPX_WAN_ENABLED
		if (initialize_ipx_wan (&ipx_class) == FAIL)
			{
			return (FAIL);
			}
#endif
		initialize_internal_ids ();
/* Sanjays code */
	initialize_ipx_basic_snmp_table();
	initialize_ipx_adv_snmp_table();
	initialize_ipx_rip_sap_snmp_table();
/* Sanjays code */


	for (virtual_port_number = 0x0000; virtual_port_number < ipx_class.number_of_ports; ++virtual_port_number)
			{
			ipx_class.port[virtual_port_number].netbios_name_cache_timer = 50;
			send_periodic_route_information (virtual_port_number);

			issue_router_info_request (virtual_port_number); /* get all router info */
			send_SAP_periodic_broadcast (virtual_port_number);
			send_SAP_query (GENERAL_SERVICE_QUERY,virtual_port_number); /* get all SAP info */
			}
		return (PASS);
		}
	else
		{
		return (FAIL);
		}
}
/****************************************************************************/
static void initialize_internal_ids (void)
{
	ROUTE_ENTRY route_entry;

	ipx_class.internal_SAP_id.ipx_address.node_address._ushort = swap (0x0001);
	ipx_class.internal_SAP_id.ipx_address.node_address._ulong = 0x00000000L;

	if (ipx_class.internal_SAP_id.ipx_address.socket == 0x0000)
		{
		ipx_class.internal_SAP_id.ipx_address.socket = swap (0x8000);
		}

	ipx_class.internal_SAP_id.intervening_networks = swap (0x0001);

	route_entry.network = ipx_class.internal_SAP_id.ipx_address.network;
	route_entry.hops = swap (0x0001);
	route_entry.transport_time = swap (0x0001);

	add_route_entry ((USHORT) (ipx_class.number_of_ports - ipx_class.remote_access_enabled),&route_entry,
		(ETHERNET_ADDRESS *) &ipx_class.internal_SAP_id.ipx_address.node_address,TRUE,TRUE,RIP_IPX_ROUTE,NULL);

	add_SAP_entry ((USHORT) (ipx_class.number_of_ports - ipx_class.remote_access_enabled),&ipx_class.internal_SAP_id,
		(ETHERNET_ADDRESS *) &ipx_class.internal_SAP_id.ipx_address.node_address,TRUE,TRUE,IPX_SAP,NULL);
}
/****************************************************************************/
static enum TEST initialize_ipx (USHORT start_port_number,USHORT number_of_ports)
{
	USHORT port_number;
	int delay;

	ipx_class.starting_port_number = start_port_number;
	ipx_class.number_of_ports = number_of_ports;
	ipx_class.number_of_circuit_entries = number_of_ports;
	ipx_class.timer_enabled = FALSE;

	build_SAP_list ();

	build_router_list ();

	for (port_number = ipx_class.starting_port_number; port_number < number_of_ports; ++port_number)
		{
		ipx_class.port[port_number].rip_compatibility = RIP_ON;
		ipx_class.port[port_number].sap_compatibility = SAP_ON;

		initialize_rip_and_sap_maximum_sizes (port_number);

#ifdef BYME
#ifdef IPX_WAN_ENABLED
		if (ipx_class.port[port_number].wan.enable_ipx_wan_packets == FALSE)
#endif
			{
			send_periodic_route_information (port_number);
			send_periodic_route_information (port_number);

			issue_router_info_request (port_number); /* get all router info */
			send_SAP_query (GENERAL_SERVICE_QUERY,port_number); /* get all SAP info */
			}
#endif

		ipx_class.port[port_number].number_of_SAP_clock_ticks = ipx_class.port[port_number].periodic_SAP_tx_timer / 2;
		}

/* Sanjays code */
	initialize_ipx_circuit_snmp_table();
	initialize_ipx_rip_sap_circuit_snmp_table();
/* Sanjays code */

	ipx_class.timer_enabled = TRUE; 

	return (PASS);
}
/****************************************************************************/
static enum TEST initialize_rip_and_sap_maximum_sizes (USHORT port_number)
{
	if (ipx_class.port[port_number].maximum_number_of_hops == 0x0000)
		{
		ipx_class.port[port_number].maximum_number_of_hops = MAXIMUM_HOP_COUNT;
		}

	if (ipx_class.port[port_number].maximum_size_of_rip_packet == 0x0000)
		{
		ipx_printf (ALARM_PRINTF,"IPX: RIP Size ILLEGAL port number %04x size of %08lx\r\n",port_number);

		return (FAIL);
		}

	if (ipx_class.port[port_number].maximum_size_of_SAP_packet == 0x0000)
		{
		ipx_printf (ALARM_PRINTF,"IPX: Sap Size ILLEGAL port number %04x size of %08lx\r\n",port_number);

		return (FAIL);
		}

	ipx_class.port[port_number].maximum_number_of_rip_entries = (ULONG)
		((ipx_class.port[port_number].maximum_size_of_rip_packet -
		(sizeof (ETHERNET_HEADER) + sizeof (IPX_HEADER) + sizeof (USHORT_ENUM (ROUTE_PACKET_TYPE)) )) /
		sizeof (ROUTE_ENTRY));

	ipx_class.port[port_number].maximum_number_of_SAP_entries = (ULONG)
		((ipx_class.port[port_number].maximum_size_of_SAP_packet -
		(sizeof (ETHERNET_HEADER) + sizeof (IPX_HEADER) + sizeof (USHORT_ENUM (RESPONSE_TYPE)) )) /
		sizeof (SAP_ID));

	return (PASS);
}
/****************************************************************************/
static void build_router_list (void)
{
	USHORT port_number;

#ifndef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
	ROUTE_LIST_ENTRY	*sptr_route_list_entry;

	for (sptr_route_list_entry = &ipx_class.route_list_entry[0] ; sptr_route_list_entry <
		&ipx_class.route_list_entry[MAXIMUM_NUMBER_OF_NETWARE_LANS]; ++sptr_route_list_entry)
		{
		add_entry_to_list ((LINK *) &ipx_class.free_router_list_entries,(LINK *) &sptr_route_list_entry->links);
		}
#endif

	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports ;	++port_number)
		{
		if (ipx_class.port[port_number].port_enabled == TRUE)
			{
			if (ipx_class.port[port_number].remote_access == FALSE)
				{
				/* BYME add the route only if network address is not be learned */
				if (ipx_class.port[port_number].learn_network_address == FALSE)
				 add_local_route (port_number);
				}
			}
		}
}
/*************************************************************************/
static void add_local_route (USHORT port_number)
{
	ROUTE_ENTRY route_entry;

	route_entry.network = ipx_class.port[port_number].network;
	route_entry.hops = swap (0x0001);
	route_entry.transport_time = swap (ipx_class.port[port_number].transport_time);

	add_route_entry (port_number,&route_entry,&ipx_class.port[port_number].ethernet_address,TRUE,TRUE,RIP_IPX_ROUTE,NULL);
}
/*************************************************************************/
void initialize_router_request_packet (USHORT port_number,ROUTE_REQUEST *sptr_router_request)
{
	sptr_router_request->ethernet_header.destination_address = broadcast_address;
	sptr_router_request->ethernet_header.source_address = ipx_class.port[port_number].ethernet_address;
	sptr_router_request->ethernet_header.length = RAW_8023_IPX;

	sptr_router_request->ipx_header.checksum = 0xffff;
	sptr_router_request->ipx_header.length = swap (sizeof (ROUTE_REQUEST) - sizeof (ETHERNET_HEADER));
	sptr_router_request->ipx_header.transport_control_hop_count = 0x00;
	sptr_router_request->ipx_header.packet_type = UNKNOWN_PACKET_TYPE;

	sptr_router_request->ipx_header.destination.network = ipx_class.port[port_number].network;
	sptr_router_request->ipx_header.destination.node_address = broadcast_address;
	sptr_router_request->ipx_header.destination.socket = ROUTING_SOCKET;

	sptr_router_request->ipx_header.source.network = ipx_class.port[port_number].network;
	sptr_router_request->ipx_header.source.node_address = ipx_class.port[port_number].ethernet_address;
	sptr_router_request->ipx_header.source.socket = ROUTING_SOCKET;

	sptr_router_request->operation = ROUTE_REQUEST_INFORMATION;

	sptr_router_request->request.network = 0xffffffffL;
	sptr_router_request->request.hops = swap (0x0001);
	sptr_router_request->request.transport_time = swap (0x0002);

	if ((ipx_class.port[port_number].learn_network_address == TRUE) &&
		(ipx_class.port[port_number].network_address_learned == FALSE)) {
			sptr_router_request->ipx_header.destination.network = 0;
			sptr_router_request->ipx_header.source.network = 0;
	}

}
/*************************************************************************/
void initialize_router_periodic_information_packet (USHORT port_number,ROUTE_INFORMATION *sptr_route_information)
{
	sptr_route_information->ethernet_header.destination_address = broadcast_address;
	sptr_route_information->ethernet_header.source_address = ipx_class.port[port_number].ethernet_address;
	sptr_route_information->ethernet_header.length = RAW_8023_IPX;

	sptr_route_information->ipx_header.checksum = 0xffff;
	sptr_route_information->ipx_header.transport_control_hop_count = 0x00;
	sptr_route_information->ipx_header.packet_type = ROUTER_PACKET_TYPE;

	sptr_route_information->ipx_header.destination.node_address = broadcast_address;
	sptr_route_information->ipx_header.destination.network = ipx_class.port[port_number].network;
	sptr_route_information->ipx_header.destination.socket = ROUTING_SOCKET;

	sptr_route_information->ipx_header.source.network = ipx_class.port[port_number].network;
	sptr_route_information->ipx_header.source.node_address = ipx_class.port[port_number].ethernet_address; 
	sptr_route_information->ipx_header.source.socket = ROUTING_SOCKET;

	sptr_route_information->operation = ROUTE_INFO;
	if ((ipx_class.port[port_number].learn_network_address == TRUE) &&
		(ipx_class.port[port_number].network_address_learned == FALSE)) {
			sptr_route_information->ipx_header.destination.network = 0;
			sptr_route_information->ipx_header.source.network = 0;
	}
}
/*************************************************************************/
void initialize_route_information_packet (USHORT port_number,ROUTE_INFORMATION *sptr_route_information,
	ETHERNET_ADDRESS *sptr_destination_address,USHORT ipx_header_length,IPX_ADDRESS *sptr_ipx_destination_address)
{
	sptr_route_information->ethernet_header.destination_address = *sptr_destination_address;
	sptr_route_information->ethernet_header.source_address = ipx_class.port[port_number].ethernet_address;
	sptr_route_information->ethernet_header.length = RAW_8023_IPX;

	sptr_route_information->ipx_header.checksum = 0xffff;
	sptr_route_information->ipx_header.length = ipx_header_length;
	sptr_route_information->ipx_header.transport_control_hop_count = 0x00;
	sptr_route_information->ipx_header.packet_type = ROUTER_PACKET_TYPE;

	sptr_route_information->ipx_header.source.network = ipx_class.port[port_number].network;
	sptr_route_information->ipx_header.source.node_address = ipx_class.port[port_number].ethernet_address;
	sptr_route_information->ipx_header.source.socket = ROUTING_SOCKET;

	sptr_route_information->ipx_header.destination = *sptr_ipx_destination_address;

	sptr_route_information->operation = ROUTE_INFO;
	if ((ipx_class.port[port_number].learn_network_address == TRUE) &&
		(ipx_class.port[port_number].network_address_learned == FALSE)) {
			sptr_route_information->ipx_header.destination.network = 0;
			sptr_route_information->ipx_header.source.network = 0;
	}
}
/*************************************************************************/
void shut_down_ipx_router (void)
{
	USHORT	port_number;

	ipx_class.timer_enabled = FALSE;

	delete_ipx_entries_and_send_farewell_broadcast ();
	delete_SAP_entries_and_send_farewell_broadcast ();

	for (port_number= ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
		{
		ipx_class.port[port_number].port_enabled = FALSE; /* lock out receives */
		}

	check_for_down_SAPs ();
	check_for_down_routers ();

	free_all_netbios_names_in_lists ();
}
/*************************************************************************/
void delete_ipx_entries_and_send_farewell_broadcast (void)
{
	ROUTE_LIST_ENTRY	*sptr_primary_route_list_entry;
	ROUTE_LIST_ENTRY	*sptr_secondary_route_list_entry;
	
	for (sptr_primary_route_list_entry = ipx_class.router_list.sptr_forward_link; sptr_primary_route_list_entry != NULL;
		sptr_primary_route_list_entry = sptr_primary_route_list_entry->links.sptr_forward_link)
		{
		for (sptr_secondary_route_list_entry = sptr_primary_route_list_entry->network_links.sptr_forward_link;
			sptr_secondary_route_list_entry != NULL;
			sptr_secondary_route_list_entry = sptr_secondary_route_list_entry->links.sptr_forward_link)
			{
 			sptr_secondary_route_list_entry->route_entry.hops = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
			}

		sptr_primary_route_list_entry->route_entry.hops = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
		sptr_primary_route_list_entry->new_primary_route = TRUE;

		++ipx_class.port[sptr_primary_route_list_entry->port_number].statistics.total_number_of_route_entries_aged_out;
		}

	update_routes_for_all_ports ();
}
/****************************************************************************/
static void build_SAP_list (void)
{
#ifndef MALLOC_ALL_ROUTE_AND_SAP_ENTRIES
	SAP_LIST_ENTRY	*sptr_SAP_list_entry;

	for (sptr_SAP_list_entry = &ipx_class.SAP_list_entry[0] ;
		sptr_SAP_list_entry < &ipx_class.SAP_list_entry[MAXIMUM_NUMBER_OF_NETWARE_LANS]; ++sptr_SAP_list_entry)
		{
		add_entry_to_list ((LINK *) &ipx_class.free_SAP_list_entries,(LINK *) &sptr_SAP_list_entry->links);
		}
#endif
}
/*************************************************************************/
void initialize_SAP_query (USHORT port_number,SAP_SEND_QUERY_PACKET	*sptr_SAP_query)
{
	sptr_SAP_query->ethernet_header.destination_address = broadcast_address;
	sptr_SAP_query->ethernet_header.source_address = ipx_class.port[port_number].ethernet_address;
	sptr_SAP_query->ethernet_header.length = RAW_8023_IPX;

	sptr_SAP_query->ipx_header.checksum = 0xffff;
	sptr_SAP_query->ipx_header.length = swap (sizeof (SAP_SEND_QUERY_PACKET) - sizeof (ETHERNET_HEADER));
	sptr_SAP_query->ipx_header.transport_control_hop_count = 0x00;
	sptr_SAP_query->ipx_header.packet_type = UNKNOWN_PACKET_TYPE;

	sptr_SAP_query->ipx_header.destination.network = ipx_class.port[port_number].network;
	sptr_SAP_query->ipx_header.destination.node_address = broadcast_address;
	sptr_SAP_query->ipx_header.destination.socket = SAP_SOCKET;

	sptr_SAP_query->ipx_header.source.network = ipx_class.port[port_number].network;
	sptr_SAP_query->ipx_header.source.node_address = ipx_class.port[port_number].ethernet_address;
	sptr_SAP_query->ipx_header.source.socket = SAP_SOCKET;

/* If IPX network is to be learned and is not yet learned
	use network = 0 to stop file server from cribbing	Vidy - 2nd Sept */
	if ((ipx_class.port[port_number].learn_network_address == TRUE) &&
		(ipx_class.port[port_number].network_address_learned == FALSE)) {
			sptr_SAP_query->ipx_header.destination.network = 0;
			sptr_SAP_query->ipx_header.source.network = 0;
	}

	sptr_SAP_query->service_query_packet.SAP_type = (enum SAP_PACKET_TYPE) ALL_SERVER_TYPES;
}
/*************************************************************************/
void initialize_SAP_periodic_response (USHORT port_number,SAP_RESPONSE_PACKET *sptr_SAP_response_packet)
{
	sptr_SAP_response_packet->ethernet_header.destination_address = broadcast_address;
	sptr_SAP_response_packet->ethernet_header.source_address = ipx_class.port[port_number].ethernet_address;
	sptr_SAP_response_packet->ethernet_header.length = RAW_8023_IPX;

	sptr_SAP_response_packet->ipx_header.checksum = 0xffff;
	sptr_SAP_response_packet->ipx_header.transport_control_hop_count = 0x00;
	sptr_SAP_response_packet->ipx_header.packet_type = PACKET_EXCHANGE_PACKET;

	sptr_SAP_response_packet->ipx_header.destination.network = ipx_class.port[port_number].network;
	sptr_SAP_response_packet->ipx_header.destination.node_address = broadcast_address;
	sptr_SAP_response_packet->ipx_header.destination.socket = SAP_SOCKET;

	sptr_SAP_response_packet->ipx_header.source.network = ipx_class.port[port_number].network;
	sptr_SAP_response_packet->ipx_header.source.node_address = ipx_class.port[port_number].ethernet_address;
	sptr_SAP_response_packet->ipx_header.source.socket = SAP_SOCKET;

	sptr_SAP_response_packet->type = GENERAL_SERVICE_RESPONSE;
	if ((ipx_class.port[port_number].learn_network_address == TRUE) &&
		(ipx_class.port[port_number].network_address_learned == FALSE)) {
			sptr_SAP_response_packet->ipx_header.destination.network = 0;
			sptr_SAP_response_packet->ipx_header.source.network = 0;
	}

}
/*************************************************************************/
void initialize_SAP_response (USHORT port_number,SAP_RESPONSE_PACKET *sptr_SAP_response_packet,
	ETHERNET_ADDRESS *sptr_destination_address,USHORT ipx_header_length,IPX_ADDRESS *sptr_ipx_destination_address,
	enum RESPONSE_TYPE response_type)
{
	sptr_SAP_response_packet->ethernet_header.destination_address = *sptr_destination_address;
	sptr_SAP_response_packet->ethernet_header.source_address = ipx_class.port[port_number].ethernet_address;
	sptr_SAP_response_packet->ethernet_header.length = RAW_8023_IPX;

	sptr_SAP_response_packet->ipx_header.checksum = 0xffff;
	sptr_SAP_response_packet->ipx_header.transport_control_hop_count = 0x00;
	sptr_SAP_response_packet->ipx_header.packet_type = PACKET_EXCHANGE_PACKET;
	sptr_SAP_response_packet->ipx_header.length = ipx_header_length;

	sptr_SAP_response_packet->ipx_header.source.node_address = ipx_class.port[port_number].ethernet_address;
	sptr_SAP_response_packet->ipx_header.source.network = ipx_class.port[port_number].network;
	sptr_SAP_response_packet->ipx_header.source.socket = SAP_SOCKET;

	sptr_SAP_response_packet->ipx_header.destination = *sptr_ipx_destination_address;

	sptr_SAP_response_packet->type = (USHORT_ENUM (RESPONSE_TYPE)) response_type;
	if ((ipx_class.port[port_number].learn_network_address == TRUE) &&
		(ipx_class.port[port_number].network_address_learned == FALSE)) {
			sptr_SAP_response_packet->ipx_header.destination.network = 0;
			sptr_SAP_response_packet->ipx_header.source.network = 0;
	}
}
/*************************************************************************/
void delete_SAP_entries_and_send_farewell_broadcast (void)
{
	SAP_LIST_ENTRY	*sptr_primary_SAP_list_entry;
	SAP_LIST_ENTRY *sptr_secondary_SAP_list_entry;

	for (sptr_primary_SAP_list_entry = ipx_class.SAP_list.sptr_forward_link; sptr_primary_SAP_list_entry != NULL;
		sptr_primary_SAP_list_entry = sptr_primary_SAP_list_entry->links.sptr_forward_link)
		{
		for (sptr_secondary_SAP_list_entry = sptr_primary_SAP_list_entry->SAP_links.sptr_forward_link;
			sptr_secondary_SAP_list_entry != NULL;
			sptr_secondary_SAP_list_entry = sptr_secondary_SAP_list_entry->links.sptr_forward_link)
			{
			sptr_secondary_SAP_list_entry->SAP_ID.intervening_networks = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
			}

		sptr_primary_SAP_list_entry->SAP_ID.intervening_networks = SERVER_OR_ROUTER_DOWN_HOP_COUNT;
		sptr_primary_SAP_list_entry->new_primary_SAP = TRUE;

		++ipx_class.port[sptr_primary_SAP_list_entry->port_number].statistics.total_number_of_SAP_entries_aged_out;
		}

	update_SAPs_for_all_ports ();

	check_for_down_SAPs ();
}
/*************************************************************************/
void register_nlsp (enum IPX_PACKET_STATE (*fptr_nlsp_rx_routine)
	(ULONG port_number,void *sptr_dlsw_rx_packet,USHORT size_of_packet),
	enum NLSP_VALID_ENTRY_RETURN_TYPE (*fptr_nlsp_check_for_valid_route_entry) (ROUTE_LIST_ENTRY *sptr_route_list_entry, 
		enum BOOLEAN rxed_rip_packet),
	enum TEST (*fptr_nlsp_check_for_valid_SAP_id) (SAP_LIST_ENTRY *sptr_SAP_list_entry, enum BOOLEAN rxed_sap_packet),
	ETHERNET_ADDRESS *(*fptr_nlsp_find_valid_route) (ULONG network_number,USHORT *usptr_next_hop_port_number),
	void (*fptr_copy_ipx_parameters_into_nlsp) (void *sptr_ipx_interface_parameters),
	void (*fptr_copy_rip_sap_compatibility_info_in_ipx) 
		(NLSP_RIP_SAP_COMPATIBILITY_PARAMETERS *sptr_nlsp_rip_sap_compatibility_parameters),
	void (*fptr_nlsp_send_pseudonode_lsps) (USHORT port_number))
{
	USHORT virtual_port_number;
	NLSP_TO_IPX_INTERFACE_PARAMETERS nlsp_to_ipx_interface_parameters;
	NLSP_RIP_SAP_COMPATIBILITY_PARAMETERS nlsp_rip_sap_compatibility_parameters;

	ipx_class.nlsp.enabled = TRUE;

	ipx_class.nlsp.fptr_nlsp_rx_routine = fptr_nlsp_rx_routine;
	ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry = fptr_nlsp_check_for_valid_route_entry;
	ipx_class.nlsp.fptr_nlsp_check_for_valid_SAP_id = fptr_nlsp_check_for_valid_SAP_id;
	ipx_class.nlsp.fptr_nlsp_find_valid_route = fptr_nlsp_find_valid_route;
	ipx_class.nlsp.fptr_copy_ipx_parameters_into_nlsp = fptr_copy_ipx_parameters_into_nlsp;
	ipx_class.nlsp.fptr_copy_rip_sap_compatibility_info_in_ipx = fptr_copy_rip_sap_compatibility_info_in_ipx;
	ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps = fptr_nlsp_send_pseudonode_lsps;

	for (virtual_port_number = 0x0000; virtual_port_number < ipx_class.number_of_ports; ++virtual_port_number)
		{
		nlsp_to_ipx_interface_parameters.wan_port[virtual_port_number] = ipx_class.port[virtual_port_number].wan_port;
		nlsp_to_ipx_interface_parameters.network[virtual_port_number] = ipx_class.port[virtual_port_number].network;
		nlsp_to_ipx_interface_parameters.ethernet_address[virtual_port_number] =
			ipx_class.port[virtual_port_number].ethernet_address;
		nlsp_to_ipx_interface_parameters.token_ring_enabled[virtual_port_number] =
			ipx_class.port[virtual_port_number].token_ring_enabled;
		nlsp_to_ipx_interface_parameters.maximum_number_of_hops[virtual_port_number] =
			ipx_class.port[virtual_port_number].maximum_number_of_hops;
		nlsp_to_ipx_interface_parameters.transport_time[virtual_port_number] = ipx_class.port[virtual_port_number].transport_time;
		nlsp_to_ipx_interface_parameters.tx_frame_type[virtual_port_number] = ipx_class.port[virtual_port_number].tx_frame_type;
		nlsp_to_ipx_interface_parameters.SAP_age_timer[virtual_port_number] = ipx_class.port[virtual_port_number].SAP_age_timer;
		nlsp_to_ipx_interface_parameters.RIP_age_timer[virtual_port_number] = ipx_class.port[virtual_port_number].RIP_age_timer;
		}

	nlsp_to_ipx_interface_parameters.internal_SAP_id = ipx_class.internal_SAP_id;
	nlsp_to_ipx_interface_parameters.sptr_SAP_list = (SAP_LINK *) &ipx_class.SAP_list;
	nlsp_to_ipx_interface_parameters.sptr_router_list = (ROUTE_LINK *) &ipx_class.router_list;
	nlsp_to_ipx_interface_parameters.stack_id = ipx_class.stack_id;

	(*ipx_class.nlsp.fptr_copy_ipx_parameters_into_nlsp) (&nlsp_to_ipx_interface_parameters);

	(*ipx_class.nlsp.fptr_copy_rip_sap_compatibility_info_in_ipx) (&nlsp_rip_sap_compatibility_parameters);

	for (virtual_port_number = 0x0000; virtual_port_number < ipx_class.number_of_ports; ++virtual_port_number)
		{
		ipx_class.port[virtual_port_number].rip_compatibility = 
			nlsp_rip_sap_compatibility_parameters.rip_compatibility[virtual_port_number];
		ipx_class.port[virtual_port_number].sap_compatibility = 
			nlsp_rip_sap_compatibility_parameters.sap_compatibility[virtual_port_number];

		if (ipx_class.port[virtual_port_number].rip_compatibility == RIP_AUTO)
			{
			ipx_class.port[virtual_port_number].auto_rip_compatibility_activated = FALSE;
			}

		if (ipx_class.port[virtual_port_number].sap_compatibility == SAP_AUTO)
			{
			ipx_class.port[virtual_port_number].auto_sap_compatibility_activated = FALSE;
			}
		}
}
/*************************************************************************/
enum TEST IPX_control (enum PROTOCOL_CONTROL_OPERATION command,ULONG parameter_0,ULONG parameter_1)
{
	USHORT port_number;
	USHORT vir_port_number;
	 
	port_number = (USHORT) parameter_0;

	switch (command)
		{
		case OPEN_PROTOCOL_STACK:
			break;
		case CLOSE_PROTOCOL_STACK:
			shut_down_ipx_router ();
			break;
		case OPEN_VIRTUAL_PORT:

			if (ipx_class.port[port_number].port_enabled == FALSE)
				break;

			if (ipx_class.port[port_number].remote_access == FALSE)
				{
				add_local_route (port_number);
				}

				/* BELOW  2 LINES WERE ADDED BY ME TO GET AROUND THE PROBLEM OF NOT
					 DETECTING THE NOV SERVERS IMMEDIATELY AFTER COMING UP */
			for (vir_port_number = ipx_class.starting_port_number; vir_port_number < ipx_class.number_of_ports; ++vir_port_number){
					ipx_class.port[vir_port_number].number_of_RIP_clock_ticks = 1000;
					ipx_class.port[vir_port_number].number_of_SAP_clock_ticks = 1000;
			}
			if (ipx_class.port[port_number].wan_port == TRUE)
				{
#ifdef IPX_WAN_ENABLED
				ipx_wan_device_driver_port_up (port_number);
#endif
				}
			else
				{
				send_periodic_route_information (port_number);
				issue_router_info_request (port_number); /* get all router info */
				send_SAP_query (GENERAL_SERVICE_QUERY,port_number); /* get all SAP info */
				send_SAP_periodic_broadcast (port_number);
				}

			break;
		case CLOSE_VIRTUAL_PORT:
			if (ipx_class.port[port_number].wan_port == TRUE)
				{
#ifdef IPX_WAN_ENABLED
				ipx_wan_port_down (port_number);
#endif
				}
			
			if(ipx_class.port[port_number].RIP_age_timer)
				shut_ipx_rip_port_down (port_number);
			if(ipx_class.port[port_number].SAP_age_timer)
				shut_ipx_SAP_port_down (port_number);

#ifdef RTRERROR
			ipx_class.port[port_number].port_enabled = FALSE;
#endif

			break;

		case IS_PROTOCOL_STACK_ENABLED:
		case GET_NUMBER_OF_PROTOCOL_STACKS_VIRTUAL_PORTS:
		case GET_PROTOCOL_STACK_TYPE:
		case GET_PROTOCOL_STACK_PROTOCOL_ID:
		case GET_PROTOCOL_STACK_SSAP:
		case GET_PROTOCOL_STACK_DSAP:
		case GET_PROTOCOL_STACK_VIRTUAL_PORT_PACKET_TYPE:
		case GET_PROTOCOL_STACK_REAL_PORT_NUMBER_USING_VIRTUAL_PORT_NUMBER:
			ipx_configuration (command,parameter_0,parameter_1);
			break;
		}

	return (PASS);													
}
#if defined (_MSC_VER)
/*************************************************************************/ 
ULONG routerware_control (enum ROUTERWARE_CONTROL_OPERATION command,...)
{
	va_list argptr;
	ULONG return_value;
	ULONG parameter[10];
	BYTE parameter_index;

	va_start (argptr,command);

	for (parameter_index = 0x00; parameter_index < 5; parameter_index = (BYTE) (parameter_index + 1))
		{
		parameter[parameter_index] = va_arg (argptr,ULONG);
		}

	switch (command)
		{
		case RW_INITIALIZE:
			return_value = initialize_IPX_router (parameter[0x00]);
			break;
		case RW_GET_CLASS_ADDRESS:
			return_value = (ULONG) &ipx_class;
			break;
		case RW_GET_CLASS_SIZE:
			return_value = sizeof (IPX_CLASS);
			break;
		case RW_GET_CONFIGURATION_TABLE_ADDRESS:
			return_value = ipx_get_configuration_table_address ();
			break;
		}

	return (return_value);
}

#endif

void init_ipx_router_network(char *ethernet_address)
{
	char *network;
	int i;
	
			network = (char *) &ipx_class.internal_SAP_id.ipx_address.network;
			for(i=0;i<4;i++)
				network[i] = ethernet_address[i+2];
}

void initialize_ipx_basic_snmp_table()
{
	ipx_class.number_of_basic_system_entries = 0x01;


	ipx_class.ipxBasicSysEntry[0].ipxBasicSysInstance = 0x00000001L;
	ipx_class.ipxBasicSysEntry[0].ipxBasicSysExistState = TRUE;

	ipx_class.ipxBasicSysEntry[0].ipxBasicSysNetNumber = ipx_class.internal_SAP_id.ipx_address.network;
	ipx_class.ipxBasicSysEntry[0].ipxBasicSysNode = ipx_class.internal_SAP_id.ipx_address.node_address;
	memcpy(ipx_class.ipxBasicSysEntry[0].ipxBasicSysName, ipx_class.internal_SAP_id.SAP_name, 48);

	/* The following is not meaningful here as we don't really provide an IPX
	** stack to anybody. So we will set it 0.
	*/
	ipx_class.ipxBasicSysEntry[0].ipxBasicSysConfigSockets = 0;
}

void initialize_ipx_adv_snmp_table()
{
	ipx_class.number_of_adv_system_entries = 0x01;


	ipx_class.ipxAdvSysEntry[0].ipxAdvSysInstance = 0x00000001L;
	ipx_class.ipxAdvSysEntry[0].ipxAdvSysMaxPathSplits = 1;

	/* For max hops, we will use the value configured for the LAN port */
	ipx_class.ipxAdvSysEntry[0].ipxAdvSysMaxHops = ipx_class.port[0].maximum_number_of_hops;

	ipx_class.ipxAdvSysEntry[0].ipxAdvSysCircCount = ipx_class.number_of_ports;

	/* We do not currently support IPXWAN. So all such variables will be at 0. */
}

/* Srikar, Apr 11, 1997. Modified code to use port_enabled field for port's existential state
	instead of using the function get_port_exist_state */
void initialize_ipx_circuit_snmp_table()
{
	USHORT port_number;
	USHORT number_of_lan_ports;

	/* Srikar, Mar 17, 1997. Added code to obtain number of lan ports */
	number_of_lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);

	ipx_class.number_of_circuit_entries = ipx_class.number_of_ports;
	
	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
	{
		ipx_class.port[port_number].ipx_instance = 1;
		/* Srikar, Mar 17, 1997. Added code to initialize exist_state field used for ipxCircExistState */
		if (ipx_class.port[port_number].wan_port == TRUE)
		{
			ipx_class.port[port_number].ipx_mib.circuit_type = POINT_TO_POINT_CIRCUIT_TYPE;
		}
		else 
		{
			ipx_class.port[port_number].ipx_mib.circuit_type = BROADCAST_CIRCUIT_TYPE;
			/* Srikar, Apr 11, 1997. Added the code to initialize the ipxCircOperState in case of lan ports */
			ipx_class.port[port_number].ipx_mib.ipxCircOperState = TRUE;
		}
		/* Srikar, Mar 17, 1997. Changed the initialized value from UNKNOWN_CIRCUIT_STATUS */
		ipx_class.port[port_number].ipx_mib.circuit_status = CURRENT_CIRCUIT_STATUS;
		ipx_class.port[port_number].statistics.ipx_mib.number_of_milliseconds_to_send_1_byte =
			((ULONG)ipx_class.port[port_number].transport_time * 1000) / ipx_class.clock_ticks_per_second; 

		/* Srikar, Mar 18, 1997. The first four are used on the LAN port, remaining on the WAN port. Hence */
		/* modified the index to the call to LSL to get port speed. */
		ipx_class.port[port_number].ipx_mib.throughput_in_bits_per_second =
				lsl_control (GET_PORT_SPEED, (ipx_class.port[port_number].wan_port == TRUE ? port_number - 3 : 0));
	}
}

void initialize_ipx_rip_sap_snmp_table()
{
	ipx_class.number_of_rip_sys_entries = 1;
	ipx_class.ripSysEntry[0].ripSysInstance = 0x00000001L;
	ipx_class.ripSysEntry[0].ripSysState = TRUE;


	ipx_class.number_of_sap_sys_entries = 1;
	ipx_class.sapSysEntry[0].sapSysInstance = 0x00000001L;
	ipx_class.sapSysEntry[0].sapSysState = TRUE;
}

void initialize_ipx_rip_sap_circuit_snmp_table()
{
	USHORT port_number;
/* Some structures locallly defined here */
	typedef struct RIP_HEADER {
		USHORT operation;
	} RIP_HEADER;
	typedef struct RIP_ENTRY {
		ULONG network_number;
		USHORT number_of_hops;
		USHORT number_of_ticks;
	} RIP_ENTRY;
	typedef struct SAP_HEADER {
		USHORT operation;
	} SAP_HEADER;
	typedef struct SAP_ENTRY {
		USHORT service_type;
		char server_name[48];
		ULONG network_number;
		MAC_ADDRESS node_address;
		USHORT socket_number;
		USHORT hops_to_server;
	} SAP_ENTRY;

	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
	{
		/* Our time in seconds by seconds per minute = rip age multiplier */
		ipx_class.port[port_number].rip_sap_mib.rip_holding_timer = 
				ipx_class.port[port_number].RIP_age_timer / 60;
		ipx_class.port[port_number].rip_sap_mib.rip_packets_per_second = 
				ipx_class.clock_ticks_per_second / ipx_class.gap_time_limit;
		ipx_class.port[port_number].rip_sap_mib.rip_packet_size = 
				ipx_class.port[port_number].maximum_number_of_rip_entries * 
					sizeof(RIP_ENTRY) + sizeof(RIP_HEADER) + sizeof(IPX_HEADER);



		ipx_class.port[port_number].rip_sap_mib.SAP_holding_timer = 
				ipx_class.port[port_number].SAP_age_timer / 60;
		ipx_class.port[port_number].rip_sap_mib.SAP_packets_per_second = 
				ipx_class.clock_ticks_per_second / ipx_class.gap_time_limit;
		ipx_class.port[port_number].rip_sap_mib.SAP_packet_size =
				ipx_class.port[port_number].maximum_number_of_SAP_entries *
					sizeof(SAP_ENTRY) + sizeof(SAP_HEADER) + sizeof(IPX_HEADER);
		ipx_class.port[port_number].rip_sap_mib.respond_to_SAP_nearest_queries = TRUE;
	}
}



