#include	"defs.h"
/*	$Modname: ipxnetbs.c$  $version: 3.17$      $date: 10/20/95$   */
/*
* 	$lgb$
2.3 01/05/92 ross
2.4 01/21/92 ross new version control 2.3
2.5 01/26/92 ross
2.6 10/20/92 ross
2.7 11/24/92 ross
2.8 11/24/92 ross
2.9 12/05/92 ross general clean-up moved some globals in #ifdefs
2.10 12/06/92 ross implemented ipx class structure - no algorithm changes
2.11 12/26/92 ross
2.12 01/12/93 ross Added checks for too large hop counts in ipxrout and ipxnetbs and statistics, LLC proper SAPs, netbios broadcast fix soon
2.13 01/13/93 ross Bug fix in Netbios courtesy of YR.
3.0 01/13/93 ross
3.1 01/31/93 ross changed send_ipx_.. to use alloced buffer.
3.2 02/08/93 ross had unneeded test case for large hop count netbios lans.
3.3 02/15/93 ross changes for hop_count and port_number. YR.
3.4 02/20/93 ross added destination address line in send.
3.5 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.6 03/30/93 ross added netbios name caching.
3.7 04/12/93 ross made variable change in vipxstr.h
3.8 05/13/93 ross added stack parameter for tunnel software
3.9 05/15/93 ross changed 0 to 0x00 in for loop.
3.10 05/24/93 ross fixed some problems will loops going down.
3.11 02/02/94 ross deleted end-of-file.
3.12 03/11/94 ross in initialize name challenge add a cast.  Courtesy of Lori.
3.13 03/14/94 ross cleaned up braces and white spaces for release.
3.14 03/19/94 ross cosmetic cleanup, extraneous header files removed.
3.15 08/25/94 ross added fixes for netbios name caching.  Courtesy of Ishwar.
3.16 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.17 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
/******************* ipxnetbs.C Source **********************************/
/************************************************************************/
#include <string.h>
#include <stdlib.h>
#include	"ipx.h"
/****************************************************************************/
static enum BOOLEAN netbios_name_is_local (USHORT port_number,NOVELL_NETBIOS_PACKET *sptr_netbios_rx_packet);
static enum BOOLEAN check_to_see_if_add_name_failed (USHORT port_number,NOVELL_NETBIOS_PACKET *sptr_netbios_rx_packet);
static NETBIOS_NAME_ENTRY *get_netbios_name_entry_from_list (USHORT port_number,char const *cptr_netbios_name);
static NETBIOS_NAME_ENTRY *get_netbios_name_entry_from_all_lists (char const *cptr_netbios_name,USHORT *usptr_port_number);
static void issue_netbios_name_challenge_packet (USHORT port_number,char const *cptr_netbios_name,
	ETHERNET_ADDRESS *sptr_netbios_name_address);
static void initialize_netbios_name_challenge_packet (USHORT port_number,
	NOVELL_NETBIOS_NAME_CHALLENGE_PACKET *sptr_netbios_challenge_packet,ETHERNET_ADDRESS *sptr_destination_ethernet_address,
	char const *cptr_netbios_name);
/****************************************************************************/
enum IPX_PACKET_STATE netbios_packet_received (USHORT port_number,NOVELL_NETBIOS_PACKET *sptr_netbios_rx_packet,
	USHORT size_of_frame,enum BOOLEAN stack_packet)
{
	enum IPX_PACKET_STATE netbios_return_code;
	BYTE	number_of_networks_already_seen;
	USHORT	local_port_number;
	enum	BOOLEAN already_seen_on_this_network;
	IPX_PACKET *sptr_netbios_packet_to_forward;

	++ipx_class.port[port_number].statistics.number_of_netbios_packets_received;
/* Sanjays code */
	++ipx_class.ipxAdvSysEntry[0].ipxAdvSysNETBIOSPackets;
/* Sanjays code */


	if (ipx_class.port[port_number].netbios_enabled == FALSE)
		{
		return (NETBIOS_DISABLED);
		}

	if (sptr_netbios_rx_packet->ipx_header.packet_type != NETBIOS_NAME_PACKET)
		{
		if (ipx_class.port[port_number].netbios_name_caching_enabled == TRUE)
			{
			check_to_see_if_add_name_failed (port_number,sptr_netbios_rx_packet);
			}

		netbios_return_code = ipx_data_to_route (port_number,(IPX_PACKET *)sptr_netbios_rx_packet,size_of_frame,stack_packet);

		return (netbios_return_code);
		}
	else if (sptr_netbios_rx_packet->ipx_header.transport_control_hop_count >=
		ipx_class.port[port_number].maximum_number_of_netbios_hops)
		{
		++ipx_class.port[port_number].statistics.number_of_netbios_hop_counts_too_large;

		return (NETBIOS_PACKET_RXED_MAX_LANS);
		}
	else if (swap (sptr_netbios_rx_packet->ipx_header.length) <
		sizeof (IPX_HEADER) + (sizeof (ULONG) * MAXIMUM_NUMBER_OF_NETBIOS_LANS))
		{
		++ipx_class.port[port_number].statistics.number_of_unknown_netbios_packets_received;

		return (NETBIOS_UNKNOWN_PACKET_RXED);
		}
	else
		{
		if (ipx_class.port[port_number].netbios_name_caching_enabled == TRUE)
			{
			if (netbios_name_is_local (port_number,sptr_netbios_rx_packet) == TRUE)
				{
				return (NETBIOS_PACKET_RXED_LOCAL);
				}
			}

		for (local_port_number = ipx_class.starting_port_number; local_port_number < ipx_class.number_of_ports; ++local_port_number)
			{
			already_seen_on_this_network = FALSE;

			for (number_of_networks_already_seen = 0x00 ;number_of_networks_already_seen <
				sptr_netbios_rx_packet->ipx_header.transport_control_hop_count;
				number_of_networks_already_seen = (BYTE) (number_of_networks_already_seen + 1))
				{
				if (sptr_netbios_rx_packet->netbios_network_number[number_of_networks_already_seen] ==
					ipx_class.port[local_port_number].network)
					{
					already_seen_on_this_network = TRUE;
					}
				}

			if ((already_seen_on_this_network == FALSE) && (port_number != local_port_number))
				{
				sptr_netbios_rx_packet->ipx_header.destination.network = ipx_class.port[local_port_number].network;

				sptr_netbios_rx_packet->ethernet_header.source_address =
					ipx_class.port[local_port_number].ethernet_address;

				sptr_netbios_rx_packet->ethernet_header.destination_address =
					sptr_netbios_rx_packet->ipx_header.destination.node_address;

			 	sptr_netbios_rx_packet->netbios_network_number[sptr_netbios_rx_packet->ipx_header.transport_control_hop_count] =
			 		ipx_class.port[port_number].network;

				sptr_netbios_packet_to_forward = (IPX_PACKET *) get_a_send_packet (local_port_number,size_of_frame);

				if (sptr_netbios_packet_to_forward == NULL)
					{
					return (OUT_OF_TX_PACKET_MEMORY);
					}

				memcpy (sptr_netbios_packet_to_forward,sptr_netbios_rx_packet,size_of_frame);

				sptr_netbios_packet_to_forward->ipx_header.transport_control_hop_count =
					(BYTE) (sptr_netbios_packet_to_forward->ipx_header.transport_control_hop_count + 1);

				send_ipx_packet (local_port_number,(IPX_PACKET *) sptr_netbios_packet_to_forward,size_of_frame,FALSE,
					send_completion_ipx_packet);
				}
			}
		}

	return (NETBIOS_PACKET_RXED);
}
/****************************************************************************/
static enum BOOLEAN netbios_name_is_local (USHORT port_number,NOVELL_NETBIOS_PACKET *sptr_netbios_rx_packet)
{	
	NETBIOS_NAME_ENTRY *sptr_netbios_name_entry;

	sptr_netbios_name_entry = get_netbios_name_entry_from_list (port_number,sptr_netbios_rx_packet->name);

	if (sptr_netbios_name_entry == NULL)
		{
		sptr_netbios_name_entry = (NETBIOS_NAME_ENTRY *) table_malloc (sizeof (NETBIOS_NAME_ENTRY),1);

		if (sptr_netbios_name_entry != NULL)
			{
			memcpy (sptr_netbios_name_entry->name,sptr_netbios_rx_packet->name,16);

         sptr_netbios_name_entry->timer_value = router_timer;

			sptr_netbios_name_entry->netbios_name_address = sptr_netbios_rx_packet->ethernet_header.source_address;

			add_entry_to_list ((LINK *) &ipx_class.port[port_number].netbios_name_list,&sptr_netbios_name_entry->links);
			}

		return (FALSE);
		}
	else
		{
		sptr_netbios_name_entry->netbios_name_address = sptr_netbios_rx_packet->ethernet_header.source_address;

		return (TRUE);
		}
}
/****************************************************************************/
static enum BOOLEAN check_to_see_if_add_name_failed (USHORT port_number,NOVELL_NETBIOS_PACKET *sptr_netbios_rx_packet)
{
	NETBIOS_NAME_ENTRY *sptr_netbios_name_entry;
	USHORT name_port_number;

	if (sptr_netbios_rx_packet->name_type_flag._bit.name_used == TRUE &&
		sptr_netbios_rx_packet->name_type_flag._bit.group_name == FALSE &&
		sptr_netbios_rx_packet->datastream_type == ADD_NETBIOS_NAME)
		{
		sptr_netbios_name_entry = get_netbios_name_entry_from_all_lists (sptr_netbios_rx_packet->name,&name_port_number);

		if (sptr_netbios_name_entry != NULL)
			{
			if (memcmp (&ipx_class.port[port_number].ethernet_address,
				&sptr_netbios_rx_packet->ipx_header.destination.node_address,sizeof (ETHERNET_ADDRESS)) != (int) NULL)
				{
	 			delete_entry_from_list ((LINK *) &ipx_class.port[name_port_number].netbios_name_list,
					&sptr_netbios_name_entry->links);

				memset (sptr_netbios_name_entry, (int) NULL, sizeof (NETBIOS_NAME_ENTRY));

				table_free (sptr_netbios_name_entry);

				return (TRUE);
				}
			else if (sptr_netbios_name_entry->challenge_issued == TRUE)
				{
				sptr_netbios_name_entry->challenge_issued = FALSE;
				}
			}
		}

	return (FALSE);
}
/****************************************************************************/
static NETBIOS_NAME_ENTRY *get_netbios_name_entry_from_list (USHORT port_number,char const *cptr_netbios_name)
{
	NETBIOS_NAME_ENTRY *sptr_netbios_name_entry;

	for (sptr_netbios_name_entry = (NETBIOS_NAME_ENTRY *) ipx_class.port[port_number].netbios_name_list.sptr_forward_link;
		sptr_netbios_name_entry != (NETBIOS_NAME_ENTRY *) 0x00000000L;
		sptr_netbios_name_entry = (NETBIOS_NAME_ENTRY *) sptr_netbios_name_entry->links.sptr_forward_link)
		{
		if (memcmp (cptr_netbios_name,sptr_netbios_name_entry->name,sizeof (sptr_netbios_name_entry->name)) == (int) NULL)
			{
			return (sptr_netbios_name_entry);
			}
		}

	return (NULL);
}
/****************************************************************************/
static NETBIOS_NAME_ENTRY *get_netbios_name_entry_from_all_lists (char const *cptr_netbios_name,USHORT *usptr_port_number)
{
	NETBIOS_NAME_ENTRY *sptr_netbios_name_entry;
	USHORT port_number;

	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
		{
		for (sptr_netbios_name_entry = (NETBIOS_NAME_ENTRY *) ipx_class.port[port_number].netbios_name_list.sptr_forward_link;
			sptr_netbios_name_entry != (NETBIOS_NAME_ENTRY *) 0x00000000L;
			sptr_netbios_name_entry = (NETBIOS_NAME_ENTRY *) sptr_netbios_name_entry->links.sptr_forward_link)
			{
			if (memcmp (cptr_netbios_name,sptr_netbios_name_entry->name,sizeof (sptr_netbios_name_entry->name)) == (int) NULL)
				{
				*usptr_port_number = port_number;
				return (sptr_netbios_name_entry);
				}
			}
		}

	return (NULL);
}
/****************************************************************************/
void check_age_of_netbios_names (USHORT port_number)
{
	NETBIOS_NAME_ENTRY *sptr_netbios_name_entry;
	NETBIOS_NAME_ENTRY *sptr_next_netbios_name_entry;

	for (sptr_netbios_name_entry = (NETBIOS_NAME_ENTRY *) ipx_class.port[port_number].netbios_name_list.sptr_forward_link;
		sptr_netbios_name_entry != (NETBIOS_NAME_ENTRY *) 0x00000000L;
		sptr_netbios_name_entry = sptr_next_netbios_name_entry)
		{
		sptr_next_netbios_name_entry = (NETBIOS_NAME_ENTRY *) sptr_netbios_name_entry->links.sptr_forward_link;

		++sptr_netbios_name_entry->timer_value;
		if (sptr_netbios_name_entry->timer_value + ipx_class.port[port_number].netbios_name_cache_timer < router_timer)
			{
			if (sptr_netbios_name_entry->challenge_issued == FALSE)
				{
				sptr_netbios_name_entry->challenge_issued = TRUE;

				issue_netbios_name_challenge_packet (port_number,&sptr_netbios_name_entry->name[0],
					&sptr_netbios_name_entry->netbios_name_address);
				}
			else
				{
	 			delete_entry_from_list ((LINK *) &ipx_class.port[port_number].netbios_name_list,&sptr_netbios_name_entry->links);

				memset (sptr_netbios_name_entry, (int) NULL, sizeof (NETBIOS_NAME_ENTRY));

				table_free (sptr_netbios_name_entry);
				}
			}
		}
}
/****************************************************************************/
static void issue_netbios_name_challenge_packet (USHORT port_number,char const *cptr_netbios_name,
	ETHERNET_ADDRESS *sptr_netbios_name_address)
{
	NOVELL_NETBIOS_NAME_CHALLENGE_PACKET *sptr_netbios_challenge_packet;

	sptr_netbios_challenge_packet = (NOVELL_NETBIOS_NAME_CHALLENGE_PACKET *) get_a_send_packet (port_number,
		sizeof (NOVELL_NETBIOS_NAME_CHALLENGE_PACKET));

	if (sptr_netbios_challenge_packet == NULL)
		{
		return;
		}

	initialize_netbios_name_challenge_packet (port_number,sptr_netbios_challenge_packet,sptr_netbios_name_address,
		cptr_netbios_name);

	sptr_netbios_challenge_packet->ipx_header.length =	swap (sizeof (NOVELL_NETBIOS_NAME_CHALLENGE_PACKET) -
		sizeof ( ETHERNET_HEADER ));

/* Sanjays code */
	++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
	send_ipx_packet (port_number,(IPX_PACKET *) sptr_netbios_challenge_packet,sizeof (NOVELL_NETBIOS_NAME_CHALLENGE_PACKET),FALSE,
		send_completion_ipx_packet);
}
/****************************************************************************/
static void initialize_netbios_name_challenge_packet (USHORT port_number,
	NOVELL_NETBIOS_NAME_CHALLENGE_PACKET *sptr_netbios_challenge_packet,ETHERNET_ADDRESS *sptr_destination_ethernet_address,
	char const *cptr_netbios_name)
{
	sptr_netbios_challenge_packet->ethernet_header.destination_address = *sptr_destination_ethernet_address;
	sptr_netbios_challenge_packet->ethernet_header.source_address = ipx_class.port[port_number].ethernet_address;

	sptr_netbios_challenge_packet->ipx_header.checksum = 0xffff;
	sptr_netbios_challenge_packet->ipx_header.transport_control_hop_count = 0x00;
	sptr_netbios_challenge_packet->ipx_header.packet_type = PACKET_EXCHANGE_PACKET;

	sptr_netbios_challenge_packet->ipx_header.destination.node_address =
		sptr_netbios_challenge_packet->ethernet_header.destination_address;
	sptr_netbios_challenge_packet->ipx_header.destination.network = ipx_class.port[port_number].network;
	sptr_netbios_challenge_packet->ipx_header.destination.socket = NETBIOS_SOCKET;

	sptr_netbios_challenge_packet->ipx_header.source.network = ipx_class.port[port_number].network;
	sptr_netbios_challenge_packet->ipx_header.source.node_address = sptr_netbios_challenge_packet->ethernet_header.source_address;
	sptr_netbios_challenge_packet->ipx_header.source.socket = NETBIOS_SOCKET;

	sptr_netbios_challenge_packet->name_type_flag._byte = 0x00;
	sptr_netbios_challenge_packet->name_type_flag._bit.name_used = TRUE;

	sptr_netbios_challenge_packet->datastream_type = ADD_NETBIOS_NAME;

	memcpy ((void *) sptr_netbios_challenge_packet->name,(void *) cptr_netbios_name,sizeof (sptr_netbios_challenge_packet->name));
}
/****************************************************************************/
void free_all_netbios_names_in_lists (void)
{
	USHORT port_number;
	NETBIOS_NAME_ENTRY *sptr_netbios_name_entry;
	NETBIOS_NAME_ENTRY *sptr_next_netbios_name_entry;

	for (port_number = ipx_class.starting_port_number; port_number < ipx_class.number_of_ports; ++port_number)
		{
		if (ipx_class.port[port_number].netbios_name_caching_enabled == TRUE)
			{
			for (sptr_netbios_name_entry = (NETBIOS_NAME_ENTRY *) ipx_class.port[port_number].netbios_name_list.sptr_forward_link;
				sptr_netbios_name_entry != (NETBIOS_NAME_ENTRY *) 0x00000000L;
				sptr_netbios_name_entry = sptr_next_netbios_name_entry)
				{
				sptr_next_netbios_name_entry = (NETBIOS_NAME_ENTRY *) sptr_netbios_name_entry->links.sptr_forward_link;

	 			delete_entry_from_list ((LINK *) &ipx_class.port[port_number].netbios_name_list,&sptr_netbios_name_entry->links);

				memset (sptr_netbios_name_entry, (int) NULL, sizeof (NETBIOS_NAME_ENTRY));

				table_free (sptr_netbios_name_entry);
				}
			}
		}
}
