#include	"defs.h"
/*	$Modname: ipxnwlit.c$  $version: 1.10$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 01/31/93 ross first cut at netware lite support.
1.1 01/31/93 ross
1.2 02/01/93 ross
1.3 02/02/93 ross changed source_address in broadcast case to use my router's address.
1.4 02/02/93 ross changed it back.
1.5 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
1.6 04/12/93 ross made variable change in vipxstr.h
1.7 05/13/93 ross added stack parameter for tunnel software
1.8 03/14/94 ross cleaned up braces and white spaces for release.
1.9 11/21/94 ross changed to compile under C++, added big sap and rip support.
1.10 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	<stdlib.h>
#include	<string.h>
#include	"ipx.h"
/****************************************************************************/
enum IPX_PACKET_STATE netware_lite_packet_received (USHORT port_number,IPX_PACKET *sptr_netware_lite_rx_packet,
	USHORT size_of_packet)
{
	USHORT	local_port_number;
	IPX_PACKET *sptr_netware_lite_packet_to_forward;

	if (ipx_class.port[port_number].netware_lite_enabled == FALSE)
		{
		return (NETWARE_LITE_DISABLED);
		}

	if (sptr_netware_lite_rx_packet->ipx_header.packet_type == NETWARE_LITE_PACKET ||
		sptr_netware_lite_rx_packet->ipx_header.packet_type == NETWARE_LITE_ACK_PACKET)
		{
		++ipx_class.port[port_number].statistics.number_of_lite_packets_received;

		if (sptr_netware_lite_rx_packet->ipx_header.destination.node_address._ulong == 0xffffffffL &&
			sptr_netware_lite_rx_packet->ipx_header.destination.node_address._ushort == 0xffff)
			{
			if (sptr_netware_lite_rx_packet->ipx_header.source.network == 0x00000000L)
				{
				sptr_netware_lite_rx_packet->ipx_header.source.network =
					ipx_class.port[port_number].network;
				}

			for (local_port_number = ipx_class.starting_port_number; local_port_number < ipx_class.number_of_ports;
				++local_port_number)
				{
				if (port_number != local_port_number)
					{
					sptr_netware_lite_packet_to_forward = (IPX_PACKET *) get_a_send_packet (port_number,size_of_packet);

					if (sptr_netware_lite_packet_to_forward == NULL)
						{
						return (OUT_OF_TX_PACKET_MEMORY);
						}

					memcpy (sptr_netware_lite_packet_to_forward,sptr_netware_lite_rx_packet,size_of_packet);

					sptr_netware_lite_packet_to_forward->ipx_header.destination.network =
						ipx_class.port[local_port_number].network;

					sptr_netware_lite_packet_to_forward->ethernet_header.source_address =
							ipx_class.port[local_port_number].ethernet_address;

					sptr_netware_lite_packet_to_forward->ethernet_header.destination_address =
							sptr_netware_lite_rx_packet->ipx_header.destination.node_address;

					sptr_netware_lite_rx_packet->ipx_header.transport_control_hop_count =
						(BYTE) (sptr_netware_lite_rx_packet->ipx_header.transport_control_hop_count + 1);

					++ipx_class.port[local_port_number].statistics.number_of_lite_packets_sent;

					send_ipx_packet (local_port_number,(IPX_PACKET *) sptr_netware_lite_packet_to_forward,size_of_packet,FALSE,
						send_completion_ipx_packet);
					}
				}
			}
		else
			{
			++ipx_class.port[port_number].statistics.number_of_lite_packets_sent;

			ipx_data_to_route (port_number,(IPX_PACKET *)sptr_netware_lite_rx_packet,size_of_packet,FALSE);
			}
		}
	else
		{
		return (ILLEGAL_NETWARE_LITE_PACKET_RXED);
		}

	return (NETWARE_LITE_PACKET_RXED);
}
