#include	"defs.h"
/*	$Modname: ipxrip.c$  $version: 3.27$      $date: 10/20/95$   */
/*
* 	$lgb$
2.22 12/26/92 ross
2.23 12/26/92 ross
2.24 01/12/93 ross Added checks for too large hop counts in ipxrout and ipxnetbs and statistics, LLC proper SAPs, netbios broadcast fix soon
2.25 01/14/93 ross added wan BOOLEAN for better wan control, upcoming IPXWAN support
2.26 01/21/93 ross
2.27 01/21/93 ross changed printf to differentiate updates from periodic sends.
2.28 01/21/93 ross fixed router down problem brought to light by DD.
3.0 01/21/93 ross files ipxrip.c and ipxsap.c split into *ls.c
3.1 01/31/93 ross added support for netware lite routing
3.2 02/08/93 ross issue_router_info... packet allocation was moved inside of test for broadcasts enabled.
3.3 03/08/93 ross added pacing logic to sap,sapls,rip,ripls, and ipxtimer
3.4 03/11/93 ross working with all novell certification tests
3.5 03/15/93 ross x86 version now works in real mode -just enough memory
3.6 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.7 04/12/93 ross made variable name change in vipxstr.h
3.8 05/13/93 ross added stack parameter for tunnel software
3.9 05/15/93 ross added several new management functions and utilized them.
3.10 05/24/93 ross fixed some problems will loops going down.
3.11 05/26/93 ross fixed the loop code stuff
3.12 11/04/93 ross fixes for simultaneous rip downs and secondary sap/rip lists
3.13 11/08/93 ross fixed some secondary rip and sap problems.  Courtesy of Rick.
3.14 11/09/93 ross Fixed swap function in ipxrip.c ipxsap.c
3.15 11/29/93 ross transport time wan fix.
3.16 02/02/94 ross for 3.15 transport time, added in big-endian.  Now adds in host-endian
3.17 03/11/94 ross changed router ids to router entries.
3.18 03/14/94 ross cleaned up braces and white spaces for release.
3.19 03/19/94 ross cosmetic cleanup, extraneous header files removed.
3.20 06/10/94 ross added #ifdef for disabling certain rip broadcasts.
3.21 06/10/94 ross added ifdef around enabled_RIP_broadcasts.  Courtesy of Ken.
3.22 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.23 11/23/94 ross Added remote access. Added auto-configuration.
3.24 03/26/95 ross nlsp changes.
3.25 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.26 10/20/95 nishit Changed copyright
3.27 10/20/95 nishit Cleanup debug printfs; ready for release
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
#include	<stdlib.h>

#include	"ipx.h"
/****************************************************************************/
static enum IPX_PACKET_STATE send_general_router_response (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number);
static enum IPX_PACKET_STATE send_nearest_router_response (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number);
static enum IPX_PACKET_STATE store_general_route_information (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number);
static enum IPX_PACKET_STATE store_nearest_route_information (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number);
static GAP_TIME_ROUTE_INFORMATION *store_route_entry_in_information_packet (USHORT port_number,
	ROUTE_INFORMATION *sptr_ipx_route_rx_packet,ROUTE_LIST_ENTRY *sptr_primary_route_entry,
	GAP_TIME_ROUTE_INFORMATION *sptr_route_information,BYTE *bptr_number_of_route_entries);
/****************************************************************************/
enum IPX_PACKET_STATE issue_router_info_request (USHORT port_number)
{
	ROUTE_REQUEST *sptr_route_request;

	if (ipx_class.port[port_number].enable_RIP_broadcasts == TRUE)
		{
		sptr_route_request = (ROUTE_REQUEST *) get_a_send_packet (port_number,sizeof (ROUTE_REQUEST));

		if (sptr_route_request == NULL)
			{
			return (OUT_OF_TX_PACKET_MEMORY);
			}

		initialize_router_request_packet (port_number,sptr_route_request);

		++ipx_class.port[port_number].statistics.RIP_tx.number_of_general_queries;

/* Sanjays code */
		++ipx_class.port[port_number].statistics.RIP_tx.number_of_packets;
/* Sanjays code */
/* Sanjays code */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
		send_ipx_packet (port_number,(IPX_PACKET *) sptr_route_request,sizeof (ROUTE_REQUEST),FALSE,send_completion_ipx_packet);
		}
	else
		return (RIP_BROADCASTS_DISABLED);

	return (GENERAL_ROUTE_INFORMATION_QUERY);
}
/*************************************************************************/
enum IPX_PACKET_STATE ipx_router_packet_received (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number)
{
	enum IPX_PACKET_STATE return_code;

	++ipx_class.port[port_number].statistics.RIP_rx.number_of_packets;

	if (sptr_ipx_router_rx_packet->ipx_header.source.network == 0x00000000) /* ws does this normally upon boot up */
		{
		sptr_ipx_router_rx_packet->ipx_header.source.network = ipx_class.port[port_number].network; 
		}

	if (sptr_ipx_router_rx_packet->ipx_header.source.network != ipx_class.port[port_number].network)
		{
		++ipx_class.port[port_number].statistics.number_of_RIP_packets_with_wrong_network_address;
		++ipx_class.ripSysEntry[0].ripSysIncorrectPackets;

		ipx_management_alarm (RIP_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT,port_number);

		return (RIP_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT);
		}

	switch (sptr_ipx_router_rx_packet->operation)
		{
		case GENERAL_SERVICE_QUERY:
			++ipx_class.port[port_number].statistics.RIP_rx.number_of_general_queries;

			if (ipx_class.port[port_number].rip_compatibility == RIP_OFF)
				{
				return (GENERAL_ROUTE_REQUEST_RXED_WITH_RIP_COMPATIBILITY_OFF); /* NLSP Spec 8.5.b.ii */
				}
			else if (ipx_class.port[port_number].rip_compatibility == RIP_AUTO)
				{
				ipx_class.port[port_number].auto_rip_compatibility_activated = TRUE;

				ipx_class.port[port_number].rip_auto_deactivation_timer = router_timer;
				}
		
			if (swap (sptr_ipx_router_rx_packet->ipx_header.length) == sizeof (ROUTE_REQUEST) - sizeof (ETHERNET_HEADER) )
				{
				++ipx_class.port[port_number].statistics.RIP_tx.number_of_packets;

				return_code = send_general_router_response (sptr_ipx_router_rx_packet,port_number);
				}
			else
				{
				++ipx_class.port[port_number].statistics.rx_number_of_unknown_router_general_queries;
/* Sanjays code */
				++ipx_class.ripSysEntry[0].ripSysIncorrectPackets;
/* Sanjays code */
				return_code = UNKNOWN_GENERAL_ROUTE_QUERY_RXED;
				}

			break;
		case NEAREST_SERVICE_QUERY: 
			++ipx_class.port[port_number].statistics.RIP_rx.number_of_nearest_queries;

			if (swap (sptr_ipx_router_rx_packet->ipx_header.length) == sizeof (ROUTE_REQUEST) - sizeof (ETHERNET_HEADER))
				{
				++ipx_class.port[port_number].statistics.RIP_tx.number_of_packets;

				return_code = send_nearest_router_response (sptr_ipx_router_rx_packet,port_number);
				}
			else
				{
				++ipx_class.port[port_number].statistics.rx_number_of_unknown_router_nearest_queries;

/* Sanjays code */
				++ipx_class.ripSysEntry[0].ripSysIncorrectPackets;
/* Sanjays code */
				return_code = UNKNOWN_NEAREST_ROUTE_QUERY_RXED;
				}
			break;

		case GENERAL_SERVICE_RESPONSE:
			if (swap (sptr_ipx_router_rx_packet->ipx_header.length) <= ipx_class.port[port_number].maximum_size_of_rip_packet - sizeof (ETHERNET_HEADER))
				{
				++ipx_class.port[port_number].statistics.RIP_rx.number_of_general_responses;

				return_code = store_general_route_information (sptr_ipx_router_rx_packet,port_number);
				}
			else
				{
				++ipx_class.port[port_number].statistics.number_of_unknown_general_router_rx_responses;

/* Sanjays code */
				++ipx_class.ripSysEntry[0].ripSysIncorrectPackets;
/* Sanjays code */
				return_code = UNKNOWN_GENERAL_ROUTE_RESPONSE_RXED;
				}
			break;

		case NEAREST_SERVICE_RESPONSE:
			if (swap (sptr_ipx_router_rx_packet->ipx_header.length) <= ipx_class.port[port_number].maximum_size_of_rip_packet - sizeof (ETHERNET_HEADER)) 
				{
				++ipx_class.port[port_number].statistics.RIP_rx.number_of_nearest_responses;

				return_code = store_nearest_route_information (sptr_ipx_router_rx_packet,port_number);
				}
			else
				{
				++ipx_class.port[port_number].statistics.number_of_unknown_nearest_router_rx_responses;
/* Sanjays code */
				++ipx_class.ripSysEntry[0].ripSysIncorrectPackets;
/* Sanjays code */

				return_code = UNKNOWN_NEAREST_ROUTE_RESPONSE_RXED;
				}
			break;
		default:
			return (NON_IPX_PACKET_RIP);
		}

	return (return_code);
}
/*************************************************************************/
static enum IPX_PACKET_STATE send_general_router_response (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	BYTE	number_of_route_entries;
	GAP_TIME_ROUTE_INFORMATION *sptr_route_information;
	enum IPX_PACKET_STATE return_ipx_state;

#ifdef DISABLE_ALL_RIP_BROADCASTS
	if (ipx_class.port[port_number].enable_RIP_broadcasts == FALSE)
		{
		return (RIP_BROADCASTS_DISABLED);
		}
#endif

	sptr_route_information = (GAP_TIME_ROUTE_INFORMATION *) get_a_send_packet (port_number,
		ipx_class.port[port_number].maximum_size_of_rip_packet + sizeof (LINK));

	if (sptr_route_information	== NULL)
		{
		return (OUT_OF_TX_PACKET_MEMORY);
		}

	return_ipx_state = GENERAL_ROUTE_REQUEST_RXED_NO_KNOWN_ROUTES;

	number_of_route_entries = 0x00;

	if (sptr_ipx_router_rx_packet->route_entry_list[0].network == ALL_ROUTERS)
		{
		for (sptr_primary_route_entry = ipx_class.router_list.sptr_forward_link;
			sptr_primary_route_entry != NULL;
			sptr_primary_route_entry = sptr_primary_route_entry->links.sptr_forward_link)
			{
			sptr_route_information = store_route_entry_in_information_packet (port_number,sptr_ipx_router_rx_packet,
				sptr_primary_route_entry,sptr_route_information,&number_of_route_entries);

			if (sptr_route_information == NULL)
				{
				return (OUT_OF_TX_PACKET_MEMORY);
				}
			}
		}
	else 
		{
		for (sptr_primary_route_entry =  get_route_list_entry_using_network (sptr_ipx_router_rx_packet->route_entry_list[0].network,
			ipx_class.router_list.sptr_forward_link);
			sptr_primary_route_entry != NULL;
			sptr_primary_route_entry = get_route_list_entry_using_network (sptr_ipx_router_rx_packet->route_entry_list[0].network,
			sptr_primary_route_entry))
			{
			sptr_route_information = store_route_entry_in_information_packet (port_number,sptr_ipx_router_rx_packet,
				sptr_primary_route_entry,sptr_route_information,&number_of_route_entries);

			if (sptr_route_information == NULL)
				{
				return (OUT_OF_TX_PACKET_MEMORY);
				}

			sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link;
			}
		}

	if (number_of_route_entries > 0)
		{
		initialize_route_information_packet (port_number,(ROUTE_INFORMATION *) &sptr_route_information->ethernet_header,
			&sptr_ipx_router_rx_packet->ethernet_header.source_address,
			swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_rip_packet - sizeof (ETHERNET_HEADER) -
			((ipx_class.port[port_number].maximum_number_of_rip_entries - number_of_route_entries) * sizeof (ROUTE_ENTRY)))),
			&sptr_ipx_router_rx_packet->ipx_header.source);

		add_entry_to_list ((LINK *) &ipx_class.port[port_number].response_RIP_list,&sptr_route_information->links);

		return (GENERAL_ROUTE_REQUEST_RXED);
		}
	else
		{
		sptr_route_information = (GAP_TIME_ROUTE_INFORMATION *)
			normalize_send_packet_header (port_number,(IPX_PACKET *) sptr_route_information);

		free_a_send_packet ((IPX_PACKET *) sptr_route_information);
		}

	if (return_ipx_state == GENERAL_ROUTE_REQUEST_RXED)
		{
		return (GENERAL_ROUTE_REQUEST_RXED);
		}
	else
		{
		return (GENERAL_ROUTE_REQUEST_RXED_NO_KNOWN_ROUTES);
		}
}
/*************************************************************************/
static GAP_TIME_ROUTE_INFORMATION *store_route_entry_in_information_packet (USHORT port_number,
	ROUTE_INFORMATION *sptr_ipx_router_rx_packet,ROUTE_LIST_ENTRY *sptr_primary_route_entry,
	GAP_TIME_ROUTE_INFORMATION *sptr_route_information,BYTE *bptr_number_of_route_entries)
{
	if (is_route_the_best_information (sptr_primary_route_entry,port_number) == TRUE)
		{
		if ((ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry == NULL) ||
			((ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry != NULL) &&
			((*ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry) (sptr_primary_route_entry, FALSE) != 
			VALID_ENTRY_ON_NON_DESIGNATED_ROUTER)))
			{
			sptr_route_information->route_entry_list[*bptr_number_of_route_entries] = sptr_primary_route_entry->route_entry;
			sptr_route_information->route_entry_list[*bptr_number_of_route_entries].transport_time =
				swap ((USHORT) (swap (sptr_route_information->route_entry_list[*bptr_number_of_route_entries].transport_time) + 
					ipx_class.port[port_number].transport_time));

			*bptr_number_of_route_entries = (BYTE) (*bptr_number_of_route_entries + 1);

			if (*bptr_number_of_route_entries >= ipx_class.port[port_number].maximum_number_of_rip_entries)
				{
				initialize_route_information_packet (port_number,(ROUTE_INFORMATION *) &sptr_route_information->ethernet_header,
					&sptr_ipx_router_rx_packet->ethernet_header.source_address,
					swap ((USHORT) (ipx_class.port[port_number].maximum_size_of_rip_packet - sizeof (ETHERNET_HEADER))),
					&sptr_ipx_router_rx_packet->ipx_header.source);

				add_entry_to_list ((LINK *) &ipx_class.port[port_number].response_RIP_list,&sptr_route_information->links);

				sptr_route_information = (GAP_TIME_ROUTE_INFORMATION *) get_a_send_packet (port_number,
					ipx_class.port[port_number].maximum_size_of_rip_packet + sizeof (LINK));

				*bptr_number_of_route_entries = 0x00;
				}
			}
		}

	return (sptr_route_information);
}
/*************************************************************************/
static enum IPX_PACKET_STATE send_nearest_router_response (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	BYTE	number_of_route_entries;
	ROUTE_INFORMATION	*sptr_route_information;

#ifdef DISABLE_ALL_RIP_BROADCASTS
	if (ipx_class.port[port_number].enable_RIP_broadcasts == FALSE)
		{
		return (RIP_BROADCASTS_DISABLED);
		}
#endif

	sptr_route_information = (ROUTE_INFORMATION *) get_a_send_packet (port_number,
		ipx_class.port[port_number].maximum_size_of_rip_packet);

	if (sptr_route_information == NULL)
		{
		return (OUT_OF_TX_PACKET_MEMORY);
		}

	sptr_route_information->ethernet_header.destination_address = sptr_ipx_router_rx_packet->ethernet_header.source_address;

	sptr_route_information->ipx_header.destination = sptr_ipx_router_rx_packet->ipx_header.source;
	sptr_route_information->ipx_header.destination.network = ipx_class.port[port_number].network;

	sptr_route_information->operation = (enum ROUTE_PACKET_TYPE) NEAREST_SERVICE_RESPONSE; 

	number_of_route_entries = 0x00;

	for (sptr_primary_route_entry =  ipx_class.router_list.sptr_forward_link; sptr_primary_route_entry != NULL;
		sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link)
		{
		if (sptr_primary_route_entry->route_entry.network == sptr_ipx_router_rx_packet->route_entry_list[0].network)
			{
			if (is_route_the_best_information (sptr_primary_route_entry,port_number) == TRUE)
				{
				if (swap (sptr_primary_route_entry->route_entry.transport_time) <
					swap (sptr_route_information->route_entry_list[0].transport_time))
					{
					sptr_route_information->route_entry_list[0] = sptr_primary_route_entry->route_entry;

					number_of_route_entries = (BYTE) (number_of_route_entries + 1);
					}
				}
			}
		}

	if (number_of_route_entries > 0)
		{
		initialize_route_information_packet (port_number,sptr_route_information,
			&sptr_ipx_router_rx_packet->ethernet_header.source_address,swap (sizeof (ROUTE_REQUEST) - sizeof (ETHERNET_HEADER)),
			&sptr_ipx_router_rx_packet->ipx_header.source);

		++ipx_class.port[port_number].statistics.RIP_tx.number_of_nearest_responses;

/* Sanjays code */
		++ipx_class.ipxBasicSysEntry[0].ipxBasicSysOutRequests;
/* Sanjays code */
		send_ipx_packet (port_number,(IPX_PACKET *) sptr_route_information,(USHORT) (sizeof (ETHERNET_HEADER) +
			swap (sptr_route_information->ipx_header.length)),FALSE,send_completion_ipx_packet);

		return (NEAREST_ROUTE_REQUEST_RXED);
		}
	else
		{
		sptr_route_information = (ROUTE_INFORMATION *)
			normalize_send_packet_header (port_number,(IPX_PACKET *) sptr_route_information);

		free_a_send_packet ((IPX_PACKET *) sptr_route_information);

		return (NEAREST_ROUTE_REQUEST_RXED_NO_KNOWN_ROUTES);
		}
}
/*************************************************************************/
static enum IPX_PACKET_STATE store_general_route_information (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number)
{
	ROUTE_ENTRY *sptr_route_entry;
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	ROUTE_LIST_ENTRY *sptr_route_list_entry;
	USHORT	current_route_entry_number;
	USHORT	number_of_route_entries;
	USHORT port_number_of_primary_route;
	enum BOOLEAN new_primary_route_added;
	enum LIST_ENTRY_TYPE route_list_return_type;
	enum NLSP_VALID_ENTRY_RETURN_TYPE route_validity_return_type;

	if (ipx_class.port[port_number].rip_compatibility == RIP_OFF)
		{
		return (GENERAL_RIP_RXED_WITH_RIP_COMPATIBILITY_OFF); /* NLSP Spec 8.5.c.i */
		}
		
	new_primary_route_added = FALSE;

	number_of_route_entries = (USHORT) ((swap (sptr_ipx_router_rx_packet->ipx_header.length) - sizeof (IPX_HEADER) -
		sizeof (USHORT)) / sizeof (ROUTE_ENTRY));

	for (sptr_route_entry = &sptr_ipx_router_rx_packet->route_entry_list[0],current_route_entry_number = 0x0000;
		current_route_entry_number < number_of_route_entries ; ++current_route_entry_number,++sptr_route_entry)
		{
		if (ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry != NULL)
			{
			if ((sptr_route_list_entry = (ROUTE_LIST_ENTRY *) table_malloc (sizeof (ROUTE_LIST_ENTRY),1)) != NULL)
				{
				sptr_route_list_entry->route_entry = *sptr_route_entry;
				sptr_route_list_entry->router_address = sptr_ipx_router_rx_packet->ethernet_header.source_address;
				sptr_route_list_entry->port_number = port_number;
				sptr_route_list_entry->type = RIP_IPX_ROUTE;
 
				route_validity_return_type = (*ipx_class.nlsp.fptr_nlsp_check_for_valid_route_entry) (sptr_route_list_entry, TRUE);

				if (route_validity_return_type == FROM_NLSP_ROUTER)
					{
					table_free (sptr_route_list_entry);

					return (GENERL_RIP_RXED_FROM_NLSP_ROUTER) ; /* NLSP Spec 8.5.a */
					}
				else
					{
					if (ipx_class.port[port_number].rip_compatibility == RIP_AUTO) /* NLSP Spec 8.5.c.iii */
						{
						ipx_class.port[port_number].auto_rip_compatibility_activated = TRUE;

						ipx_class.port[port_number].rip_auto_deactivation_timer = router_timer;
						}

					if (ipx_class.port[port_number].sap_compatibility == SAP_AUTO) /* NLSP Spec 8.5.c.iii */
						{
						ipx_class.port[port_number].auto_sap_compatibility_activated = TRUE;
						}

					if ((route_validity_return_type == NLSP_ROUTE_EXISTS_TO_THIS_NETWORK) || /* NLSP Spec 8.5.c.iv */
						(route_validity_return_type == VALID_ENTRY_ON_NON_DESIGNATED_ROUTER))
						{
						table_free (sptr_route_list_entry);

						continue;
						}
					}

				table_free (sptr_route_list_entry);
				}
			}
			
		if (sptr_route_entry->hops < SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			sptr_route_entry->hops = swap ((USHORT) (swap (sptr_route_entry->hops) + 1));

			if (sptr_route_entry->hops == SERVER_OR_ROUTER_DOWN_HOP_COUNT)
				{
				continue;
				}
			}

		if (sptr_route_entry->hops > SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			continue; /* added for ipx test */
			}

		if (sptr_route_entry->network == 0x00000000) /* SPECIAL case (I'm not sure this ever happens) */
			{
			++ipx_class.port[port_number].statistics.number_of_RIP_packets_with_no_network_address_rxed;
			sptr_route_entry->network = ipx_class.port[port_number].network;
			}

		route_list_return_type = MATCHING_ENTRY_NOT_FOUND;

		for (sptr_primary_route_entry = get_route_list_entry_using_network (sptr_route_entry->network,
			ipx_class.router_list.sptr_forward_link) ; sptr_primary_route_entry != NULL;
			sptr_primary_route_entry = get_route_list_entry_using_network (sptr_route_entry->network,sptr_primary_route_entry))
			{
			port_number_of_primary_route = sptr_primary_route_entry->port_number;

			route_list_return_type = check_if_in_primary_route_list (sptr_primary_route_entry,sptr_route_entry,
				&sptr_ipx_router_rx_packet->ethernet_header.source_address,port_number,RIP_IPX_ROUTE,NULL);

			if (route_list_return_type != MATCHING_ENTRY_NOT_FOUND)
				{
				break;
				}

			sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link;
			}

		if (route_list_return_type == MATCHING_ENTRY_FOUND_UPDATE)
			{
			if (port_number_of_primary_route != sptr_primary_route_entry->port_number)
				{
				if (ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps != NULL)
					{
					(*ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps) (port_number_of_primary_route);
					}
				}

			new_primary_route_added = TRUE;
			}

		if (sptr_primary_route_entry == NULL)
			{
			if (sptr_route_entry->hops >= SERVER_OR_ROUTER_DOWN_HOP_COUNT)
				{
				continue;
				}

			if (add_route_entry (port_number,sptr_route_entry,&sptr_ipx_router_rx_packet->ethernet_header.source_address,
				TRUE,FALSE,RIP_IPX_ROUTE,NULL) == PASS)
				{
				new_primary_route_added = TRUE;
				}
			}
		}

	if (new_primary_route_added == TRUE)
		{
		update_routes_for_all_ports ();

		if (ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps != NULL)
			{
			(*ipx_class.nlsp.fptr_nlsp_send_pseudonode_lsps) (port_number);
			}
			
		return (GENERAL_RIP_RXED_UPATE);
		}
	else
		{
		return (GENERAL_RIP_RXED);
		}
}
/*************************************************************************/
static enum IPX_PACKET_STATE store_nearest_route_information (ROUTE_INFORMATION *sptr_ipx_router_rx_packet,USHORT port_number)
{
	ROUTE_LIST_ENTRY *sptr_primary_route_entry;
	enum BOOLEAN new_primary_route_added;

	new_primary_route_added = FALSE;

	for (sptr_primary_route_entry =  ipx_class.router_list.sptr_forward_link;
		sptr_primary_route_entry != NULL;
		sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link)
		{
		if (sptr_ipx_router_rx_packet->route_entry_list[0].hops < SERVER_OR_ROUTER_DOWN_HOP_COUNT)
			{
			sptr_ipx_router_rx_packet->route_entry_list[0].hops =
				swap ((USHORT) (swap (sptr_ipx_router_rx_packet->route_entry_list[0].hops) + 1));
			}

		if (sptr_ipx_router_rx_packet->route_entry_list[0].network == 0x00000000) /* SPECIAL case (I'm not sure this ever happens) */
			{
			sptr_ipx_router_rx_packet->route_entry_list[0].network = ipx_class.port[port_number].network;
			}

		if (sptr_primary_route_entry->route_entry.network != ipx_class.port[port_number].network) 
			{
			if (check_if_in_primary_route_list (sptr_primary_route_entry,
				&sptr_ipx_router_rx_packet->route_entry_list[0],&sptr_ipx_router_rx_packet->ethernet_header.source_address,
				port_number,RIP_IPX_ROUTE,NULL) != MATCHING_ENTRY_NOT_FOUND)
				break;
			}
		}

	if (sptr_primary_route_entry == NULL)
		{
		add_route_entry (port_number,&sptr_ipx_router_rx_packet->route_entry_list[0],
			&sptr_ipx_router_rx_packet->ethernet_header.source_address,TRUE,FALSE,RIP_IPX_ROUTE,NULL);
		}

	if (new_primary_route_added == TRUE)
		{
		update_routes_for_all_ports ();

		return (NEAREST_RIP_RXED_UPATE);
		}
	else
		{
		return (NEAREST_RIP_RXED);
		}
}
