#include	"defs.h"
/*	$Modname: ipxsnmp.c$  $version: 3.27$      $date: 10/25/95$   */
/*
* 	$lgb$
1.0 12/05/92 ross
1.1 12/06/92 ross implemented ipx class structure - no algorithm changes
1.2 12/06/92 ross
1.3 12/06/92 ross adding functions to ipxsnmp.c, added static protos for ipx.c and ipxsap.c
3.0 12/26/92 ross
3.1 01/31/93 ross added support for netware lite routing
3.2 03/15/93 ross x86 version now works in real mode -just enough memory
3.3 03/22/93 ross changed name of IPX_MANAGEMENT_PARAMETERS to IPX_PORT_CLASS
3.4 03/30/93 ross added netbios name caching.
3.5 04/12/93 ross made variable name change in vipxstr.h
3.6 05/13/93 ross added stack parameter for tunnel software
3.7 05/15/93 ross moved ipxwan display function out, made some static functions public.
3.8 05/21/93 ross made some more tunnel changes, corrected some printf bugs
3.9 05/24/93 ross fixed some problems will loops going down.
3.10 10/09/93 ross Added changes for ipxwan
3.11 10/28/93 ross added fix for borland compiler . needed a blank line in switch.
3.12 11/04/93 ross fixes for simultaneous rip downs and secondary sap/rip lists
3.13 02/02/94 ross changes for dlsx.
3.14 03/14/94 ross cleaned up braces and white spaces for release.
3.15 03/19/94 ross cosmetic cleanup, extraneous header files removed.
3.16 03/26/94 ross put IPX: in front of the rip, sap printfs.
3.17 05/20/94 ross added better support for disabled port, and added add rip/sap function pointers.  Courtest of Fred and Don.
3.18 05/20/94 ross changed DLSX to DLSW.
3.19 06/08/94 ross first version support for ipx and rip sap mibs. Ugh.
3.20 08/25/94 ross cleaned up DEBUG conditional.  Courtesy of Lori.
3.21 09/15/94 ross put in an x in the print statement.  Courtesy of Craig.
3.22 11/21/94 ross changed to compile under C++, added big sap and rip support.
3.23 03/26/95 ross nlsp changes.
3.24 09/25/95 ross added changes for dynamic loading
3.25 10/20/95 ross changes for NLSP RIP-SAP compatibility
3.26 10/20/95 nishit Changed copyright
3.27 10/25/95 nishit Modified display routines
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1989 - 1995 RouterWare, Inc.								   */
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Suite 212 Newport Beach, CA  92660  */
/************************************************************************/
/*******************IPX.C Source ****************************************/
/************************************************************************/
#include	<string.h>
#include	"ipx.h"
/****************************************************************************/
#if !defined (_MSC_VER)
	extern ULONG timer_ulong;
#endif

void display_route_list (void);
void display_route_list_entry (ROUTE_LIST_ENTRY *sptr_route_entry);
void display_SAP_list (void);
void display_SAP_entry (SAP_LIST_ENTRY *sptr_SAP_entry);
void display_SAP_ID (SAP_ID *sptr_SAP_entry);
void display_mac_address (char const *cptr_address_type, MAC_ADDRESS *sptr_mac_address);
void display_links (char const *cptr_link_type, LINK *sptr_link);
void display_port_number (USHORT port_number);
void display_timer_value (ULONG timer_value);
#ifdef DEBUG
static void display_echo_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive);
static void display_router_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive);
static void display_SAP_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive);
static void display_netbios_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive);
static void display_ipx_data_to_route_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive);
#endif
/****************************************************************************/
void ipx_management_alarm (enum IPX_PACKET_STATE alarm,USHORT port_number)
{
	switch (alarm)
		{
		case OUT_OF_ROUTE_LIST_ENTRIES:
			ipx_printf (ALARM_PRINTF,"IPX: Route Table is full or no malloc memory available %04x\r\n",port_number);
			break;
		case OUT_OF_SAP_LIST_ENTRIES:
			ipx_printf (ALARM_PRINTF,"IPX: SAP Table is full or no malloc memory available %04x\r\n",port_number);
			break;
		case RIP_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT:
			ipx_printf (ALARM_PRINTF,"IPX: RIP packet received with incorrect routing information %04x\r\n",port_number);
			break;
		case SAP_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT:
			ipx_printf (ALARM_PRINTF,"IPX: SAP packet received with incorrect routing information %04x\r\n",port_number);
			break;
		case WS_PACKET_RXED_WITH_WRONG_NETWORK_ADDRESS_FOR_PORT:
			ipx_printf (ALARM_PRINTF,"IPX: WS packet received with incorrect routing information %04x\r\n",port_number);
			break;
		case TRYING_TO_ADD_DUPLICATE_ROUTE:
			ipx_printf (ALARM_PRINTF,"IPX: Trying to add duplicate route %04x\r\n",port_number);
			break;
		default:
			break;
		}

	if (ipx_class.fptr_snmp_trap_function != NULL)
		{
		(*ipx_class.fptr_snmp_trap_function) (port_number,(ULONG) NULL,(ULONG) NULL);
		}
}
/****************************************************************************/
void set_trap_function (void (*fptr_snmp_trap_function) (USHORT port_number,void *vptr_packet,USHORT length))
{
	ipx_class.fptr_snmp_trap_function = fptr_snmp_trap_function;
}
/****************************************************************************/
void *get_route_list (void)
{
	return ((void *)&ipx_class.router_list);
}
/****************************************************************************/
void *get_sap_list (void)
{
	return ((void *)&ipx_class.SAP_list);
}
/****************************************************************************/
void set_ipx_class_to_zero (void)
{
	memset (&ipx_class,(int) NULL,sizeof (IPX_CLASS));
}
/****************************************************************************/
void *get_ipx_port_class (USHORT port_number)
{
	return ((void *)&ipx_class.port[port_number]);
}
/****************************************************************************/
void *get_ipx_port_statistics (USHORT port_number)
{
	return ((void *)&ipx_class.port[port_number].statistics);
}
/****************************************************************************/
void display_route_list (void)
{
	ROUTE_LIST_ENTRY	*sptr_primary_route_entry;
	ROUTE_LIST_ENTRY *sptr_secondary_route_entry;

	for (sptr_primary_route_entry =  ipx_class.router_list.sptr_forward_link;
		sptr_primary_route_entry != NULL;
		sptr_primary_route_entry =  sptr_primary_route_entry->links.sptr_forward_link)
		{
		display_route_list_entry (sptr_primary_route_entry);

		for (sptr_secondary_route_entry =  sptr_primary_route_entry->network_links.sptr_forward_link;
			sptr_secondary_route_entry != NULL;
			sptr_secondary_route_entry =  sptr_secondary_route_entry->links.sptr_forward_link)
			{
			display_route_list_entry (sptr_secondary_route_entry);
			}
		}
}
/****************************************************************************/
void display_route_list_entry (ROUTE_LIST_ENTRY *sptr_route_entry)
{
	display_links ("List",(LINK *) &sptr_route_entry->links);
	display_links ("Network",(LINK *) &sptr_route_entry->network_links);

	display_route_entry (&sptr_route_entry->route_entry);

	display_mac_address ("Router",(MAC_ADDRESS *) &sptr_route_entry->router_address);

	display_port_number (sptr_route_entry->port_number);

	display_timer_value (sptr_route_entry->timer_value);

	ipx_printf (SNMP_PRINTF,"IPX: Do Not Age %01x,New Primary Route %01x \r\n",sptr_route_entry->do_not_age,
		sptr_route_entry->new_primary_route);
}
/****************************************************************************/
void display_SAP_list (void)
{
	SAP_LIST_ENTRY	*sptr_primary_SAP_entry;
	SAP_LIST_ENTRY *sptr_secondary_SAP_entry;

	for (sptr_primary_SAP_entry = ipx_class.SAP_list.sptr_forward_link;
		sptr_primary_SAP_entry != NULL;
		sptr_primary_SAP_entry = sptr_primary_SAP_entry->links.sptr_forward_link)
		{
		display_SAP_entry (sptr_primary_SAP_entry);

		for (sptr_secondary_SAP_entry = sptr_primary_SAP_entry->SAP_links.sptr_forward_link;
			sptr_secondary_SAP_entry != NULL;
			sptr_secondary_SAP_entry = sptr_secondary_SAP_entry->links.sptr_forward_link)
			{
			display_SAP_entry (sptr_secondary_SAP_entry);
			}
		}
}
/****************************************************************************/
void display_SAP_entry (SAP_LIST_ENTRY *sptr_SAP_entry)
{
	display_links ("List\r\n",(LINK *) &sptr_SAP_entry->links);
	display_links ("SAP type\r\n",(LINK *) &sptr_SAP_entry->SAP_links);

	display_SAP_ID (&sptr_SAP_entry->SAP_ID);

	display_port_number (sptr_SAP_entry->port_number);

	display_timer_value (sptr_SAP_entry->timer_value);

	display_mac_address ("IPX: SAP\r\n",(MAC_ADDRESS *) &sptr_SAP_entry->router_address);

	ipx_printf (SNMP_PRINTF,"IPX: Do Not Age %01x \r\n",sptr_SAP_entry->do_not_age);
	ipx_printf (SNMP_PRINTF,"IPX: New Primary SAP %01x \r\n",sptr_SAP_entry->new_primary_SAP);
}
/****************************************************************************/
void display_route_entry (ROUTE_ENTRY *sptr_route_entry)
{
	ipx_printf (RIP_PRINTF,"     Net %08lx   Hops %04x   Ticks %04x ",swap_long (sptr_route_entry->network),
		swap(sptr_route_entry->hops),swap (sptr_route_entry->transport_time));
}
/****************************************************************************/
void display_SAP_ID (SAP_ID *sptr_SAP_ID)
{
	ipx_printf (SAP_PRINTF,"     Service: %s   Type %04x   Hops %04x",&sptr_SAP_ID->SAP_name[0],swap (sptr_SAP_ID->SAP_type),
		swap (sptr_SAP_ID->intervening_networks));

	display_ipx_address (&sptr_SAP_ID->ipx_address);
}
/****************************************************************************/
void display_ipx_address (IPX_ADDRESS *sptr_ipx_address)
{
	ipx_printf (SNMP_PRINTF,"     Net %08lx   Node %08lx%04x   Socket %04x",swap_long (sptr_ipx_address->network),
		swap_long (sptr_ipx_address->node_address._ulong),swap (sptr_ipx_address->node_address._ushort),
		swap (sptr_ipx_address->socket));
}
/****************************************************************************/
void display_mac_address (char const *cptr_address_type,MAC_ADDRESS *sptr_mac_address)
{
	ipx_printf (SNMP_PRINTF,"%s Address %08lx%04x\r\n",
		cptr_address_type,swap_long (sptr_mac_address->_ulong),swap (sptr_mac_address->_ushort));
}
/****************************************************************************/
void display_links (char const *cptr_link_type,LINK *sptr_link)
{
	ipx_printf (SNMP_PRINTF,"%s forward %08lx and backward link %08lx\r\n",
		cptr_link_type,sptr_link->sptr_forward_link,sptr_link->sptr_backward_link);
}
/****************************************************************************/
void display_port_number (USHORT port_number)
{
	ipx_printf (SNMP_PRINTF,"IPX: Port Number %04x\r\n",port_number);
}
/****************************************************************************/
void display_timer_value (ULONG timer_value)
{
	ipx_printf (SNMP_PRINTF,"IPX: Timer Value %04x\r\n",timer_value);
}
#ifdef DEBUG
/****************************************************************************/
void display_ipx_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive)
{
	switch (((ROUTE_INFORMATION *)sptr_ipx_packet)->ipx_header.packet_type)
		{
		case ECHO_PACKET_TYPE:
			display_echo_packet (port_number,sptr_ipx_packet,number_of_bytes,receive);
			break;

		case UNKNOWN_PACKET_TYPE:
		case ROUTER_PACKET_TYPE:
		case NETWARE_CORE_PROTOCOL_TYPE:
		case PACKET_EXCHANGE_PACKET:
		case SEQUENCED_PACKET_PROTOCOL:
			if (((ROUTE_INFORMATION *)sptr_ipx_packet)->ipx_header.destination.socket == ROUTING_SOCKET)
				{
				if (ipx_class.RIP_printing_enabled == TRUE)
					display_router_packet (port_number,sptr_ipx_packet,number_of_bytes,receive);
				}
			else if (((ROUTE_INFORMATION *)sptr_ipx_packet)->ipx_header.destination.socket == SAP_SOCKET)
				{
				if (ipx_class.SAP_printing_enabled == TRUE)
					display_SAP_packet (port_number,sptr_ipx_packet,number_of_bytes,receive);
				}
#ifdef IPX_WAN_ENABLED
			else if (((ROUTE_INFORMATION *)sptr_ipx_packet)->ipx_header.destination.socket == IPX_WAN_SOCKET)
				{
				display_wan_packet (port_number,sptr_ipx_packet,number_of_bytes,receive);
				}
#endif
			else
				{
				if (((ROUTE_INFORMATION *)sptr_ipx_packet)->ipx_header.destination.socket == NETBIOS_SOCKET ||
					((ROUTE_INFORMATION *)sptr_ipx_packet)->ipx_header.source.socket == NETBIOS_SOCKET)
					{
					if (ipx_class.netbios_printing_enabled == TRUE)
						display_netbios_packet (port_number,sptr_ipx_packet,number_of_bytes,receive);
					}
				else
					{
					if (ipx_class.data_printing_enabled == TRUE)
						display_ipx_data_to_route_packet (port_number,sptr_ipx_packet,number_of_bytes,receive);
					}
				}

			break;

		case NETBIOS_NAME_PACKET:
			if (ipx_class.netbios_printing_enabled == TRUE)
				display_netbios_packet (port_number,sptr_ipx_packet,number_of_bytes,receive);
			break;

		default:
			if (ipx_class.data_printing_enabled == TRUE)
				display_ipx_data_to_route_packet (port_number,sptr_ipx_packet,number_of_bytes,receive);
			break;
		}
}
#endif
#ifdef DEBUG
/****************************************************************************/
static void display_echo_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive)
{
	PARAMETER_NOT_USED (number_of_bytes);

	if (receive)
		{
		ipx_printf (ECHO_PRINTF,"IPX: Echo Rx on Port %04x Network %08lx at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),timer_ulong);
		}	
	else
		{
		ipx_printf (ECHO_PRINTF,"IPX: Echo Tx on Port %04x Network %08lx at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),timer_ulong);
		}

	ipx_printf (ECHO_PRINTF,"Echo ");

	display_ipx_address (&sptr_ipx_packet->ipx_header.destination);
	display_ipx_address (&sptr_ipx_packet->ipx_header.source);

	ipx_printf (ECHO_PRINTF,"\r\n");
}
/****************************************************************************/
static void display_router_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive)
{
	USHORT	number_of_route_entries;
	ROUTE_ENTRY *sptr_route_entry;
	USHORT	current_route_entry_number;
	ROUTE_INFORMATION *sptr_route_information;

	PARAMETER_NOT_USED (number_of_bytes);

	if (receive)
		{
		ipx_printf (RIP_PRINTF,"IPX: RIP Rx on Port %04x from %08lx.%08lx%04x at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),swap_long (sptr_ipx_packet->ipx_header.source.node_address._ulong),
			swap (sptr_ipx_packet->ipx_header.source.node_address._ushort),timer_ulong);

/*		display_ipx_address (&sptr_ipx_packet->ipx_header.source); */
		}
	else
		{
		ipx_printf (RIP_PRINTF,"IPX: RIP Tx on Port %04x Network %08lx at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),timer_ulong);
		}

	sptr_route_information = (ROUTE_INFORMATION *) sptr_ipx_packet;

	number_of_route_entries = (USHORT) ((swap (sptr_route_information->ipx_header.length) - sizeof (IPX_HEADER) -
		sizeof (USHORT)) / sizeof (ROUTE_ENTRY));

	for (sptr_route_entry = &sptr_route_information->route_entry_list[0],current_route_entry_number = 0x0000;
		current_route_entry_number < number_of_route_entries ; ++current_route_entry_number,++sptr_route_entry)
		{
		display_route_entry (sptr_route_entry);
		}

	ipx_printf (RIP_PRINTF,"\r\n");
}
/****************************************************************************/
static void display_SAP_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive)
{
	USHORT	number_of_SAP_IDs;
	SAP_ID 	*sptr_SAP_ID;
	SAP_RECEIVE_PACKET *sptr_ipx_SAP_rx_packet;
	BYTE current_SAP_ID_number;

	PARAMETER_NOT_USED (number_of_bytes);

	if (receive)
		{
		ipx_printf (SAP_PRINTF,"IPX: SAP Rx on Port %04x Network %08lx at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),timer_ulong);
		}
	else
		{
		ipx_printf (SAP_PRINTF,"IPX: SAP Tx on Port %04x Network %08lx at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),timer_ulong);
		}

	sptr_ipx_SAP_rx_packet = (SAP_RECEIVE_PACKET *) sptr_ipx_packet;

	sptr_SAP_ID = &sptr_ipx_SAP_rx_packet->rx_SAP.ID_packet.SAP_ID[0];

	number_of_SAP_IDs = (USHORT) ((swap (sptr_ipx_SAP_rx_packet->ipx_header.length) - sizeof (IPX_HEADER) - sizeof (USHORT)) /
		sizeof (SAP_ID));

	if (sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.query_type == GENERAL_SERVICE_QUERY)
		{
		ipx_printf (SAP_PRINTF,"IPX: General Service Query %04x\r\n",sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.SAP_type);
		
		return;
		}
	else if (sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.query_type == NEAREST_SERVICE_QUERY)
		{
		ipx_printf (SAP_PRINTF,"IPX: Nearest Service Query %04x\r\n",sptr_ipx_SAP_rx_packet->rx_SAP.query_packet.SAP_type);

		return;
		}

	for (current_SAP_ID_number = 0x00; current_SAP_ID_number < number_of_SAP_IDs ;
		current_SAP_ID_number = (BYTE) (current_SAP_ID_number + 1),++sptr_SAP_ID)
		{
		display_SAP_ID (sptr_SAP_ID);

		ipx_printf (SAP_PRINTF,"\r\n");

/*		if (current_SAP_ID_number + 1 < number_of_SAP_IDs )
			{
			ipx_printf (SAP_PRINTF,"                      ");
			} */
		}
}
/****************************************************************************/
static void display_netbios_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,enum BOOLEAN receive)
{
	PARAMETER_NOT_USED (number_of_bytes);

	if (receive)
		{
		ipx_printf (NETBIOS_PRINTF,"IPX: NetBIOS Rx on Port %04x Network %08lx at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),timer_ulong);
		}
	else
		{
		ipx_printf (NETBIOS_PRINTF,"IPX: NetBIOS Tx on Port %04x Network %08lx at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),timer_ulong);
		}

	ipx_printf (NETBIOS_PRINTF,"Netbios ");

	display_ipx_address (&sptr_ipx_packet->ipx_header.destination);
	display_ipx_address (&sptr_ipx_packet->ipx_header.source);

	ipx_printf (NETBIOS_PRINTF,"\r\n");
}
/****************************************************************************/
static void display_ipx_data_to_route_packet (USHORT port_number,IPX_PACKET *sptr_ipx_packet,USHORT number_of_bytes,
	enum BOOLEAN receive)
{
	PARAMETER_NOT_USED (number_of_bytes);

	if (receive)
		{
		ipx_printf (DATA_PRINTF,"IPX: Data Rx on Port %04x Network %08lx at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),timer_ulong);
		}
	else
		{
		ipx_printf (DATA_PRINTF,"IPX: Data Tx on Port %04x Network %08lx at time %08lx: ",port_number,
			swap_long (ipx_class.port[port_number].network),timer_ulong);
		}

	ipx_printf (DATA_PRINTF,"Data ");

	display_ipx_address (&sptr_ipx_packet->ipx_header.destination);
	display_ipx_address (&sptr_ipx_packet->ipx_header.source);

	ipx_printf (DATA_PRINTF,"\r\n");
}
#endif
/****************************************************************************/
USHORT get_number_of_ipx_ports (void)
{
	return (ipx_class.number_of_ports);
}
/****************************************************************************/
ULONG get_ipx_network_for_port (USHORT port_number)
{
	return (ipx_class.port[port_number].network);
}
/****************************************************************************/
void get_ipx_mac_address_for_port (USHORT port_number,ETHERNET_ADDRESS *sptr_mac_address)
{
	*sptr_mac_address = ipx_class.port[port_number].ethernet_address;
}
