#include	"defs.h"
/*	$Modname: ipxspxw.c$  $version: 1.2$      $date: 10/20/95$   */
/*
* 	$lgb$
1.0 01/26/95 ross
1.1 01/26/95 ross added copyright.
1.2 10/20/95 nishit Changed copyright
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 - 1995 RouterWare, Inc.									*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
/* Portions used from RouterWare SPX source code available separately!!!*/
/************************************************************************/
#include	<string.h>
#include	<stdlib.h>
#include	"ipx.h"
/****************************************************************************/
static SPX_CONNECTION_ENTRY *get_spx_connection_entry (USHORT rx_port_number,USHORT tx_port_number,SPX_PACKET *sptr_spx_packet,
	enum BOOLEAN *eptr_new_entry);
static void free_spx_connection_entry (SPX_CONNECTION_LINKS *sptr_spx_connection_list,SPX_CONNECTION_ENTRY *sptr_spx_connection);
static enum BOOLEAN store_sequence_numbers (USHORT rx_port_number,SPX_HEADER *sptr_spx_header,
	SPX_CONNECTION_ENTRY *sptr_spx_connection,BYTE hop_count);
static SPX_CONNECTION_ENTRY *find_spx_connection_entry (USHORT rx_port_number,USHORT tx_port_number,SPX_PACKET *sptr_spx_packet);
static enum BOOLEAN are_ids_equal (USHORT source_id,USHORT destination_id,SPX_CONNECTION_ENTRY *sptr_spx_connection);
static enum BOOLEAN are_port_numbers_equal (USHORT rx_port_number,USHORT tx_port_number,SPX_CONNECTION_ENTRY *sptr_spx_connection);
static enum IPX_PACKET_STATE send_spx_watchdog_reply (SPX_PACKET *sptr_spx_rx_packet,USHORT size_of_packet,
	SPX_CONNECTION_ENTRY *sptr_spx_connection);
static enum BOOLEAN are_ipx_addresses_equal (IPX_HEADER *sptr_ipx_header,SPX_CONNECTION_ENTRY *sptr_spx_connection);
/****************************************************************************/
enum IPX_PACKET_STATE spx_packet_received (USHORT rx_port_number,USHORT tx_port_number,SPX_PACKET *sptr_spx_rx_packet,
	USHORT size_of_packet)
{
	SPX_CONNECTION_ENTRY *sptr_spx_connection;
	enum IPX_PACKET_STATE return_code;
	enum BOOLEAN sequence_numbers_same_as_previous;
	enum BOOLEAN new_entry;

	if (sptr_spx_rx_packet->spx_header.datastream_type == END_OF_CONNECTION)
		{
		sptr_spx_connection = get_spx_connection_entry (rx_port_number,tx_port_number,sptr_spx_rx_packet,&new_entry);

		if (sptr_spx_connection != NULL)
			{
			free_spx_connection_entry (&ipx_class.port[sptr_spx_connection->source.port_number].spx_connection_list,
				sptr_spx_connection);
			}
		}

	if (sptr_spx_rx_packet->spx_header.datastream_type == 0x00)
		{
		sptr_spx_connection = get_spx_connection_entry (rx_port_number,tx_port_number,sptr_spx_rx_packet,&new_entry);

		if (sptr_spx_connection != NULL)
			{
			sequence_numbers_same_as_previous = store_sequence_numbers (rx_port_number,&sptr_spx_rx_packet->spx_header,
				sptr_spx_connection,sptr_spx_rx_packet->ipx_header.transport_control_hop_count);

			if (sptr_spx_rx_packet->spx_header.connection_control._bit.system_packet == TRUE)
				{
				if ((new_entry == FALSE) && (sequence_numbers_same_as_previous == TRUE) &&
					(ipx_class.port[rx_port_number].wan_port == FALSE)) 
					{
					/* this is a watchdog request, so spoof the reply */

					send_spx_watchdog_reply (sptr_spx_rx_packet,size_of_packet,sptr_spx_connection);

					return (DATA_PACKET_WAS_RXED_AND_WAS_FORWARDED);
					}
				}
			}
		}

	return_code = send_ipx_packet (tx_port_number,(IPX_PACKET *) sptr_spx_rx_packet,size_of_packet,TRUE,NULL);

	return (return_code);
}
/****************************************************************************/
static SPX_CONNECTION_ENTRY *get_spx_connection_entry (USHORT rx_port_number,USHORT tx_port_number,SPX_PACKET *sptr_spx_packet,
	enum BOOLEAN *eptr_new_entry)
{
	SPX_CONNECTION_ENTRY *sptr_spx_connection;

	sptr_spx_connection = find_spx_connection_entry (rx_port_number,tx_port_number,sptr_spx_packet);

	if (sptr_spx_connection == NULL)
		{
		if (sptr_spx_packet->spx_header.connection_control._bit.ack_required == FALSE)
			{
			sptr_spx_connection = table_malloc (1,sizeof (SPX_CONNECTION_ENTRY));

			*eptr_new_entry = FALSE;

			if (sptr_spx_connection != NULL)
				{
				sptr_spx_connection->source.port_number = rx_port_number;
				sptr_spx_connection->source.connection_id = sptr_spx_packet->spx_header.source_connection_id;
				sptr_spx_connection->source.sequence_number = sptr_spx_packet->spx_header.sequence_number;
				sptr_spx_connection->source.ack_number = sptr_spx_packet->spx_header.ack_number;
				sptr_spx_connection->source.allocation_number = sptr_spx_packet->spx_header.allocation_number;
				sptr_spx_connection->source.number_of_packets_rxed = 0x00000000L;
				sptr_spx_connection->source.ipx_address = sptr_spx_packet->ipx_header.source;
				sptr_spx_connection->source.hop_count = 0x00;

				sptr_spx_connection->destination.connection_id = sptr_spx_packet->spx_header.destination_connection_id;
				sptr_spx_connection->destination.ipx_address = sptr_spx_packet->ipx_header.destination;

				sptr_spx_connection->current_session_time = 0x00000000L;

				add_entry_to_list ((LINK *) &ipx_class.port[rx_port_number].spx_connection_list,
					(LINK *) &sptr_spx_connection->links.sptr_forward_link);

				*eptr_new_entry = TRUE;
				}
			}
		}

	return (sptr_spx_connection);
}
/****************************************************************************/
static SPX_CONNECTION_ENTRY *find_spx_connection_entry (USHORT rx_port_number,USHORT tx_port_number,SPX_PACKET *sptr_spx_packet)
{
	SPX_CONNECTION_ENTRY *sptr_spx_connection;

	for (sptr_spx_connection = (SPX_CONNECTION_ENTRY *)
		get_pointer_to_first_entry_in_list ((LINK *) &ipx_class.port[rx_port_number].spx_connection_list);
		sptr_spx_connection != NULL;
		sptr_spx_connection = get_pointer_to_next_entry_in_list ((LINK *) &sptr_spx_connection->links))
		{
		if (are_ids_equal (sptr_spx_packet->spx_header.source_connection_id,
			sptr_spx_packet->spx_header.destination_connection_id,sptr_spx_connection) ==	TRUE)
			{
			if (are_port_numbers_equal (rx_port_number,tx_port_number,sptr_spx_connection) == TRUE)
				{
				if (are_ipx_addresses_equal (&sptr_spx_packet->ipx_header,sptr_spx_connection) == TRUE)
					{
					return (sptr_spx_connection);
					}
				}
			}
		}

	for (sptr_spx_connection = (SPX_CONNECTION_ENTRY *)
		get_pointer_to_first_entry_in_list ((LINK *) &ipx_class.port[tx_port_number].spx_connection_list);
		sptr_spx_connection != NULL;
		sptr_spx_connection = get_pointer_to_next_entry_in_list ((LINK *) &sptr_spx_connection->links))
		{
		if (are_ids_equal (sptr_spx_packet->spx_header.source_connection_id,
			sptr_spx_packet->spx_header.destination_connection_id,sptr_spx_connection) ==	TRUE)
			{
			if (are_port_numbers_equal (rx_port_number,tx_port_number,sptr_spx_connection) == TRUE)
				{
				if (are_ipx_addresses_equal (&sptr_spx_packet->ipx_header,sptr_spx_connection) == TRUE)
					{
					break;
					}
				}
			}
		}

	return (sptr_spx_connection);
}
/****************************************************************************/
static enum BOOLEAN are_ids_equal (USHORT source_id,USHORT destination_id,SPX_CONNECTION_ENTRY *sptr_spx_connection)
{
	if ((sptr_spx_connection->source.connection_id == source_id) &&
		(sptr_spx_connection->destination.connection_id == destination_id))
		{
		return (TRUE);
		}
	else if ((sptr_spx_connection->source.connection_id == destination_id) &&
		(sptr_spx_connection->destination.connection_id == source_id))
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/****************************************************************************/
static enum BOOLEAN are_port_numbers_equal (USHORT rx_port_number,USHORT tx_port_number,SPX_CONNECTION_ENTRY *sptr_spx_connection)
{
	if ((sptr_spx_connection->source.port_number == rx_port_number) &&
		(sptr_spx_connection->destination.port_number == tx_port_number))
		{
		return (TRUE);
		}
	else if ((sptr_spx_connection->source.port_number == tx_port_number) &&
		(sptr_spx_connection->destination.port_number == rx_port_number))
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/****************************************************************************/
static enum BOOLEAN are_ipx_addresses_equal (IPX_HEADER *sptr_ipx_header,SPX_CONNECTION_ENTRY *sptr_spx_connection)
{
	if ((memcmp (&sptr_spx_connection->source.ipx_address,&sptr_ipx_header->source,sizeof (IPX_ADDRESS)) == (int) NULL) &&
		(memcmp (&sptr_spx_connection->destination.ipx_address,&sptr_ipx_header->destination,sizeof (IPX_ADDRESS)) == (int) NULL))
		{
		return (TRUE);
		}
	else if ((memcmp (&sptr_spx_connection->source.ipx_address,&sptr_ipx_header->destination, sizeof (IPX_ADDRESS)) ==
		(int) NULL) &&
		(memcmp (&sptr_spx_connection->destination.ipx_address,&sptr_ipx_header->source,sizeof (IPX_ADDRESS)) == (int) NULL))
		{
		return (TRUE);
		}
	else
		{
		return (FALSE);
		}
}
/****************************************************************************/
static void free_spx_connection_entry (SPX_CONNECTION_LINKS *sptr_spx_connection_list,SPX_CONNECTION_ENTRY *sptr_spx_connection)
{
	delete_entry_from_list ((LINK *) &sptr_spx_connection_list->sptr_forward_link,
		(LINK *) &sptr_spx_connection->links.sptr_forward_link);

	table_free (sptr_spx_connection);
}
/****************************************************************************/
static enum BOOLEAN store_sequence_numbers (USHORT rx_port_number,SPX_HEADER *sptr_spx_header,
	SPX_CONNECTION_ENTRY *sptr_spx_connection,BYTE hop_count)
{
	SPX_CONNECTION_CLASS *sptr_connection_class;
	enum BOOLEAN return_code;

	return_code = TRUE;

	if (rx_port_number == sptr_spx_connection->source.port_number)
		{
		sptr_connection_class = &sptr_spx_connection->source;
		}
	else
		{
		sptr_connection_class = &sptr_spx_connection->destination;
		}

	sptr_connection_class->hop_count = hop_count;

	if (sptr_connection_class->sequence_number != sptr_spx_header->sequence_number)
		{
		sptr_connection_class->sequence_number = sptr_spx_header->sequence_number;

		return_code = FALSE;
		}

	if (sptr_connection_class->ack_number != sptr_spx_header->ack_number)
		{
		sptr_connection_class->ack_number = sptr_spx_header->ack_number;

		return_code = FALSE;
		}

	if (sptr_connection_class->allocation_number != sptr_spx_header->allocation_number)
		{
		sptr_connection_class->allocation_number = sptr_spx_header->allocation_number;

		return_code = FALSE;
		}

	sptr_spx_connection->current_session_time = 0x00000000L;

	++sptr_connection_class->number_of_packets_rxed;

	return (return_code);
}
/****************************************************************************/
void spx_connection_timer (USHORT port_number)
{
	SPX_CONNECTION_ENTRY *sptr_spx_connection;

	for (sptr_spx_connection = (SPX_CONNECTION_ENTRY *)
		get_pointer_to_first_entry_in_list ((LINK *) &ipx_class.port[port_number].spx_connection_list);
		sptr_spx_connection != NULL;
		sptr_spx_connection = get_pointer_to_next_entry_in_list ((LINK *) &sptr_spx_connection->links))
		{
		if (ipx_class.port[port_number].spx_connection_timeout != 0x00000000L) /* 0x00000000L -> spx entry do not age */
			{
			if (++sptr_spx_connection->current_session_time > ipx_class.port[port_number].spx_connection_timeout)
				{
				free_spx_connection_entry (&ipx_class.port[port_number].spx_connection_list,sptr_spx_connection);
				}
			}
		}
}
/****************************************************************************/
static enum IPX_PACKET_STATE send_spx_watchdog_reply (SPX_PACKET *sptr_spx_rx_packet,USHORT size_of_packet,
	SPX_CONNECTION_ENTRY *sptr_spx_connection)
{
	enum IPX_PACKET_STATE return_code;
	USHORT connection_id;
	SPX_CONNECTION_CLASS *sptr_connection_class;
	IPX_ADDRESS ipx_address;
	ETHERNET_ADDRESS	*sptr_hop_routers_ethernet_address;
	USHORT	outgoing_port_number;

	connection_id = sptr_spx_rx_packet->spx_header.source_connection_id;
	sptr_spx_rx_packet->spx_header.source_connection_id = sptr_spx_rx_packet->spx_header.destination_connection_id;
	sptr_spx_rx_packet->spx_header.destination_connection_id = connection_id;

	if (sptr_spx_rx_packet->spx_header.source_connection_id == sptr_spx_connection->source.connection_id)
		{
		sptr_connection_class = &sptr_spx_connection->source;
		}
	else
		{
		sptr_connection_class = &sptr_spx_connection->destination;
		}

	sptr_spx_rx_packet->spx_header.sequence_number = sptr_connection_class->sequence_number;
	sptr_spx_rx_packet->spx_header.ack_number = sptr_connection_class->ack_number;
	sptr_spx_rx_packet->spx_header.allocation_number = sptr_connection_class->allocation_number;

	ipx_address = sptr_spx_rx_packet->ipx_header.source;
	sptr_spx_rx_packet->ipx_header.source = sptr_spx_rx_packet->ipx_header.destination;
	sptr_spx_rx_packet->ipx_header.destination = ipx_address;

	sptr_spx_rx_packet->ipx_header.transport_control_hop_count = sptr_connection_class->hop_count;

	sptr_hop_routers_ethernet_address = get_next_hop_router_address (sptr_spx_rx_packet->ipx_header.destination.network,
		&outgoing_port_number);

	if (sptr_hop_routers_ethernet_address == ON_OTHER_PORTS_NETWORK)
		{
		sptr_spx_rx_packet->ethernet_header.destination_address = sptr_spx_rx_packet->ipx_header.destination.node_address;
		}
	else
		{
		sptr_spx_rx_packet->ethernet_header.destination_address = *sptr_hop_routers_ethernet_address;
		}

	sptr_spx_rx_packet->ethernet_header.source_address = ipx_class.port[outgoing_port_number].ethernet_address;

	if (sptr_hop_routers_ethernet_address != CANT_FIND_NETWORK)
		{
		return_code = send_ipx_packet (outgoing_port_number,(IPX_PACKET *) sptr_spx_rx_packet,size_of_packet,TRUE,NULL);

		return (return_code);
		}
	else
		{
		return (DATA_PACKET_WAS_RXED_AND_WAS_NOT_FORWARDED);
		}
}
